h26207
s 00002/00002/00163
d D 1.3 83/02/19 18:41:29 mrk 3 2
c wrong interface to text justification globals
e
s 00000/00000/00165
d D 1.2 83/01/28 14:11:42 tes 2 1
c initial_internal_update
e
s 00165/00000/00000
d D 1.1 83/01/28 13:07:45 tes 1 0
c date and time created 83/01/28 13:07:45 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine text (numchr, string)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Output text at the current cursor position             #
#                                                                      #
#     Input Parameters:                                                #
#            numchr - number of characters in string                   #
#            string - array of ADE characters                          #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device independent device interface              #
#            txclip - clip text to proper boundary                     #
#            gpn2dc - convert a coordinate from (0-1) to (0,32K)       #
#                                                                      #
########################################################################
integer numchr, string(1)

integer opcd, nchr, contrl(5), idummy(1), ptsin(2), ptsout(1)

integer kout, kstart, kend, ddc(2), dxdc, dydc, start1, start2, 
	stop1, stop2, i

real cjx, cjy, delta, x, y, dx, dy, xoff, yoff, 
     xsave, ysave, line1(4), line2(4), temp

include(`pltcom')

# The following equivalences are made to reduce code size
#
#       contrl(1) :: opcd
#       contrl(4) :: nchr
#       ddc(1) :: dxdc
#       ddc(2) :: dydc

equivalence (contrl(1), opcd), (contrl(4), nchr), 
	    (ddc(1), dxdc), (ddc(2), dydc)

   if (numchr > 0 ) {
 
      dx = zchwdt * zdx   #determine the x and y deltas for one character
      dy = zchhgt * zdy 
      temp = zchhgt * zdx
      xoff = dx * numchr
      yoff = dy * numchr 

      if (txtpre == CHARACTERxPRECISION & ntxtrt == NO) {
	 dy = dy * zchhgt / zchwdt
	 }

      if (txtpre == STRINGxPRECISION) {
         dx = zchwdt 
         dy = 0.0
         }

      # x,y is the lower left corner of the first character cell. We adjust
      #   the position according to the specified text justification, 
      #        txtjh - horizontal:
      #                   0=left, 1=center, 2=right
      #        txtjv - vertical:
D 3
      #                   0=top, 1=CAP, 2=center, 3=base, 4=bottom
E 3
I 3
      #                   0=botterm 1=center 2=top
E 3
      cjx = .5*txtjh 
D 3
      cjy = 1. - .5*(float((2*txtjv)/3)) 
E 3
I 3
      cjy = .5*txtjv
E 3
 
      x = (zxabsl + cjy*dy) - cjx*xoff
      y = (zyabsl - cjy*temp) - cjx*yoff
      
      # Text Clipping is done by clipping the rectangle which encloses the  
      #   text string. We use the base line and Caps line to clip against.
      #   If any portion of either line is clipped the character is 
      #   considered clipped.
 
      # Define two (2) lines: 1) define the lower extention of the text
      #    string and 2) the upper extention of the text string
      line1(1) = x
      line1(2) = y
      line1(3) = x + xoff
      line1(4) = y + yoff
      line2(1) = x - dy
      line2(2) = y + dx
      line2(3) = line2(1) + xoff       
      line2(4) = line2(2) + yoff       

      # 'delta' is the distance along the base line of one (1) character
      delta = sqrt(dx*dx + dy*dy)
      
      # initialize the end of the string variables to the full character
      #    string length
      stop1 = numchr
      stop2 = numchr

      # Clip each the string base line and the cap line and then determine
      #    where in the string to start and end output
      call txclip (line1, delta, start1, stop1)
      call txclip (line2, delta, start2, stop2)

      # if start1 and start2 are greater than 0, then there is at least one
      #    character to be output
      if ((start1 > 0) & (start2 > 0)) {
	
	 # determine the extents of the string to be output
	 kstart = max0 (start1, start2)
	 kend = min0 (stop1, stop2)
        
	 # determine the total string length to be output
	 kout = (kend - kstart) + 1
	
	 # calculate the position of the first character to be output
	 xsave = x + (kstart-1)*dx
	 ysave = y + (kstart-1)*dy
	
	 # calculate the delta 'x' and delta 'y' for each character in
	 #   device coordinates
	 call gpn2dc (dx, dy, ddc)
	 }
      else {
	 kout = 0
	 }

      if (kout > 0 ) {
         # Set the string length for CHARxPRECISION initially, then if STRING
         #    is being used adjust the loop control parameter KOUT so we loop
         #    only once.
 
        # contrl(1) = TEXT
        opcd = TEXT      
	contrl(2) = 1   # One xy point
	# Contrl(4) = 1
        nchr = 1
	# ptsin(1) and ptsin(2) = x, y starting postion
	call gpn2dc (xsave, ysave, ptsin)

         if (txtpre == STRINGxPRECISION) {
	     # Contrl(4) = kout
             nchr = kout
             kend = kstart
             }
 
	 # Output the text string begining with the KSTART character in the
         #    string and ending with KEND.
         for (i=kstart; i<=kend; i=i+1) {
	    
	    # Output the character or string
	    call gzddop (contrl, string(i), ptsin, idummy, ptsout)
            
	    # Increment the character position to the next position
	    ptsin(1) = ptsin(1) + dxdc
            ptsin(2) = ptsin(2) + dydc
            }

         }
     }
 
   return
end
E 1
