h08245
s 00004/00004/00055
d D 1.2 83/01/28 14:03:29 tes 2 1
c initial_internal_update
e
s 00059/00000/00000
d D 1.1 83/01/28 13:05:08 tes 1 0
c date and time created 83/01/28 13:05:08 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine legend (x, y, numitm, font, size, color)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: set legend position                                    #
#                                                                      #
#     Input Parameters:                                                #
#            x, y - position of legend                                 #
#            numitm - number of legend items to be placed in legend    #
#            font - character font to be used for legend items         #
#            size - character size for legend items                    #
#            color - character color for legend items                  #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gptxat - set up the proper text enviroment                #
#                                                                      #
########################################################################
integer numitm, font, color
real x, xtemp, y, ytemp, size
 
D 2
PLOTxREALS PLOTxGETREAL
E 2
I 2
real gtreal 
E 2

include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) x, y, numitm, font, size, color
DxB 100 format (' legend:', 2f10.5, 2i5, f10.5, i5)
 
   if (numitm > 0)  {  # If legends are to be drawn
      nleged = numitm
D 2
      xtemp = PLOTxGETREAL(x)    # Upper left corner of legend area
      ytemp = PLOTxGETREAL(y)
E 2
I 2
      xtemp = gtreal (x, 0)    # Upper left corner of legend area
      ytemp = gtreal (y, 0)
E 2
      zlgxy(1) = xtemp/100.      # Save position in 0-1 space
      zlgxy(2) = ytemp/100.
      nfont(LEGENDxTEXTxATT) = font
D 2
      ztxsiz(LEGENDxTEXTxATT) = PLOTxGETREAL(size)
E 2
I 2
      ztxsiz(LEGENDxTEXTxATT) = gtreal (size, 0)
E 2
      ntxclr(LEGENDxTEXTxATT) = color
      njust(LEGENDxTEXTxATT) = 1   # Justify to lower left corner
      call gptxat (LEGENDxTEXTxATT) # Set the text size globals for inquiry
 
      zxlspc = 5.0*zchwdt          # We allow for 5 character widths for the
                                   #    display of line and bar type.
      zylspc = 1.50*zchhgt         # We use 1.5 for interline spacing of legend
      ndflgd = 1                   # The legend has been defined
      }
 
   else ndflgd = 0   # No legends are to be drawn
 
   return
end
E 1
