h13740
s 00066/00000/00000
d D 1.1 83/03/08 20:23:54 tes 1 0
c date and time created 83/03/08 20:23:54 by tes
e
u
tes
mrk
U
t
T
I 1
subroutine gpzmov (mode, x, y)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: do a 2D absolute move in device space                  #
#                                                                      #
#     Input Parameters:                                                #
#            mode - 1 = Absolute,  2 = Relative                        #
#            x - x coordinate                                          #
#            y - y coordinate                                          #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            none                                                      #
#                                                                      #
########################################################################
integer mode, x, y

integer contrl(5), opcd, intin(1), ptsout(1), intout(1)
integer curx, cury, ipos

include(`pltcom')
 
# The following equivelences were made to reduce code size:
#     contrl(1) = opcd

equivalence (contrl(OPCODE), opcd)

data opcd /POLYLINE/


   if (ncount > 1)   {  # There is a pending polyline to output

      # Set the number of vertices to ncount for output
      contrl(2) = ncount
 
      call gzddop (contrl, intin, npnts, intout, ptsout)
      }


   if (mode == ABSOLUTE)   {   # an absolute move
      curx = x
      cury = y
      }
   else  {
      ipos = 2*ncount - 1
      curx = x + npnts(ipos)
      cury = y + npnts(ipos+1)
      }

   ncount = 1  # Reset to the first point

   npnts(1) = curx
   npnts(2) = cury

   return
end
E 1
