h34008
s 00071/00000/00000
d D 1.1 83/03/08 20:24:29 tes 1 0
c date and time created 83/03/08 20:24:29 by tes
e
u
tes
mrk
U
t
T
I 1
subroutine gpzdrw (mode, x, y)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: do a polyline in device coordinates                    #
#                                                                      #
#     Input Parameters:                                                #
#            mode - 1 = Absolute,  2 = Relative                        #
#            x - x coordinate                                          #
#            y - y coordinate                                          #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device driver control                            #
#                                                                      #
########################################################################
integer mode, x, y 

integer contrl(5), opcd, intin(1), ptsout(1), intout(1), ipos
integer xtemp, ytemp

include(`pltcom')

# The following equivelences were made to reduce code size:
#     contrl(1) = opcd

equivalence (contrl(OPCODE), opcd)

data opcd /POLYLINE/


   if (ncount >= 10)   {  # Time to dump the buffer

      # Set the number of vertices to 10 for output
      contrl(2) = ncount
      call gzddop (contrl, intin, npnts, intout, ptsout)

      # Set new start position to the last point drawn to
      ipos = 2*ncount - 1
      ncount = 1  # Reset count 
      npnts(1) = npnts(ipos)
      npnts(2) = npnts(ipos+1)
      }

   ipos = 2*ncount - 1
   if (mode == ABSOLUTE)   {   # an absolute draw
      xtemp = x
      ytemp = y
      }
   else  {                     # a relative draw
      xtemp = x + npnts(ipos)
      ytemp = y + npnts(ipos+1)
      }

   # set end point into polyline buffer 
   ncount = ncount + 1
   ipos = 2*ncount - 1
   npnts(ipos) = xtemp
   npnts(ipos+1) = ytemp

  return
end
E 1
