h28595
s 00002/00000/00057
d D 1.4 83/03/02 15:09:24 mjb 4 3
c put in check for 0 start or end
e
s 00001/00001/00056
d D 1.3 83/02/07 14:24:03 mrk 3 2
c fixed bug for value less than 0
e
s 00000/00000/00057
d D 1.2 83/01/28 14:00:05 tes 2 1
c initial_internal_update
e
s 00057/00000/00000
d D 1.1 83/01/28 13:04:25 tes 1 0
c date and time created 83/01/28 13:04:25 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpxfrm (index, xin, xout)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: transform data from user units to plot area units      #
#               by applying any logarithmic transform                  #
#                                                                      #
#     Input Parameters:                                                #
#            index  - index of axis being converted                    #
#            xin    - input coordinate to be coverted                  #
#                                                                      #
#     Output Parameters:                                               #
#            xout   - converted output coordinate                      #
#                                                                      #
#     Routines Called:                                                 #
#            none                                                      #
#                                                                      #
########################################################################
integer index
real xin, xout
 
integer type
real x, start, end
 
include(`pltcom')
 
   x = xin                 # local copies of points in case of log transforms
   start = zrstrt(index)
   end = zrend(index)

   type = natype(index)
   if (type != 0) {
D 3
      if (x <= 0.0) x = 1./10.**10
E 3
I 3
      if (x <= 0.0) x = 1.
I 4
      if (start <= 0.0) start = 1.
      if (end <= 0.0) end = 1.
E 4
E 3
      if (type == 1) {
	 x = alog10 (x)
	 start = alog10 (start)
	 end = alog10 (end)
	 }
      else {
	 x = alog (x)
	 start = alog (start)
	 end = alog (end)
	 }
      }
 
   xout = (x - start)/(end-start)
   xout = zplmin(index) + xout*(zplmax(index) - zplmin(index))

   return
end
E 1
