h49387
s 00005/00006/00049
d D 1.2 83/01/28 13:47:14 tes 2 1
c initial_internal_update
e
s 00055/00000/00000
d D 1.1 83/01/28 13:00:54 tes 1 0
c date and time created 83/01/28 13:00:54 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine frame (xmin, xmax, ymin, ymax)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: draw a frame around a specified area                   #
#                                                                      #
#     Input Parameters:                                                #
#            xmin - x coordinate for the lower left hand corner        #
#            xmax - x coordinate for the upper right hand corner       #
#            ymin - y coordinate for the lower left hand corner        #
#            ymax - y coordinate for the upper right hand corner       #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gpdraw - draw to the specified location                   #
#            gplnat - establish the current line attributes            #
#            imove  - modify the current position for latter action    #
#                                                                      #
########################################################################
real xmin, xmax, ymin, ymax
 
D 2
real txmin, txmax, tymin, tymax
PLOTxREALS PLOTxGETREAL
E 2
I 2
real txmin, txmax, tymin, tymax, gtreal 
E 2

include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) 
DxB 100 format (' frame:')
 
D 2
   txmin = PLOTxGETREAL(xmin)/100.  # convert from users real format
   txmax = PLOTxGETREAL(xmax)/100.  
   tymin = PLOTxGETREAL(ymin)/100.
   tymax = PLOTxGETREAL(ymax)/100.
E 2
I 2
   txmin = gtreal (xmin, 0)/100.  # convert from users real format
   txmax = gtreal (xmax, 0)/100.  
   tymin = gtreal (ymin, 0)/100.
   tymax = gtreal (ymax, 0)/100.
E 2

   call gplnat
   nclip = YES   # Turn on clipping
   call imove (ABSOLUTE, txmin, tymin)
   call gpdraw (txmax, tymin)
   call gpdraw (txmax, tymax)
   call gpdraw (txmin, tymax)
   call gpdraw (txmin, tymin)

   nclip = NO
 
   return
end
E 1
