h37209
s 00005/00006/00080
d D 1.2 83/03/31 12:43:39 mmm 2 1
c 
e
s 00086/00000/00000
d D 1.1 83/03/15 21:43:54 tes 1 0
c date and time created 83/03/15 21:43:54 by tes
e
u
4
U
t
T
I 1
subroutine gswkvw (xmin, xmax, ymin, ymax)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set the workstation viewport size                      #
#                                                                      #
#     Input Parameters:                                                #
#            xmin,ymin -   the lower left corner (device coordinates)  #
#            xmax,ymax -   the upper right corner(device coordinates)  #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#      Errors:                                                         #
#          7 GKS not in proper state: GKS must be in one of the states #
#            WSOP, WSAC, or SGOP                                       #
#         20 specified workstation identifier is invalid               #
#         25 Specified workstation is not open                         #
#         41 Rectangle definition is invalid                           #
#         45 Workstation viewport is not within the display space      #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
real xmin, xmax, ymin, ymax
 
ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

D 2
real txmin, txmax, tymin, tymax
REALS GETREAL
E 2
I 2
real txmin, txmax, tymin, tymax, gtreal 
E 2

include(`gkscom')

D 2
   txmin = GETREAL(xmin)  # convert to R real format 
   txmax = GETREAL(xmax)
   tymin = GETREAL(ymin)
   tymax = GETREAL(ymax)
E 2
I 2
   txmin = gtreal (xmin, 0)  # convert to R real format 
   txmax = gtreal (xmax, 0)
   tymin = gtreal (ymin, 0)
   tymax = gtreal (ymax, 0)
E 2

   ifdef(`ERROR_ON',`
      rounum = GSWKVW
      errind = errchk(wrkid, ierdum)
      errind = 0
      ')

      if (txmax <= txmin | tymax <= tymin)
      ifdef(`ERROR_ON',`errind = 41',`return')

      if ((amin1(0.0,txmin,txmax,tymin,tymax) != 0.0) |
	  (txmax > mxdsln(1)) | (tymax > mxdsln(2)))
      ifdef(`ERROR_ON',`errind = 45',`return')

   ifdef(`ERROR_ON',`
      if (errind != 0) {
	 call gkserr (errind)
	 return
	 }
      ')

   if (devcor == METERS) {  # Convert to device raster space
       cwrkvw(1) = txmin / sptszx
       cwrkvw(2) = txmax / sptszx
       cwrkvw(3) = tymin / sptszy
       cwrkvw(4) = tymax / sptszy
       }
   else {
      cwrkvw(1) = txmin   # Set the workstation viewport extents
      cwrkvw(2) = txmax
      cwrkvw(3) = tymin
      cwrkvw(4) = tymax
      }

   nwkvw = 1          # Set the workstation transform dirty
   ntext = 1          # Set the text transform dirty
 
   return
end
E 1
