h48660
s 00003/00004/00093
d D 1.2 83/03/31 12:35:57 mmm 2 1
c 
e
s 00097/00000/00000
d D 1.1 83/03/15 21:40:58 tes 1 0
c date and time created 83/03/15 21:40:58 by tes
e
u
4
U
t
T
I 1
subroutine gpm (n, px, py)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Place a marker at each point specified in world space. #
#                                                                      #
#     Input Parameters:                                                #
#            n       - number of points to connect                     #
#            px      - array of x coordinates in world space           #
#            py      - array of y coordinates in world space           #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Errors:                                                          #
#            5  GKS not in proper state: GKS must be either in the     #
#               state WSAC or in the state SGOP                        #
#          100  Number of points is invalid                            #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            gwddc2 - convert/clip line from world to device           #
#            gzddop   - call current device driver                     #
#                                                                      #
########################################################################
integer n
real px(n), py(n)

integer contrl(5), i, idummy(1), ptsin(4), opcd, vertin
D 2
real linein(4)
REALS GETREAL
E 2
I 2
real linein(4), gtreal 
E 2

logical q1move, q2move, qgone

ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

include(`gkscom')
 
# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements. The arrays and the
#    variables equivalenced are listed below:
#
#       contrl(OPCODE) :: opcd
#       contrl(VERTICESxIN) :: vertin
 
equivalence (contrl(OPCODE), opcd), (contrl(VERTICESxIN), vertin)

ifdef(`ERROR_ON',`
      rounum = GPM
      errind = errchk(ierdum(1), ierdum)
      ')

if (n <= 0) {
   ifdef(`ERROR_ON',`call gkserr (100)')
   return
   }

   # Loop over points and put markers at each one.
   for (i=1; i<=n; i=i+1) {
 
D 2
      linein(1) = GETREAL(px(i))
      linein(2) = GETREAL(py(i))
E 2
I 2
      linein(1) = gtreal (px, i-1)
      linein(2) = gtreal (py, i-1)
E 2
      linein(3) = linein(1)
      linein(4) = linein(2)
 
      # We convert to device coords. and clip the point to determine 
      # if the point is in the current window.
      #    The drivers are expected to determine if the marker can be
      #    fully displayed.
      call gwddc2 (linein, ptsin, q1move, q2move, qgone)

      if (!qgone) {
 
         # contrl(OPCODE)
         opcd = POLYMARKER
	 # contrl(VERTICESxIN) = 1
         vertin = 1 

	 # x/y position is in rlin
         call gzddop (contrl, idummy, ptsin, idummy, idummy) 

	 # Set screen erase flag to erase
	 eraflg = YES
         }
    }
 
   return
end
E 1
