h14715
s 00002/00002/00074
d D 1.2 83/03/31 12:32:50 mmm 2 1
c 
e
s 00076/00000/00000
d D 1.1 83/03/15 21:38:50 tes 1 0
c date and time created 83/03/15 21:38:50 by tes
e
u
4
U
t
T
I 1
subroutine gitxf (wktype,errind,ntxi,rtxi)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire number of predefined text indices              #
#                                                                      #
#     Input Parameters:                                                #
#            wktype - workstation type                                 #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            ntxi(1)- number of fonts                                  #
#            ntxi(2)- number of character heights                      #
#            rtxi(1)- minimum character height                         #
#            rtxi(2)- maximum character height                         #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           22  Specified workstation type is invalid                  #
#           23  Specified workstation does not exist                   #
#           37  Specified workstation is neither an output             #
#               station nor an output/input workstation                #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer  wktype, errind, ntxi(2)
real rtxi(2)

real trtx1, trtx2, rtemp

ifdef(`ERROR_ON',`
   integer errchk, ierdum, ierary(1), erary1
   ')

include(`gkscom')

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')
 
   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GITXF
      #   ierary(1) = wktype
      erary1 = wktype
      errind = errchk(ierdum, ierary)
      if (errind !=  0) return
      ')
   
   ntxi(1) = nfont     # Get values from common             
   ntxi(2) = nchht   

   rtemp = (float(mxdsdc(2))+1.0) / 32768.0
   trtx1 = float(mnchht) * rtemp # Convert from 32k to raster
   trtx2 = float(mxchht) * rtemp

   if (devcor == METERS) {
      trtx1 = trtx1 * sptszy
      trtx2 = trtx2 * sptszy
      }

D 2
   PUTREAL(trtx1, rtxi(1))  # Put back into user format reals
   PUTREAL(trtx2, rtxi(2))
E 2
I 2
   call ptreal (trtx1, 0, rtxi)  # Put back into user format reals
   call ptreal (trtx2, 1, rtxi)
E 2

   return
end
E 1
