h43332
s 00008/00009/00101
d D 1.2 83/03/31 12:32:36 mmm 2 1
c 
e
s 00110/00000/00000
d D 1.1 83/03/15 21:38:43 tes 1 0
c date and time created 83/03/15 21:38:43 by tes
e
u
4
U
t
T
I 1
subroutine gitxex (wkid,sx,sy,il,nch,str,errind,cpx,cpy,txtext)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire text extent                                    #
#                                                                      #
#     Input Parameters:                                                #
#            wkid   - workstation identifier                           #
#            sx     - starting point                                   #
#            sy     -                                                  #
#            il     - maximum character item count                     #
#            nch    - length of string in characters                   #
#            str    - charcter string                                  #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            cpx    - concatenation point                              #
#            cpy    -                                                  #
#            txtext - text extent rectangle (lower left, upper right)  #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           20  Specified workstation identifier is invalid            #
#           25  specified workstation is not open                      #
#           37  Specified workstation is neither an output workstation #
#               nor an output/input station                            #
#                                                                      #
#     Routines Called:                                                 #
#               gztxtn - calculate current text size                   #
#               arycnr - intialize real array to specified value       #
#               errchk - perform appropriate error checking            #
#                                                                      #
########################################################################
integer wkid, il, nch, str(il), errind 
real sx, sy, cpx, cpy, txtext(4)
 
integer i, kount

ifdef(`ERROR_ON',`
   integer errchk, ierary(1), erary1
   ')

D 2
real hypot, tcpx, tcpy, dx, dy, upx, upy, rtemp(4)
REALS GETREAL
E 2
I 2
real hypot, tcpx, tcpy, dx, dy, upx, upy, rtemp(4), gtreal 
E 2
 
include(`gkscom')

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GITXEX
      #   ierary(1) = wrktyp
      erary1 = wrktyp
      errind = errchk(wkid, ierary)
      if (errind != 0) return
      ')

   kount = 0
   for (i=1; i<=nch; i=i+1) { # Check for non-printables
      if (str(i) >=  BLANK & str(i) <= TILDE) kount = kount + 1
      }
 
   if (kount > 0) {

      # Reset character size if viewing transform has changed
      if (ntext == 1) {
	 call gztxtn (chrhgt)
	 ntext = 0
	 }

      # Set the text baseline and charup vectors depending upon precision
      dx = normdx
      dy = normdy
      upx = actupx
      upy = actupy
      if (txpre == CHARACTERxPRECISION) {
	 dx = unrmdx  # Use users specified rotation values
	 dy = unrmdy
	 upx = chrupx
	 upy = chrupy
	 }

      hypot = kount*curwdt
D 2
      tcpx = GETREAL(sx) + hypot * dx
      tcpy = GETREAL(sy) + hypot * dy / xywasp
      rtemp(1) = GETREAL(sx)
      rtemp(2) = GETREAL(sy)
E 2
I 2
      tcpx = gtreal (sx, 0) + hypot * dx
      tcpy = gtreal (sy, 0) + hypot * dy / xywasp
      rtemp(1) = gtreal (sx, 0)
      rtemp(2) = gtreal (sy, 0)
E 2
      rtemp(3) = tcpx + upx * celhgt * xywasp
      rtemp(4) = tcpy + upy * celhgt
      }
                   
D 2
   PUTREAL(tcpx, cpx)   # Put back into user real format
   PUTREAL(tcpy, cpy)
E 2
I 2
   call ptreal (tcpx, 0, cpx)   # Put back into user real format
   call ptreal (tcpy, 0, cpy)
E 2
   do i =1, 4 {
D 2
      PUTREAL(rtemp(i), txtext(i))
E 2
I 2
      call ptreal (rtemp(i), i-1, txtext)
E 2
      }

   return
end
E 1
