h58424
s 00000/00000/00066
d D 1.2 83/03/31 12:29:16 mmm 2 1
c 
e
s 00066/00000/00000
d D 1.1 83/03/15 21:36:06 tes 1 0
c date and time created 83/03/15 21:36:06 by tes
e
u
4
U
t
T
I 1
subroutine giaip (wktype,errind,ninput)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire number of available logical input devices      #
#                                                                      #
#     Input Parameters:                                                #
#            wktype - workstation type                                 #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            ninput - number of available logical input devices        #
#               (1) - number of locator devices                        #
#               (2) - number of valuator devices                       #
#               (3) - number of choice devices                         #
#               (4) - number of pick devices                           #
#               (5) - number of string devices                         #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           22  Specified workstation type is invalid                  #
#           23  Specified workstation does not exist                   #
#           36  Specified workstation is neither an output             #
#               station nor an output/input workstation                #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer  wktype, errind, ninput(5)

ifdef(`ERROR_ON',`
   integer errchk, ierdum, ierary(1), erary1
   ')

include(`gkscom')

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GIAIP
      #   ierary(1) = wktype
      erary1 = wktype
      errind = errchk(ierdum, ierary)
      if (errind != 0) return
      ')

   ninput(1) = nlocdv  # Get number of devices from common
   ninput(2) = nvaldv   
   ninput(3) = nchodv
   ninput(4) = 0
   ninput(5) = nstrdv

   return
end
E 1
