h38967
s 00059/00000/00000
d D 1.1 83/01/20 11:08:52 tes 1 0
c date and time created 83/01/20 11:08:52 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine bakpos (iptr, row, column, mode)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Back up one field from the current position            #
#                                                                      #
#     Input Parameters:                                                #
#            iptr - pointer to current data area                       #
#            row  - current row of data area                           #
#            column - current column of data area                      #
#                                                                      #
#     Output Parameters:                                               #
#            iptr - pointer to current data area                       #
#            row  - row of next data area                              #
#            column - column of next data area                         #
#            mode - mode of next data area                             #
#                                                                      #
#     Routines Called:                                                 #
#            None                                                      #
#                                                                      #
########################################################################
integer iptr, row, column, mode

include(`mnucom')

if (dtabfr(1) > 0) {   # make sure that we've got a choice defined

   if (iptr > 1) {

      # the field data structure is a redundent format as follows:
      # /command length/row/column/length/mode/string/NULL/string/NULL
      # So to find the previous field we find the first none ASCII byte
      # and bypass the terminating NULL by decrementing by 2
      iptr = iptr - 2
      while (dtabfr(iptr) >= BLANK | dtabfr(iptr) == NUL) { 
	 iptr = iptr - 1 
	 }

      # we have found the previous field definition's mode value,
      # the length, column, and row values are 1, 2, and 3 less respectively
      iptr = iptr - 4
      row = dtabfr(iptr+1)
      column = dtabfr(iptr+2)
      mode = dtabfr(iptr+4)
      }
   else {
      column = dtabfr(iptr+2)
      }
   }

return
end
E 1
