h22041
s 00113/00000/00000
d D 1.1 83/03/23 16:18:15 bog 1 0
c date and time created 83/03/23 16:18:15 by bog
e
u
4
U
t
T
I 1
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#############################################################################
#									    #
#	Function:  							    #
#		LOGICAL Function EmMEdN (Common,Var)			    #
#			Input	Common:	CHARACTER <Common> code		    #
#				Var:	INTEGER <Variable> index	    #
#			Output	EmNPut:	LOGICAL True if edit was ok; False  #
#					if repaint and continue needed	    #
#		    Read keyboard and parse for an INTEGER.  Stuff it in    #
#		    <Common>:<Var>.					    #
#									    #
#	Called By:							    #
#									    #
#	Routines Called:						    #
#									    #
#############################################################################
 
LOGICAL Function EmMEdN(Common,Var)
CHARACTER Common
INTEGER Var
 
CHARACTER Char,C
INTEGER Val,XSave,YSave,Error
LOGICAL Rubbed
 
CHARACTER EmIKb
External EmIKb
CHARACTER EmNPut
External EmNPut
 
BEGINCOMMON
COMMON(BEAMSTATE)
COMMON(DRIVER)
COMMON(SPECIALKEYS)
ENDCOMMON
 
EmMEdN = TRUE			# Assume edit goes ok
 
XSave = X			# Save X,Y for possible reshow
YSave = Y
 
Val = 0				# Start with accumulated value of zero
 
Repeat {			# Forever; or at least until break
  While (EmIKb(Char) == EMPTY) {# Get a non-EMPTY character
    }
  If ((Char >= ZERO) & (Char <= NINE)) {	# Digit
    If (Going) {		# Echo if not init time
      Call EmAsci(Char)
      }
    Val = Val*10+Char-ZERO	# Include this digit
    }
   Else {			# Not a digit
    If ((Char == BS) | (Char == DEL)) {	# Rub out a digit
      Rubbed = FALSE
      Repeat {			# Until not BS or DEL
	If (Val != 0) {		# Something to rub?
	  Val = Val/10		# Remove rightmost digit
	  If (Going) {		# Unless init time
	    Rubbed = TRUE	# Something has been rubbed
	    Call EmAsci(BS)	# Back a space
	    Call EmAsci(SPLAT)	#  & wipe digit
	    }
	  }
	While (EmIKb(Char) == EMPTY) {	# Get a non-EMPTY character
	  }
	} Until ((Char != BS) & (Char != DEL))
      Call EmPKb(Char)		# Push rub stopper back to keyboard
      If (Rubbed & Going) {	# If something was rubbed
	If (Y > YCh) {		# Room for another line
	  X = XSave		# Move to original X,Y
	  Y = YSave
	  MOVE(X,Y)
	  Call EmAsci(LF)	# Down a line
	  XSave = X		# Save X,Y in case further rubbing
	  YSave = Y
	  C =EmNPut(Val)	# Show integer so far
	  }
	 Else {			# No room; must repaint
	  While (Val != 0) {	# Push digits back to kb backwards
	    C = Mod(Val,10)	# Get a digit
	    Call EmPKb(C)	# Push it back
	    EmMEdN = FALSE	# Must repaint
	    Break
	    }
	  }
	}
      }
     Else {
      If (Char != CR) {		# Push unknowns except Cr back
	Call EmPKb(Char)
	}
      Break			# Quit on unknown characters
      }
    }
  }				# End Repeat
 
If (Val != 0) {			# Stuff only if non-zero
  Call EmIPut(Val,Common,Var)	#  into place edited
  }
 
Return
End
E 1
