h08719
s 00254/00000/00000
d D 1.1 83/03/23 16:15:42 bog 1 0
c date and time created 83/03/23 16:15:42 by bog
e
u
4
U
t
T
I 1
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#############################################################################
#									    #
#	Function:  							    #
#		Subroutine EmCntl (Ch)					    #
#			Input	Ch:	Character in [NUL..US]		    #
#		    Emulate all control characters.  LCE may be set.	    #
#									    #
#	Called By:							    #
#		Subroutine EmPoll ()					    #
#		    4012/4014 Emulator Main Polling Loop		    #
#									    #
#	Routines Called:						    #
#		Subroutine EmGTrm (Ch,X,Y)				    #
#			Input	Ch:	Character in [NUL..DEL,EMPTY])	    #
#				X,Y:	Integer coordinates in XYSPACE	    #
#		    Terminate Graphic Input, maybe with Ch		    #
#									    #
#		Subroutine EmOBel ()					    #
#		    Ring the bell					    #
#									    #
#		Subroutine EmOBs ()					    #
#		    Display a Backspace					    #
#									    #
#		Subroutine EmOHt ()					    #
#		    Display a Horizontal Tab				    #
#									    #
#		Subroutine EmOLf ()					    #
#		    Display a Line Feed					    #
#									    #
#		Subroutine EmOVt ()					    #
#		    Display a Vertical Tab				    #
#									    #
#		Subroutine EmPage ()					    #
#		    <Esc> <Ff> Clear screen				    #
#									    #
#		Subroutine EmAlfM ()					    #
#		    Force ALPHA mode					    #
#									    #
#		Subroutine EmGEnd ()					    #
#		    Stop GIN without sending coordinates		    #
#									    #
#		Subroutine EmOCr ()					    #
#		    Display a Carriage Return				    #
#									    #
#		Subroutine EmCopy ()					    #
#		    <Esc> <Etb> Hardcopy screen				    #
#									    #
#		Subroutine EmGBeg ()					    #
#		    Enter Graphic Input mode				    #
#									    #
#############################################################################
 
Subroutine EmCntl(Ch)
CHARACTER Ch
 
BEGINCOMMON
COMMON(BEAMSTATE)
ENDCOMMON
 
#Switch (Ch) {
{Goto (101,101,101,101,105,101,107,108,109,110,111,112,113,101,101,
   101,101,101,101,101,101,101,123,124,101,126,127,128,129,130,131),Ch
 
#   Case NUL: {
    100 {
	}
	Goto 199
 
#   Case SOH,STX,ETX,EOT,ACK,SO,SI,DLE,DC1,DC2,DC3,DC4,NAK,SYN,EM: {
    101 {
	LCE = FALSE
	}
	Goto 199
 
#   Case ENQ: {
    105 {
	If (LCE) {
	    LCE = FALSE
	    #??? wait a while
	    If (Mode == GIN) {
		Call EmGTrm(EMPTY,X,Y)
		}
	    Else {
		Ch = 37			# 0010 0101  Alpha mode
		If ((Mode == GRAPH)
		     | (Mode == POINTPLOT)
		     | (Mode == SPECIALPOINT)
			) {
		    Ch = 41		# 0010 1001  Some Graph mode
		    }
		If ((X >= XMarg2) & Margn2) {
		    Call EmGTrm(Ch+2,X-XMarg2,Y)	# Margin 2 on
		    }
		else {
		    Call EmGTrm(Ch,X,Y)
		    }
		}
	    }
	}
	Goto 199
 
#   Case BEL: {
    107 {
	LCE = FALSE
	Bypass = FALSE
	IsDraw = TRUE
	Call EmOBel
	}
	Goto 199
 
#   Case BS: {
    108 {
	LCE = FALSE
	Bypass = FALSE
	Call EmOBs
	}
	Goto 199
 
#   Case HT: {
    109 {
	LCE = FALSE
	Bypass = FALSE
	Call EmOHt
	}
	Goto 199
 
#   Case LF: {
    110 {
	If (NOT(LCE)) {
	    Bypass = FALSE
	    Call EmOLf
	    }
	}
	Goto 199
 
#   Case VT: {
    111 {
	Bypass = FALSE			# Also reset LCE???
	Call EmOVt
	}
	Goto 199
 
#   Case FF: {
    112 {
	If (LCE) {
	    Call EmPage
	    }
	}
	Goto 199
 
#   Case CR: {
    113 {
	If (NOT(LCE)) {
	    Bypass = FALSE
	    Call EmAlfM
	    ExtraX = 0
	    ExtraY = 0
	    Call EmOCr
	    }
	}
	Goto 199
 
#   Case ETB: {
    123 {
	If (LCE) {
	    LCE = FALSE
	    Call EmCopy
	    }
	}
	Goto 199
 
#   Case CAN: {
    124 {
	If (LCE) {
	    LCE = FALSE
	    Bypass = TRUE
	    }
	}
	Goto 199
 
#   Case SUB: {
    126 {
	If (LCE) {
	    LCE = FALSE
	    Call EmGBeg
	    }
	}
	Goto 199
 
#   Case ESC: {
    127 {
	LCE = TRUE
	}
	Goto 199
 
#   Case FS: {
    128 {
	If (LCE) {
	    Mode = SPECIALPOINT
	    GotInt = FALSE
	    }
	Else {
	    Mode = POINTPLOT
	    }
	GotLoY = FALSE
	LCE = FALSE
	Bypass = FALSE
	IsDraw = TRUE
	}
	Goto 199
 
#   Case GS: {
    129 {
	Mode = GRAPH
	GotLoY = FALSE
	LCE = FALSE
	Bypass = FALSE
	IsDraw = FALSE
	}
	Goto 199
 
#   Case RS: {
    130 {
	Mode = INCREMENTAL
	LCE = FALSE
	Bypass = FALSE
	IsDraw = TRUE
	IncrX = X4010(X)
	IncrY = Y4010(Y)
	}
	Goto 199
 
#   Case US: {
    131 {
	LCE = FALSE
	Bypass = FALSE
	Call EmAlfM
	}
#       Goto 199
 
  199 Continue
    }
Return
End
E 1
