/******************************************************************************
* PRINTER.C - Parallel Printer Driver				Version 1.4.00
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
*  1.4.00 07/15/87 ldt  swapped includes io.h with system.h (avoid heap error)
*  1.2.05 11/24/86 reb  fixed prn_wrt to break up long chunks of writes
*  1.2.04 11/24/86 reb  fixed for abort of process and loss of mem context
*  1.2.03 07/16/86 AM	Added error checking to prn_portget().
*  1.2.02  7/10/86 DR-K	StkSize needed to be a Long
*  1.2.01 06/20/86 mei  High C port.
* v1.2.00 04/11/86 FRH	Add sysbuild.h
*     2.3 09/26/85 DR-K	implement prn_get(),prn_set(),getset() and
*				 prn_table[u]
*     2.2 09/20/85 DR-K	merge prn_char() into prn_wrt() and add mapu
*     2.1 09/13/85 DR-K	make prn_write() async. It doasr(prn_wrt)
*     2.0 09/11/85 DR-K	test status before pollevent call in prn_char
*******************************************************************************
*
*	What I assume:
*	1) That there will be no more that 4 units. Tables affected are
*	   PRN_BASEPORT and PRN_RTN, which are set up for
*	   this limit.
*	2) That the baseports at 0000:0408 through 0000:040F are valid
*	   and set up by the boot ROM.
******************************************************************************/

#include "portab.h"
#include "sysbuild.h"
#include "system.h"
#include "io.h"

#if METAWARE 
#define PRINTER
#include "protos.h"
#endif

#define	INSTALL	1		/* Non-zero to be installable.		*/
#define	LINK	0		/* Non-zero to be linkable.		*/

#define	CONSOLE	0		/* Non-zero to use console		*/
#define	PRINTER 1		/* Non-zero to use printer		*/

#define	PRN_ASY	1		/* Use the POLLEVENT function.		*/
#define	PRN_SYN	0		/* Use straight polling.		*/

#define DAPORT		0x10	/* Interfacer 3				*/
#define STPORT		0x11	/* Interfacer 3				*/
#define	USRPORT		0x17	/* User select				*/
#define	MODEPORT	0x12	/* USART mode				*/
#define	CMDPORT		0x13	/* USART command reg			*/

/************************************************************************
*	The next three defines are the relative offset of each printer
*	register from its base value (as described in PRN_BASEPORT,
*	below).
*************************************************************************/

#define	P_DATA	0		/* Offset of the DATA latch register	*/
#define	P_STAT	1		/* Offset of the STATUS register	*/
#define	P_COMM	2		/* Offset of the COMMAND register	*/

#define	NBRUNIT	4		/* Maximum of four printers.		*/
#define	FLAGVAL	0x0A		/* sync at unit level,16-bit reads	*/

#define	YES	1		/* Writing is allowed			*/
#define	NO	0		/* Writing isn't allowed		*/

#define	STRBDLY	1000		/* Length of the Strobe Delay		*/
#define	INITDLY	16384		/* Length of the Init Delay		*/

#define StkSize	300L		/* Size of stack storage for asrwait()	*/

#define	READY	-1		/* Returned from PRN_STATUS if ready	*/
#define	UNREADY	0		/* Returned from PRN_STATUS if not ready*/

/************************************************************************
*	Printer Status Bits
*************************************************************************/

#define	PRN_TO	0x01		/* Time out error			*/
#define	PRN_IO	0x08		/* I/O error				*/
#define	PRN_SEL	0x10		/* Printer Selected			*/
#define	PRN_OOP	0x20		/* Out Of Paper				*/
#define	PRN_ACK	0x40		/* Strobe Acknowledge			*/
#define	PRN_NBY	0x80		/* Not Busy				*/

#define	PRN_ERR	(PRN_OOP)	/* Any of these is an error.		*/

/************************************************************************
*	Printer Command Bits
*************************************************************************/

#define	PRN_STROBE	0x01	/* Set STROBE line high			*/
#define	PRN_INIT	0x04	/* Set INIT* line high			*/
#define	PRN_NOINT	0x08	/* Force INT line low			*/

/************************************************************************
*	External Definitions
*************************************************************************/

#if LINK
EXTERN LONG mwait(), aret();
#endif

#if INSTALL
EXTERN	VOID	asrwait();
EXTERN  LONG	pollevent();
#define	mwait(a) supif(F_WAIT,a)
#define	aret(a) supif(F_RETURN,a)
#endif

EXTERN WORD inp(), outp();

/************************************************************************
*	Locally defined routines. The first four rows are normal
*	driver routines. The fifth contains the status routines.
*************************************************************************/

LONG	prn_init(), prn_uninit(), prn_subdrv(), prn_select(), prn_flush();
LONG	prn_read(), prn_write(), prn_get(), prn_set(), prn_special();

WORD	prn_st0(), prn_st1(), prn_st2(), prn_st3(), prn_status();
VOID	prn_wrt(), getset();

/************************************************************************
*	The Printer Driver Driver Header.
*
*	This must be the first data structure defined, so that the loader
*	knows where to find it.
*************************************************************************/

GLOBAL DH prn_dh = 
{
	0,			/* Number of units allocated.		*/
	NBRUNIT,		/* Maximum number of units.		*/
	FLAGVAL,		/* Synchronize at Unit level.		*/
	prn_init,		/* Initialize the printer.		*/
	prn_subdrv,		/************** Not Needed **************/
	prn_uninit,		/* Un-initializes the printer.		*/
	prn_select,		/* Selects the printer for use.		*/
	prn_flush,		/* Carroll O'Connor's favorite func.	*/
	prn_read,		/************** Not Needed **************/
	prn_write,		/* Writes data to the printer.		*/
	prn_get,		/* gets prn_table[u]			*/
	prn_set,		/* sets prn_table[u]			*/
	prn_special,		/**** Unimplemented **** not needed *****/
	0L,0L,0L,0L,0L		/* resevered				*/
} ;

/************************************************************************
*	prn_table
*
*	defines and sets up the default values for each printer unit
*	change this table to your values (if known)
*************************************************************************/
#define PTE	struct	prnTableStruct
PTE
{	LONG	PT_STATUS;
	BYTE	PT_MODE;
	BYTE	PT_PAPERTYP;
	WORD	PT_WIDTH;
	BYTE	PT_LEGMODE;
	BYTE	PT_SINGPAG;
	BYTE	PT_LPI;
	BYTE	PT_LENGTH;
	BYTE	PT_NAME[16];
};

PTE	prn_table[NBRUNIT] = {
{ 8L, 0, 0, 85, 11, 0, 0, 8, "Personal printer" },
{ 8L, 0, 0, 85, 11, 0, 0, 8, "Personal printer" },
{ 8L, 0, 0, 85, 11, 0, 0, 8, "Personal printer" },
{ 8L, 0, 0, 85, 11, 0, 0, 8, "Personal printer" },
 };

	LONG	didchar;	/* diag */
	LONG	didpollev;	/* diag */

			/* an array of pointers to stack save areas which */
			/* will be SALLOCed later.  used by asrwait()	  */
	LONG	StkSave[NBRUNIT] = { 0,0,0,0 };
			/* a place to store the user's parmeter block when */
			/* we return control and possible overwrite	   */
	DPBLK	prn_wpb[NBRUNIT];

	WORD	abflg[NBRUNIT] = {0,0,0,0} ;

/************************************************************************
*	PRN_BASEPORT
*
*	An array of the base ports of each printer unit. I don't know
*	what the exact values are...
*************************************************************************/

struct {
    LONG pfill, pstart, plength;
    } prn_physpb		= { 0L, 0x408L, 8L };

/************************************************************************
*	PRN_RTN
*
*	A list of all the status routines, one for each unit. This is
*	necessary because POLLEVENT doesn't let the status routine have
*	any arguments, hence this method of determining the unit number.
*************************************************************************/

WORD (*prn_rtn[NBRUNIT])() = { prn_st0, prn_st1, prn_st2, prn_st3 };

/************************************************************************
*	PRN_FLAGS
*
*	A list of event flags for each unit.
*************************************************************************/

LONG prn_flags[NBRUNIT] = { 0L, 0L, 0L, 0L };

/************************************************************************
*	PRN_PORTGET
*
*	Get the I/O address of the specified printer port.
*************************************************************************/

WORD prn_portget(unitno)
int unitno;
{
    static WORD *tval, getinit=0;

    if(!getinit){
	/***** Check for error return from mapphys() *****/
	if ( ( tval = (WORD *)mapphys(&prn_physpb,1) ) == NULLPTR )
		return(0);
	getinit = 1;
	}
    return(*(tval + unitno));
}

/************************************************************************
*	PRN_INIT
*
*	Initialize the specified unit number
*************************************************************************/

LONG prn_init( unitno )
WORD unitno;
{
    WORD port;
    WORD i;
    LONG rc;

					/* Get flag for future use.	*/
    if( (rc = flagget()) == NULLPTR ) return(ED_PRN | E_EMASK);
    prn_flags[unitno] = rc;
					/* Get some memory for asrwait */
    if ( ( StkSave[unitno] = salloc( StkSize ) ) == NULLPTR )
		return( ED_PRN + E_MEMORY);

#if PRINTER
    /***** Check for error from prn_portget (caused by mapphys()) *****/
    if ( ( port = prn_portget(unitno) ) == 0 )
	return( ED_PRN + E_MEMORY );
    outp( port+P_COMM, PRN_NOINT );	/* Assert INIT*			*/
    for( i = INITDLY; --i; );		/* Wait for printer to catch on	*/
					/* No ints, no auto lf, INIT* hi*/
    outp( port+P_COMM, PRN_NOINT+PRN_INIT );
#endif

    prn_table[unitno].PT_STATUS = 0L;
    return((LONG)DVR_PRN);		/* Return code.			*/
}

/************************************************************************
*	PRN_UNINIT
*
*	Uninitialize the current unit number... disable reading and
*	writing.
*************************************************************************/

LONG prn_uninit( unitno )
WORD unitno;
{
    if(flagrel(prn_flags[unitno]) < 0) return(ED_PRN | E_CONFLICT);
    if(StkSave[unitno] > 0L)
	  return( sfree(StkSave[unitno]) );
    return(E_SUCCESS);
}

/************************************************************************
*	PRN_SELECT
*
*	Enable printing on the selected unit.
************************************************************************/

LONG prn_select( pb )
DPBLK *pb;
{
    return(E_SUCCESS);
}

/************************************************************************
*	PRN_FLUSH
*
*	Flush the current unit number. Currently has no meaning for
*	a printer.
*************************************************************************/

LONG prn_flush( pb )
DPBLK *pb;
{
    if (!(pb->dp_flags))  {
	abflg[pb->dp_unitno] = 1 ;
    }
    return(E_SUCCESS);
}

/************************************************************************
*	PRN_READ
*
*	Again, no meaning for a printer.
************************************************************************/

LONG prn_read( pb )
DPBLK *pb;
{
    return(ED_PRN | E_IMPLEMENT);
}

/***********************************************************************
*	PRN_WRITE
*
*	Sets up an ASR function to do the write to the printer.
*	needs to make local copy of parmeter block.
*	And returns the event mask to the Resource Manager
************************************************************************/

LONG prn_write( pb )
DPBLK *pb;
{
	WORD	unitno,size,*d,*s;
	LONG	emask;

    unitno = pb->dp_unitno;		/* The unit number.		*/

    if((emask=flagevent(prn_flags[unitno],pb->dp_swi)) > 0L)
	{
	size = sizeof(DPBLK) / 2 ;		/* make it words */
	d = (WORD *) &prn_wpb[unitno];
	s = (WORD *) pb;
	while (size--) *d++ = *s++ ;
	doasr(prn_wrt,&prn_wpb[unitno],(LONG)*prn_dh.dh_curpd,201);
	}
    return(emask);
}

/***********************************************************************
*	PRN_WRT
*
*	Sends numchars from pbuf to the parallel port
*	sets up a POLLEVENT function if a wait for the printer status to be
*	ready is neccessary, then strobes the parallel port and returns.
************************************************************************/

VOID prn_wrt( pb,curpd )
DPBLK *pb;
LONG curpd;		/* for flagset at end */
{
    BYTE *pbuf;				/* Pointer to the characters	*/
    WORD unitno;			/* Which printer.		*/
    LONG numchars;			/* Number of characters in buf.	*/
    WORD pdelay, status;
    LONG emask,prn_poll;
    LONG rc 	 = 0L;			/* Error return from down under	*/
    LONG written = 0L;

    unitno = pb->dp_unitno;		/* The unit number.		*/
    if (abflg[unitno])  {
	abflg[unitno] = 0 ;
        if(rc == 0L) rc = written;		/* Get proper return code	*/
					/* Signal mama that we're done.	*/
        if (pb->dp_flags & DPF_UADDR) unmapu();
        flagset(prn_flags[unitno],curpd,rc);

	return ;
    }
    pbuf = pb->dp_buffer;		/* And wherever they are.	*/
    numchars = pb->dp_bufsiz;		/* Get number of characters.	*/
    
    if (pb->dp_flags & DPF_UADDR)
	{
	mapu( pb->dp_pdaddr );
	pbuf = (BYTE *) SADDR(pbuf);
	}

    for(; numchars--; ++written )	/* For each char in buffer	*/
					/* output it.			*/
     {
	status = inp( prn_portget(unitno)+P_STAT );/* Get printer status	*/
	if( status & PRN_ERR )
	    {				/* Any errors?		*/
		rc = (ED_PRN | E_CONFLICT);
		break;
	    }
	outp( prn_portget(unitno)+P_DATA, *pbuf++ );	/* Latch the character	*/

#if PRN_SYN
	while( prn_status(unitno) == UNREADY )	/* Wait until ready.	*/
		;
#endif

#if PRN_ASY
	if ( prn_status(unitno) == UNREADY )	/* Wait until ready.	*/
	  {
	    prn_poll = (LONG)(prn_rtn[unitno]);
	    emask = pollevent(prn_poll,0L);	/* setup pollevent to	*/
	    asrwait ( emask,StkSave[unitno] );				/* Wait until ready.	*/

    	    if (abflg[unitno])  {
	    	abflg[unitno] = 0 ;
	        if(rc == 0L) rc = written;		/* Get proper return code	*/
					/* Signal mama that we're done.	*/
	        if (pb->dp_flags & DPF_UADDR) unmapu();
	        flagset(prn_flags[unitno],curpd,rc);
       	        return ;
    	    }

	    if (pb->dp_flags & DPF_UADDR)
		{
		mapu( pb->dp_pdaddr );
		pbuf = (BYTE *) SADDR(pbuf);
		}
	  }
	else {
		asrwait(0L,StkSave[unitno]) ;
        	if (pb->dp_flags & DPF_UADDR)
			{
			mapu( pb->dp_pdaddr );
			pbuf = (BYTE *) SADDR(pbuf);
			}
	}
#endif

	outp( prn_portget(unitno)+P_COMM, PRN_NOINT+PRN_INIT+PRN_STROBE );
	for( pdelay=STRBDLY; --pdelay; );		/* Keep it high for now	*/
							/* Set STROBE low	*/
	outp( prn_portget(unitno)+P_COMM, PRN_NOINT+PRN_INIT );

     }

    if(rc == 0L) rc = written;		/* Get proper return code	*/
					/* Signal mama that we're done.	*/
    if (pb->dp_flags & DPF_UADDR) unmapu();
    flagset(prn_flags[unitno],curpd,rc);
}


/************************************************************************
*	PRN_STATUS
*
*	Return the status of the printer -- -1 if ready, else 0
*************************************************************************/

WORD prn_st0()
{
#if CONSOLE
    outp( USRPORT, 7 );
    return( (inp(STPORT) & 1) ? READY : UNREADY );
#endif

#if PRINTER
    return(prn_status(0));
#endif
}

WORD prn_st1()
{
    return(prn_status(1));
}

WORD prn_st2()
{
    return(prn_status(2));
}

WORD prn_st3()
{
    return(prn_status(3));
}

WORD prn_status(unitno)
WORD unitno;
{
    WORD tempds, pstat;

/****    drvsetds(&tempds,&prn_dh);*****/
    pstat = (inp(prn_portget(unitno)+P_STAT ) & PRN_NBY) ? READY : UNREADY;
/****    drvresds(&tempds);	*/
/****    pstat = (inp( 0x3BC+P_STAT ) & PRN_NBY) ? READY : UNREADY;*****/
    return(pstat);
}

/************************************************************************
*	PRN_GET
*	PRN_SET
*
*	The driver GET and SET functions ... awaiting definition of the
*	table.
*************************************************************************/

LONG prn_get( pb ) 
DPBLK *pb ;
{
	BYTE	*buff;

	buff = pb->dp_buffer;

	if ( pb->dp_flags & DPF_UADDR )
	{
		mapu(pb->dp_pdaddr);
		buff = (BYTE *) saddr(buff);
	}

	getset(&prn_table[pb->dp_unitno],buff,(WORD)pb->dp_bufsiz);

	if ( pb->dp_flags & DPF_UADDR )
		unmapu();
	return(E_SUCCESS);
}

LONG prn_set( pb ) 
DPBLK *pb ;
{
	BYTE	*buff;

	buff = pb->dp_buffer;

	if ( pb->dp_flags & DPF_UADDR )
	{
		mapu(pb->dp_pdaddr);
		buff = (BYTE *) saddr(buff);
	}

	getset(buff,&prn_table[pb->dp_unitno],(WORD)pb->dp_bufsiz);

	if ( pb->dp_flags & DPF_UADDR )
		unmapu();
	return(E_SUCCESS);
}

/************************************************************************
*	PRN_SPECIAL
*
*	Again, a function that doesn't apply (yet, at least) to the
*	printer drivers.
*************************************************************************/

LONG prn_special( pb )
DPBLK *pb ;
{
    return(ED_PRN | E_IMPLEMENT) ;
}

/************************************************************************
*	PRN_SUBDRV
*
*	The printer driver does not need a sub driver
*************************************************************************/

LONG prn_subdrv( pb )
DPBLK *pb ;
{
    return(ED_PRN | E_UNWANTED) ;
}

/************************************************************************
*	GETSET
*
*	Common routine for PRN_GET() and PRN_SET() code
*	copies sz words from source pointer to destination pointer
*	checking against field size.
*************************************************************************/
/*
*
*	here's a little macro for checking if this field is now beyond
*	the size of get/set requested.  Done by macro so source code line
*	length remains exceptable
*/

#define	ckspace(s,p,n)	((s) -= sizeof((p))) >= sizeof((n))

VOID	getset(sp,dp,sz)
REG PTE	 *sp,*dp;
REG WORD sz;
{
	BYTE	i;

 if( sz >= sizeof(dp->PT_STATUS))
 {
  dp->PT_STATUS = sp->PT_STATUS;
  if( ckspace(sz,dp->PT_STATUS,dp->PT_MODE) )
  {
  dp->PT_MODE = sp->PT_MODE;
   if( ckspace(sz,dp->PT_MODE,dp->PT_PAPERTYP) )
   {
   dp->PT_PAPERTYP = sp->PT_PAPERTYP;
   if( ckspace(sz,dp->PT_PAPERTYP,dp->PT_WIDTH) )
    {
    dp->PT_WIDTH = sp->PT_WIDTH;
    if( ckspace(sz,dp->PT_WIDTH,dp->PT_LEGMODE) )
     {
     dp->PT_LEGMODE = sp->PT_LEGMODE;
     if( ckspace(sz,dp->PT_LEGMODE,dp->PT_SINGPAG) )
      {
      dp->PT_SINGPAG = sp->PT_SINGPAG;
      if( ckspace(sz,dp->PT_SINGPAG,dp->PT_LPI) )
       {
       dp->PT_LPI = sp->PT_LPI;
       if( ckspace(sz,dp->PT_LPI,dp->PT_LENGTH) )
        {
        dp->PT_LENGTH = sp->PT_LENGTH;
        if( ckspace(sz,dp->PT_LENGTH,dp->PT_NAME) )
         {
	 for (i=0 ; i < sizeof(dp->PT_NAME) ; i++)
         	dp->PT_NAME[i] = sp->PT_NAME[i];
         }
        }
       }
      }
     }
    }
   }
  }
 }
}
