 
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.4.1      IFDISR.C                                 *
 *                      Contains Floppy Disk ISR's.              *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1       6/17/85 reb     changed calls yabnc to _bmove    *
 *    1.2       6/17/86 mei	High C port. Disk errors OR'd    *
 *				   with ED_DISK.		 *	
 *    1.3       860916  reb     add sti to isr opening statements*
 *    1.4       01/25/87 KPB    Added INPW to slow floppy down   *
 *                              and OUTPW.(FOR 386)              *
 *    1.4.1     07/12/87	removed extern _bmove		 *
 *===============================================================*
 *  INCLUDES:                                                    */

#include        "portab.h"
#include        "system.h"              /*  system defines              */
#include        "atmc286.h"             /* machine defs                 */
#include        "io.h"                  /*  i/o driver definitions      */
/* (gam) 1 may - combined dk.h and floppy.h to one header file  */
#include        "fd.h"

#if METAWARE 
#define IFDISR
#include "protos.h"
#endif

/* (gam) 1 may added externs    */
EXTERN  IORB    *FDI ;
EXTERN  BYTE    FDDRIVE ;
EXTERN  ISR     (*FDISR)() ;
EXTERN  ASR     (*FDASR)() ;
EXTERN  FDTF    *CurTF ;
EXTERN  FDLUTE  DKUT[] ;
EXTERN  BYTE    RecalRetry ;
EXTERN  WORD    CurCyl[] ;
EXTERN  VOID	outp(), fd_reset(), position();
EXTERN	BYTE	INP();
EXTERN  VOID    KillTime();
EXTERN	BOOLEAN	FInResFromFdc();
        BYTE    INPW();
        VOID    OUTPW();
ERROR	fd_ErrorAnal();

/************************************************************************
*  code macros
*/

#define FDCBUSY                 (INPW( FSTPORT ) & FSTFBSY)



/************************************************************************
 *                                                                      *
 *                      Floppy Driver ISR                               *
 *                                                                      *
 *  ** NOTE **  this file is INCLUDED in a source compile control file  *
 *              such as ifd86.c or ifd286.c                             *
 ************************************************************************/
/************************************************************************
 *  flop_interrupt -
 *
 *  THIS ROUTINE (except for fd_ErrorAnal) and the text below are straight
 *  FROM THE INTEL PUBLICATION "APPLICATION NOTE AP-121; Software Design
 *  and Implementation of Floppy Disk Subsystems" June, 1981.
 *
 *      interrupt processing for the fdc.  Basically, two types of
 *      interrupts are generated by the 8271/765:
 *
 *              a)  when the execution phase of an operation has been
 *              completed, an interrupt is generated to signal the beginning
 *              of the result phase (the fdc *BUSY* flag is set when this
 *              interrupt is receeived).  
 *      
 *              b)  when an overlapped operation is completed or an unexpected
 *              interrupt is received (the fdc busy flag is *NOT* set when this
 *              interrupt is received).
 *      
 *              When an interrupt of type (a) is received, the result bytes from
 *              the operation are read from the fdc and the operation complete
 *              flag is set.
 *      
 *              When an interrupt of type (b) is received, we output a Sense
 *              Interrupt Status command to reset the interrupt line, then
 *              read in the results of the command to determine the nature of 
 *              the interrupt.  After processing the interrupt request
 *              (described below) we repeat the Sense Interrupt Status Command
 *              to catch any hidden interrupt requests (this is recommended by
 *              Intel).
 *
 *              After a Sense Interrupt Status Command, only ST0 is read back
 *              in for the result phase.  Bits 5,6,and 7 will indicate one of
 *              the following reasons for interrupt, and which action should 
 *              be taken:
 *      
 *                1.    an overlapped operation (recalibrate or seek) has been
 *                completed.  
 *      
 *                2.    an abnormal  termination of an operation has
 *                occurred.  
 *      
 *                3.    The execution of an invalid command has been
 *                attempted.  This signals the successful completion of all
 *                interrupt processing, as a Sense Interrupt Command with no
 *                interrupts pending will return an invalid command status.
 *      
 *                4.    The ready status of a drive has been changed.  
 *                **The DoorOpen Flag is set to TRUE.**
 *
 *                If an operation is currently in progress on
 *                the affected drive, the result data is placed in the
 *                currently active task file.
 *                **  It is assumed that another interrupt will occur indi-
 *                cating the end of the command that was in progress; this 
 *                may be picked by the next issuance of the Sense Interrupt
 *                Command **.
 *      
 *                If an operation is not in progress on the affected drive,
 *                the result data is put in the affected drive's task file.
 *
 *              After an interrupt is processed, additional sense interrupt
 *              status commands must be issued and processed until an invalid
 *              command result is returned form the fdc.  This action
 *              guarantees that all "hidden" interrupts are serviced.
 *      
 */

ISR     flop_interrupt()
{
        /*********************/
        static FDTF     IntTF ;         /*  temp task file              */

        BOOLEAN br = FALSE ;            /*  boolean return code         */
        BYTE    driveno ;               /*  drive number for interrupt  */
        BYTE    ic ;                    /*  interrupt code M0008        */
        FDTF    *f ;                    /*  task file ptr               */

        EXTERN	BOOLEAN fd_IntStatus() ; /*  output sense interrupt      */
        EXTERN	BOOLEAN fd_DriveStatus() ;  /*  output sense drive status   */
        /********************/

        OUTPW( PICOCWPORT , PICSEOICMD ) ;       /*  reset pic           */
	STI() ;


        if( FDCBUSY )
        {
                /*
                 *  if the fdc is busy when an interrupt is received, then the
                 *  result phase of the previous non-overlapped operation
                 *  has begun.
                 *
                 *  proc interrupt if operation in progress
                 */
                f = CurTF ;                     /*  get addr of task file    */
                                                /*  for cmd just issued      */

                if( !(FInResFromFdc(f)) )       /*  error on result input?   */
                        GOTO fdi_stuck ;

                FDI->io_error = fd_ErrorAnal( f ) ;
                if( FDASR ) DKASR( FDASR , 0L , 0L ) ;
                if(  FDISR  ) br = (*FDISR)() ;

        }
        else
        {
                /* 
                **  if the fdc is not busy, then:
                **      1.      an overlapped operation has been completed 
                **              (seek or recal)
                **      2.      Ready Line of one of the drives has changed
                */

                while(1)                        /*  until fdc satisfied  */
                {
                        if( !fd_IntStatus( f = &IntTF )  )
                                GOTO fdi_stuck ;

                        /*  determine which drive interrupted us        */
                        /*  and get results into proper task file       */

                        driveno = f->fd_res[0] & FDRDRV ;

                        if( driveno > FDMAXUNITS-1 )            /*  M0009  */
                                continue ;                      /*  [3]    */

                        if( driveno == FDDRIVE )
                                f = CurTF ;
                                
                        /*  
                        **  check termination code  
                        */

                        ic = IntTF.fd_res[0] & 0xc0 ;   /* [2] M0008  */

                        if( ic == 0  ||  ic == 0x40  )
                        {
                                /*  
                                **  operation complete for seek, recal
                                **  or abnormal termination             
                                */
                                _bmove( &IntTF.fd_res[0] , &f->fd_res[0] ,  RFMAX);
                                FDI->io_error = fd_ErrorAnal(f) ;
                                if( FDASR ) DKASR( FDASR , 0L , 0L ) ;
                                if( FDISR ) 
                                {
                                        br = (*FDISR)() ;
                                        break ;
                                }
                        }
                        else if( ic == 0x80 )
                        {
                                /*  
                                **  invalid command / no more nested interrupts                 
                                */
                                break ;
                        }
                        else /*  if( ic == 0xc0 )  */
                        {
                                /*  drive ready change [1]              */

                                if( ! fd_DriveStatus( driveno , f ) )
                                        GOTO fdi_stuck ;

                                DKUT[ driveno ].fu_dooropen =
                                    ( ! (f->fd_res[ 0 ] & 0x20)  ) ; /* [5] */
                        }
                } /*  end for stmt  */
        } /*  end else  */

        return( br ) ;

fdi_stuck:
        FDI->io_error = (ED_DISK | E_DKATTACH) ;
        fd_reset() ;
        return( TRUE ) ;
}

/*
**  FOOTNOTES:
**
**  [1] If the door open interrupt is for the drive on which a command was
**      in progress, then we will either get an abnormal termination on the
**      next issuance of the sense interrupt status, get another interrupt,
**      or time out.  So we won't worry about taking care of the FDASR, FDISR
**      routines here (this is, after all, an abnormal situation).
**
**  [2] mask off all but the top two bits, which are the interrupt completion
**      code bits.
**
**  [3] It's been noted that after seek interrupts, certain machines who shall
**      remain nameless (nudgenudge) change the state of the ready lines which
**      are available for drives 2 and 3.  Of course this is invalid, since 
**      there are no such drives - so we must ignore them.
**
**  [4] if more than one normal operation interrupt occurrs (case ic == 0,0x40)
**      in the NOT BUSY part of the code, above, the FDASR and FDISR will be 
**      called twice.
**      This is not good, but is not likely to happen, either, as we start 
**      one operation at a time.  
**      Typically, the NOT BUSY interrupt will be the result of a seek or 
**      recal int., which will first fall to the operation complete case, 
**      re-issue the sense interrupt status, get an invalid command error, 
**      then exit the loop. (see [3]).
**
**  [5] 0x20 masks all but the ready bit in the st3 register.  if the ready 
**      bit is on, then the drive is ready and we set dooropen to false; if
**      the ready bit is off, then the drive is not ready, and we must set 
**      dooropen to TRUE.
*/



/**************************************************************************
*  recal_intr -
*/

VOID    recal_intr()
{
        /**********/
        ERROR   err ;

        EXTERN 	PROC    start_recal() ;
        EXTERN	PROC    flop_iocompl() ;
        EXTERN  PROC    fd_ClearTimer() ;
        /**********/


        fd_ClearTimer() ;

        if ( (err = FDI->io_error)  == NULLPTR )
        {
                CurCyl[ FDDRIVE ] = 0 ;
                position() ;
        }
        else if ( ( err == (ED_DISK | E_READY ) )    || 
		  ( err == (ED_DISK | E_DKATTACH ) ) || 
                  ( err == (ED_DISK | E_WPROT ) ) 	)
                flop_iocompl() ;

        else if( RecalRetry-- )
                start_recal() ;

        else /*  not terminal and no retries  */
        {
                if( err == NOT_TRK0 )
                        FDI->io_error = (ED_DISK | E_DKATTACH) ;
                flop_iocompl() ;
        }

}




/**************************************************************************
*  seek_intr -
*/
VOID    seek_intr()
{
        EXTERN	PROC    fd_ClearTimer() ;
        EXTERN	PROC    seek_end() ;

        fd_ClearTimer() ;
        seek_end() ;
}

/**************************************************************************
*  fmseek_intr -
*/
VOID    fmseek_intr()
{
        EXTERN	PROC    fd_ClearTimer() ;

        fd_ClearTimer() ;
}



/***********************************************************************
*  fd_ErrorAnal -
*       analyzes result file and returns the 
*       appropriate error code
*/

ERROR   fd_ErrorAnal( f )
FDTF    *f ;
{
        ERROR           r ;
        REG BYTE        s ;     /*  ST0 or ST1 from res file in FDTF    */
        BYTE            ic ;    /*  interrupt code                      */

        s = f->fd_res[0] ;      /*     S  ==   ST0                      */
        ic = (s & 0xc0) ;       /*  get interrupt code                  */

        if( !ic )               /*  no error                            */
                r = 0L ;

        else if( ic == 0x80 )
                r = (ED_DISK | E_INVCMD) ;

        else if( ic == 0xc0 )
                r = (ED_DISK | E_READY) ;

        /*  ic must be equal to 0x40 - abnormal termination  */

        /*  bit 5, seek end, is not an error flag                       */

        else if( s & 0x10 )                     /*  eq. check flag      */
                {
                        if( (f->fd_cmd[0] & 0x0f) == FCMRECAL )
                                r = NOT_TRK0 ;
                        else
                                r = (ED_DISK | E_DKATTACH) ;
                }

        else if( s & 0x08 )
                r = (ED_DISK | E_READY) ;           /*  not ready (again)   */

        /*  bits 0, 1, and 2 are unit and head select bits              */

        else                                    /*  abnormal termination */
        {
                if(  ( s = f->fd_res[1] )  == NULLPTR ) /*  get STATUS REG 1*/
                        r = (ED_DISK | E_DKATTACH) ;

                else if( s == 0x80 )            /*  past end of cyl?    */
                        r = SUCCESS ;           /*    no error [1]      */
                else if( s & 0x20 )             /*  crc error           */
                        r = (ED_DISK | E_CRC) ;
                else if( s & 0x10 )             /*  dma overrun         */
                        r = (ED_DISK | E_GENERAL) ;
                else if( s & 0x04 )             /*  No Data Bit         */
                        r = (ED_DISK | E_SEC_NOTFOUND) ;
                else if( s & 0x02 )             /*  write protected     */
                        r = (ED_DISK | E_WPROT) ;
                else if( s & 0x01 )             /*  no address mark     */
                        r = (ED_DISK | E_MISADDR); /* (reb) 850314 for int13 */
                else
                        r = (ED_DISK | E_DKATTACH) ;     /*  we missed something */
        }
        
        return( r ) ;
}

/*
** [1]  reading past the end of a cylinder is not necessarily an error; on
**      the compupro, the dma does not output a terminal count (tc) signal,
**      and so the fdc will continue reading from the disk, although it
**      only outputs the desired number of sectors on the buss (my
**      interpretation, but it does something like this).  In short, past
**      end of cylinder, by itself, is not an error.
**                      - ktb.
*/
/**************************************************************************
*  Function INPW.  This function calls INP.  It is used to slow down down *
*  the INP call to avoid running out of ASR's.                            *
*                                                                         *
***************************************************************************/
BYTE INPW(Word)
WORD Word;
{
 KillTime();
 KillTime();
 return(INP(Word));
 KillTime();
 KillTime();
};
VOID  OUTPW(Word1,Word2)
WORD   Word1;
WORD   Word2;
{
 KillTime();
 KillTime();
 OUTP(Word1,Word2);
 KillTime();
 KillTime();
}
