/*======================================================================*
 *   Version 2.9	Console Driver					*
 *			Header file					*
 *----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *   1.00   3/19/85  8:12 DR-K  Added this intro to files		*
 *   1.01   4/18/85 10:16 DR-K	CTE flags defined			*
 *   1.02   4/23/85  9:45 DR-K	define CP_CURMOVE			*
 *   1.03   5/03/85 14:06 DR-K	define TIMER,BASE,BEEPTIME		*
 *   1.04   5/20/85 10:52 DR-K	cleanup and reconcile			*
 *   1.05   6/12/85 13:56 DR-K	use io.h for defines of DPB and DH	*
 *   1.06   6/12/85 15:02 DR-K	define all OC_ 16-bit characters	*
 *   2.0    10/2/85 12:38 DR-K	define CP_REORDER as only a VCorder copy*
 *   2.1   10/29/85	  DR-K	define PCT_BITMAP as this console can be*
 *				 a PC memory mapped video lookalike	*
 *   2.2   11/01/85 16:19 RFW   added v_imode to VCBLK structure and    * 
 * 				added IMGRAPHIC flag to CTE struct 	*
 *   2.3    3/4/86	  DR-K	added v_ptop to VCBLK for physical top	*
 *   2.4    3/17/86       RFW   changed meaning of mouse flag		* 
 *   2.5    4/28/86	  DR-K	moved CT_pcframe to end of table	*
 *   2.6    9/18/86 	  RFW	Defined CTx_ROW, CTx_COL, CTx_FLGS,	*
 *				CTx_PL, CTx_ATT, CTx_EXT, CTx_CC,       *
 *				CTx_NFKS, CTx_BUTS, CTx_SNUM, CTx_MR, 	*
 *			       and CTx_MC where x is the console number.*
 *				So that the default CONSOLE TABLE 	*
 *				configuration is modified here instead 	*
 *				having to know where it is in ICDRV.c.	*
 *   2.7    02/02/1987    KJ	set console default values for MOUSE Driver *
 *   2.8    05/07/1987    KJ	add CT_crows, CT_ccols, CT_charheight,  *
 *				and CT_charwidth to CTE stucture.       *
 *   2.9    06/17/1987    KJ	removed min(), max(), abs() to PORTAB.H *
 *======================================================================*/
/*
**  10/1/86  PKB
**  references to CDOS, Concurrent or Concurrent DOS changed to FlexOS
*/


/*************************************************************************/
/* NOTE: Changing the Default configuration of the Console Table for each*/
/* console supported is done below. You may respecify any of the defined */
/* values. The CTx_FLGS field is a Byte field and maybe set to one of the*/
/* following defines all the other bits are set during init.		 */
/*************************************************************************/
/* CTx_FLGS defines */

#define AMOUSE   4				/* A Mouse is supported  */
#define NONUMPD  2				/* No Number Pad is supported*/
#define NUMPD	 0				/* A NUMBER Pad is supported */
/* CTx_CC defines */
#define USofA	1670			/* Define United States country code */

/* Console 0 Defaults */
#define CT0_ROW		25			/* Number of rows */
#define CT0_COL		80			/* Number of cols */
#define CT0_FLGS	1		/* Graphics   FLAGS bits set */
#define CT0_PL		3			/* Number of plains */
#define CT0_ATT		8			/*Number of bits in att plain*/
#define CT0_EXT		0			/*Number of bits in ext plain*/
#define CT0_CC		USofA			/* The Country code */
#define CT0_NFKS	10			/* Number of function keys */
#define CT0_BUTS	0			/* Number of mouse buttons */
#define CT0_SNUM	0L			/* Serial # of mouse */
#define CT0_MR		1			/* mickeys per pixel for rows*/
#define CT0_MC		1			/* mickeys per pixel for cols*/
#define CT0_CH		8			/* character hight in pixel  */
#define CT0_CW		8			/* character width in  pixel */

/* Console 1 Defaults */
#define CT1_ROW		24			/* Number of rows */
#define CT1_COL		80			/* Number of cols */
#define CT1_FLGS	NONUMPD			/* FLAGS bits set*/
#define CT1_PL		3			/* Number of plains */
#define CT1_ATT		8			/*Number of bits in att plain*/
#define CT1_EXT		0			/*Number of bits in ext plain*/
#define CT1_CC		USofA			/* The Country code */
#define CT1_NFKS	9			/* Number of function keys */
#define CT1_BUTS	0			/* Number of mouse buttons */
#define CT1_SNUM	0L			/* Serial # of mouse */
#define CT1_MR		1			/* mickeys per pixel for rows*/
#define CT1_MC		1			/* mickeys per pixel for cols*/
#define CT1_CH		8			/* character hight in pixel  */
#define CT1_CW		8			/* character width in  pixel */

#define CT2_ROW		24			/* Number of rows */
#define CT2_COL		80			/* Number of cols */
#define CT2_FLGS	NONUMPD			/* FLAGS bits set*/
#define CT2_PL		3			/* Number of plains */
#define CT2_ATT		8			/*Number of bits in att plain*/
#define CT2_EXT		0			/*Number of bits in ext plain*/
#define CT2_CC		USofA			/* The Country code */
#define CT2_NFKS	9			/* Number of function keys */
#define CT2_BUTS	0			/* Number of mouse buttons */
#define CT2_SNUM	0L			/* Serial # of mouse */
#define CT2_MR		1			/* mickeys per pixel for rows*/
#define CT2_MC		1			/* mickeys per pixel for cols*/
#define CT2_CH		8			/* character hight in pixel  */
#define CT2_CW		8			/* character width in  pixel */


/****************************************************************/
/*      PROGRAM CONTROLS					*/
#define	COMPU	FALSE	/* is this a CompuPro driver		*/
#define subs	TRUE	/* whether there are subdrivers		*/
#define TxINT	FALSE	/* should we enable tx_interrupts	*/
#define	NOWRAP	TRUE	/* don't do wraparound on EOLN writes	*/
/****************************************************************/


/****************************************************************/
/*  first some data structures used by any driver		*/
/****************************************************************/

#define	ERROR		LONG	/* type of error code returns	*/
#define EMASK		LONG

#define E_IllUnitno	(E_UNITNO | ED_CON)


/****************************************************************/
/*  Console Driver  dependent type definitions 			*/
/****************************************************************/

#define	 MAXcdUNIT	3	/* number of units */
#define	 BITMAP		0	/* unit number of the mem mapped video */

#define  BASE		0x60    /* keyboard left-most port */
#define	 TIMER		0x40	/* timer chip port address */
#define	 BEEPTIME	1400	/* Loop counter for beep */

/** #define  max(a,b)  ((a) > (b) ? (a) : (b))   now in PORTAB.H  */
/** #define  min(a,b)  ((a) < (b) ? (a) : (b))		"	" */
/** #define  abs(w1)  ((w1) < 0 ? (-w1) : (w1))		"	" */

#define RECT 		struct 	rectstruct
#define FRAME		struct 	framestruct

#define topVF		0x0080	/* this is the topmost VirCon	*/
				/* whether to update the cursor */

#define PL_USE0		0x01	/* Plane 0 usage mask		*/
#define PL_USE1		0x02	/* Plane 1 usage mask		*/
#define PL_USE2		0x04	/* Plane 2 usage mask		*/
#define PL_USEALL	0x03	/* All Planes usage mask	*/
#define PL_NPLANE	3	/* Number of Planes		*/

#define PL_CHAR		0	/* Character Plane Index, Shift	*/
#define PL_ATTR		1	/* Attribute Place Index, Shift	*/
#define PL_EXT		2	/* Extension Plane Index, Shift	*/

#define	CW_PWflg	0x4000	/* Phys update also on this VC op */

	/** Bit meanings within the Copy/Alter parmblk option field */
#define	DESTUFRAME	0x01
#define	SRCUFRAME	0x02
#define	ALTER		0x04	/* this is an Alter operation	*/
#define VSYNC		0x08	/* Color Bitmap video wait for Vsync */
#define	CPPMASK		0x03	/* mask for ops within copy/Alt	*/
/************************************************************************/
FRAME
{
	BYTE	*fr_pl[PL_NPLANE];	/* addr of plane data */
				/* 0- char 1 - attrib 2 - color */
	UWORD	fr_nrow;	/* Number of rows in frame	*/
	UWORD	fr_ncol;	/* Number of columns in frame	*/
	UWORD	fr_use;		/* bit field of plane usage. If bit = 1,*/
				/* plane pointer indicates an array,	*/
				/* else points to a single byte that 	*/
				/* represents a plane with every byte	*/
				/* the same value.			*/
};

RECT
{
	UWORD	r_row;		/* origin row				*/
	UWORD	r_col;		/* origin column			*/
	UWORD	r_nrow;		/* number of rows			*/
	UWORD	r_ncol;		/* number of columns			*/
};

#define CDCOPALT	struct  condrvcopyaltstruct

CDCOPALT
{
	BYTE	cd_unit;	/* unit number			*/
	BYTE	cd_opt;		/* options			*/
	UWORD	cd_flags;	/* you guessed it		*/
	UWORD	cd_crow;	/* current row			*/
	UWORD	cd_ccol;	/* current column		*/
	PD	*cd_pd;		/* process descriptor address of*/
				/* user process owning UFRAME	*/
	FRAME	*cd_dfram;	/* address of destination frame	*/
	RECT	*cd_drect;	/* address of destination rectangle	*/
	FRAME	*cd_sfram;	/* address of source frame	*/
	RECT	*cd_srect;	/* address of source rect       */
};

#define	CPBLK	struct	CopyInfoBlkstruct
		/* Implementation specific info for Copy/Alter moves */
CPBLK
{
	VOID	(*cp_rowcopy)();	/* routine to move characters	*/
	VOID	(*cp_chfill)();		/* routine to fill characters	*/
	VOID	(*cp_rowalt)();		/* routine to alter characters	*/
	WORD	cp_sindex;		/* source index number		*/
	WORD	cp_dindex;		/* destination index		*/
};

#define	CP_CURMOVE	0x1000	/* This copy/alter call will be just */
				/* a cursor move call */
#define CP_REORDER	0x0800	/* This copy/alter call will be need */
				/* to store the sources v_att,v_mode */
				/* and v_top to destinations	     */
#define CTE     struct  conTablestruct
CTE
{
        UWORD   CT_rows         ;/* number of pixel rows                */
        UWORD   CT_cols         ;/* number of pixels columns            */
        UWORD   CT_crows        ;/* number of character rows            */
        UWORD   CT_ccols        ;/* number of character columns         */
        BYTE    CT_flags        ;/* flags                               */
        BYTE    CT_planes       ;/* planes being supported              */
        BYTE    CT_attrp        ;/* attribute plane bits supported      */
        BYTE    CT_extp         ;/* extension plane bits supported      */
        UWORD   CT_country      ;/* country code number                 */
        BYTE    CT_nfkys        ;/* number of function keys             */
        BYTE    CT_buttons      ;/* number of mouse buttons             */
        LONG    CT_serial       ;/* serial number of the mouse          */
        UWORD   CT_murow        ;/* mouse row units per inch            */
        UWORD   CT_mucol        ;/* mouse column units per inch         */
	UWORD	CT_charheight   ;/* height of character cell in dots    */
	UWORD   CT_charwidth    ;/* width of character cell in dots	*/
        UWORD   (*CT_conv8)()	;/* ptr to 8 to 16 char convert routine */
        UWORD   (*CT_conv16)()	;/* ptr to 16 to 8 char convert routine */
        LONG    CT_pcframe      ;/* ptr to PC char map if available     */
} ;

/************* values for flag field above ******************************/
				/* such as I can do GRPAHICS		*/
#define	GRAPHIC	0x0001		/* 0==char mapped, 1==bit mapped	*/
#define	NUMPAD	0x0002		/* 0==has a numerical keypad		*/
#define	MOUSE	0x0004		/* 1==supports a mouse			*/
#define	COLOR	0x0008		/* 0==monochrome, 1==color screen	*/
#define	PCT_BITMAP 0x0010	/* 1==is a bit mapped memory video	*/
#define IMGRAPHIC 0x0020	/* 0==not in graphics mode, 1==in 	*/
				/* graphics mode */   
#define	PCFRAME	0x80		/* this frame is a PC look-alike */

/******** a Virtual Console Data Block ***************/
#define	VCBLK	struct	VirConDataBlock
VCBLK
{
	FRAME	v_frame		;/* description of this frame */
	UWORD	v_top		,/* where the topline of screen scrolled to */
		v_currow,
		v_curcol,
		v_cursx,	/* where the cursor should be left */
		v_cursy,
		v_tempx,
		v_tempy ;
	BYTE	v_escflg,	/*how deep into the esc handler */
		v_mode,		/*what mode we are in now*/
				/* bit 0 == 1 insert char mode	*/
				/*     1 == 1 delete this char	*/
				/*     2 == 1 reverse video mode*/
				/*     3 == 1 wraparound mode	*/
				/*     4 == 1 cursor invisiable	*/
				/*     5 == 1 Phys cursor off	*/
				/*     7 == 1 this is a PCframe	*/
		v_att,		/* the current write attribute	*/
		v_imode,	/* The current mode the 6845 crt*/
				/* controller should be for a   */
				/* virtual console.		*/
		*v_dirty;	/* a plane of boolean dirty markers */
	WORD	v_dbuf;		/* stores ptr into dirty when nextasr */
	WORD	v_ptop;		/* Pychical top, really the number of */
				/* hardware scrolls that have been done*/
} ;

	/* Fields used in v_mode above */
#define	INSCHM	1	/* insert character mode active */
#define	DELCHM	2	/* delete thes character mode 	*/
#define	REVVIDM	4	/* reverse video mode active	*/
#define WRAPM	8	/* wraparound mode is active	*/
#define	CURSOFFM 0x10	/* Cursor off mode		*/
#define	PCURSOFF 0x20	/* Physical Cursor turned off	*/
#define	PCFRAME	0x80	/* this frame is a PC look-alike */


#define	DRECT	struct	DirtyRectBlock
DRECT
{
	WORD	currow,		/* current cursor */
		curcol ;
	WORD	row;		/* origin column			*/
	WORD	col;		/* origin row				*/
	WORD	nrow;		/* number of columns			*/
	WORD	ncol;		/* number of rows			*/
};

#define	CDWRITE	struct	ConDrvWriteBlock
CDWRITE
{
	BYTE	cdw_unit;	/* unit number			*/
	BYTE	cdw_two;	/* unused			*/
	UWORD	cdw_flags;
	LONG	cdw_vcid;	/* vcon id # - 0 if PFRAME	*/
	PD	*cdw_pd;	/* ptr to PD of process owning BUFFER */
	WORD	*cdw_buffer;	/* ptr to character buffer	*/
	LONG	cdw_bufsiz;	/* buffer size in bytes		*/
	UWORD	cdw_row;	/* row position for start of write */
	UWORD	cdw_col;	/* column position for start of write	*/
	DRECT	*cdw_dirty;	/* ptr to structure containing new cursor
				 * position and info on Dirty region	*/
};

#define	CDSPECIAL   struct	SpclConDrvStruct
CDSPECIAL
{
	BYTE	cds_unit;	/* unit number			*/
	BYTE	cds_option;	/* function number		*/
	UWORD	cds_flags;
	UWORD	cds_rows;	/* number of rows desired	*/
	UWORD	cds_cols;	/* number of columns desired	*/
	BYTE	*cds_pl0;	/* pre-existing character plane ptr */
        UWORD   cds_mode ;
};

#define	PL0GIVEN	0x0040	/* on == cds_pl0 is provided	*/
#define	PHYSCON		0x0080	/* on == creating a physical	*/

#define	CDSELECT   struct	SelectConDrvStruct
CDSELECT
{
	BYTE	unitno;		/* unit number 			*/
	BYTE	cdse_two;	/* unused			*/
	WORD	cdse_three;	/* unused			*/
	LONG	kbd_pin;	/* address of KEYBOARD ASR	*/
	LONG	m_pin;		/* address of MOUSE ASR		*/
	LONG	mbut_pin;	/* address of BUTTON ASR	*/
	LONG	PConId;		/* Physical Console Id		*/
};

#define	CDMAPPB	struct	MapPhysAddrStruct
CDMAPPB
{
	LONG	zero;		/* not used */
	LONG	physaddr;	/* physical address to translate */
	LONG	length;
};

/*
 *	Defines for magic numbers in the 16 bit output character
 *	set for FlexOS.
 */

/* high nibble of 16 bit character */
#define OC_NOSEE	0x1	/* Non-visible characters that take no space */
#define OC_EDITFN	0x2
#define OC_ROWGOTO	0x3
#define OC_COLGOTO	0x4
#define OC_COLOR	0x5	/* 50 set foreground, 51 set background */

/* mask to extract the absolute new row or column if OC_ROWGOTO or OC_COLGOTO */
#define OC_GOTOMASK	0x0fff

/* define the particular edit functions if high nibble == OC_EDITFN */
#define OC_DOCHINSERT	0x40	/* Enter insert character mode */
#define OC_NOCHINSERT	0x4F	/* Exit insert character mode */
#define OC_UPCURSOR	0x41
#define OC_DOWNCURSOR	0x42
#define OC_RIGHTCURSOR	0x43
#define OC_LEFTCURSOR	0x44
#define OC_CLEAR	0x45
#define OC_HOME		0x48
#define OC_INDEXREV	0x49	/* Reverse Index (Reverse Line Feed) */
#define OC_EEOP		0x4a	/* Erase to End Of Page */
#define OC_EEOL		0x4b	/* Erase to End Of Line */
#define OC_EEL		0x6C	/* Erase Entire Line */
#define OC_LNINSERT	0x4c	/* Insert blank line */
#define OC_LNDELETE	0x4d	/* Delete Line */
#define OC_CHDELETE	0x4e	/* Delete Character */
#define OC_EBOP		0x64	/* Erase to Beginning of Display */
#define OC_ENABLECURS	0x65	/* Enable Cursor */
#define OC_DISABLECURS	0x66	/* Disable Cursor */
#define OC_SAVECURS	0x6A	/* Save the cursor position */
#define OC_RESTORECURS	0x6b	/* Restore Cursor Position */
#define OC_EBOL		0x6f	/* Erase to Beginning of Line */
#define OC_REVERSE	0x70	/* Enter Reverse Video */
#define OC_NOREVERSE	0x71	/* Exit Reverse Video */
#define OC_INTENSIFY	0x72	/* Enter Intensify Mode */
#define OC_NOINTENSIFY	0x75	/* Exit Intensify Mode */
#define OC_BLINK	0x73	/* Enter Blink Mode */
#define OC_NOBLINK	0x74	/* Exit Blink Mode */
#define OC_WRAP		0x76	/* Wrap at end of line */
#define OC_NOWRAP	0x77	/* Discard at End of Line */

