/*======================================================================*
 *   Version 2.3        Console Driver					*
 *			Miscellaneous Tools				*
 *----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *    .90   3/01/85	  FH	Conditional use of same asm routines	*
 *   1.00   3/19/85  8:12 DR-K  Added this intro to files		*
 *   1.01   4/03/85 14:05 DR-K	Add the real AT beep routine		*
 *   1.02   5/06/85 12:10 DR-K	Add e_timer and beepoff to beepbell()	*
 *   1.03   5/21/85 14:28 DR-K	add VTop (optimized scroll) 		*
 *   1.04   6/12/85 11:31 DR-K	add third unit data block		*
 *				 include io.h not pd.h			*
 *   1.05   7/24/85 21:32 DR-K	add c_update() so asrmx always in asr	*
 *   1.06   8/29/85 16:04 DR-K	use vars (Curs_Top, Curs_Bott) in 	*
 *				 off_pcursor() and on_pcursor()		*
 *   2.0   10/17/85  9:18 DR-K	fix beepoff by anding the bellbit off	*
 *   2.1   06/11/86       mei	High C port.				*  
 *   2.2   02/05/87 17:44 RFW	fixed beepbell() and beepoff() to only  *
 *				run one bell at a time in ASR land.	*
 *				As noted by (RW0001) for changes.	*
 *   2.3   06/17/87 11:11 KJ 	removed min() and max() with Meatware   *
 *				_min() and _max() intrinsics defined in *
 *				PORTAB.H				*
 *======================================================================*/

#define  NORASM	  FALSE  /* if 0, Replaced by RASM code */

#include "portab.h"
#include "io.h"
#include "system.h"
#include "icdrv.h"

#if METAWARE 
#define ICDRTOOL
#include "protos.h"
#endif

EXTERN	VCBLK	*pcb[] ;
EXTERN	BYTE	sd_units[] ;
EXTERN	DH	*sd_hdr[] ;
EXTERN	CTE	contab[];
EXTERN	BYTE	ranupd[];
EXTERN	LONG	c_mxid[];
EXTERN  WORD	CRTbase;

#if (COMPU == FALSE)
EXTERN	VOID	beepoff();
EXTERN	WORD	Curs_Top;
EXTERN	LONG	e_timer();
#endif
 
EXTERN	LONG	s_return();
EXTERN  VOID	OUTP();
EXTERN	BYTE	inp();
GLOBAL	VOID	update();
GLOBAL	VOID	pos_cursor();

MLOCAL  BOOLEAN bellst;	/*RW0001 state of bell ASR in beepbell() and beepoff()*/

BYTE cupdate[MAXcdUNIT] = {0,0,0};
UBYTE cupinf[] =
{
	0,0,0,0,
	0,0,0,0,
	0,0,0,0
};

VOID c_update(null,unit)
	LONG	null,unit;
{				/* run update in mxregion */
	LONG	e;
	if ( ( e = asrmx( c_mxid[unit] )) != NULLPTR  )
		nextasr( e, update, e , (LONG)unit, 200);
	   else
		update(0L,unit);
}

VOID movcurs(wrtok,unit)
    LONG wrtok;
    LONG unit;
{
    UBYTE *cupbuf;
    WORD  u,sdunit;
    LONG (*addr)();

	u = unit;
	if (ranupd[u] != 1)
	{
	    update(wrtok,unit);
	    return;
	}

	if (wrtok) s_return(wrtok);
	wrtok = 0;
	addr = (sd_hdr[u])->dh_write;
	sdunit = (UWORD) sd_units[u] ;
	cupbuf = &(cupinf[(u<<2)]);

	while (cupdate[u])
	{
	    wrtok = (*addr)(sdunit,*cupbuf);
	    (cupdate[u])--;
	    if (wrtok)
	    {
		nextasr(wrtok,movcurs,wrtok,unit,200);
		return;
	    }
	    cupbuf++;
	}

	ranupd[u]--;

	   /* See if someone has dirtied the PFRAME while we were updating
	    * the physical cursor.
	    */

	if (ranupd[u])
	    doasr(update,0L,unit,200);
	 else
	    mxrel( c_mxid[u] );	/* release the mxregion */
}

VOID update(wrtok,unit)	/* an ASR to update the physical screen */
    LONG wrtok;
    LONG unit;
{
    UWORD start,p,r,c,psize;
    LONG  vtop;
    VCBLK *v;
    FRAME *f;
    UBYTE *dp,ch;
    UWORD *cp;
    UBYTE *cupbuf;
    WORD  u,sdunit;
    UWORD vtrow,vtcol,diff;
    CTE	  *ct;
    LONG (*addr)();


	if (wrtok) s_return(wrtok);
	wrtok = 0;

	u = unit;
	addr = sd_hdr[u]->dh_write;
	sdunit = (UWORD) sd_units[u] ;
	ct = &(contab[u]);

		/* See if we are changing the cursor */

	cupbuf = &(cupinf[(u<<2)]);
	while (cupdate[u])
	{
	    wrtok = (*addr)(sdunit,*cupbuf);
	    (cupdate[u])--;
	    if (wrtok)
	    {
		nextasr(wrtok,update,wrtok,unit,200);
		return;
	    }
	    cupbuf++;
	}
	
	cupbuf = &(cupinf[(u<<2)]);
	v = (VCBLK *) pcb[u];
	f = (FRAME *) v ;
	psize = f->fr_nrow * f->fr_ncol ;
	start = p = v->v_dbuf;

	if (!start)
	    ranupd[u] = 1;

	vtop = (LONG)( (p + (v->v_top * f->fr_ncol)) % psize );
	cp = (UWORD *)( (LONG)(f->fr_pl[0]) + (LONG)(vtop << 1) );
	dp = vtop + v->v_dirty;
	vtrow = v->v_currow;
	vtcol = v->v_curcol;

	while ( (p < psize) && !(wrtok) )
	{

	    if (*dp)	/* if this position has been changed (dirty==1) */
	    {
		r = p / f->fr_ncol ;
		c = p % f->fr_ncol ;
		
		if ((vtrow != r) || (vtcol != c))
		{
			/* Cursor not in the right place */
			/* Set up a cursor move and goto update */

		    if ( (r == vtrow) &&
			 (c > vtcol) &&
			 ((diff = c - vtcol) <= 4))
		    {
				/* We are within 4 characters */
				/* Cheaper than cursor control */

			cp -= diff;
			while (diff--)
			{
			    (cupdate[u])++;
			    *cupbuf++ = *cp++;
			}
		    }
		    else
		    {
			if ( (r == 24) && (vtrow != r) )
			    {
				cupdate[u] = 3;
				*cupbuf++ = 0x1b;
				*cupbuf++ = 'x';
				*cupbuf = '1';
				c = 100;
			    }
			else
			    {
				cupdate[u] = 4;
				*cupbuf++ = 0x1b;
				*cupbuf++ = 'Y';
				*cupbuf++ = 0x20 + r;
				*cupbuf = 0x20 + c;
			   }
		    }
		    v->v_curcol = c;
		    v->v_currow = r;
		    v->v_dbuf = p;
		    doasr(update,0L,unit,200);
		    return;
		}
			/* Cursor in the right place */
			/* Write the character to the port driver */
			/* unless wierd case of writting a null */
		ch = (UBYTE) *cp ;
		if ( (ch < ' ') || (ch & 0x80) )
			ch = ' ';
		wrtok = (*addr)( sdunit,ch );
		start = p;		/* update last dirty */
		*dp = 0;
		vtcol++;
	    }
	    p++;
	    if ( ++vtop < psize )
	      {
		dp++;
		cp++;
	      }
	    else
	      {		/* we just wrapped around */
		vtop = 0;
		cp = (UWORD *)f->fr_pl[0];
		dp = v->v_dirty;
	      }
	}

	v->v_curcol = vtcol;

	if (wrtok)
	{
		/* We've overflowed the Port driver */
		/* Wait until its ready and continue */

	    v->v_dbuf = p;
	    nextasr(wrtok,update,wrtok,unit,200);
	    return;
	}

	v->v_dbuf = 0;

	if (start && (ranupd[u] > 1))
	{
		/* We are done with active pass, but more dirty	*/
		/* regions may have appeared behind us if	*/
		/* ranupd[unit] is not 1.			*/

	    if (ranupd[u] > 1)
	    {
		ranupd[u]--;
	        doasr(update,0L,unit,200);
	        return;
	    }
	}
		/* Made a complete pass with nothing to do	*/
		/* or no one has dirtied the PFRAME after we	*/
		/* started.  We're done so put the cursor back	*/
		/* where it belongs (only if visable)		*/

	if (v->v_mode & CURSOFFM)
	   {
		mxrel( c_mxid[u] );	/* release the sync block */
		ranupd[u] = 0;
	   }
	else
	   {
		ranupd[u] = 1;
		cupdate[u] = 4;
		*cupbuf++ = 0x1b;
		*cupbuf++ = 'Y';
		*cupbuf++ = 0x20 + (v->v_currow = v->v_cursx);
		*cupbuf = 0x20 + (v->v_curcol = v->v_cursy);
		doasr(movcurs,0L,unit,200);
	   }
}

#if NORASM

VOID ch1fill( buffer,size,fillch )	/*put fillch into every byte of buffer*/
    BYTE *buffer;
    WORD size;
    BYTE fillch;
{
	while (size--) 
	    *buffer++ = fillch ;
}

VOID ch2fill( buffer,size,fillch )	/*put fillch into every-other byte of buffer*/
    BYTE *buffer;
    WORD size;
    BYTE fillch;
{
	while (size--) 
	{
	    *buffer = fillch ;
	    buffer += 2 ;
	}
}

clip(d,row,col,nrow,ncol)
    RECT *d;
    WORD row, col, nrow, ncol;
{
    WORD dr,dc,r,c;

	dr = d->r_row + d->r_nrow -1;
	r = row + nrow -1;
	dc = d->r_col + d->r_ncol -1;
	c = col + ncol -1;

	d->r_row = _max(d->r_row,row); 
	d->r_col = _max(d->r_col,col);

	r = _min(r,dr);
	c = _min(c,dc);

	d->r_nrow = r - d->r_row + 1;
	d->r_ncol = c - d->r_col + 1;

	if ((d->r_row > r) || (d->r_col > c))
	    return(FAILURE);

	return(SUCCESS);
}

mod(a,b)
    WORD a,b;
{
    WORD c;
	if ((c = a%b) < 0) c += b;
	return(c);
}

/*
 *	The following set of Copy routines are used in copy
 *	when copying between the two basic types of frame
 *	representations: Virtual/Physical Frame and the User
 *	Frame.  By now you must realize that the Vurtual/Physical
 *	Frame representation has an interleaved character and attribute
 *	plane which is dictated by the physical design of the
 *	VME/10.  The extension plane is a single, contiguous byte
 *	plane.  All three planes in the user frame are single, contiguous
 *	byte planes.
 *
 *	This necessitates four types opf copy routine:
 *
 *		U to U		b1to1copy()
 *		U to P/V	b1to2copy()
 *		P/V to U	b2to1copy()
 *		P/V to P/V	b2to2copy()
 *		
 */

VOID	b1to1copy(s,d,count,dirty)
    BYTE *s, *d;
    WORD count;
    BYTE *dirty;
{
	if ((d > s) && ((s + count) > d ))
	{
	    s += count -1;
	    d += count -1;
	    while( count-- )
		*d-- = *s-- ;
	}
	else
	{
	    while( count-- )
		*d++ = *s++;
	}
}

VOID	b1to2copy(s,d,count,dirty)
    BYTE *s, *d;
    WORD count ;
    BYTE *dirty; 
{
	while( count-- )
	{
	    if (dirty)
	    {
		if (*d != *s) *dirty = 1;
		dirty++;
	    }
	    *d = *s++;
	    d += 2;
	}
}

VOID	b2to1copy(s,d,count,dirty)
    BYTE *s, *d;
    WORD count ;
    BYTE *dirty;
{
	while( count-- )
	{
	    *d++ = *s;
	    s += 2;
	}
}

VOID b2to2copy(s,d,count,dirty)
    BYTE *s, *d;
    WORD count;
    BYTE *dirty;
{
    WORD nbytes;

	nbytes = (count << 1);

	if( (d > s) && ((s + nbytes) > d ))
	{
	    s += nbytes;
	    d += nbytes;
	    if (dirty)
		dirty += count;
	    while( count-- )
	    {
		d -= 2;
		s -= 2;
		if (dirty)
		{
		    dirty--;
		    if (*d != *s)
			*dirty = 1;
		}
		*d = *s;
	    }
	}
	else
	{
	    while( count-- )
	    {
		if (dirty)
		{
		    if (*d != *s)
			*dirty = 1;
		    dirty++;
		}
		*d = *s;
		s += 2;
		d += 2;
	    }
	}
}

VOID b2alter(d,andc,xorc,count,dirty)
    UBYTE *d,andc,xorc;
    WORD count;
    BYTE *dirty;
{
    UBYTE tmp;

	while( count-- )
	{
	    tmp = ((*d & andc) ^ xorc);
	    if (dirty)
	    {
		if (*d != tmp)
		    *dirty = 1;
		dirty++;
	    }
	    *d = tmp;
	    d += 2;
	}
}

VOID b1alter(d,andc,xorc,count,dirty)
    UBYTE *d,andc,xorc;
    WORD count;
    BYTE *dirty;
{
    UBYTE tmp;

	while( count-- )
	{
	    tmp = ((*d & andc) ^ xorc);
	    if (dirty)
	    {
		if (*d != tmp) *dirty = 1;
		dirty++;
	    }
	    *d++ = tmp;
	}
}

/*
 *	Null function for illegal entries in Copy Table
 */

VOID illegal()
{
}

#endif	/* NORASM */


VOID off_pcursor(u)	/*** turn off the physical cursor ****/
	BYTE	u;
{
	pcb[u]->v_mode |= PCURSOFF;	/* mark physically off now */

#if (COMPU == FALSE)
	if (u == BITMAP)
	  {
		OUTP( CRTbase, 10);		/* select cursor reg */
		OUTP( CRTbase +1, 0x20 );	/* non-display */
		return;
	  }
#endif

	(*sd_hdr[u]->dh_write)(sd_units[u],0x001b);
	(*sd_hdr[u]->dh_write)(sd_units[u],'x');
	(*sd_hdr[u]->dh_write)(sd_units[u],'5');
}


VOID on_pcursor(u)	/*** turn on the physical cursor ****/
	BYTE	u;
{
	pcb[u]->v_mode &= ~PCURSOFF;	/* mark physically on now */

#if (COMPU == FALSE)
	if (u == BITMAP)
	  {
		OUTP( CRTbase, 10);		/* select cursor reg */
		OUTP( CRTbase +1, Curs_Top);	/* display */
		return;
	  }
#endif

	(*sd_hdr[u]->dh_write)(sd_units[u],0x001b);
	(*sd_hdr[u]->dh_write)(sd_units[u],'y');
	(*sd_hdr[u]->dh_write)(sd_units[u],'5');
}

VOID beepbell(u)	/*** beep the physical bell ***/
	BYTE	u;
{

#if (COMPU == FALSE)
	BYTE	val;
	LONG	emask;

	if (u == BITMAP)
	  {
		if (bellst) return; /* RW0001 don't allow another bell to fire*/
		OUTP( TIMER +3, 0xB6);	/* select timer value reg */
		OUTP( TIMER +2, 0x33);	/* lsb */
		OUTP( TIMER +2, 0x05);	/* msb */
		val = inp( BASE +1 );	/* save old value */
			/* timing loop */
		emask = e_timer( 0L,0,500L );
		OUTP( BASE +1, (val | 3) );	/* turn on speaker */
		bellst = TRUE;	/* RW0001 disallow anymore bells until done */
		nextasr( emask,beepoff,emask,(LONG)val,200);

		return;
	  }
#endif

	(*sd_hdr[u]->dh_write)(sd_units[u],0x0007);
}


VOID beepoff( emask,val )
	LONG	emask,val;
{
	OUTP( BASE +1, (BYTE)(val & ~3) );	/* restore old value */
	bellst = FALSE; 	/* RW0001 the bell is done so allow another */
	aret( emask );
}


VOID pos_cursor( r,c,ncols )		/* move the IBM cursor */
	UWORD	r,c,ncols;
{
	UWORD	temp;
	
	temp = ( r * ncols ) + c ;
	OUTP( CRTbase , 14 );	/* select cursor MSB register */
	OUTP( CRTbase+1 , temp >> 8 );
	OUTP( CRTbase , 15 );	/* select cursor LSB register */
	OUTP( CRTbase+1 , (BYTE) temp );
}
