echo off
cls
echo :
echo :    RAMDISK.BAT - This Batch file installs the Memory Disk Driver using
echo :                  the driver file /DRIVERS/RAMDSK.DRV
echo :
echo :    If a command line paramter is not used ( see below ) with this
echo :    batch file, the Memory Disk Driver will be installed with a
echo :    disk size of 64K.
echo :
echo :    RAMDSK.DRV is installed with the physical device name "RD0:" and
echo :    the logical device name "R:".
echo :
rem
rem    Check if a command line paramter was entered.
rem

if NOT @%1==@ goto SKIPAUSE

echo :    Command line parameters :  [ 64, 128, 256, 512 ]
echo :
pause
echo :

:SKIPAUSE
rem
rem    First check to see if rd0: has already been installed
rem

if not exist rd0: goto GETSIZE

rem
rem    Prepare to re-install install RD0: by first uninstalling the device
rem

echo :
echo :    Execute:  DVRUNLK RD0:

dvrunlk rd0:
if errorlevel 3 goto UNLOADERR
if errorlevel 2 goto UNLOADERR
if errorlevel 1 goto UNLOADERR

:GETSIZE
rem
rem    Is a size specified ?
rem
if @%1 == @ goto DEFAULTSIZE

rem
rem    Is the size specified valid ?
rem

if %1 ==  64 goto DEFINESIZE
if %1 == 128 goto DEFINESIZE
if %1 == 256 goto DEFINESIZE
if %1 == 512 goto DEFINESIZE

rem
rem    The size specified is invalid....Show the error.
rem
goto BADSIZE

rem
rem    Define the keyword RDSIZE to be a system level logical definition
rem    containing the size specification.
rem

:DEFAULTSIZE
rem
rem    No command line size specification, therefore, use
rem    the default size of 64k.
rem

define -s RDSIZE = 64
goto DOINSTALL

:DEFINESIZE
rem
rem    Use the command line size specification....
rem

define -s RDSIZE = %1

:DOINSTALL
rem
rem    Report the attempt to install the driver, and look for errors....
rem
echo :
echo :    Execute:  DVRLOAD RD0: \DRIVERS\RAMDSK.DRV LNRWS

dvrload rd0: \drivers\ramdsk.drv lnrws
if errorlevel 3 goto LOADERR
if errorlevel 2 goto LOADERR
if errorlevel 1 goto LOADERR

goto FINISH

rem
rem    Errors....
rem

:UNLOADERR
:LOADERR
rem
rem    Report the LOAD / UNLOAD error...
rem
echo :
echo :    An error occurred loading/unloading the current Ram Disk
echo :    Driver ( RD0: ).  The driver may be in use and cannot be
echo :    accessed by the DVRLOAD\DVRUNLK commands.
echo :
goto END

:BADSIZE
rem
rem    Report the BAD SIZE paramter entered on the command line...
rem
echo :
echo :    The command line parameter, [ %1 ], is invalid...
echo :
echo :    Valid command line paramters are: [ 64, 128, 256, 512 ].
echo :    Reenter the batch file with one of the above values.
echo :
goto END


:FINISH
rem
rem    Finish up the installation by assigning single letter access
rem    to the RAM DISK device.
rem

define -s r:=rd0:

rem
rem    Report success...
rem
if @%1 == @ goto REPORT64k

echo :
echo :    Ram Disk ( RD0: or R: ) has been installed with a size of %1K
goto END

:REPORT64k
echo :
echo :    Ram Disk ( RD0: or R: ) has been installed with a size of 64K

rem
rem    All done....
rem
:END
echo :
