### FLEX386.MAK :
### FlexOS 386 System Makefile
### High C version
###
##############################################################################
##									    ##
##	Executed from the default directory where all source and object     ##
##      modules	are located....						    ##
##									    ##
##	Compile time definitions.					    ##
##									    ##
##############################################################################
HCPRO 	=  -pro system.pro -def
MKKERN 	=  $HCPRO kern
MKLOADER=  $HCPRO loader
MKPRM 	=  $HCPRO prm
MKCRM 	=  $HCPRO crm
MKCONF 	=  $HCPRO conf
MKMRM 	=  $HCPRO mrm
MKFS 	=  $HCPRO drm
MKFLOP 	=  $HCPRO floppy
MKGMAN	=  $HCPRO gman
MKSYS 	=  $HCPRO sys
MKPDRV 	=  $HCPRO pdrv
MKYDK	=  $HCPRO hdisk
MKFE	=  $HCPRO fe
MKOTHER =  $HCPRO other
####################################
##				  ##
##	Systems to be created.    ##
##				  ##
####################################
flex286.sys :	bootprot.286 bload286.286 printer.drv sdrv.drv \
		athd.drv ramdsk.drv mdrv.drv

 fix bootprot.286 flex286.sys

bootprot.286 :	disp386.obj config.obj aconf386.obj clock.obj clockat.obj \
		comlib.l86 filesys.l86 atlib.l86 felib.l86

 link boot386[i]
 link debug386[i]

######################
# System libraries.  #
######################
comlib.l86 :	abort.obj aflag.obj aflag286.obj allocpg.obj async.obj \
		async286.obj base.obj breakpt.obj command.obj crman.obj \
		crmconv8.obj crmcopy.obj crmcreat.obj crmdel.obj crmgsl.obj \
		crminst.obj crmkb.obj crmmouse.obj crmopen.obj crmrdel.obj \
		crmread.obj crmwind.obj crmwrite.obj crmxlat.obj dinit.obj \
		dvrif.obj except.obj fe.obj feprot.obj findbit.obj freepg.obj \
		heappg.obj install.obj kfuncs.obj kgetblk.obj ktools.obj \
		l286.obj l386.obj lf286.obj lutils.obj m386.obj mgetblk.obj \
		mis286.obj misman.obj mrange.obj nulldev.obj ofile.obj \
		osmem.obj overlay.obj panic86.obj pg.obj pewter.obj pipe.obj \
		pipe286.obj pmget.obj process.obj rdelim.obj rtmif.obj \
		sup.obj sup386.obj superman.obj swi.obj swi386.obj tables.obj \
		tools.obj va.obj xhand386.obj
 lib86 mkcom386[i]

filesys.l86 :	fpool.obj fscache.obj fsdm.obj fsname.obj fspath.obj \
		fsvol.obj fswindow.obj hook.obj swap.obj
 lib86 mkfslib[i]


atlib.l86 : 	icdrv.obj icdrvwrt.obj icdrcopy.obj icdrtool.obj ipdrv.obj \
		ireset.obj icdrvkb.obj icdtool.obj fd.obj ifd.obj ifdasr.obj \
		ifdglob.obj ifdhook.obj ifdisr.obj ifdmd.obj \
		ydk.obj ydkmd.obj ydksync.obj yhdmd.obj yphd.obj yhdhook.obj \
		yport286.obj getcmos.obj mpyl.obj divl.obj

 lib86 mkatlib[i]
###########################################
###  Special creation of the following :  #
###  	mpyl.obj divl.obj                 #
###  Search for mpyl or divl....          #
###########################################

felib.l86 :	comfe.obj comfeu.obj crmb000.obj dosfe1.obj dosfe2.obj \
		dosfe3.obj dosfeint.obj dosinit.obj dosmain.obj dosman.obj \
		em386.obj feio.obj feu.obj gp386.obj lexecom.obj

 lib86 mkfelib[i]


######################
# System loader....  #
######################
bload286.286 :	bload286.obj

 link bload286.obj[data[max[0],origin[0]]
 fix bload286.286 bload286.sys /r

######################
# System drivers...  #
######################
sdrv.drv :	sdrv.obj sdrvtool.obj
 link sdrv[i]

mdrv.drv :	mdrv.obj sdrvtool.obj
 link mdrv[i]

athd.drv :	ydk.obj ydkmd.obj yhdmd.obj yphd.obj yhdhook.obj \
		yport286.obj getcmos.obj
 link mkldhd[i]

ramdsk.drv :	rdd.obj btools.obj
 link mkldrd[i]

printer.drv :	printer.obj
 link printer[i]

# # # # # # # # # # # # # # # #
#   Common Source makefile    #
# # # # # # # # # # # # # # # #
###################
# .A files....... #
###################
mrange.obj:	mrange.a

 casm mrange -c
 cto mrange

###################
# .A86 files..... #
###################
disp386.obj :	sysbuild.equ struct.equ segs.equ system.equ \
		panic.equ i386.equ \
		disp386.a86

 rasm86 disp386 $$pzszlo286

breakpt.obj :	breakpt.a86

 rasm86 breakpt $$pzsz286

sup386.obj :	sysbuild.equ struct.equ segs.equ system.equ \
		panic.equ sup.equ \
		i386.equ \
		sup386.a86

 rasm86 sup386 $$pzsz286

mgetblk.obj :	sysbuild.equ panic.equ \
		mgetblk.a86

 rasm86 mgetblk $$pzsz286

kgetblk.obj :	sysbuild.equ panic.equ \
		kgetblk.a86

 rasm86 kgetblk $$pzsz286

async286.obj :	sysbuild.equ struct.equ system.equ panic.equ \
		async286.a86 

 rasm86 async286 $$pzsz286

xhand386.obj :	sysbuild.equ system.equ struct.equ segs.equ panic.equ \
		i386.equ \
		xhand386.a86

 rasm86 xhand386 $$pzsz286

aflag286.obj :	sysbuild.equ system.equ struct.equ \
		aflag286.a86

 rasm86 aflag286 $$pzsz

swi386.obj :	sysbuild.equ struct.equ system.equ \
		i386.equ \
		swi386.a86

 rasm86 swi386 $$pzsz286

pipe286.obj :	sysbuild.equ system.equ flags.equ ofile.equ \
		struct.equ \
		pipe286.a86

 rasm86 pipe286 $$pzsz286

mis286.obj :	sysbuild.equ system.equ flags.equ ofile.equ \
		struct.equ pblk.equ \
		mis286.a86

 rasm86 mis286 $$pzsz286

dvrif.obj :	sysbuild.equ \
		i386.equ \
		dvrif.a86

 rasm86 dvrif $$pzsz286

tools.obj :	sysbuild.equ \
		tools.a86

 rasm86 tools $$pzsz286

findbit.obj :	findbit.a86

 rasm86 findbit $$pzsz286

###############
# .C files... #
###############
heappg.obj :	portab.h sysbuild.h struct.h baspag.h \
		malloc.h system.h pg.h protos.h \
		heappg.c 
 hc heappg $MKKERN

m386.obj :	portab.h sysbuild.h struct.h baspag.h \
		system.h malloc.h pg.h protos.h \
		m386.c
 hc m386 $MKKERN

freepg.obj :	portab.h sysbuild.h struct.h system.h \
		baspag.h malloc.h pg.h protos.h \
		freepg.c
 hc freepg $MKKERN

allocpg.obj :	portab.h sysbuild.h struct.h baspag.h \
		pblk.h malloc.h system.h flags.h pg.h \
		protos.h \
		allocpg.c
 hc allocpg $MKKERN

osmem.obj :	portab.h sysbuild.h struct.h baspag.h \
		protos.h \
		pg.h \
		osmem.c
 hc osmem $MKKERN

pg.obj :	portab.h sysbuild.h system.h pg.h \
		struct.h baspag.h \
		protos.h \
		pg.c
 hc pg $MKKERN

va.obj :	portab.h sysbuild.h system.h pg.h \
		struct.h baspag.h panic.h \
		protos.h \
		va.c
 hc va $MKKERN


abort.obj :	portab.h sysbuild.h struct.h system.h \
		baspag.h panic.h protos.h \
		abort.c
 hc abort $MKKERN

async.obj :	portab.h sysbuild.h struct.h system.h \
		baspag.h panic.h protos.h \
		async.c
 hc async $MKKERN

base.obj :	portab.h sysbuild.h struct.h \
		base.c
 hc base $MKKERN

dinit.obj :	portab.h sysbuild.h struct.h baspag.h \
		protos.h \
		dinit.c
 hc dinit $MKKERN

process.obj :	portab.h sysbuild.h struct.h baspag.h \
		system.h protos.h \
		process.c
 hc process $MKKERN

rtmif.obj :	portab.h sysbuild.h struct.h sstruct.h \
		baspag.h system.h flags.h protos.h \
		rtmif.c
 hc rtmif $MKKERN

ktools.obj :	portab.h sysbuild.h struct.h system.h \
		protos.h \
		ktools.c
 hc ktools $MKKERN

except.obj :	portab.h sysbuild.h struct.h system.h \
		except.h protos.h \
		except.c
 hc except $MKKERN

aflag.obj :	portab.h sysbuild.h system.h struct.h \
		baspag.h protos.h \
		aflag.c
 hc aflag $MKKERN

swi.obj :	portab.h sysbuild.h struct.h baspag.h \
		system.h panic.h protos.h \
		swi.c
 hc swi $MKKERN

fe.obj :	portab.h sysbuild.h system.h struct.h \
		gp.h protos.h \
		fe.c
 hc fe $MKKERN

feprot.obj :	portab.h sysbuild.h struct.h baspag.h \
		gp.h protos.h \
		feprot.c
 hc feprot $MKKERN

panic86.obj :	portab.h sysbuild.h struct.h protos.h \
		panic86.c
 hc panic86 $MKKERN

install.obj :	portab.h sysbuild.h system.h flags.h \
		dh.h pd.h pblk.h dispatch.h protos.h \
		install.c
 hc install $MKKERN

kfuncs.obj :	portab.h \
		kfuncs.c
 hc kfuncs $MKKERN

sup.obj :	portab.h sysbuild.h pd.h sup.h dh.h \
		sstruct.h system.h flags.h swap.h \
		dispatch.h protos.h \
		sup.c
 hc sup $MKKERN

superman.obj :	portab.h sup.h pd.h system.h protos.h \
		superman.c
 hc superman $MKKERN

pmget.obj :	portab.h sysbuild.h struct.h protos.h \
		pmget.c
 hc pmget $MKKERN

tables.obj :	portab.h sup.h sstruct.h system.h \
		tables.c
 hc tables $MKKERN

command.obj :	portab.h sysbuild.h struct.h baspag.h \
		system.h malloc.h dmdef.h pblk.h \
		protos.h \
		command.c
 hc command $MKLOADER

l286.obj :	portab.h sysbuild.h load.h pd.h \
		system.h protos.h \
		l286.c
 hc l286 $MKLOADER

l386.obj :	portab.h sysbuild.h load.h struct.h \
		system.h pg.h baspag.h protos.h \
		l386.c
 hc l386 $MKLOADER

lf286.obj :	portab.h sysbuild.h struct.h system.h \
		baspag.h protos.h \
		lf286.c
 hc lf286 $MKLOADER

overlay.obj :	portab.h pd.h pblk.h system.h protos.h \
		overlay.c
 hc overlay $MKLOADER

lutils.obj :	portab.h system.h protos.h \
		lutils.c
 hc lutils $MKLOADER

pewter.obj :	portab.h sysbuild.h pblk.h protos.h \
		pewter.c
 hc pewter $MKLOADER

nulldev.obj :	portab.h sysbuild.h system.h struct.h \
		protos.h \
		nulldev.c
 hc nulldev $HCPRO ndev	

pipe.obj :	portab.h sysbuild.h struct.h baspag.h \
		system.h flags.h ofile.h dh.h pipe.h \
		pblk.h protos.h \
		pipe.c
 hc pipe $MKPRM

misman.obj :	portab.h sysbuild.h struct.h pblk.h \
		system.h flags.h ofile.h dh.h protos.h \
		misman.c
 hc misman $MKMRM

rdelim.obj :	portab.h system.h flags.h ofile.h \
		evb.h dh.h pblk.h protos.h \
		rdelim.c
 hc rdelim $MKMRM

ofile.obj :	portab.h sysbuild.h system.h flags.h \
		ofile.h pd.h protos.h \
		ofile.c
 hc ofile $MKMRM

crman.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h pblk.h ofile.h console.h dh.h \
		vcb.h cpack.h flags.h crmexrn.h \
		crman.c
 hc crman $MKCRM

crmopen.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmopen.c
 hc crmopen $MKCRM

crmread.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmread.c
 hc crmread $MKCRM

crmrdel.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmrdel.c
 hc crmrdel $MKCRM

crmkb.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmkb.c
 hc crmkb $MKCRM

crmconv8.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmconv8.c
 hc crmconv8 $MKCRM

crmxlat.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmxlat.c
 hc crmxlat $MKCRM

crmmouse.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h crmexrn.h gman.h vdi.h \
		crmmouse.c
 hc crmmouse $MKCRM

crminst.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crminst.c
 hc crminst $MKCRM

crmcopy.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmcopy.c
 hc crmcopy $MKCRM

crmcreat.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h crmexrn.h \
		crmcreat.c
 hc crmcreat $MKCRM

crmdel.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h crmexrn.h \
		crmdel.c
 hc crmdel $MKCRM

crmwrite.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		crmexrn.h panic.h \
		crmwrite.c
 hc crmwrite $MKCRM

crmgsl.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h crmexrn.h \
		crmgsl.c
 hc crmgsl $MKCRM

crmwind.obj :	portab.h sysbuild.h system.h struct.h \
		evb.h dh.h ofile.h flags.h char.h \
		pblk.h console.h vcb.h cpack.h \
		frame.h xlat.h crmexrn.h \
		crmwind.c
 hc crmwind $MKCRM

# # # # # # # # # # # # # # #
#    File System makefile   #
# # # # # # # # # # # # # # #
fpool.obj :	portab.h sysbuild.h struct.h osdef.h \
		protos.h \
		fpool.c
 hc fpool $MKFS

fscache.obj :	portab.h sysbuild.h osdef.h pd.h dmdef.h \
		dmg.h dmtbl.h system.h swap.h protos.h \
		bcbio.f fatio.f \
		fscache.c
 hc fscache $MKFS

fsdm.obj :	portab.h sysbuild.h osdef.h pd.h pblk.h \
		dmdef.h dmg.h dmtbl.h system.h swap.h \
		protos.h \
		dminit.f dm.f dutils.f special.f protect.f \
		fsdm.c
 hc fsdm $MKFS

fsname.obj :	portab.h sysbuild.h pd.h osdef.h \
		dmdef.h dmg.h dmtbl.h system.h \
		swap.h protos.h \
		parse.f rename.f dosfesup.f \
		fsname.c
 hc fsname $MKFS

fspath.obj :	portab.h sysbuild.h evb.h pd.h osdef.h \
		dmdef.h dmg.h dmtbl.h system.h swap.h \
		protos.h \
		docc.f dsgl.f hash.f dpath.f \
		fspath.c
 hc fspath $MKFS

fsvol.obj :	portab.h sysbuild.h evb.h pd.h osdef.h \
		dmdef.h dmg.h dmtbl.h system.h swap.h \
		protos.h \
		dinstall.f dinitm.f dvrlock.f lock.f \
		fsvol.c
 hc fsvol $MKFS

fswindow.obj :	portab.h sysbuild.h pd.h osdef.h dmdef.h \
		dmg.h dmtbl.h system.h swap.h protos.h \
		drw.f window.f \
		fswindow.c
 hc fswindow $MKFS

hook.obj :	portab.h sysbuild.h struct.h osdef.h \
		dmdef.h \
		hook.c
 hc hook $MKFS

swap.obj :	sysbuild.equ \
		swap.a86

 rasm86 swap $$pzsz286


# # # # # # # # # # # # # # #
#   Serial Driver makefile  #
# # # # # # # # # # # # # # #
sdrv.obj :	portab.h flags.h char.h io.h \
		system.h sdrv.h protos.h \
		sdrv.c
 hc sdrv $MKOTHER

sdrvtool.obj :	sdrvtool.a86

 rasm86 sdrvtool $$pzsz286

# # # # # # # # # # # # # #
#  Mouse Driver makefile  #
# # # # # # # # # # # # # #
mdrv.obj :	portab.h io.h system.h console.h \
		mdrv.h mdrv.c
 hc mdrv $MKOTHER


# # # # # # # # # #
#   AT makefile   #
# # # # # # # # # #
###################
#  mpyl.obj...... #
#  divl.obj...... #
###################
mpyl.obj : c:\highc\big\hcbe.l86

 +-define -s o: = c:/highc/big/
 +-lib86 mpyl.obj = o:hcbe.l86[sel[_mwmpyl_]]

divl.obj : c:\highc\big\hcbe.l86

 +-define -s o: = c:/highc/big/
 lib86 divl.obj = hcbe.l86[sel[_mwdivl_]]

###################
# .A86 files..... #
###################
bload286.obj :	sysbuild.equ bload286.a86

 rasm86 bload286 $$pzsz286

aconf386.obj :	sysbuild.equ struct.equ segs.equ panic.equ \
		i386.equ \
		aconf386.a86

 rasm86 aconf386 $$pzsz286

clockat.obj :	sysbuild.equ struct.equ system.equ \
		clockat.a86

 rasm86 clockat $$pzsz286

icdtool.obj :	cd.equ \
		ega.equ \
		icdtool.a86

 rasm86 icdtool $$pzsz286

ireset.obj :	sysbuild.equ \
		ireset.a86

 rasm86 ireset $$pzsz286

###############
# .C files... #
###############
clock.obj :	portab.h sysbuild.h struct.h system.h \
		baspag.h protos.h \
		clock.c
 hc clock $MKKERN

config.obj :	portab.h sysbuild.h system.h sup.h \
		dh.h flags.h struct.h baspag.h \
		panic.h protos.h \
		imc286.h config.h \
		config.c
 hc config $MKCONF

icdrv.obj :	portab.h system.h io.h protos.h \
		icdrv.h \
		icdrv.c
 hc icdrv $MKCRM

icdrvwrt.obj :	portab.h io.h system.h protos.h \
		icdrv.h \
		icdrvwrt.c
 hc icdrvwrt $MKCRM

icdrcopy.obj :	portab.h io.h system.h protos.h \
		icdrv.h \
		icdrcopy.c
 hc icdrcopy $MKCRM

icdrtool.obj :	portab.h io.h system.h protos.h \
		icdrtool.c
 hc icdrtool $MKCRM

ipdrv.obj :	portab.h system.h io.h protos.h \
		ipdrv.h \
		ipdrv.c
 hc ipdrv $MKPDRV

icdrvkb.obj :	portab.h protos.h \
		icdrvkb.c
 hc icdrvkb $MKCRM

fd.obj :	portab.h io.h system.h \
		atmc286.h fd.h \
		fd.c
 hc fd $MKFLOP

ifd.obj :	portab.h system.h io.h protos.h \
		fd.h ifdma.h \
		iifdtim.c iifdphy.c iifdmot.c iifddma.c \
		ifd.c
 hc ifd $MKFLOP

ifdasr.obj :	portab.h system.h io.h protos.h \
		atmc286.h fd.h \
		ifdasr.c
 hc ifdasr $MKFLOP

ifdglob.obj :	portab.h system.h io.h \
		atmc286.h fd.h \
		ifdglob.c
 hc ifdglob $MKFLOP

ifdisr.obj :	portab.h system.h io.h \
		atmc286.h fd.h \
		ifdisr.c
 hc ifdisr $MKFLOP

ifdmd.obj :	portab.h system.h io.h protos.h \
		atmc286.h fd.h atmdbs.h cpmdbs.h \
		ifdmd.c
 hc ifdmd $MKFLOP

ifdhook.obj :	portab.h system.h \
		ifdhook.c
 hc ifdhook $MKFLOP

# # # # # # # # # # # # # # # # #
#   Hard disk Driver makefile   #
# # # # # # # # # # # # # # # # #
yport286.obj :	sysbuild.equ \
		yport286.a86

 rasm86 yport286 $$pzszlo286

getcmos.obj :	portab.h \
		getcmos.c
 hc getcmos $MKKERN

ydk.obj :	portab.h system.h \
		yio.h ymd.h ydk.h ydksync.h \
		ydk.c
 hc ydk $MKYDK

yphd.obj :	portab.h system.h \
		yhd.h yio.h ymd.h ydk.h ydksync.h\
		yphd.c
 hc yphd $MKYDK

yhdmd.obj :	portab.h system.h \
		yhd.h yio.h ymd.h ydk.h ydksync.h \
		yhdmd.c
 hc yhdmd $MKYDK

ydkmd.obj :	portab.h system.h \
		yio.h ymd.h ydk.h \
		ydkmd.c
 hc ydkmd $MKYDK

yhdhook.obj :	portab.h system.h \
		yio.h yhd.h ydk.h \
		yhdhook.c
 hc yhdhook $MKYDK

ydksync.obj :	portab.h system.h evb.h \
		yio.h ymd.h ydk.h ydksync.h \
		ydksync.c
 hc ydksync $MKYDK


# # # # # # # # # # # # # # # #
#   Printer Driver makefile   #
# # # # # # # # # # # # # # # #
printer.obj :	portab.h sysbuild.h io.h system.h \
		protos.h \
		printer.c
 hc printer $MKOTHER


# # # # # # # # # # # # # # # #
#   Ram Disk Driver makefile  #
# # # # # # # # # # # # # # # #
rdd.obj :	portab.h system.h io.h \
		btools.h
 hc rdd $MKOTHER

btools.obj :	sysbuild.equ \
		btools.a86

 rasm86 btools $$pzsz286


# # # # # # # # # # #
#   DOSFE makefile  #
# # # # # # # # # # #

###################
# .A86 files..... #
###################
em386.obj :	sysbuild.equ struct.equ segs.equ \
		gpequ.equ em386.a86

 rasm86 em386 $$286

gp386.obj :	sysbuild.equ struct.equ segs.equ i386.equ \
		gpequ.equ gp386.a86

 rasm86 gp386 $$286


###############
# .C files... #
###############
comfeu.obj :	portab.h sysbuild.h sup.h struct.h \
		system.h flags.h protos.h fe.h \
		dosfe.h frntend.h \
		comfeu.c
 hc comfeu $MKFE

crmb000.obj :	portab.h sysbuild.h system.h dh.h \
 		ofile.h pblk.h evb.h console.h \
 		vcb.h struct.h panic.h protos.h \
 		fe.h \
		crmb000.c
 hc crmb000 $MKFE

dosfe1.obj :	portab.h sysbuild.h sup.h struct.h \
		system.h flags.h protos.h dmtbl.h \
 		mdb.h dosfe.h frntend.h fe.h \
		dosfe1.c
 hc dosfe1 $MKFE

dosfe2.obj :	portab.h sysbuild.h sup.h dmtbl.h \
		struct.h system.h flags.h protos.h \
 		mdb.h dosfe.h frntend.h fe.h \
		dosfe2.c
  hc dosfe2 $MKFE

dosfe3.obj :	portab.h sysbuild.h sup.h dmtbl.h \
		struct.h system.h flags.h protos.h \
 		mdb.h dosfe.h frntend.h fe.h \
		dosfe3.c
  hc dosfe3 $MKFE

feu.obj :	portab.h sysbuild.h sup.h dmtbl.h \
		struct.h system.h flags.h protos.h \
 		fe.h mdb.h frntend.h dosfe.h \
		feu.c
 hc feu $MKFE

dosinit.obj :	portab.h sysbuild.h sup.h dmtbl.h \
		struct.h system.h console.h protos.h \
 		fe.h frntend.h mdb.h dosfe.h \
		dosinit.c
 hc dosinit $MKFE

dosmain.obj :	portab.h sysbuild.h sup.h struct.h \
 		system.h flags.h protos.h \
 		fe.h frntend.h dosfe.h \
		dosmain.c
 hc dosmain $MKFE

dosman.obj :	portab.h sysbuild.h struct.h \
 		system.h pblk.h protos.h \
 		fe.h dosfe.h frntend.h \
		dosman.c
 hc dosman $MKFE

feio.obj :	portab.h sysbuild.h sup.h \
 		struct.h system.h gp.h protos.h \
 		fe.h frntend.h dosfe.h \
		feio.c
 hc feio $MKFE

comfe.obj :	portab.h sysbuild.h sup.h struct.h \
		system.h flags.h dmtbl.h protos.h \
 		frntend.h fe.h mdb.h \
		comfe.c
 hc comfe $MKFE

lexecom.obj :	portab.h sysbuild.h sup.h struct.h \
 		system.h flags.h protos.h \
 		fe.h frntend.h dosfe.h \
		lexecom.c
 hc lexecom $MKFE

dosfeint.obj :	portab.h sysbuild.h sup.h system.h \
 		flags.h dmtbl.h struct.h protos.h \
 		fe.h dosfe.h mdb.h frntend.h \
		dosfeint.c
 hc dosfeint $MKFE

