/************************************************************************
* hdsync.c								*
*	Synchronous Interface section to the Hard			*
*	disk driver.							*
*************************************************************************
* Copyright (c) 1987 Digital Research Inc. All rights reserved. {proprietary} *
* The Software Code contained in this listing is proprietary to Digital       *
* Research Inc., Monterey, California, and is covered by U.S. and other       *
* copyright protection. Unauthorized copying, adaption, distribution, use or  *
* display is prohibited and may be subject to civil and criminal penalties.   *
* Disclosure to others is prohibited. For the terms and conditions of software*
* code use, refer to the appropriate Digital Research License Agreement.      *
*		U.S. GOVERNMENT RESTRICTED RIGHTS			      *
* This software product is provided with RESTRICTED RIGHTS.  Use, duplication *
* or disclosure by the Government is subject to restrictions as set forth in  *
* FAR 52.227-19 (c) (2) (June, 1987) when applicable or the applicable	*
* provisions of the DOD FAR supplement 252.227-7013 subdivision (b) (3) (ii)  *
* (May, 1981) or subdivision (c) (1) (ii) (May, 1987). Contractor/manufacturer*
* is Digital Research Inc. / 70 Garden Court / BOX DRI / Monterey, CA 93940.  *
*******************************************************************************
* Revision History:
* Date   Author SPR #	Comments
* 871231 reb		Originated from previous versions of athd.drv source
* 880114 reb            modified dk_infmt special to succeed/ stubbed it out
* 880122 reb		performance update.
************************************************************************/
/************************************************************************
* File:		hdsync.c
*
* Description:	This files contains the logical/synchronous portion of the
*		Hard Disk Driver.  The portion of the driver that is run
*		in the user context.
*
* Build Info:	see file hd.mak for dependencies.
*
* Overview:
*
************************************************************************/
/*======================================================================*
*  INCLUDES:								*/
#include    "portab.h"
#include    "hd.h"	

/************************************************************************/
/* Driver Header -							*/
/*  This is the driver header.  It MUST BE THE FIRST ITEM IN THE DATA	*/
/*  SEGMENT and is used by the supervisor install routines to 'install'	*/
/*  the driver into the i/o system.					*/
/************************************************************************/
#define DKFLAGVAL   1
				/*  driver sync flags.			*/
				/*  0 = no sync required		*/
				/*  1 = sync at driver level		*/
				/*  2 = sync at unit level		*/

#define FILLVAL	0L		/*  fill value for control words	*/

GLOBAL DKH dk_dh =
{
	0,DKMAXUNITS,DKFLAGVAL,
	dk_init,			/*  address of init routine	*/
	dk_subdrv,			/*  address of subdrv routine   */
	dk_uninit,			/*  address of uninit routine   */
	dk_select,			/*  address of select routine   */
	dk_flush,			/*  address of flush routine	*/
	dk_read,			/*  address of read routine	*/
	dk_write,			/*  address of write routine	*/
	dk_get,				/*  address of get routine	*/
	dk_set,				/*  address of set routine	*/
	dk_special,			/*  address of special routine  */
	FILLVAL,			/* must be 0 !			*/
	FILLVAL,			/* must be 0 !			*/
	FILLVAL,			/* must be 0 !			*/
	(PD **)0L,			/*  ptr to rlr			*/
	FILLVAL				/*  ptr to sys table		*/
} ;


/************************************************************************/
/*  DK_UT -								*/
/*   Disk Unit Table.  An array of entries which contain		*/
/*   information about the logical unit.  Indexed by the logical	*/
/*   unit number (number passed in parm block from supervisor).		*/
/************************************************************************/
LUTE	*DK_UT[DKMAXUNITS] =
{
/*
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
*/
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 ,
	(LUTE *) 0 
} ;

PLIST_ENTRY	part_list[DKMAXUNITS] ;
WORD		cnt_parts = 0 ;

LONG	DriveSync[2];
PUD	*puda ;
static	WORD	initialized = FALSE ;
LUTE	physlute[HDMAXUNITS] ; ;

/************************************************************************/
/*	Special Purpose lute for read and write system area calls	*/
/************************************************************************/

EXTERN	P2L    P2LM[ HDMAXUNITS ] ;

UWORD	physunits = HDMAXUNITS ;
				/* parmblock for mappphy call KPB 	*/
struct	
{
	LONG	r_Type;
	ULONG	r_PhysicalAddr;
	LONG	r_Size;
} RomTable;

/************************************************************************/
/*  dk_init -								*/
/************************************************************************/
ERROR	dk_init(unitnbr)
LONG	unitnbr ;
{
	BYTE	unitno = (BYTE) unitnbr ;

	LUTE	*u ;
	ERROR	r ;


	if( unitno >= DKMAXUNITS )
	{
		return( ED_DISK | E_UNITNO ) ;
	}


	if (DK_UT[unitno])
	{
		return ( ED_DISK | E_UNITNO ) ;
	}

	if( (DK_UT[unitno]=(LUTE *)salloc((LONG)sizeof(LUTE))) == NULLPTR)
		return( ED_DISK | E_POOL ) ;
	_fill_char((BYTE *) DK_UT[unitno], sizeof(LUTE), 0) ;

	u = DK_UT[ unitno ] ;
	(*u).lu_unitno = unitno ;

	(*u).lu_iflag = (WORD) (( unitnbr & 0xffff0000L ) >> 16 ) ;
	(*u).lu_flags = 0 ;

	(*u).lu_pdaddr = (*dk_dh.dkh_pdaddr) ;

	(*u).lu_swi = 0L ;

	if( ((*u).lu_ioflagno = flagget() ) <= NULLPTR)
		return(ED_DISK | E_POOL) ;	/* not a driver E_CODE	*/

	if( !initialized )
	{
						/* initialize syncs	*/
		DriveSync[0] = mxinit();
		DriveSync[1] = mxinit();
		hd_init(u) ;			/* phys level init	*/
		initialized = TRUE ;		/* called only once	*/
	}
				/* perform logical unit initialization */
	if ( ( r = logicinit (u) ) != E_SUCCESS )
	{
		logicuninit ( unitno );
		return ( r );
	}

	return( (LONG)DVR_DISK );			/* SUCCESS	*/
}


/************************************************************************/
/* dk_subdrv - link to sub-driver (if any)				*/
/************************************************************************/
ERROR dk_subdrv()
{
	return( ED_DISK | E_IMPLEMENT ) ;
}

/************************************************************************/
/*	dk_uninit -							*/
/*	Uninitialize a driver unit					*/
/************************************************************************/
ERROR	dk_uninit(unitnbr)
LONG	unitnbr ;
{
	BYTE	unitno = (BYTE) unitnbr ;
	BYTE	unit ;				/* local varible unitno */
	LUTE	*u ;
	LONG	flag ;

	if( unitno >= DKMAXUNITS )
		return( ED_DISK | E_UNITNO ) ;

	u = DK_UT[ unitno ] ;
	if( (flag = (*u).lu_ioflagno ) == NULLPTR)	
					/* ioflagno has been installed 	*/
		return( ED_DISK | E_UNITNO ) ;

	flagclr( flag ) ;
	flagrel( flag ) ;
	(*u).lu_ioflagno = 0 ;
	sfree(DK_UT[unitno]) ;

	DK_UT[unitno] = (LUTE *) 0 ;

		/* if all units are uninstalled call low level uninit	*/

	for( unit = DKMAXUNITS ; unit-- ; )
	{
		if((LONG) DK_UT[ unit ])
			return( E_SUCCESS ) ;
	}
	/* unint syncs */
	mxrel(DriveSync[0]);
	mxuninit(DriveSync[0]);
	mxrel(DriveSync[1]);
	mxuninit(DriveSync[1]);

	hd_uninit() ;				/* low level uninit	*/
	return( E_SUCCESS ) ;
}

/************************************************************************/
/*	dk_select -							*/
/*	determines the type of drive we are on (if			*/
/*	that is a variable) and the type of media			*/
/*	in the drive.							*/
/*									*/
/************************************************************************/
ERROR	dk_select(pb)
DKSELPB *pb ;				/*  ptr to select parm block	*/
{

	ERROR	r ;					/* return code	*/
	LUTE	*u ;		/* ptr to logical unit table entry	*/
    WORD        mdbsize;        /* size of MDB expected by caller */

    /* Copy MDB to caller's buffer - assume buffer is addressable
       and large enough, based on size of MDB specified in option
       byte.
    */

	if ( pb->dks_option & DKO_BIGMDB )
        	mdbsize = sizeof(MDB);
	else
		mdbsize = 28;


	u = DK_UT[ pb->dks_unitno ] ;	/* u => LUTE for this unit	*/

	(*u).lu_pdaddr = (*dk_dh.dkh_pdaddr) ;	/* use current pd addr	*/
	(*u).lu_b_pdaddr = (PD *) 0L ;
	(*u).lu_swi = 0L ;		/*	null swi address [1] 	*/
	(*u).lu_flags = 0 ;		/*	null request flags	*/

	if( (r = hd_select()) == NULLPTR)
	{ 
					/* copy mdb to callers buffer	*/
	    movie((BYTE *)pb->dks_mdbp , (BYTE *)&(*u).ld_mdb , mdbsize ) ;
	}
	return( r ) ;
}

/************************************************************************/
/* dk_flush -								*/
/************************************************************************/
LONG	dk_flush()
{
	return(E_SUCCESS) ;
}

/************************************************************************/
/*	dk_read -							*/
/*	start read or verify operation from disk.			*/
/************************************************************************/
EMASK	dk_read(pb)
DKPBLK	*pb ;
{
	if( pb->dk_flags & DKF_VERIFY )
	{
		return( dk_iosetup( DKVERIFY , pb ) ) ;
	}
	else
	{
		return( dk_iosetup( DKREAD , pb )	) ;
	}
}

/************************************************************************/
/*	dk_write - start write operation to disk.			*/
/************************************************************************/
EMASK	dk_write(pb)
DKPBLK	*pb ;
{
	return( dk_iosetup( DKWRITE , pb )	) ;
}

/************************************************************************/
/* dk_get - This driver handles non-removable media only,therefor mdb	*/
/* values can be used .							*/
/************************************************************************/
LONG	dk_get(pb)
DKGETPB	*pb ;
{
	LUTE	*u = DK_UT[ pb->fgt_unitno ] ;

	pb->fgt_dtype = 0 ;			/* non-removable disk	*/
	pb->fgt_maxrs = (*u).ld_mdb.md_secsiz ;	/* max record size	*/
	pb->fgt_addr	= 0L ;			/* open door address	*/
	pb->fgt_maxfatrecs = (*u).ld_mdb.md_nfrecs ; /* max fat records	*/
	pb->fgt_mxfsize = (*u).ld_mdb.md_secsiz * (UWORD)(*u).ld_mdb.md_nfrecs ;
	pb->fgt_mxdsize = (*u).ld_mdb.md_dirsize ; /* max root dir entries */
	return( E_SUCCESS ) ;
}

/************************************************************************/
/* dk_set -								*/
/************************************************************************/
LONG	dk_set()
{
	return( ED_DISK | E_IMPLEMENT ) ;	/*	per spec	*/
}

/************************************************************************/
/*	dk_special -							*/
/************************************************************************/
LONG	dk_special(spb)
DKSPPB	*spb ;
{
	LUTE	*u = DK_UT[ spb->dsp_unitno ] ;
	BYTE	opt ;
	ERROR	r ;
	PUD	*pudbuf;		/* buffer pointer for PUD	*/
	MDB	*mdbp ;
	LUTE	*savelute ;
	WORD	unit = spb->dsp_unitno ;

	switch( opt = spb->dsp_funcno )
	{

		case	DKO_RDSYS:	/*	READ	SYSTEM AREA	*/
		case	DKO_WRSYS:	/*	WRITE SYSTEM AREA	*/
		case	DKO_FMSYS:
		case	DKO_FMTRK:
			r = (ED_DISK | E_INVCMD) ;
			break ;
		case	DKO_INFMT:		/*	INIT FORMAT	*/
			return E_SUCCESS ;	/* just for old format	*/
			break ;
		case	DKO_PUD:		/* return PUD info.	*/
	
 		       /* insure buffer is accessable */
	
			pudbuf = (PUD *) spb->dsp_buffer;
			r = mrange ( pudbuf, (LONG) sizeof(PUD));
	
			/* since the user address flag is not passed
			through on this special call, it is assumed
			that all buffer addresses are from the user -
			system buffers and read-only buffers are not
			allowed.
			*/
			if ( r & ( E_ERR | RD_ONLY | SYS_SPC ) )
				return ( ED_DISK | E_RANGE );
	
					/* obtain PUD info from MDB     */
	
			pudbuf->pu_maxcyl   = (*u).ld_mdb.md_maxcyl;
			pudbuf->pu_nheads   = (*u).ld_mdb.md_nheads;
			pudbuf->pu_precomp  = (*u).ld_mdb.md_precomp;
			pudbuf->pu_crashpad = (*u).ld_mdb.md_crashpad;
			pudbuf->pu_sectors  = (*u).ld_mdb.md_sectrk;
			pudbuf->pu_step     = (*u).ld_mdb.md_step;
			pudbuf->pu_resv1 = 0;
			pudbuf->pu_resv2 = 0;
			pudbuf->pu_resv3 = 0;
			pudbuf->pu_resv4 = 0;
	
			return ( E_SUCCESS );
	 
		case    DKO_RWPHYS:		/* physical read/write  */
	
#ifdef FLEXOS131FILESYSTEM
			spb->dsp_flags |= DKF_UADDR; /* assume user addr*/
#endif
					/* insure buffer is accessable	*/
	
			mdbp = &(DK_UT[unit]->ld_mdb);
			r = mrange ( ((DKPBLK *)spb)->dk_buffer,
				spb->dsp_prsiz * mdbp->md_secsiz );
	
			if (( r & (E_ERR | RD_ONLY) ) ||
				( (spb->dsp_flags & DKF_UADDR ) &&
				( r & SYS_SPC) ) )
				return ( ED_DISK | E_RANGE );
	
			/* make the special call look like a read/write	*/
	
			((DKPBLK *)spb)->dk_option = 0;
			((DKPBLK *)spb)->dk_flags |= 0x0600; /* data IO	*/
			((DKPBLK *)spb)->dk_nsecs = spb->dsp_prsiz;
	
			savelute = DK_UT[unit] ;

			DK_UT[unit] = &physlute[DK_UT[unit]->lu_driveno] ;

			physlute[DK_UT[unit]->lu_driveno].ld_endssn = 0x7fff_fff0 ;

			if ( spb->dsp_flags & 0x0100 )
				r = dk_iosetup ( DKWRITE , (DKPBLK *)spb );
			else
				r = dk_iosetup ( DKREAD , (DKPBLK *)spb );
	
			DK_UT[spb->dsp_unitno] = savelute ;

			if ( r > 0 )
				return ( supif ( F_RETURN, r ) );
			else
				return ( r );
 		default:
			r = (ED_DISK | E_BADPB) ;
			break ;
	}
 
	return( r ) ;
}

/************************************************************************/
/*	dk_iosetup - Prep for the i/o operation.  Setup the LUTE's i/o 	*/
/* request variables and invoke the io state machine.			*/
/************************************************************************/
EMASK	dk_iosetup( op , pb )
BYTE	op ;
DKPBLK	*pb ;
{
	LUTE	*u ;
	EMASK	IoEmask ;
	LONG	r ;

	u = DK_UT[ pb->dk_unitno ] ;
	
	(*u).io_op = op ;
	/*	io_type bits 9,10 00-na,01-fat,10-dir,11-data		*/
	(*u).io_type = (pb->dk_flags & 0x0600 ) ;
	(*u).io_totnsecs = (*u).io_savnsecs = pb->dk_nsecs ;
	(*u).io_error = 0L ;

	if( pb->dk_flags & DKF_HSCADDR )
	{				/* [1] */
		(*u).io_stssn = (*u).io_savssn =
			(*u).ld_stssn + yGetSsn( (HSCADDR *)&pb->dk_record , u ) ;
	}
	else
	{
		(*u).io_stssn = (*u).io_savssn =
			pb->dk_record + (*u).ld_stssn ;
	}

	if((*u).io_stssn	< (*u).ld_stssn )
		return( ED_DISK | E_SEEK ) ;
	if((*u).io_stssn + (*u).io_totnsecs	> (*u).ld_endssn + 1)
				/* 860404 reb last sector recovered 	*/
		return( ED_DISK | E_SEEK ) ;

	(*u).io_buffer = (SYSADDR) pb->dk_buffer ;
	if( pb->dk_flags & DKF_UADDR )
	{
		(*u).io_buffer = (SYSADDR) saddr( (*u).io_buffer ) ;
	}
	(*u).lu_pdaddr = (*dk_dh.dkh_pdaddr) ;
	(*u).lu_b_pdaddr = (PD*) pb->dk_pdaddr ;

	(*u).lu_swi = pb->dk_swi ;
	(*u).lu_flags = pb->dk_flags ;

	IoEmask = flagevent( (*u).lu_ioflagno , pb->dk_swi ) ;

	hdsync(DriveSync[(*u).lu_driveno]);
	if(( r = doasr( hd_io , u , 0L, DKASRPRI )) < 0L)
	{
		hd_terminate(u,r) ;
	}
	return( IoEmask ) ;
}

/************************************************************************/
/*	dk_recal - Recalibrates the drive to track 0.  This code WAITS!	*/
/* It must be called from synchronous code...eg: from code with a	*/
/* process context.							*/
/************************************************************************/
ERROR	dk_recal( u )
LUTE	*u ;		/*	pointer to logical unit table		*/
{
	EMASK	e ;
	LONG	r ;

	hdsync(DriveSync[(*u).lu_driveno]);

	(*u).lu_swi = 0L ;			/*     dummy swi	*/
	(*u).lu_pdaddr = (*dk_dh.dkh_pdaddr) ;	/*  current process	*/
	(*u).lu_b_pdaddr = (PD *) 0L ;
	(*u).lu_flags = 0 ;			/* null flags		*/

	e = flagevent( (*u).lu_ioflagno , 0L ) ;
	if(( r = doasr( hd_recal , u , 0L, DKASRPRI )) < 0L)
	{
		flagset( (*u).lu_ioflagno , (*u).lu_pdaddr , r ) ;
		mxrel(DriveSync[(*u).lu_driveno]);
		return( r ) ;
	}
	supif( F_WAIT , e ) ;
	return(	supif( F_RETURN , e )	) ;

}

/************************************************************************/
/* dk_format - format media						*/
/************************************************************************/
ERROR	dk_format()
{
	return E_IMPLEMENT ;
}

/************************************************************************/
/* movie - string move routine						*/
/************************************************************************/
VOID movie( d , s , length )
BYTE	*s ;
BYTE	*d ;
WORD	length ;
{
	while ( length-- ) *d++ = *s++ ;
}


/************************************************************************/
/*									*/
/*      read - read a sector						*/
/*									*/
/************************************************************************/

MLOCAL  LONG    read ( u, diskaddr, buffer )

LUTE	*u;
SSN	 diskaddr;
BYTE	*buffer;

{
    LONG	emask;
    
    (*u).io_op = DKREAD;
    (*u).io_totnsecs = 1;
    (*u).io_stssn = diskaddr;
    (*u).io_buffer = (LONG) buffer;
    
    if ( ( emask = hdsync(DriveSync[(*u).lu_driveno]) ) == E_SUCCESS )
    {
	emask = flagevent( (*u).lu_ioflagno , 0L ) ;
	if ( emask > 0 )
	{
	    doasr ( hd_io , u , 0L , DKASRPRI );
	    return ( supif ( F_RETURN, emask )); /* wait for I/O */
	}
    }
    
    return ( emask ) ;
    
} /* read */


/************************************************************************/
/*	hd_physinfo - provide characteristics of a physical drive -	*/
/*		   A LUTE provided as input, which contains the		*/
/*		   physical drive number, is updated with the		*/
/*		   drive information.					*/
/************************************************************************/
VOID	hd_physinfo( u , drive )
LUTE	*u;
WORD	drive;
{
 
    PUD	 *pudp;
    MDB	 *mdbp;
 
    pudp = P2LM[(*u).lu_driveno=drive].pudp;
    mdbp = &((*u).ld_mdb);
 
    mdbp->md_secsiz  = SECTORSIZE;
    mdbp->md_nheads  = pudp->pu_nheads;
    mdbp->md_maxcyl  = pudp->pu_maxcyl;
    mdbp->md_sectrk  = pudp->pu_sectors;
    mdbp->md_nsecs   = (LONG)pudp->pu_maxcyl * (LONG)pudp->pu_nheads *
			pudp->pu_sectors ;
    mdbp->md_driveno = drive;
 
} /* hd_physinfo */


/************************************************************************/
/*									*/
/*      logicuninit - perform logical uninitialization			*/
/*									*/
/************************************************************************/

VOID    logicuninit ( unit )
BYTE	unit;	   /* unit to uninstall */
{
    LUTE	*u;
    
    u = DK_UT[unit];
    flagclr ( (*u).lu_ioflagno );
    flagrel ( (*u).lu_ioflagno );
    DK_UT[unit] = NULLPTR;
    sfree ( u );
    
} /*			logicuninit					*/



LONG	logicinit(u)
LUTE	*u ;
{
	BYTE	*buffer ;
	LONG	rc ;

	if ( ( buffer = (BYTE *) salloc ( (LONG) MAXREC ) ) == NULLPTR )
	    return ( ED_DISK | E_MEMORY );
	
	rc = makemdb( u, buffer ) ;

	sfree(buffer) ;

	return ( rc ) ;
}

LONG hdsync(sy)
LONG	sy;
{
LONG b;

	if ( NULLPTR != (b = mxevent(sy) ))
	{
		if (b != (EM_KERN | E_EMASK))
			b = supif(F_RETURN,b);
	}
	return(b);
}

