/************************************************************************
* hd.h - This header contains the definitions and typedefs for the 
*        sample Hard Disk Driver of Flexos.
*******************************************************************************
* Copyright (c) 1987 Digital Research Inc. All rights reserved. {proprietary} *
* The Software Code contained in this listing is proprietary to Digital       *
* Research Inc., Monterey, California, and is covered by U.S. and other       *
* copyright protection. Unauthorized copying, adaption, distribution, use or  *
* display is prohibited and may be subject to civil and criminal penalties.   *
* Disclosure to others is prohibited. For the terms and conditions of software*
* code use, refer to the appropriate Digital Research License Agreement.      *
*		U.S. GOVERNMENT RESTRICTED RIGHTS			       *
* This software product is provided with RESTRICTED RIGHTS.  Use, duplication *
* or disclosure by the Government is subject to restrictions as set forth in  *
* FAR 52.227-19 (c) (2) (June, 1987) when applicable or the applicable        *
* provisions of the DOD FAR supplement 252.227-7013 subdivision (b) (3) (ii)  *
* (May, 1981) or subdivision (c) (1) (ii) (May, 1987). Contractor/manufacturer*
* is Digital Research Inc. / 60 Garden Court / BOX DRI / Monterey, CA 93940.  *
*******************************************************************************
* Revision History:
* Date   Author SPR #	Comments
* 871231 reb		Originated from consolidation of previous separate
* 			header files of the old version of the driver.
* 880122 reb		performance update. CNEAR heavily used.
*  3FEB88 jmb           Add comment re: 24 partition limit.
************************************************************************/

/************************************************************************
* File:		hd.h
*
* Description:	Consolidated header file for hd.drv
*
* Build Info:	This file is included in all of the "C" modules
*		of the Hard Disk Driver.
*
* Overview:
*
************************************************************************/

#include    "system.h"


#define CNEAR 	_cc(_DEFAULT_CALLING_CONVENTION | _NEAR_CALL | _CALLEE_POPS_STACK)
#define CFAR 	_cc(_DEFAULT_CALLING_CONVENTION | _FAR_CALL)

/* Hard disk driver modifiers should be aware that if there are greater */
/* than 24 partitions in both physical devices, DOS has mucho problems  */
/* booting from either drive.  In fact, the problems may be deeper than */
/* just booting.  In any case, limit the maxparts here to avoid that    */
/* problem. 3 FEB 88 */ 

#define	maxparts	24	/* partitions per physical device	*/
#define	maxphydrv	2	/*	max # of physical devices	*/
				/* max # of logical units		*/
#define	DKMAXUNITS  (maxparts * maxphydrv)
				/* number of disk types supported, 47	*/
				/* types added a few for insurance 	*/
#define NUMBER_DRIVES_SUPPORTED    100	
			/* physical address of disk drive cmos table	*/
#define CMOS_DISK_TABLE_ADDRESS   0xfe401

#define MAXPTES         4	/* maximum partition table entries/MBR	*/       
#define MAXREC        512  	/* maximum sector size			*/       
#define SECTORSIZE    512
/************************************************************************/
/*									*/
/*      Constants							*/
/*									*/
/************************************************************************/

#define SIGNATURE       0xAA55  /* MBR/EBR/OS boot record signature	*/
#define DOS12           1       /* DOS partition with 12 bit FATs	*/
#define DOS16           4       /* DOS partition with 16 bit FATs	*/
#define DOSEXT          5       /* Extended DOS Partition/Volume	*/
#define DOS16L		6	/* large dos partition			*/

/************************************************************************/
/*		driver parameter defines				*/
/************************************************************************/

#define	HDMAXUNITS	maxphydrv	/* 2 hard disks			*/
				/* max number of phy units supported	*/
#define	HDFLAGVAL	2	/*  dh flag value			*/
#define	HDFILLVAL	0L	/*  DH fill value for control words	*/
#define	HDMAXSECS	256

/************************************************************************/
/************************************************************************/
/*		HDC defines						*/
/************************************************************************/
/************************************************************************/

/************************************************************************/
/*		port definitions					*/
/************************************************************************/

#define HDCDATA		0x1f0	/*read/write-data port (16 BITS !!!)	*/
#define	HDCERR		0x1f1	/*  read - error flags			*/
#define	HDCPRECOMP	0x1f1	/*  write - write precomp cyl 		*/
#define	HDCSECCNT	0x1f2	/*  read/write - sector count		*/
#define HDCSECNO	0x1f3	/*  read/write - sector number		*/
#define HDCCYLLO	0x1f4	/*  read/write - lsb cylinder number	*/
#define HDCCYLHI	0x1f5	/*  read/write - msb cylinder number	*/
#define HDCSDH		0x1f6	/* read/write-sectorsize,drv #,head #	*/
#define HDCSTAT		0x1f7	/*  read - status register		*/
#define HDCCMD		0x1f7	/*  write - command register		*/
	
/************************************************************************/
/*	HDCSTAT	status port values					*/
/************************************************************************/

#define	HDC_BSY		0x80	/*  1 = hdc busy 			*/
#define HDC_RDY		0x40	/*  1 = hdc ready			*/
#define HDC_WF		0x20	/*  1 = hdc write fault			*/
#define HDC_SC		0x10	/*  1 = hdc seek complete		*/
#define HDC_DRQ		0x8	/*  1 = hdc data request		*/
#define	HDC_ECC		0x4	/*  0 = hdc reserved bit		*/
#define HDC_INDEX	0x2	/*  1 = hdc index pulse			*/
#define HDC_ERR		0x1	/*  1 = hdc error			*/

/************************************************************************/
/*	HDCERR - error register equates					*/
/************************************************************************/

#define HDC_BB		0x80	/*  1 = hdc bad block detect		*/
#define HDC_CRC		0x40	/*  1 = hdc crc data field		*/
#define HDC_ID		0x10	/*  1 = hdc id not found		*/
#define HDC_AC		0x4	/*  1 = hdc aborted command		*/
#define HDC_TK		0x2	/*  1 = hdc track 0 error 		*/
#define HDC_DM		0x1	/*  1 = hdc data address mark not found	*/

/************************************************************************/
/*  		command summary						*/
/************************************************************************/


#define	HDCRECAL	0x10	/*  hdc restore command			*/
#define HDCSEEK		0x70	/*  hdc seek command			*/
#define HDCREAD		0x20	/*  hdc read sector command		*/
#define HDCWRITE	0x30	/*  hdc write sector command		*/
#define	HDCVERIFY	0x40	/*  hdc read sector with no data xfer	*/
#define HDCFORMAT	0x50	/*  hdc format track command		*/
#define HDCDIAG		0x90	/*  hdc diagnostics			*/
#define HDCSET		0x91	/*  hdc set parameters 			*/

/************************************************************************/
/*  additional bits/bit masks in command codes/parameter registers	*/
/************************************************************************/

#define HDCRETRY	0x0	/* hdc retry switch			*/
				/* 0 = enable retries 			*/
				/* 1 = disable retries			*/
#define HDCMULTI	0x4	/* hdc multi - sector read/write	*/
				/*  0 = transfer one sector		*/
				/*  1 = transfer multiple sectors	*/
#define HDCIE		0x8	/* hdc interrupt enable			*/
#define HDCECC		0x80	/* extended sector size for ecc field	*/

/************************************************************************/
/*    Hard Disk register defines					*/
/************************************************************************/

#define	HDCREG		0x3f6	/*  fixed disk register			*/
#define	HDC_H16		0x8	/* 16 head option, no reset		*/
#define	HDC_H8		0x0	/* 8 head option, no reset		*/
#define HDC_RESET	0x4	/* reset, 8 head option 		*/






/************************************************************************/
/*	HDTF - Hard Disk Task File.					*/
/************************************************************************/

#define	CFMAX	7	/*  max number of command bytes in command file	*/

typedef struct 
{
	BYTE	hd_cmd[CFMAX] ;	/*  disk command file			*/
} HDTF ;

/************************************************************************/
/*		hd_misc values 						*/
/************************************************************************/

#define	HDINTNO		118	/* xmacine hard disk interrupt #	*/
#define PIC0CTL		0x20	/* pic control port			*/
#define PIC0MSK		0x21	/* pic mask port			*/
#define	PIC1CTL		0xa0	/* pic 1 control port #			*/
#define PIC1MSK		0xa1	/* pic 1 mask port #			*/
#define PICNSEOI	0x20	/* non specific end of interrupt	*/

#define	HDMAXREC	1024	/* max record size for this controller  */
#define HDCMOSVAL	0x92	/* cmos access value for hard disk type	*/  
#define HD1CMOSVAL      0x9A    /* cmos index drive type for drive d:   */
#define HD0CMOSVAL      0x99    /* cmos index drive type for drive c:   */
#define CODE_TYPE          0    /* type field for mapphys calls         */


#define PD struct _ProcDescr	/*  Process Descriptonr structure.	*/


/************************************************************************/
/*  general type definitions						*/
/************************************************************************/

typedef WORD	ASR ;	/************************************************/
			/*  another subroutine type.  declares the rtn	*/
			/*  as an ASR, returning no value, and running	*/
			/*  asynchronously.				*/
			/************************************************/

typedef BOOLEAN	ISR ;	/************************************************/
			/*  for interrupt service routines		*/
			/************************************************/


#define	ERROR	LONG	/************************************************/
			/*  Error codes.				*/
			/************************************************/

#define EMASK	LONG	/************************************************/
			/*  Event Masks.				*/
			/************************************************/

#define ENUM	LONG	/************************************************/
			/*  Event numbers.				*/
			/************************************************/

#define	MXID	LONG	/************************************************/
			/*  mutual exclusion id's			*/
			/*  used with mxinit, mxevent, etc		*/
			/************************************************/

#define	FLAGNO 	LONG	/************************************************/
			/*  flag numbers used with flagget, flagset, etc*/
			/************************************************/

#define	NULLL	0L	/************************************************/
			/*  Long Nulls					*/
			/************************************************/

#define	SYSADDR	LONG	/************************************************/
			/*  System Address				*/
			/************************************************/

#define	PHYSADDR LONG	/************************************************/
			/*  Physical Address				*/
			/************************************************/

#define	USRADDR	LONG	/************************************************/
			/*  User Address				*/
			/************************************************/



/************************************************************************/
/*		usefull constants					*/
/************************************************************************/


#define	MAXPOSLONG	0x7fffffffL


/************************************************************************/
/*		system externals					*/
/************************************************************************/

/************************************************************************/
/*  		mutual exclusion functions				*/
/************************************************************************/
EXTERN	MXID	mxinit() ;			
EXTERN	MXID	mxevent() ;
EXTERN	MXID	mxuninit() ;
EXTERN	MXID	mxrel() ;

EXTERN	VOID	nodisp() ;
EXTERN	VOID	okdisp() ;
EXTERN	VOID	noabort() ;
EXTERN	VOID	okabort() ;
EXTERN	VOID	noasr() ;
EXTERN	VOID	okasr() ;

/************************************************************************/
/*		flag system functions					*/
/************************************************************************/

EXTERN	ERROR	flagclr() ;
EXTERN	ERROR	flagset() ;
EXTERN	EMASK	flagevent() ;
EXTERN	FLAGNO	flagget() ;
EXTERN	ERROR	flagrel() ;

EXTERN	EMASK	wait() ;
EXTERN	ERROR	aret() ;

/************************************************************************/
/*		memory allocate functions				*/
/************************************************************************/

EXTERN	SYSADDR	salloc() ;
EXTERN	ERROR	sfree() ;

/************************************************************************/
/*	memory mapping functions					*/
/************************************************************************/
EXTERN	VOID	mapu() ;
EXTERN	VOID	unmapu() ;
EXTERN	SYSADDR	mapphys() ;

EXTERN	SYSADDR	saddr() ;
EXTERN	USRADDR	uaddr() ;
EXTERN	PHYSADDR paddr() ;

/************************************************************************/
/*	misc memory mgmt functions					*/
/************************************************************************/

EXTERN	VOID	mlock() ;
EXTERN	VOID	munlock() ;
EXTERN	ERROR	mrange() ;

/************************************************************************/
/* 		 misc functions						*/
/************************************************************************/
EXTERN	EMASK	pcreate() ;
EXTERN	VOID	setvec() ;
EXTERN	LONG	supif() ;
EXTERN  ERROR	pollevent() ;
EXTERN  ERROR	doasr();
EXTERN	ERROR	nextasr();

EXTERN  VOID	outp();
EXTERN	BYTE	inp();


#define DKASRPRI    199 		/* asr priority			*/

/************************************************************************/
/*		disk driver constants					*/
/************************************************************************/

#define DKREAD      1
#define DKWRITE     2
#define DKRECAL     3
#define DKRDID      4
#define DKRDTRK     5
#define DKFMT       6
#define DKFMTLST    7
#define DKFMTBB     8
#define DKFMTBBLST  9
#define DKVERIFY    10

/************************************************************************/
/*		disk driver type definitions				*/
/************************************************************************/

#define SSN LONG        		/*  Sequential Sector Number	*/
#define SECTOR  UWORD       		/*  Sector Number		*/


/************************************************************************/
/************************************************************************/
/*	  disk driver structure type definitions			*/
/************************************************************************/
/************************************************************************/




/************************************************************************/
/*  HSCADDR -								*/
/*  disk address.  Head, Sector, Cylinder				*/
/************************************************************************/



typedef struct 
{
	UBYTE   hsc_head ;		/*  head number (0, 1, ... )	*/
	UBYTE   hsc_sector ;    	/*  sector number (1, 2, ...)   */
	UWORD   hsc_cyl ;   		/*  cylinder number (0, 1, ...) */
} HSCADDR ;






/************************************************************************/
/*  DKPBLK -								*/
/*  Disk Parm Block.  Parameter block given to disk drivers		*/
/*  for reads and writes.						*/
/************************************************************************/
typedef struct
{
	UBYTE   dk_unitno ; 			/*  unit number		*/
	UBYTE   dk_option ; 			/*  option byte		*/
	UWORD   dk_flags ;  			/*  flag word		*/
	LONG    dk_swi ;    	/*  software interrupt routine address  */
	LONG    dk_pdaddr ; 	/*  address of Process Descriptor	*/
	BYTE    *dk_buffer ;	/*  address of caller's  buffer		*/
	LONG    dk_nsecs ;	/*  number of records for i/o		*/
	LONG    dk_record ;	/*  disk address to start i/o		*/
				/*  (either hh,ss,cccc or log sec nbr)	*/
} DKPBLK ;

/************************************************************************/
/*		option values						*/
/************************************************************************/

#define DKO_RDSYS   0
#define DKO_WRSYS   1
#define DKO_FMSYS   2
#define DKO_FMTRK   3
#define DKO_INFMT   8
#define DKO_PUD	    9
#define DKO_RWPHYS 10 
#define DKO_BIGMDB 1
/************************************************************************/
/*		flags in dk_flags					*/
/************************************************************************/

#define DKF_UADDR   0x8000      	/* user not system address	*/
#define DKF_VERIFY  0x04        	/* verify not read i/o		*/
#define DKF_HSCADDR 0x02
			/*  record is in  Head Sector Cylinder Format   */
			/*               (BYTE)(BYTE) (WORD)		*/





/************************************************************************/
/*	DKSPPB -							*/
/*   Disk Special Parm BLock.  Parm Block for special i/o calls.	*/
/************************************************************************/
typedef struct
{
	BYTE    dsp_unitno ;	/*  logical unit number			*/
	BYTE    dsp_funcno ;	/*  special function code		*/
	WORD    dsp_flags ; 	/*  flags -  see DKF_  flags in DKPBLK  */
	BYTE    *dsp_res1 ;    	/*  reserved				*/
	LONG    dsp_pdaddr ;   	/*  process descriptor address		*/
	BYTE    *dsp_buffer ;  	/*  ptr to i/o buffer			*/
	LONG    dsp_bufsiz ;	/*  number of bytes in i/o buffer	*/
	BYTE	*dsp_prbuf ;	/*  ptr to format parm buffer		*/
	LONG    dsp_prsiz ;	/*  size of format parm buffer		*/
/************************************************************************/
/*									*/
/* [1]if DKF_HSCADDR is true (in the flag word), then this is a physical*/
/* head/track address in HSC format.  otherwise, it is a logical track	*/
/* number, which is an offset from Logical Track 0.			*/
/************************************************************************/

} DKSPPB ;






/************************************************************************/
/*  DKGETPB -	disk get parm block.					*/
/************************************************************************/
typedef struct
{
	UBYTE   fgt_unitno ;
	UBYTE   fgt_res[3] ;
	UWORD   fgt_dtype ;
	UWORD   fgt_maxrs ;
	UBYTE   *fgt_addr ;
	UWORD   fgt_maxfatrecs ;
	UWORD   fgt_mxfsize ;
	UWORD   fgt_mxdsize ;
} DKGETPB ;







/************************************************************************/
/*  MDB - Media Descriptor Block.					*/
/************************************************************************/
typedef struct
{
        UWORD   md_secsiz ;     	/* physical sector size       	*/
        UWORD   md_1sec ;       	/* 1st sector number of FAT   	*/
        ULONG   md_nsecs ;      	/* no. of sectors on volume   	*/
        UWORD   md_sectrk ;     	/* no. of sectors/track       	*/
        UWORD   md_secblk ;     	/* sectors per cluster        	*/
        UBYTE   md_nfats ;      	/* no. of FATs                	*/
        UBYTE   md_mdb ;        	/* media descriptor byte      	*/
        UWORD   md_nfrecs ;     	/* no. of sectors/FAT         	*/
        UWORD   md_dirsize ;    	/* max no. root dir entries   	*/
        UBYTE   md_nheads ;     	/* number of heads            	*/
        UBYTE   md_format ;     	/* FAT format                 	*/
        ULONG   md_hidden ;     	/* no. of sectors before vol  	*/
        ULONG   md_syssize ;    	/* size of system area        	*/
        UWORD   md_maxcyl;      	/* no. of cylinders           	*/
        UWORD   md_crashpad;    	/* landing zone cylinder no.  	*/
        UWORD   md_precomp;     	/* precomp cylinder no.       	*/
        UWORD   md_reserve1;    	/* needed for XT              	*/
        UWORD   md_step;        	/* disk step rate             	*/
        UWORD   md_driveno;     	/* physical drive number      	*/
        UWORD   md_partno;      	/* partition no. of unit      	*/
} MDB ;

#define MDCPM       0   	/* format byte, cpm media (non-DOS)	*/
#define MDDOS       1   	/* format byte, DOS media 1.5 byte fats	*/
#define MDDOSX      2   	/* format byte, DOS media 2.0 byte fats	*/






/************************************************************************/
/*  DKSELPB -								*/
/*   Disk Select Parameter Block.  Parm Block for			*/
/*   Select Calls to disk drivers.					*/
/************************************************************************/
typedef struct
{
	BYTE    dks_unitno ;        	/*  hi level logical unit nbr	*/
	BYTE    dks_option ;      	/*  unused			*/
	MDB *dks_mdbp ;     		/*  ptr to dsk man's med descr	*/
} DKSELPB ;


/************************************************************************/
/*  PUD -								*/
/*   Physical Unit Descr						*/
/*									*/
/************************************************************************/
typedef struct
{
        UWORD   pu_maxcyl ;			/* max cyl # for i/o    */                      
        UBYTE   pu_nheads ;			/* no of heads		*/
        UWORD   pu_resv1;       		/* reserved		*/
        UWORD   pu_precomp ;			/* precomp cylinder no	*/
        UBYTE   pu_resv2;			/* reserved		*/
        UWORD   pu_step;			/* step rate		*/                      
        UWORD   pu_resv3;			/* reserved		*/
        UWORD   pu_crashpad ;		/* landing zone cylinder no	*/                  
        UBYTE   pu_sectors ;			/* no sectors/track	*/
        UBYTE   pu_resv4;			/* reserved		*/
} PUD ;

/************************************************************************/
/*  LUTE -								*/
/*  disk logical unit table entry.					*/
/************************************************************************/
typedef struct
{
	WORD    io_op ;     	/*  opcode (read,write,format,etc)  	*/
	WORD    io_type ;   	/*  type of io ( fat,dir,data r/w ) 	*/
	LONG    io_totnsecs ;   /*  total number of sectors     	*/
	SSN     io_stssn ;  	/*  starting sequential sector #   	*/
	SYSADDR io_buffer ; 	/*  address of buffer in system space   */
	WORD    io_rtc ;    	/*  retry count             		*/

	HSCADDR io_dkaddr ; 	/*  head sector cyl address     	*/
	WORD    io_nsecs ;  	/*  current number of sectors       	*/

	PHYSADDR io_dmaddr ;    /*  dma address, setup by low level 	*/
	LONG    io_dmcount ;    /*  number of bytes, setup by low level */

	ERROR   io_error ;  	/*  return code for request     	*/
	LONG    io_savnsecs ;   /*  same as io_totnsecs for verify  	*/
	SSN	io_savssn ; 	/*  same as io_stssn for verify     	*/

	LONG	io_tnsecs ;	/*  number of sectors for this command	*/
	LONG	io_tbuff ;	/*  buffer pointer for the local track	*/

	SSN	ld_stssn ;  	/*  starting ssn for the logical disk	*/
	SSN	ld_endssn ; 	/*  ending   ssn for the logical disk	*/
	MDB	ld_mdb ;    	/*  mdb                 		*/

	PD	*lu_b_pdaddr ;      	/*  ptr to PB PD		*/
	PD	*lu_pdaddr ;		/*  ptr to requesting PD	*/
	LONG    lu_swi ;		/*  address of req proc's swi	*/

	FLAGNO  lu_ioflagno ;		/*  i/o flagnumber		*/
	BYTE    lu_unitno ;		/*  logical unit number		*/
	BYTE    lu_driveno ;		/*  physical unit number	*/
	WORD    lu_iflag ;		/*  install flags		*/
	WORD    lu_flags ;		/*  request flags		*/
} LUTE ;

#define LU_VERIFY       0x0200  /* verify after write operations */             
#define LU_PARTITIONED  0x0100  /* device partitions allowed     */             
 



/************************************************************************/
/* Physical to Logical Mapping table entry.				*/
/************************************************************************/
typedef struct
{
	CNEAR	ISR (*seqisr)(WORD) ; /* next ISR for current command 	*/
	LUTE    *physlute;	/* pointer to the logical unit table	*/
	WORD    curcyl ;        /* current cylinder for the seek 	*/
	PUD	*pudp ;		/* physical unit descriptor pointer	*/
	BYTE	*tbuff ;	/* intermediate buffer			*/
} P2L ;






/************************************************************************/
/*  BPB - Bios Parameter Block						*/
/************************************************************************/
typedef struct
{
	UBYTE   bpb_njump[3];   /* 3 BYTE near JUMP to boot code	*/
	UBYTE   bpb_oem[8]; /* 8 BYTE OEM name and version      	*/
	UWORD   bpb_bps;    /* WORD bytes per sector        		*/
	UBYTE   bpb_spau;   /* BYTE sectors per allocation unit 	*/
	UWORD   bpb_rs;     /* WORD reserved sectors        		*/
	UBYTE   bpb_nof;    /* BYTE number of FATs          		*/
	UWORD   bpb_nrde;   /* WORD number of root dir entries  	*/
	UWORD   bpb_nsli;   /* WORD number of sectors in logical im.	*/
	UBYTE   bpb_md;     /* BYTE media descriptor        		*/
	UWORD   bpb_nsobsf; /* WORD number of sectors in single FAT 	*/
	UWORD   bpb_spt;    /* WORD sectors per track       		*/
	UWORD   bpb_noh;    /* WORD number of heads         		*/
	ULONG   bpb_nohs;   /* ULONG number of hidden sectors    	*/
	ULONG   bpb_nslx;   /* LONG DRI extension to # sec in log im.	*/
} BPB ;






/************************************************************************/
/*  DKH - Disk Driver Header.						*/
/************************************************************************/
typedef struct
{
	UWORD   dkh_reserved    ;	/* reserved field		*/
	UBYTE   dkh_nbrunits    ;	/* max units supported		*/
	UBYTE   dkh_flags   ;		/* flag word			*/

	ERROR   (*dkh_init)()   ;	/*  pointer to init code	*/
	ERROR   (*dkh_recal)()  ;	/* pointer to recalibrate code	*/
	ERROR   (*dkh_seek)()   ;	/* pointer to init code		*/
	ERROR   (*dkh_select)() ;	/* pointer to select code	*/
	ERROR   (*dkh_flush)()  ;	/* pointer to flush code	*/
	ERROR   (*dkh_io)() ;		/* pointer to read code		*/

	ERROR   (*dkh_res1)()   ;	/*  reserved			*/

	ERROR   (*dkh_get)()    ;	/* pointer to get code		*/
	ERROR   (*dkh_set)()    ;	/* pointer to set code		*/
	ERROR   (*dkh_format)() ;	/* pointer to special code	*/

	/****************************************************************/
	/*   all items below are filled in by the o/s and should be	*/
	/*   initialized to 0L						*/
	/****************************************************************/

	LONG    dkh_ctl0    ;		/* reserved			*/
	LONG    dkh_ctl1    ;		/* reserved			*/
	LONG    dkh_sync    ;		/* mxid for syncing on driver	*/
	PD  **dkh_pdaddr    ;		/*pointer to current pd pointer	*/
	LONG    dkh_sysfunc ;		/* ptr to os function table	*/
} DKH ;


/************************************************************************/
/* PTE - partition table entry						*/
/*  in the master boot record of DOS type fixed disk media		*/
/*  defines 1 of 24 possible partitions on the media			*/
/************************************************************************/
typedef struct
{
	BYTE    bootind ;   /* active boot partition indicator 1 per sys*/
	BYTE    shead ;     /* start head               		*/
	BYTE    ssector ;   /* starting sector (lower 6 bits)   	*/
	BYTE    scylinder ; /* start cylinder less upper 2 sector bits	*/
	BYTE    sysird ;    /* sys type indicator 1=DOS 0=OTHER 	*/
	BYTE    ehead ;     /* ending head no for this partition    	*/
	BYTE    esector ;   /* end sector (6 bits)          		*/
	BYTE    ecylinder ; /* end cylinder (10 bits )      		*/
	LONG    relsec ;    /* relative starting sector no      	*/
	LONG    nsecs ;     /* no of sectors in partition       	*/
} PTE ;

typedef struct
{
	UBYTE	physdrive ;
	UBYTE	used ;
	PTE	unit_part_entry ;
}  PLIST_ENTRY ;

/************************************************************************/
/*  Master Boot Partition Record					*/
/************************************************************************/
typedef struct
{
	BYTE    bootcode[446];  /* offset to PTE in master boot record  */
	PTE	pte[4]; /* partition table has 4 partition table entries*/
	WORD    signature;		/* MBPR/boot signature 		*/
} MBPR ;


/************************************************************************/
/* Disk Time Out timer Parm blcok					*/
/************************************************************************/
typedef struct
{
	UBYTE   tim_sync ;  			/* 0=sync , 1=async	*/
	UBYTE   tim_res ;   			/* reserved		*/
	UWORD   tim_flags ; 		/* 1=absolute , 0 = relative	*/
	LONG    tim_swi ;   			/* action address       */
	LONG    tim_time ;  			/* milliseconds         */
} DKTIMPB ;



CNEAR		LONG 	hd_select(void);
CFAR		ASR 	hd_io(LUTE *u);
CNEAR		VOID 	hd_io1(LUTE *u);
CFAR		ASR 	hd_startio(LUTE *u);
CNEAR		VOID 	hd_terminate(LUTE *u, LONG r);
CNEAR		VOID 	hd_iocompl(LUTE *u);
CNEAR		ISR 	dummyisr(WORD drno);
CNEAR		VOID 	hd_bldtf(HDTF *hdtfp, LUTE *u, WORD driveno);
CFAR		ASR 	seekasr(LUTE *u);
CNEAR		ISR 	seekisr(WORD drno);
CNEAR		ISR 	headisr(WORD drno);
CFAR		ASR 	headasr(LUTE *u);
CNEAR		ISR 	readisr(WORD drno);
CFAR		ASR 	readasr(LUTE *u);
CNEAR		ISR 	writeisr(WORD drno);
CFAR		ASR 	writeasr(LUTE *u);
CNEAR		ISR 	verifyisr(WORD drno);
CFAR		ASR 	verifyasr(LUTE *u);
CFAR		WORD 	hd_poll(void);
CNEAR		VOID 	hd_settimer(LONG time, LUTE *u);
CNEAR		VOID 	hd_cleartimer(LUTE *u);
CFAR		ASR 	hd_timex(LUTE *u);
CNEAR		LONG 	dk_iosetup(BYTE op, DKPBLK *pb);
CNEAR		VOID 	movie(BYTE *d, BYTE *s, WORD length);
CNEAR		LONG 	read(LUTE *u, LONG diskaddr, BYTE *buffer);
CNEAR		VOID 	hd_physinfo(LUTE *u, WORD drive);
CNEAR		VOID 	logicuninit(BYTE unit);
CNEAR		LONG 	logicinit(LUTE *u);
CNEAR		LONG 	hdsync(LONG sy);
CNEAR		VOID 	yGetHscAddr(HSCADDR *hsc, LONG StSsn, LUTE *u);
CNEAR		LONG 	yGetSsn(HSCADDR *hsc, LUTE *u);
CNEAR		LONG 	hd_dmphyio(LUTE *u, CFAR WORD (*rtnaddr)(LUTE *));
CNEAR		LONG 	dk_findpud(BYTE drive);
CNEAR		LONG 	makemdb(LUTE *u, BYTE *buffer);
CNEAR		short 	outputbyte(WORD port, BYTE byte);
CNEAR		short 	cmdquery(void);
CNEAR		BYTE 	hcmdcode(BYTE op);
CNEAR		LONG 	hd_setparm(LUTE *u);
CNEAR		short 	outputcmd(HDTF *hdtfp);
CNEAR		BYTE 	bpsx(WORD n);
CNEAR		VOID 	hd_init(LUTE *u);
CNEAR		VOID 	hd_uninit(void);
CFAR		ASR 	hd_recal(LUTE *u);
CNEAR		LONG 	chk_stat(void);
CFAR		WORD 	getcmos(BYTE offset);
CNEAR		LONG	outpstr( LONG, WORD) ;	/* out word string */
CNEAR		LONG	inpstr( LONG, WORD) ;	/* in word string  */

LONG	dk_init() ;
LONG	dk_subdrv() ;
LONG	dk_uninit() ;
LONG	dk_select() ;
LONG	dk_flush() ;
LONG	dk_read() ;
LONG	dk_write() ;
LONG	dk_get() ;
LONG	dk_set() ; 
LONG	dk_special() ;

ISR	hd_int() ;

