/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.5.01     IFDASR.C                                 *
 *                      Floppy Disk ASR's.                       *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1       6/21/85 reb     excised statctr and friends      *
 *    1.2       6/25/85 reb     SPR 6/24/85 0314                 *
 *    1.3	6/17/86 mei	High C port. Disk errors OR'd    *
 *				   with ED_DISK.		 *
 *    1.4       1/27/87 KPB     Added OUTPW INPW for 386         *
 *    1.5       3/5/86  KPB     Added user address to dm_dmda call*
 *                              for 386 contig memory            *
      1.6	07-Oct-87 glp	FLOP_FMTEND was calling FLOP_IOCOMPL with to
      				many parameters.
      1.7	27-Oct-87 glp	Added reset_seek() for DOD support on XMACHINE
      				with TIMEOUTS.
      1.71	87Dec01	glp	Added support for formating hyper diskettes
      				in a 2nd hyper drive. SPR 1769 (IF00064).
      1.5.00	88Jan19	glp	Fixed reset_seek() so that a reset of the DCL
      				will not cause us to mess up the FDC. This bug
				occurred on DOD drives only.  Also rewrote
				reset_seek() to use FlexOS device polling
				routine instead of hard polling. SPR 1862.
				*** 1.5.00 88Jan19 ***
      1.5.01	88Jan24 glp	Rewrote reset_seek and fdc_seek1 again.  This
      				time I removed use of FlexOS device polling
				routine to clean up code and place less
				overhead on the system. Since this was done
				I also removed fd_poll().
				*** 1.5.01 88Jan24 ***
     1.6	880219		added motor_on check in format_seek
 *===============================================================*
 *  INCLUDES:                                                    */

#include        "portab.h"
#include        "system.h"              /*  system defines              */
#include        "atmc286.h"             /* machine defs                 */
#include        "io.h"                  /*  i/o driver definitions      */
#include        "fd.h"

#include	"floppy.h"		/* Proto types for floppy code	*/

#if METAWARE 
#define IFDASR
#include "protos.h"
#endif

/* (gam) added externs  */
EXTERN	LONG	e_timer() ;
EXTERN  FDLUTE  *FDU ;
EXTERN  IORB    *FDI ;
EXTERN  BYTE    FDDRIVE ;
EXTERN  BOOLEAN         InPosn ;
EXTERN  BYTE            IoInProg ;
EXTERN  BOOLEAN         IoRdy ;
EXTERN  FDTF    IOTF ;
EXTERN  FDTF    PSNTF ;
EXTERN  ISR     (*FDISR)() ;
EXTERN  ASR     (*FDASR)() ;
EXTERN  WORD    CurCyl[] ;
EXTERN  BOOLEAN motor_on[] ;
EXTERN  BOOLEAN FDG_PGFAULT ;
EXTERN  BYTE    xval[] ;
EXTERN  FDTF    *CurTF ;
EXTERN	int	dcl_cleared;
EXTERN	ULONG	fdc_track;


/********************************FORWARD DECLARATIONS***********mei******/

VOID start_io(), io_time(), position(), start_recal(), start_seek(); 
VOID seek_end(), flop_iocompl(), GetHscAddr();	
ASR  flop_fmtend(), do_format(), io_end();

/************************************************************************
*                                                                       *
*               asynchronous portion of floppy drivers                  *
*                                                                       *
************************************************************************/

/**************************************************************************
*  flopasr_io -
*       async portion of read/write request.
*       turn on the motor, position the read/write head, calc the nbr
*       of sectors we can handle, then start the i/o
*/

VOID     flopasr_io() 
{
        /**********/
        LDD     *l ;
        ENUM    e ;
        LONG    nb ;
        WORD    nsecs ;
        WORD    bps ;
        unsigned int	motor_is_on ;

	EXTERN  ENUM    e_timer() ;
        EXTERN	LONG    dm_dmamax() ;
        EXTERN	PROC    fd_pgfault() ;
        /**********/

		FDI->io_error = 0L ;

        /*
        **  convert address to physical head/sector/cylinder
        **  start i/o and exit
        */


        if ( !(FDI->io_pflgs & 0x01) ) 
            GetHscAddr( &FDI->io_dkaddr , FDI->io_stssn , FDU->fu_lddp ) ; /* (reb) */

        /*
        **  turn motor on and position head
        */

        IoRdy = InPosn = FALSE ;
#if     (MACHINE == XMACHINE)
        motor_is_on = fd_motor( ON , FDDRIVE , FALSE ) ;
	if ( motor_is_on == E_DOOROPEN )
	{
/* 1.5.00 88Jan19 (start) */
		return ;
/* 1.5.00 88Jan19 (end) */
	}
#endif
/* no motor on/off stuff for the compupro, so fake it   */
#if     (MACHINE == COMPUPRO)
        motor_is_on = TRUE ;
#endif

        position() ;

        /* 
        **  calc nbr of sectors to do this i/o:
        **    get the lesser of the two:
        **      sectors left on the track  or  nbr of sectors requested
        */

        l = FDU->fu_lddp ;

        if (FDI->io_pflgs & 0x01)  {
                nsecs = 1 ;                             
        }

        else  {
                nsecs = (WORD) 
                  MIN(l->ld_mdb.md_sectrk - FDI->io_dkaddr.hsc_sector + 1,FDI->io_totnsecs ) ;
        }


        /*
        **  nsecs , or  number of sectors dma will allow [1]
        */
        bps = l->ld_mdb.md_secsiz ;             /* bytes per sector     */


#if     (MACHINE == XMACHINE)
        nb = nsecs * bps ;                      /* total nbr of bytes   */
        mapu( FDU->fu_b_pdaddr ) ;
        nb = dm_dmamax((LONG)FDI->io_buffer, nb,&(FDI->io_dmaddr)) ;
        unmapu() ;
        nsecs = nb / bps ;                      /* nbr of sectors in limit */

        if(  !nsecs   ) {                       /*  sector crosses pg bndry */
                fd_pgfault() ;
                nsecs = 1 ;
        }
#else
        mapu( FDU->fu_b_pdaddr ) ;
        FDI->io_dmaddr = PADDR( FDI->io_buffer );
        unmapu() ;
#endif
        FDI->io_nsecs = nsecs ;         /* # of secs in limit   */
        FDI->io_dmcount = nsecs * bps ; /* nbr of bytes to xfer */

        /*
        **  build the task file for the FDC
        */

        buildtf( &IOTF , FDI , l ) ;            /*  M0013               */
        HK_start( FDI ) ;                       /*  M0017               */

        /*
        **  adjust (totnsecs, stssn, buffer) for next try.
        */

        FDI->io_totnsecs -= nsecs ;             /*  adjust for next round  */
        FDI->io_stssn += nsecs ;
        FDI->io_buffer += FDI->io_dmcount ;

        /*
        **  see if we have to wait for the floppy motor to spin up
        */

        if( motor_is_on )  {
                IoRdy = TRUE ;
                if( InPosn ) {
                        start_io() ;
                }
        }
        else {
                e = e_timer( NULLSWI , RELTIME , FDMOTORTIME ) ;
                DKNASR( e , io_time , e , 0L ) ;
        }

}

/*
** [1]  on the XMACHINE, the dma will wrap a segment boundary.  Therefore,
**      we have to limit the i/o up to the top of a physical page (segment)
**      and in the case where the buffer for the requested sector will 
**      actually cross the boundary, we must block/deblock (pgfault condition)
*/

/**************************************************************************
*  position -
*/

VOID    position()
{
        /**********/
        WORD    NewCylNo ;      /*  new cylinder number                 */
        WORD    CurCylNo ;      /*  present cylinder number             */

        /**********/

        CurCylNo = CurCyl[ FDDRIVE ] ;
        NewCylNo = FDI->io_dkaddr.hsc_cyl ;

        if( NewCylNo == CurCylNo ) {
                seek_end() ;
        }
        else if( CurCylNo ==  -1 ) {
                start_recal() ;
        }
        else {                                          /* if( NewCylNo != CurCylNo )  */
                start_seek() ;
        }

}

/**************************************************************************
*  start_recal -
*/

VOID    start_recal()
{
        EXTERN	ISR     recal_intr() ;
        EXTERN	PROC    fd_SetTimer() ;


        FDISR = recal_intr ;
        FDASR = NULLASR ;

        PSNTF.fd_cmd[0] = FCMRECAL ;            /*  recal op code       */
        PSNTF.fd_cmd[1] = FDDRIVE ;             /*  drive to recal on   */
        fd_SetTimer( FDRECALTIME ) ;            /*  start timer         */
        FOutCmd2Fdc( &PSNTF ) ;                 /*  output recal cmd    */
}


/**************************************************************************
*  start_seek -
*/
VOID    start_seek()
{
        /**********/
        EXTERN	ISR     seek_intr() ;
        EXTERN	PROC    fd_SetTimer() ;
        /**********/

        PSNTF.fd_cmd[2] = FDI->io_dkaddr.hsc_cyl ;      /*  desired cyl no */
        FDISR = seek_intr ;
        FDASR = NULLASR ;
#if ( MACHINE == XMACHINE ) /* if AT check for hyper flop       */
        if(  xval[ FDDRIVE ] == H360  )         /*  shift cyl no if nec */
                PSNTF.fd_cmd[2] <<= 1 ;         /*  [1]                 */
#endif
        PSNTF.fd_cmd[1] = FDDRIVE ;             /*  fdc drive number    */
        PSNTF.fd_cmd[0] = FCMSEEK ;             /*  seek command        */

        fd_SetTimer( FDSEEKTIME ) ;             /*  start timer         */
        FOutCmd2Fdc( &PSNTF ) ;                 /*  output seek cmd     */
}
/*
** [1]  double density diskette in a quad density drive; must double step
**      for each cylinder.
*/




/**************************************************************************
*  seek_end -
*/

VOID    seek_end()
{
        CurCyl[ FDDRIVE ] = FDI->io_dkaddr.hsc_cyl ;
        InPosn = TRUE ;
        if( IoRdy )     {
            start_io() ;
        }
}
#if ( TIMEOUTS == TRUE)


/* 1.5.01 88Jan24 (start) */
/* 1.5.00 88Jan19 (start) */

/**************************************************************************
*  reset_seek, fdc_seek1				call from ASR only
*
*	This ASR does two seeks to reset the DCL(Dickette Controller Line)
*	so that we that we can tell when the next E_DOOROPEN
*	error occurs.  This routine will first do a recal if need be. Also
*	it appears the DCL cannot be turned off if the door is open. We
*	therefore return a E_READY error if after resetting the DCL we find
*	that it has not been reset.
*/

ASR	reset_seek()

{
        /**********/
        EXTERN	PROC    fd_SetTimer() ;
        EXTERN	ISR     recal1_intr() ;
        /**********/

	++dcl_cleared;		/* For accounting only	*/
	fdc_track = 2;
	InPosn = FALSE;
	if (CurCyl[ FDDRIVE ] == -1)
	{	  /* We need to do a recal so do it */
	        FDISR = recal1_intr ;
		FDASR = fdc_seek1;
		PSNTF.fd_cmd[0] = FCMRECAL ;	/*  recal op code       */
		PSNTF.fd_cmd[1] = FDDRIVE ;     /*  drive to recal on   */
		fd_SetTimer( FDRECALTIME ) ;    /*  start timer         */
		FOutCmd2Fdc( &PSNTF ) ;         /*  output recal cmd    */
	}
	else
	{
		fdc_seek1();		/* Complete DCL reset	*/
	}
	return(TRUE);
	
}


/**************************************************************************
*  fdc_seek1						call from ASR only
*	See reset_seek above.
*/

ASR    fdc_seek1()


{
        /**********/
        EXTERN	ISR     recal1_intr() ;
        EXTERN	PROC    fd_SetTimer() ;
        /**********/

	if ( fdc_track ==  -2 )
	{	  /* We are done with reset_dcl */
		if ( INPW(FDCDIR) & DISKCHANGED )
		{	  /* We failed in turning off the DCL so the door 
			  must be currently open -- so say so.		*/
			FDI->io_error = (ED_DISK | E_READY);
		}
		else
		{
			FDI->io_error = (ED_DISK | E_DOOROPEN);
		}
		flop_iocompl();
		return(TRUE);
	}
	InPosn = FALSE;
        FDISR = recal1_intr ;		/* Use plain ISR		*/
	FDASR = fdc_seek1;		/* ASR to call at intr time	*/
	PSNTF.fd_cmd[0] = FCMSEEK ;     /*  seek command		*/
	PSNTF.fd_cmd[1] = FDDRIVE ;	/*  fdc drive number		*/
	PSNTF.fd_cmd[2] = fdc_track ;	/*  desired cyl no		*/
	CurCyl[ FDDRIVE ] = fdc_track ;	/* Update global, if we time
					out fd_Timesup will set to -1	*/
        fd_SetTimer( FDSEEKTIME ) ;     /*  start timer			*/
	FOutCmd2Fdc( &PSNTF ) ;         /*  output seek cmd		*/
	fdc_track = fdc_track - 2 ;	/* Get ready for next seek 	*/
	return(TRUE);

}

/* 1.5.00 88Jan19 (end) */
/* 1.5.01 88Jan24 (end) */
#endif

/*
** [1]  double density diskette in a quad density drive; must double step
**      for each cylinder.
*/



/**************************************************************************
*  io_time -
*       this routine gets execution when:
*               the motor was not on @ flopasr_io and
*               the motor spinnup time has expired.
*/

VOID    io_time ( e ) 
ENUM    e ;
{
        ARET(e) ;
        IoRdy = TRUE ;
        start_io() ;
}
        
/**************************************************************************
*  start_io -
*       make sure we are ready, then output the read/write/format command
*       to the controller.
*/

VOID    start_io()
{
        /**********/
        EXTERN	PROC    FOutCmd2Fdc() ;
        EXTERN	PROC    dm_DmaOutput() ;
        /**********/

        if( InPosn && motor_on[ FDDRIVE ] && IoRdy ) {
                FDASR = io_end ;
                FDISR = NULLISR ;
                dm_DmaOutput( FDI ) ;           /*  setup dma for i/o   */
                fd_SetTimer( FDIOTIME ) ;       /*  start timer         */
                FOutCmd2Fdc( &IOTF ) ;          /*  output io cmd       */
        }
}

/**************************************************************************
*  io_end -
*       The phys i/o request has completed, with or without an error.
*       See if
*               there was an error.  if so, and it was terminal, 
*                       abort the logical request.  if it wasn't,
*                       and if there are retries, restart the
*                       physical request; otherwise, abort.
*               there is more left to do, and if so, start it up.
*/


ASR    io_end()
{
        /**********/
        static BYTE     recal_retry = 0 ;
        EMASK   error ;                 
        EXTERN	PROC    fd_ClearTimer() ;
	EXTERN  PROC    fd_pgend() ;
        /**********/

        fd_ClearTimer() ;                       /*  cancel timer        */

        if( FDG_PGFAULT )                       /*  deblock             */
                fd_pgend() ;

        /* (gam) removed call to terminal();    */
        error = FDI->io_error;
        if( error )     {
        if( ! ( ( error == (ED_DISK | E_READY ) )     || 
		( error == (ED_DISK | E_DKATTACH ) )  || 
                ( error == (ED_DISK | E_WPROT ) ) )  && ( FDI->io_rtc--  )  )
                {

                        /*  
                        **  allow one quick retry the rest will recal the drive
                        */

                        if( recal_retry++ )     {
                                CurCyl[ FDDRIVE ] = -1 ; /*  force recal  */
                        }

                        /*  backup stssn, totnsecs, buffer.  */

                        FDI->io_totnsecs +=   FDI->io_nsecs ;
                        FDI->io_stssn    -=   FDI->io_nsecs ;
                        FDI->io_buffer   -=   FDI->io_dmcount ;

                        flopasr_io() ;  /*  try again                   */
                        return(0) ;     /*  don't reset recal_retry     */
                }
                else {
                        flop_iocompl() ;
                }
        }
        else if( FDI->io_totnsecs )     {
                /*  more to do  */
                flopasr_io() ;
        }
        else /* ( done ) */
                flop_iocompl() ;

        recal_retry = 0 ;
}


VOID    mio_time ( e ) 
ENUM    e ;
{
        ARET(e) ;

	fd_SetTimer( FDSEEKTIME ) ;             /*  start timer         */

	FOutCmd2Fdc( &PSNTF ) ;		/*  output seek cmd     */
}

/* 28 feb - (gam) inserted formating routines   */
/******************************************************************************
*  format_seek -
*       format one track by one of two methods.  1) take the starting sector
*       number and the number of sectors for this track and format the track
*       with sequential sectors (no interleave).  2)  take a list of sector
*       numbers, and format the track in order dictated by the list.
*/

ASR     format_seek( u )
FDLUTE  *u ;
{
        /**********************/
	ERROR	r;
	EMASK	e ;
        EXTERN	ISR     fmseek_intr() ;

        /**********************/

FDASR = do_format ; /* sched in interrupt routine, it will do the output
                        to the FDC, for the format write */
FDISR = fmseek_intr ;


/* (gam) 4 apr 85  */

#if ( MACHINE == XMACHINE)
/* 1.71 87Dec01	(start) */
	if ( UnitType[FDDRIVE] == UT_96TPIDOD) {
		  /* Hyper drive */
                if (FDU->fu_lddp->ld_mdb.md_mdbyte == 0xf9 ) {
			  /* Hyper diskette */
                        xval[FDDRIVE] = H12;
                } else {
			  /* XT type diskette in hyper drive */
			xval[FDDRIVE] = H360;
		}
        } else {
		xval[FDDRIVE] = DD360;		/* All others XT style */
	}
	OUTPW( XPORT , xval[FDDRIVE]);
/****	  
        if ( FDDRIVE )  {
                OUTPW( XPORT , xval[FDDRIVE] = H360 ) ;
        }       
        else {
                if (FDU->fu_lddp->ld_mdb.md_mdbyte == 0xf9 ) {
                        OUTPW( XPORT ,xval[FDDRIVE] = H12 ) ;
                }
                else {
                        OUTPW( XPORT , xval[FDDRIVE] = H360 ) ;
                }
        }
****/
/* 1.71 87Dec01	(end) */
/* gam  */
#endif


#if     (MACHINE == XMACHINE)
        fd_motor( ON , FDDRIVE , FALSE ) ;
#endif

/* set up cmd file for seek and output it to the controller */
PSNTF.fd_cmd[2] = FDI->io_dkaddr.hsc_cyl ;      /*  desired cyl no */

#if     (MACHINE == XMACHINE)
if(  xval[ FDDRIVE ] == H360  ) {       /*  shift cyl no if nec */
        PSNTF.fd_cmd[2] <<= 1 ;         /*  [1]                 */
}
#endif

PSNTF.fd_cmd[1] = FDDRIVE ;             /*  fdc drive number    */
PSNTF.fd_cmd[0] = FCMSEEK ;             /*  seek command        */

    if(!motor_on[FDDRIVE])
    {
	e = e_timer( NULLSWI , RELTIME , FDMOTORTIME ) ;
        DKNASR( e , mio_time , e , 0L ) ;
    }
    else
    {
	fd_SetTimer( FDSEEKTIME ) ;             /*  start timer         */

	if (( r = FOutCmd2Fdc( &PSNTF ) ) != NULLPTR )  {  /*  output seek cmd     */
        	return( r );                              
	}
	else {
	        return( SUCCESS );
	} 
    }
}


        
/******************************************************************************
*  do_format -
*       format one track by one of two methods.  1) take the starting sector
*       number and the number of sectors for this track and format the track
*       with sequential sectors (no interleave).  2)  take a list of sector
*       numbers, and format the track in order dictated by the list.
*/

ASR    do_format( )
{
        /**********************/

        static BYTE     fgap[2][6] =
        {
                { 0x19, 0x30, 0x87, -1,   -1, -1 } ,
                {   -1, 0x32, 0x50, 0xf0, 01, -1 }
        } ;

        /**********************/
        FDTF    *f ;            /*  ptr to task file                    */
        BYTE    *cf ;           /*  ptr to command file of task file    */
        BYTE
                ddens,          /*  double density boolean              */
                fill,           /*  data fill char for format           */
                N ;             /*  bytes / sector indicator            */


        /**********************/

        ddens = FDI->io_rtc >> 8 ;              /*  double dens indic   */
        fill = FDI->io_rtc & 0xff ;             /*  fill characetrer    */
        N = *((BYTE*)FDI->io_buffer + 3) ;      /*  4th field in chrn buffer */

        f = &IOTF ;
        cf = &f->fd_cmd[0] ;

        *cf++ = ( ddens ? FCMFMT | FCMMFM : FCMFMT ) ;  /*  FDC Command */
        *cf++ = (FDI->io_dkaddr.hsc_head << 2) + FDU->fu_driveno ;      
        *cf++ = N ;                             /*  bytes/sector indic  */
        *cf++ = (BYTE) FDI->io_nsecs ;          /*  sectors/track(cyl)  */
        *cf++ = fgap[ddens][N] ;                /*  format gap indic    */
        *cf++ = fill ;                          /*  fill char           */

        dm_DmaOutput( FDI ) ;                   /*  setup dma           */
        FDASR = flop_fmtend ;                   /*  setup global ASR    */
        FDISR = NULLISR ;

        if(  ! FOutCmd2Fdc( f )   )             /*  if problems in output    */
        {                                       /*    there won't be an intr */
                FDI->io_error = ( ED_DISK | E_DKATTACH ); /*so, set error code */
                flop_iocompl() ;
        }
	return(0);
}




/******************************************************************************
*  flop_fmtend -
*       the interrupt for the format has occurred.  signal the upper level
*       driver that we are finished.  error code is already in io_error via
*       fd_erroranal...
*/

ASR  flop_fmtend()
{
        flop_iocompl( ) ;
	return(0);
}



/***************************************************
*  flop_iocompl -
*       terminate the I/O request 
*       the error code is in the iorb.
*/
VOID    flop_iocompl()
{
        LONG    ecount = 0 ;

        if( FDI->io_error )

                ecount++ ;

        FLAGSET( FDU->fu_ioflagno , FDU->fu_f_pdaddr , FDI->io_error ) ;
        /*  M0016  */
        HK_exit(FDI,CurTF) ;                             /*  M0017  */
        FDISR = NULLISR ;
        FDASR = NULLASR ;
        IoInProg = FALSE ;
}




/***************************************************
 *  GetHscAddr -
 *      Get the Head Sector and Cylinder Address
 *      from the Sequential Sector Number.
 *
 *      NOTE:  This is dependent on disk formats.  WILL
 *      NOT WORK on CPM media or hard disks with track
 *      numbers in sector id's instead of cylinder numbers.
 *      
 *      
 *      
 */

VOID    GetHscAddr( hsc, StSsn , l )

        HSCADDR *hsc ;          /*  ptr to head sector cylinder addr    */
        SSN     StSsn ;         /*  Starting Sequential Sector Number   */
        LDD     *l ;            /*  ptr to log disk descr               */

{
        WORD    LogTrkNo ;      /*  Nbr logical trks before start */

        if ( l->ld_mdb.md_format == MDFCPM )  {

                /* Logical tracks start at phys cyl 0 side 0 proceeding inward to 
                ** the center on side 0 then coming back out on side 1.
                */

                hsc->hsc_sector = ( StSsn % l->ld_mdb.md_sectrk ) + 1 ; /* 1,2,... */
                LogTrkNo = StSsn / l->ld_mdb.md_sectrk ;                                                        /* 0,1,... */

                if ( l->ld_mdb.md_nheads == 2 )  {
                        if ( LogTrkNo > 39 )  {
                                hsc->hsc_head = 1 ;
                                hsc->hsc_cyl = 79 - LogTrkNo ;
                        }                                               
                }
                else  {
                        hsc->hsc_cyl = LogTrkNo ;                                               /* 0,1,... */
                        hsc->hsc_head = LogTrkNo % l->ld_mdb.md_nheads ;        /* 0,1,... */
                }
        } 
        else  {

                /*
                **  Logical tracks start at phys cyl 0/side 0, then to cyl 0/side 1,
                **  then cyl 1/side 0, etc
                */

                hsc->hsc_sector = ( StSsn % l->ld_mdb.md_sectrk ) + 1 ; /* 1,2,... */
                LogTrkNo = StSsn / l->ld_mdb.md_sectrk ;                /* 0,1,... */
                hsc->hsc_head = LogTrkNo % l->ld_mdb.md_nheads ;        /* 0,1,... */
                hsc->hsc_cyl = LogTrkNo / l->ld_mdb.md_nheads ;         /* 0,1,... */
        }

}
