/******************************************************************************
* CONFIG.H - CONFIG Control Module: Protected			Version 1.5.03
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
* v1.5.03 88Mar28  AM	Changed NUM_ASR from 32 to 64 for SPR #2035.
* v1.5.02 88mar09  ldt  Added define UNSECURE.
* v1.5.01 88Feb29  glp	Added FNUM_ defines for new FNUMTAB support.  SPR 1785.
*			*** 1.5.01 88Feb29 ***
* v1.5.00 88Feb08  ldt  Removed RELDATE, RELVER and COPYRIGHT.
* v1.4.04 01/19/88 ldt	Removed NEWTEXT ( not used ). Cleaned up comments,
*			removed opportunity to attempt to make partition 4
*			bootable.
* v1.4.03 11/04/87 sgt	Define NETREQ and NETDLC
* v1.4.02 08/24/87 ldt	Added support for a fourth partition.
* v1.4.01 06/01/87 AM	Changed LOADADDR to 0x1f0c0 for IAPX386 beta.
* v1.4.00 04/23/87 BVH	Define NEWTEXT to use the text subdrivers.
* v1.3.02 10/10/86 ldt  rename file to config.h - config.c includes config.h
* v1.3.01 09/14/86 ldt  Reduced FS tuning specs by 1/4th.
* v1.3.00 09/14/86 ldt  Doubled the FS tuning specs.
* v1.2.04 06/12/86 RFW  Changed GMAN define to GIF Graphics Interface 
*  1.2.03 06/10/86 mei  #ifndef ICONF286 for Metaware functional prototypes.
* v1.2.02 06/02/86 tdm  Added network defines.
* v1.2.01 04/29/86 LDT	Corrected GMAN define.
* v1.2.00 04/11/86 FRH	Add sysbuild.h (struct.h assumes this)
*	8 03/10/86 LDT	Increased FSMEMSIZE to 6K. (was 2K)
*	7 01/09/86 RFW	added GMAN define to setup graphics
*	6 09/19/85 cpg	OSPOOL, FNUMTAB and ASR table init changes
******************************************************************************/
/*
**	For a debuggable system...depending on which system is built...
*/
#if IAPX386
#define	LOADADDR	0x17760		/* 386 load address */
#elif IAPX286
#define	LOADADDR	0x260C0		/* 286 load address */
#endif

/*
**	For an usecured system, allow searching for the command.286
**	and config.bat files.  The minimum requirement to bring FlexOS
**      up, will be owning a FlexOS Programmer's Toolkit #1 diskette.
**
*/
#define UNSECURE 1

/*************************
**			**
**	ATTACHMENTS	**
**			**
**************************
**
**	Include a DOS Application Environment.
*/
#define  DOSFE

/*
**	Include the Graphics Interface modules in FlexOS.
*/
$#define GIF

/*
**	Link in the Hard Disk Driver via CONFIG.C.
**	If FALSE, make a floppy bootable FlexOS system.
*/
#define	HARD		FALSE

/*
**	Define the following two variables based on how many partitions
**	the hard disk has.  This is important when booting FlexOS from
**	a partition other than partition 1.
**
**	Install partition 2 via CONFIG.C.
*/
#define	TWOHARD		FALSE

/*
**	Install partition 3 via CONFIG.C.
*/
#define	THREEHARD	FALSE

/*
**	FlexOS partition on the hard disk where the window manager 
**	and shell are to be loaded from.  This coincides with which
**	partition FlexOS is to be booted from also.
**
**	1 = first partition
**	2 = second partition
**	3 = third partition
*/
#define	DOSPART		1

/*
**	Link in the Printer Driver via CONFIG.C
**	If FALSE, use a loadable printer driver.
*/
#define	PRINTER		FALSE

/*
**	Determine how the mouse driver is to loaded.
**
**	2 = Mouse sub-driver will be linked in.
**	1 = Mouse sub-driver is loadable.
**	0 = OLD Mouse sub-driver is linked in.
*/
#define MOUSE		1

/*********************
**		    **
**	MEMORY	    **
**		    **
**********************
**
**	Default stack size for a process.
*/
#define	DEFSTK	2536L

/*
**	Number ldt entries allocated per process.
*/
#define	MAXLDT	200

/*****************************************
**					**
**	   FILE SYSTEM TUNING   	**
**					**
******************************************
**
**	Larger values used below will either increase performance
**	or allow open more files at the expense of user memory.
**
**	Size in bytes of a single internal OS memory pool used to 
**      cache FATs and directories.
*/
#define	DIRFATSZ	0x6000L

/*
**	Size in bytes of a single internal OS memory pool used to
**	cache file data.
*/
#define	DATASZ		0x2100L

/*
**	Portion of TOTALQUOTA pool reserved for path name as opposed
**	to hash codes.
*/
#define	PATHQUOTA	0x600

/*
**	Portion of FSMEMSIZE pool reserved for pathname and pathname
**	hash code storage.
*/
#define	TOTALQUOTA	0x1200

/*
**	Size in bytes of the internal file system memory pool.
**	This pool contains file-open-lists, lock-lists, etc.
*/
#define FSMEMSIZE	0x9000	


/* 1.5.01 88Feb29 (start) */

/*
**	Maximum number of current open files.
*/


	/*** The following 3 defines can be changed ***/
	
  /* FNUM_TBITS. Number of bits in the low UWORD of a file number to be
  used to represent the file table that the file number data structure
  can be found in.  1 <= FNUM_TBITS < 16.  FNUM_TBITS + FNUM_IBITS <= 16 */
  
#define	FNUM_TBITS	4

  /* FNUM_IBITS. Number of bits in the low UWORD of a file number to be
  used to represent the index of the file number data structure within
  a given file table.  1 <= FNUM_IBITS < 16.  FNUM_TBITS + FNUM_IBITS <= 16 */

#define	FNUM_IBITS	5

  /* FNUM_TABLES.  Number of file tables to start with.  1 <= FNUM_TABLES
  <= FNUM_MTABLES.  (FNUM_TABLES * FNUMALLOTMENT) is the number of files
  that can be opened initially by all processes.			*/

#define	FNUM_TABLES	4

	/* (1 << FNUM_IBITS) * sizeof(FNUMT) < 64k */
	/* sizeof(FNUMT) is currently 10 */


	/*** Do change the following 5 defines ***/

#define FNUM_MTABLES	(1 << FNUM_TBITS)	/* Maximum file tables	*/
#define FNUM_ALLOTMENT	(1 << FNUM_IBITS)	/* FNUMs per file table	*/

	/* (FNUM_MTABLES * FNUM_ALLOTMENT) is the maximum file opens that
	are supported by your FlexOS system this must be < 64k.	 */


#define FNUM_SHIFTTABLE		(16 - FNUM_TBITS)
	/* Number of bits to shift to get the file table index */
#define FNUM_BITSALLOTMENT	(FNUM_ALLOTMENT-1)
	/* Bit mask for the index into a file table */
#define FNUM_UNUSEDBITS		((0xffff >> FNUM_TBITS) & (~FNUM_BITSALLOTMENT))
	/* Bit mask of the unused bits in the low UWORD of a file number */

/* 1.5.01 88Feb29 (end) */



/*
**	Maximum number of current ASR's scheduled.
*/
#define NUM_ASR		64


/*********************
**		    **
**	NETWORK	    **
**		    **
**********************
**
**	Network defines:  True  =  linked with system or non-existent.
**			  False =  loaded as driver.
**
** 	Note:	NETWORK must be set to true if any one of the other net
**		defines is set to true.
**		Set NETSERV to false to have a requester only node.
*/
#define NETWORK		FALSE		/* Network Resource Manager 	  */
#define NETREQ		FALSE		/* Network Requester		  */
#define	NETXPORT	FALSE		/* Transporter.			  */
#define NETDLC		FALSE		/* DLC driver			  */
#define	NETNAMES	FALSE		/* Name server.			  */
#define NETDEV		FALSE		/* Net: device.			  */
#define NETSERV		FALSE		/* Server module.		  */
