#################################################################
## FlexOS Floppy, Hard Disk, and Console Drivers -- Makefile   ##
## High C version                                              ##
##                                                             ##
##    Execute on the command line :                            ##
##                                                             ##
##         MAKE -F CNFGLIB.MAK                                 ##
##                                                             ##
#################################################################

#################################################################
##                                                             ##
##    Compile time definitions                                 ##
##                                                             ##
#################################################################
HCPRO 	=  -pro system.pro -def
HDPRO   =  -pro driver.pro -def

#################################################################
##                                                             ##
##    Set the Code segments                                    ##
##                                                             ##
#################################################################
MKCRM 	=  $HCPRO crm
MKPDRV 	=  $HCPRO pdrv
MKFLOP 	=  $HCPRO floppy
MKHD    =  $HDPRO hdisk

#################################################################
##                                                             ##
##    CNFGLIB dependencies                                     ##
##                                                             ##
#################################################################
cnfglib.l86 : 	icdrv.obj icdrvwrt.obj icdrcopy.obj icdrtool.obj ipdrv.obj \
		ireset.obj icdrvkb.obj icdtool.obj fd.obj ifd.obj ifdasr.obj \
		ifdglob.obj ifdhook.obj ifdisr.obj ifdmd.obj \
		hdasm.obj hdasync.obj hdsync.obj hdphys.obj getcmos.obj

 lib86 mkcfglib[i]

icdtool.obj :	cd.equ \
		ega.equ \
		icdtool.a86

 rasm86 icdtool $$pzsz286

ireset.obj :	sysbuild.equ \
		ireset.a86

 rasm86 ireset $$pzsz286

###############
# .C files... #
###############
icdrv.obj :	portab.h system.h io.h protos.h \
		icdrv.h \
		icdrv.c
 hc icdrv $MKCRM

icdrvwrt.obj :	portab.h io.h system.h protos.h \
		icdrv.h \
		icdrvwrt.c
 hc icdrvwrt $MKCRM

icdrcopy.obj :	portab.h io.h system.h protos.h \
		icdrv.h \
		ega.h \
		icdrcopy.c
 hc icdrcopy $MKCRM

icdrtool.obj :	portab.h io.h system.h protos.h \
		icdrtool.c
 hc icdrtool $MKCRM

ipdrv.obj :	portab.h system.h io.h protos.h \
		ipdrv.h \
		ipdrv.c
 hc ipdrv $MKPDRV

icdrvkb.obj :	portab.h protos.h \
		icdrvkb.c
 hc icdrvkb $MKCRM

fd.obj :	portab.h io.h system.h \
		atmc286.h fd.h floppy.h \
		fd.c
 hc fd $MKFLOP

ifd.obj :	portab.h system.h io.h protos.h \
		fd.h ifdma.h floppy.h \
		iifdtim.c iifdphy.c iifdmot.c iifddma.c \
		ifd.c
 hc ifd $MKFLOP

ifdasr.obj :	portab.h system.h io.h protos.h \
		atmc286.h fd.h floppy.h \
		ifdasr.c
 hc ifdasr $MKFLOP

ifdglob.obj :	portab.h system.h io.h \
		atmc286.h fd.h floppy.h \
		ifdglob.c
 hc ifdglob $MKFLOP

ifdisr.obj :	portab.h system.h io.h \
		atmc286.h fd.h floppy.h \
		ifdisr.c
 hc ifdisr $MKFLOP

ifdmd.obj :	portab.h system.h io.h protos.h \
		atmc286.h fd.h atmdbs.h cpmdbs.h \
		ifdmd.c
 hc ifdmd $MKFLOP

ifdhook.obj :	portab.h floppy.h system.h \
		ifdhook.c
 hc ifdhook $MKFLOP

###
###  Hard disk driver modules are created by the
###  make file called below.
###
hdasm.obj :	hdasm.a86 sysbuild.equ
 rasm86 hdasm $$pzszlo286

hdasync.obj :	hdasync.c hd.h system.h sysbuild.h
 hc hdasync $MKHD

hdsync.obj :	hdsync.c hd.h system.h sysbuild.h
 hc hdsync $MKHD

getcmos.obj :	getcmos.c portab.h
 hc getcmos $MKHD

hdphys.obj :	hdphys.c hd.h system.h
 hc hdphys $MKHD

