/******************************************************************************
* PD.H - Non-Kernal Process Descriptor Definition		Version 1.3.01
*******************************************************************************
* Copyright (c) 1985, Digital Research, Inc. All Rights Reserved. The Software
* Code contained in this listing is proprietary to Digital Research, Inc.,
* Monterey, California and is covered by U.S. and other copyright protection.
* Unauthorized copying, adaptation, distribution, use or display is prohibited
* and may be subject to civil and criminal penalties.  Disclosure to others is
* prohibited.  For the terms and conditions of software code use refer to the
* appropriate Digital Research License Agreement.
*******************************************************************************
* Version   Date   Who  Description
* ======= ======== ===  =======================================================
* v1.3.01 09/26/86 AM	Added p_tevnt field and removed PF1_STDWAIT flag from
*			the PD.
*  1.3.00 09/25/86 ldt  Added p_osvp to the PD structure for overlay use.
*  1.2.00 08/11/86 mei  #ifndefs around #defines, NEWSWI conditional out.
*			This pd.h may now be used in files where I previously
*			replaced it with struct.h, but put it at the end, after 
*			other .h's to define all other structs that you use. 
* v1.0.04 860805   reb  removed defines for IAPX286 MC68K and NEWSWI they are in
*			sysbuild.h
* v1.0.03 11/18/85 FRH	NEWSWI Conditionals
* v1.0.02 09/17/85 FRH	Remove p_jba, p_nrpl
* v1.0.01 08/18/85 FRH	Use IAPX286
* v1.0.00 		FlexOS 286 1.0 Release Version
******************************************************************************/
/*
**  10/1/86  PKB
**  references to CDOS, Concurrent or Concurrent DOS changed to FlexOS
*/



#define PD	struct _pd
#define REGSAV	struct _regsav

#ifndef EVSPEC
#define EVSPEC	LONG
#endif
#ifndef UDA
#define	UDA	BYTE
#endif
#ifndef EVB
#define	EVB	BYTE
#endif
#ifndef BDA
#define	BDA	BYTE
#endif
#ifndef VCB
#define	VCB	BYTE
#endif
#ifndef LSRTL
#define	LSRTL	BYTE
#endif
#ifndef MTBL
#define	MTBL	BYTE
#endif
#ifndef MD
#define	MD	BYTE
#endif
#ifndef MLD
#define	MLD	BYTE
#endif

REGSAV
{
#if MC68K
	ULONG	r_dreg[8];	/* D0-D7 */
	ULONG	r_areg[8];	/* A0-A7 */
	ULONG	r_pc;		/* PC */
	UWORD	r_sr;		/* status reg */
#endif

#if IAPX286
	UWORD	r_ip;
	UWORD	r_flags;
	UWORD	r_ax;
	UWORD	r_cx;
	UWORD	r_dx;
	UWORD	r_bx;
	UWORD	r_sp;
	UWORD	r_bp;
	UWORD	r_si;
	UWORD	r_di;
	UWORD	r_es;
	UWORD	r_cs;
	UWORD	r_ss;
	UWORD	r_ds;
	UWORD	r_errcode;	/* exception error code */
#endif

	BYTE	r_pblk[32];	/* SVC parm block */
} ;


PD 
{
	PD	*p_link;
	PD	*p_thread;
	REGSAV	*p_regsav;
	UDA	*p_uda;
/* 0x10 */
	BYTE	p_name[10];
	BYTE	p_stat;
	BYTE	p_prior;
	WORD	p_flag;
	WORD	p_type;
/* 0x20 */
	LONG	p_evbits;	/* event bits in use */
	LONG	p_evwait;	/* event wait mask */
	LONG	p_evflg;	/* event flags */
	EVB	*p_swilist;
/* 0x30 */
	EVB	*p_evlist;
	EVB	*p_term;	/* wait for this proc to terminate */
	PD	*p_curmem;  	/* current memory context */
	PD	*p_parent;
/* 0x40 */
		/* Environment Table Info */
	LONG	p_stdfil[4];	/* std in,out,err,ovl */
/* 0x50 */
	WORD	p_secur;	/* default security */
	WORD	p_flag1;	/* Process Flags, 2nd word */
	BYTE	p_user;		/* Current User ID */
	BYTE	p_group;	/* Current Group ID */
	WORD	p_fid;		/* family id */
	LONG 	p_pid;
	WORD	p_rnid;
	WORD	p_rfid;		/* remote family id */
/* 0x60 */
	LONG	p_rpid;

		/* End Environment Table Info */

	BYTE	p_cid;
	BYTE	p_vcid;
	BYTE	p_tkcnt;
	BYTE	p_abort;
	BDA	*p_bda;		/* bdos data area pointer */
	VCB	*p_cda;		/* cio data area */
/* 0x70 */
	BYTE	*p_feptr;
	BYTE	*p_def;		/* DEFINE table */
	BYTE	*p_mget;	/* mgetblk memory owned by this process */
	BYTE	*p_xlat;	/* xlat table */
/* 0x80 */
	EVB	*p_emaster;	/* controlled process master block field */
	EVB	*p_eslave;
	PD	*p_master;
#if NEWSWI
	LONG	p_savwait;
/* 0x90 */
	LONG	p_swistk;
#else
	PD	*p_swimaster;
/* 0x90 */
	EVB	*p_eswimaster;
#endif
	WORD	p_swienable;
	UWORD	p_stksiz;	/* System stack size */
	BYTE	*p_systak;
	BYTE	*p_cmdenv;
/* 0xa0 */
	BYTE	*p_npx;		/* Numeric processor state save */
	LSRTL	*p_srtl;	/* Process Shared Runtime Lib. list */
	MTBL	*p_ldt;
	LONG	p_maxmem;
/* 0xb0 */
	MD	*p_mem[4];	/* code, data, heap stack */
/* 0xc0 */
	MLD	*p_level;
	MD	*p_stay;	/* term and stay resident memory */
	LONG	p_abortc;	/* abort code save */
	EVB	*p_stdwait;	/* wait for std files open */
/* 0xd0 */
	BYTE	*p_ovsp;
	EVB	*p_tevnt;	/* Terminatstion event */
};		/* pd is 0xd8 => 216 bytes */

/* pd defines */

/* p_stat */
#define		PS_RUN		0
#define		PS_BLOCK	1
#define		PS_RESTORE	2
#define 	PS_TERM		4
#define		PS_MWAIT	6
#define		PS_SHARE	8

/* p_flag */
#define		PF_SYSPROC	0x0001
#define		PF_LOCKED	0x0002
#define		PF_INSWI	0x0004
#define		PF_ORIGINAL	0x0008
#define		PF_NRPL		0x0010
#define		PF_RESOURCE	0x0020
#define		PF_SLAVE	0x0040
#define 	PF_CTLC		0x0080
#define		PF_INSYS	0x0100
#define		PF_TEMPKEEP	0x0200
#define		PF_LOADALL	0x0400
#define		PF_SHOLD	0x0800	/* shared code holder */
#define		PF_SUPER	0x1000
#define		PF_SAVSTK	0x2000	/* Dos frontend errmode flag. */
#define		PF_ABORT	0x4000	/* Process Irrevocably Aborting. */
#if NEWSWI
#define		PF_TERMSWI	0x8000	/* Running Term Event Swi */
#else
#define		PF_HANDLE	0x8000	/* Handling abort now? */
#endif

/* p_flag1 */

#define		PF1_WINDX	0x0001	/* Switching Virtual Consoles */
