/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.2        IFD.C                                    *
 *                      Includes Floppy Disk Machine Dependent   *
 *                      Modules.                                 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0       6/12/85 reb     rewritten/added to system        *
 *    1.1	6/17/86 mei	High C port. Disk error returns  *
 *				   OR'd with ED_DISK.		 *
 *    1.2       1/27/86 KPB     Added INPW OUTW for 386          *
 *                                                               *
 *===============================================================*
 *  INCLUDES:                                                    */

#include        "portab.h"
#include        "system.h"              /*  system defines              */
#include        "atmc286.h"             /*  machine defs                */
#include        "io.h"                  /*  i/o driver definitions      */
/* (gam) 1 may - combined dk.h and floppy.h to one header file  */
#include        "fd.h"
#include        "ifdma.h"

#if METAWARE 
#define IFD
#include "protos.h"
#endif

/************************************************************************
*                       PHYSICAL FLOPPY DRIVERS                         *
*                        Intel 8272A / NEC 765                          *
*                      source compile control file                      *
*                                                                       *
************************************************************************/


/*************************************************************************
*  EXTERNal declarations for the included modules.
*/

EXTERN  BOOLEAN FDG_PGFAULT ;
EXTERN  BYTE    *SPC_BUFF ;
EXTERN  WORD    CurCyl[] ;
EXTERN  BYTE    IoInProg ;
EXTERN  BYTE    *FDG_Ubuff ;
EXTERN  BYTE    dor_image ;
EXTERN  VOID    KillTime();

#if ( MACHINE == XMACHINE )
EXTERN  BYTE    IoFlag[] ;
EXTERN  BYTE    xval[] ;
EXTERN  BOOLEAN motor_on[] ;
EXTERN	LONG	e_timer();
#endif

EXTERN  BYTE    Frdy4res() ;
EXTERN	VOID	OUTPW(), _bmove();
EXTERN	LONG	s_cancel(); 
EXTERN  PROC	flop_iocomp();

/************************************************************************
*  Forward declarations for the included files
*/

VOID 	fd_reset();
VOID	md_tburn();
BOOLEAN FOutByte2Fdc();
BOOLEAN	FInResFromFdc();
BOOLEAN Frdy4cmd();
BOOLEAN	fd_IntStatus();
BOOLEAN	fd_DriveStatus();
BYTE	FInByteFromFdc();
BYTE	Frdy4res();
BYTE	CmdCode();
BYTE	bpsi();
VOID	fd_asettime();
VOID	fd_TimesUp();
VOID	fd_acleartime();

#if ( MACHINE == XMACHINE )
VOID	spintime();
VOID	motortime();
#endif

/************************************************************************
*  included source files
*/

#include        "iifdtim.c"             /*  timer code                  */
#include        "iifdphy.c"
#if (MACHINE == XMACHINE)
#include        "iifdmot.c"
#endif
#include        "iifddma.c"
