
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.8        FDUTLS.C				 *
 *                      Utility procedures for FDISK.		 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *     1.8      12/27/86 KPB   Cast nsec arguments to long to    *
 *                             allow for 40meg drives            *
 *     1.7      10/23/86 KPB   Fixed fdcalc so the formula for   *
 *                             the number of fat sectors was right*
 *     1.6   10/06/86	DR-K	calculate number of sectors needed*
 *				for FATS in a more DOS-like manner*
 *	1.5   08/06/86  ldt	HC port			 	 *
 *	1.4   09/25/85	jsr	Added DEL & WRT flags to both	 *
 *				disk find s_open()'s, to force	 *
 *				exclusive access, even though at *
 *				that point it's only desired to  *
 *				prevent media determination.	 *
 *				However, since the disk gets	 *
 *				accessed anyway, it doesn't do a *
 *				whole lot of good. Also since a	 *
 *				floppy with an open door causes	 *
 *				an open error (after a long	 *
 *				timeout), it was neccessary to	 *
 *				get rid of error aborts on these *
 *				s_open()'s and on the following	 *
 *				s_get()'s. Then, to prevent a	 *
 *				floppy from getting hit, a kludge*
 *				check for the disk device name	 *
 *				starting with 'F' was done. This *
 *				is only temporary code and should*
 *				be removed if and when a method	 *
 *				is implemented to find out the	 *
 *				two things FDISK needs to know	 *
 *				without creating a disk access.	 *
 *				These two items are known by the *
 *				driver at install time, they are:*
 *				whether the device contains	 *
 *				removable media or not, and	 *
 *				whether the device is partitioned* 
 *	1.3   07/22/85	jsr	Modified for 68K compile, added	 *
 *				user terminate code.		 *
 *	1.2   05/09/85	jsr	Fixed FDFDCALC (fat size) prblm. *
 *	1.1   05/07/85	jsr	Updated for HDBOOT/BOOT changes. *
 *	1.0   04/11/85	jsr					 *
 *                                                               *
 *===============================================================*/

/* include some header files */

#include	"portab.h"
#include	"concur.h"
#include	"ccutls.h"
#include	"fdisk.h"

/* declare remote (global) variables */

EXTERN	BYTE	fdpartcnt;			      /* count of partitions */
EXTERN	BYTE	fdcdev[];			   /* name of current device */
EXTERN	BYTE	fdudev[];			/* unavailable device's name */
EXTERN	BYTE	*fdbufptr;		  /* buffer for MBPR and BOOT images */
EXTERN	WORD	fdesclvl;			 /* escape level state count */
EXTERN	WORD	fdcommand;			  /* selected command number */
EXTERN	WORD	fdtotcyl;      /* total number of cylinders on physical disk */
EXTERN	WORD	fddelims[];			/* S_RDELIM input delimiters */
EXTERN	BOOLEAN	fdchange;		    /* set if MBPR changed (written) */
EXTERN	BOOLEAN	fddevopen;				 /* device open flag */
EXTERN	BOOLEAN	fdmulti;		/* set if multiple fixed disks found */
EXTERN	BOOLEAN	fdpexist[];			/* partition existance flags */
EXTERN	BOOLEAN	fdfulsrch;			    /* full search loop flag */
EXTERN	BOOLEAN	fddevunav;			   /* dev found, but unavail */
EXTERN	BOOLEAN	fdpartflg;			  /* set if partitioned disk */
EXTERN	BOOLEAN	fdnoinfo;		       /* set if no FMTINFO for disk */
EXTERN	LONG	fdfnum;				       /* device file number */
EXTERN	LONG	fdlookey;				/* lookup search key */
EXTERN	LONG	fdbufsiz;			/* size of fdbutptr's buffer */
EXTERN	LONG	fdbsiz;				       /* size of boot image */
EXTERN	LONG	fdmsiz;			     /* size of hidden sectors image */
EXTERN	DISK	fddsktbl;		    /* disk device information table */
EXTERN	MBPR	*fdmbprptr;		 /* master boot partition record ptr */
EXTERN	BOOTREC	*fdbootptr;				  /* boot record ptr */
EXTERN	MCB	fdmcb;				    /* message control block */
EXTERN	FMTINFO	*fdfmtptr;		     /* pointer to FMTINFO structure */

EXTERN	jumpbuff	fdjmpbuf;	/* error abort control transfer info */

/* cast local procedures */

BYTE	*fdfixnum();
WORD	fdcylfix();
BOOLEAN	fdchknum();
VOID	fdinit(), fdsetmulti(), fdfindsk(), fdcntp();
VOID	fdsortps(), fdfindgaps(), fdmakep();
VOID	fdrdmbpr(), fdwtmbpr(), fdwtboot();
VOID	fddisparts(), fdprnhdr(), fdprncyls(), fdgetinp();
VOID	fdmemalloc(), fdmemfree();
VOID	fdls2hcs();
VOID	fdfdcalc();
VOID	fdwarnack();
VOID	fderrhand();
VOID	fdterminate();

/* declare external variables */
							  /* from CCMSGS.L86 */
EXTERN	BYTE	carret, eschar;
EXTERN	BYTE	blank, devdelim;
EXTERN	BYTE	numconv[], nullstr[];
EXTERN	BYTE	nextline[], wilddev[], stdiname[];
EXTERN	BYTE	*nullmsg[];
EXTERN	BYTE	cc0316[];
EXTERN	BYTE	*cc0415[], *cc0416[];
EXTERN	BYTE	cc0465[];
EXTERN	BYTE	cc0561[];
EXTERN	BYTE	cc0570[];
EXTERN	BYTE	cc0581[];
EXTERN	BYTE	*cc0600[];
							    /* from FDMSGS.C */
EXTERN	BYTE	fdm0000[];
EXTERN	BYTE	*fdm0010[], *fdm0011[], fdm0012[], fdm0013[];
EXTERN	BYTE	fdm0030[], fdm0031[];
EXTERN  BYTE	*fdm0040[];
EXTERN	BYTE	fdm0062[];
EXTERN	BYTE	fdm0070[];
EXTERN	BYTE	fdm0080[], fdm0081[], fdm0082[], fdm0083[];
EXTERN	BYTE	fdm0084[], fdm0085[], fdm0086[];
EXTERN	BYTE	fdm0093[], fdm0099;

/* declare external procedures */
							  /* from SETFIP.OBJ */
EXTERN	VOID	setfip();
							  /* from CCUTLS.L86 */
EXTERN	BYTE	ut2upr(), *utui2ds(), *utul2ds(), *utskpzro();
EXTERN	LONG	utslen(), utprnmsg();
EXTERN	VOID	strcat(), utintmcb(), utstmcb();
EXTERN	VOID	utemaloc(), utemfree();
EXTERN	VOID	utecrop(), utegtlk(), uterw();
EXTERN	LONG	utfarjmp();

							   /* from CCRTL.L86 */
EXTERN	LONG	s_close(), s_get(), s_lookup(), s_open();
EXTERN	LONG	s_malloc(), s_mfree();
EXTERN	LONG	s_rdelim(), s_read(), s_write();
EXTERN	VOID	s_swiret();

/* start of code */

/* fdmakep() : make a partition entry */
/* Sets the global "fdmcb" and accesses the globals "fdmbprptr" & "fdfmtptr" */

VOID fdmakep(pn, sc, nc, bi)

WORD	pn, sc, nc;		   /* partition number, startcyl and numcyls */
BYTE	bi;						   /* boot indicator */

{

    BYTE	*h, *c, *s;
    LONG	ssec, nsec;

    ssec = 0;
    nsec = ((LONG)nc * ((LONG)fdfmtptr->fi_nhds * fdfmtptr->fi_spt));

					/* start partition on track boundary */
    if(sc == 0)
    {
	ssec = fdfmtptr->fi_hidesecs / fdfmtptr->fi_spt;
	if(fdfmtptr->fi_hidesecs % fdfmtptr->fi_spt)
	    ++ssec;
	ssec *= fdfmtptr->fi_spt;
	nsec -= ssec;
    }

    ssec += (sc * (fdfmtptr->fi_nhds * fdfmtptr->fi_spt));

    fdfdcalc(nsec);

    fdmbprptr->mbpr_pte[pn].pte_bootind = bi;

    fdmbprptr->mbpr_pte[pn].pte_sysind = (fdfmtptr->fi_format == DFM_DOS2) ?
      DOS16B : DOS12B;

    h = &(fdmbprptr->mbpr_pte[pn].pte_shead);
    c = &(fdmbprptr->mbpr_pte[pn].pte_scylinder);
    s = &(fdmbprptr->mbpr_pte[pn].pte_ssector);
    fdls2hcs(ssec, h, c, s);

    h = &(fdmbprptr->mbpr_pte[pn].pte_ehead);
    c = &(fdmbprptr->mbpr_pte[pn].pte_ecylinder);
    s = &(fdmbprptr->mbpr_pte[pn].pte_esector);
    fdls2hcs((ssec + nsec - 1), h, c, s);

    fdmbprptr->mbpr_pte[pn].pte_relsec = ssec;
    fdmbprptr->mbpr_pte[pn].pte_nsecs = nsec;

    fdwtmbpr();

    fdwtboot(ssec);
}

/* fdfdcalc() : calculate secblk, fsecs, dirsize, and format		     */
/* This routine should be IBM PCDOS 3.0 compatible.			     */

VOID fdfdcalc(nsecs)

LONG	nsecs;

{

    BYTE	buf[LBUFSIZ];
    LONG	x, y, minsize;
    LONG        HoldLong;

    fdfmtptr->fi_nsecs = nsecs;
    HoldLong = nsecs;
    HoldLong -= ((32 * FXDSKDIR) / fdfmtptr->fi_ssize);
    
    fdfmtptr->fi_dirsize = FXDSKDIR;

    if(fdfmtptr->fi_nsecs > FXDSKSEC)
    {
	fdfmtptr->fi_spb = SPB2;
	fdfmtptr->fi_format = DFM_DOS2;
    }
    else
    {
	fdfmtptr->fi_spb = SPB1;
	fdfmtptr->fi_format = DFM_DOS1;
    }
						    /* calc # of fat entries */
    x = HoldLong / fdfmtptr->fi_spb;
							 /* calc size factor */
    y = x;
    if(fdfmtptr->fi_format == DFM_DOS1)
    {
	y = x/2;
	if(x & 1)
	   ++y;
    }
				     /* calc minimum size in bytes for a FAT */
    x += y;
	/* The above calculation yields the number of sectors needed for*/
	/* a single FAT.  This amount times the number of FATs should be*/
	/* subtracted from the total number of sectors available on the */
	/* partition, and then the whole calculation done again.	*/
    x = x / fdfmtptr->fi_ssize;
    x = x * fdfmtptr->fi_nfats;
    x = (HoldLong - x) / fdfmtptr->fi_spb;
							 /* calc size factor */
    y = x;
    if(fdfmtptr->fi_format == DFM_DOS1)
    {
	y = x / 2;
	if(x & 1)
	   ++y;
    }
    x += y;
 					      /* calc # of sectors for a FAT */
    fdfmtptr->fi_fsecs = x / fdfmtptr->fi_ssize;
    if(x % fdfmtptr->fi_ssize)
     ++fdfmtptr->fi_fsecs;

    minsize = (fdfmtptr->fi_nfats * fdfmtptr->fi_fsecs) +
      (fdfmtptr->fi_dirsize / (fdfmtptr->fi_ssize / BPDE)) +
      fdfmtptr->fi_bootsecs;
    if(fdfmtptr->fi_nsecs < minsize)
    {
	minsize = ((minsize / fdfmtptr->fi_spt) / fdfmtptr->fi_nhds);
	fdwarnack(fdm0070, utskpzro(utul2ds(minsize, buf)), nullstr);
    }
}

/* fdls2hcs() : convert logical sector to head, cylinder, sector values */
/* Accesses the global "fdfmtptr" */

VOID fdls2hcs(lsec, h, c, s)

LONG	lsec;
BYTE	*h, *c, *s;

{

    WORD	hd, cyl, sec;

    sec = (lsec % fdfmtptr->fi_spt) + fdfmtptr->fi_startsec;
    cyl = (lsec / fdfmtptr->fi_spt) / fdfmtptr->fi_nhds;
    hd = (lsec / fdfmtptr->fi_spt) % fdfmtptr->fi_nhds;

    sec |= ((cyl & 0x0300) / 4);
    cyl &= 0x00ff;

    *s = (BYTE)sec;
    *c = (BYTE)cyl;
    *h = (BYTE)hd;
}

/* fdgetinp() : get input from user, check for escapes.			     */
/* Sets the globals "fdesclvl" and "fdmcb".				     */
/* Accesses the global "fddelims".					     */

VOID fdgetinp(def, buf, max)
BYTE	*def;					      /* default text answer */
BYTE	*buf;				 /* buffer to place answer text into */
WORD	max;		      /* maximum answer length (buflen >= (max + 1)) */
{
    BYTE	inpbuf[BUFSIZ];
    BYTE	*ptrd, *ptrs;

    fdmcb.pptr[PARM5] = def;
    utprnmsg(fdm0031, fdmcb.pptr, STDOUT);

    if((max > BUFSIZ) || (utslen(def) > max))
	fderrhand(FDERR006, 0, (UR_SOURCE|UR_INTERNAL));

    fdmcb.retcode = s_rdelim((RDF_FLS|RDF_DLM|RDF_INC|RDF_EDT|RDF_FP),
      STDIN, inpbuf, (LONG)max, (LONG)0, (LONG)fddelims);

    if(fdmcb.retcode <= 0)
	fderrhand(FDERR012, S_RDELIM, fdmcb.retcode);

    ptrs = inpbuf;
    ptrd = buf;

    if((fdmcb.retcode == 1) && (*ptrs == carret))
    {
	ptrs = def;
	while(*ptrs)
	    *ptrd++ = *ptrs++;
	*ptrd = NULL;
	return;
    }

    while(fdmcb.retcode > 0)
    {
	if(*ptrs == eschar)
	{
	    ptrd = buf;
	    *ptrd = NULL;
	    --fdesclvl;
	    return;
	}

	if(*ptrs == carret)
	{
	    *ptrd = NULL;
	    return;
	}

	*ptrd++ = ut2upr(*ptrs++);
	--fdmcb.retcode;
    }
}

/* fddisparts() : display partition information */
/* Sets globals "fdpexist", "fdpartcnt" and "fdmcb" */
/* Accesses the global "fdmbprptr" */

VOID fddisparts()
{

    BYTE	buf1[2], buf2[LBUFSIZ], buf3[LBUFSIZ], buf4[LBUFSIZ];
    WORD	i;
    WORD	scyl, ecyl;

    fdpartcnt = 0;				      /* no partitions found */

    for(i = 0; i < MAXPARTS; ++i)			  /* check all pte's */
    {
	if(!fdmbprptr->mbpr_pte[i].pte_nsecs)		/* empty partition ? */
	{
	    fdpexist[i] = FALSE;		    /* mark as such and then */
	    continue;					     /* skip to next */
	}

	fdpexist[i] = TRUE;				 /* partition exists */
	++fdpartcnt;						 /* count it */

	if(fdpartcnt == 1)				/* first one found ? */
	    utprnmsg(fdm0080, fdmcb.pptr, STDOUT);	     /* show rep hdr */

	buf1[0] = numconv[i + 1];
	buf1[1] = NULL;
	fdmcb.pptr[PARM2] = buf1;		      /* set partition # msg */
	fdmcb.pptr[PARM3] =			    /* set boot activity msg */
	  (fdmbprptr->mbpr_pte[i].pte_bootind==PARTACTIVE)?fdm0081:fdm0082;
	fdmcb.pptr[PARM4] =			 /* set system indicator msg */
	  ((fdmbprptr->mbpr_pte[i].pte_sysind == DOS12B) ||
	  (fdmbprptr->mbpr_pte[i].pte_sysind == DOS16B))
	  ? fdm0084 : fdm0083;
	scyl = fdcylfix(fdmbprptr->mbpr_pte[i].pte_ssector,
	  fdmbprptr->mbpr_pte[i].pte_scylinder);
	fdmcb.pptr[PARM5] = fdfixnum(scyl, buf2);	/* set start cyl msg */
	ecyl = fdcylfix(fdmbprptr->mbpr_pte[i].pte_esector, 
	  fdmbprptr->mbpr_pte[i].pte_ecylinder);
	fdmcb.pptr[PARM6] = fdfixnum(ecyl, buf3);	  /* set end cyl msg */
	fdmcb.pptr[PARM7] = fdfixnum(1+(ecyl - scyl),buf4); /* set #cyls msg */
	utprnmsg(fdm0085, fdmcb.pptr, STDOUT);		/* print report line */
    }

    if(!fdpartcnt)				   /* if no partitions found */
	fdwarnack(fdm0062, nullstr, fdm0093);

    fdprncyls();				    /* print total cylinders */
}

/* fdprnhdr() : print command/level header (and current disk) */
/* Sets global "fdmcb" */
/* Accesses globals "fdmulti" and "fddsktbl" */

VOID fdprnhdr(i)

WORD	i;

{
    fdmcb.pptr[PARM5] = nullstr;
    utprnmsg(nextline, fdmcb.pptr, STDOUT);
    utprnmsg(fdm0040[i], fdmcb.pptr, STDOUT);

    if((fdmulti) && (fdcommand != SELECT))
    {
	fdmcb.pptr[PARM5] = fddsktbl.dsk_name;
	utprnmsg(fdm0030, fdmcb.pptr, STDOUT);
    }
}

/* fdprncyls() : prints total number of cylinders message 		     */
/* Sets the global "fdmcb" and accesses globals "fdtotcyl" & "fdfmtptr"      */

VOID fdprncyls()
{

    BYTE	buf[LBUFSIZ];

    fdmcb.pptr[PARM5] = utskpzro(utui2ds(fdtotcyl, buf));
    utprnmsg(fdm0086, fdmcb.pptr, STDOUT);		  /* total cylinders */
}

/* fdcylfix() : form a single cylinder number from MBPR packed value */

WORD fdcylfix(sec, cyl)

UBYTE	sec, cyl;

{
    return(((sec << 2) & ~0xff) + cyl);    
}

/* fdfixnum() : convert WORD to string and blank leading zeros, fieldmax = 4 */
/* Sets the global "fdmcb" */

BYTE *fdfixnum(num, buf)

WORD	num;
BYTE	*buf;

{

    BYTE	cnt, *sptr, *eptr;

    if((num < 0) || (num > 9999))
	fderrhand(FDERR007, 0, (UR_SOURCE|UR_INTERNAL));

    sptr = utskpzro(utui2ds(num, buf));
    eptr = sptr;

    while(*eptr)
	++eptr;

    cnt = 4 - (eptr - sptr);

    while(cnt)
    {
	*--sptr = blank;
	--cnt;
    }

    return(sptr);
}

/* fdsortps() : sort partitions by relsec */
/* Accesses the global "fdmbprptr" */

VOID fdsortps(pi)

WORD	pi[];

{

    WORD	i, temp;
    BOOLEAN	undone;

    for(i = 0; i < MAXPARTS; ++i)
	pi[i] = i;

    do
    {
	undone = FALSE;

	for(i = 0; i < (MAXPARTS - 1); ++i)
	{

	  if(fdmbprptr->mbpr_pte[pi[i+1]].pte_relsec <
	    fdmbprptr->mbpr_pte[pi[i]].pte_relsec)
	  {
		temp = pi[i+1];
		pi[i+1] = pi[i];
		pi[i] = temp;
		undone = TRUE;
	  }
	}

    } while(undone);
}

/* fdfindgaps() : setup an array of gap sizes				     */
/* Accesses the globals "fdmbprptr", "fdtotcyl" and "fdfmtptr"		     */

VOID fdfindgaps(g, pi)

GAPINFO	*g;
WORD	pi[];

{

    WORD	i;
    LONG	min;

    g->gapsexist = FALSE;			     /* assume no gaps exist */
    g->largeindex = 0;

    for(i = 0; i <= MAXPARTS; ++i)
    {
	g->gapstart[i] = 0;
	g->gapsize[i] = 0;
    }

    min = fdfmtptr->fi_hidesecs / fdfmtptr->fi_spt;
    if(fdfmtptr->fi_hidesecs % fdfmtptr->fi_spt)
	++min;
    min *= fdfmtptr->fi_spt;

    for(i = 0; i < MAXPARTS; ++i)
    {
	if(!fdpexist[pi[i]])
	    continue;

	if(min < fdmbprptr->mbpr_pte[pi[i]].pte_relsec)
	{
	    g->gapsexist = TRUE;
	    g->gapstart[i] = ((min /fdfmtptr->fi_spt) / fdfmtptr->fi_nhds);
	    g->gapsize[i] = (((fdmbprptr->mbpr_pte[pi[i]].pte_relsec - min) /
	      fdfmtptr->fi_spt) / fdfmtptr->fi_nhds);
	}

	min = fdmbprptr->mbpr_pte[pi[i]].pte_relsec +
	  fdmbprptr->mbpr_pte[pi[i]].pte_nsecs;
    }

    min = ((min / fdfmtptr->fi_spt) / fdfmtptr->fi_nhds);

    if(min < fdtotcyl)
    {
	g->gapsexist = TRUE;
	g->gapstart[MAXPARTS] = min;
	g->gapsize[MAXPARTS] = fdtotcyl - min;
    }

    if(g->gapsexist)
    {
	for(i = 0; i <= MAXPARTS; ++i)
	    if(g->gapsize[i] > g->gapsize[g->largeindex])
		g->largeindex = i;
    }
}

/* fdchknum() : returns TRUE if all buffer entries are numeric */

BOOLEAN	fdchknum(ptr)

BYTE	*ptr;

{

    BYTE	c;
    BOOLEAN	ret;

    ret = TRUE;
    while((*ptr) && (ret == TRUE))
    {
	c = *ptr++ - numconv[0];

	if((c < 0) || (c > 9))
	{
	    ret = FALSE;
	    break;
	}
    }
    return(ret);
}

/* fdinit() : get the FDISK module ready to do it's work.		     */
/* Sets globals "fdfmtptr","fddevopen","fdchange","fdesclvl","fdcommand",    */
/* "fdmcb", "fdfulsrch", "fddevunav", "fdpartflg", "fdnoinfo", "fdcdev",     */
/* "fddelims" & "fdlookey".						     */
/* Also indirectly sets "fdmulti" thru fdsetmulti() and			     */
/* "fdfnum", "fddsktbl" & "fdfmtptr" thru fdfindsk().			     */
/* Accesses the global "fddsktbl"					     */

VOID fdinit()

{
    fdcdev[0] = NULL;
    fdfulsrch = TRUE;
    fdesclvl = ESCLVL1;
    fdfmtptr = (FMTINFO *)0;
    fdcommand = fdlookey = 0;
    fddevopen = fdchange = fddevunav = fdpartflg = fdnoinfo = FALSE;

    fddelims[0] = 2;
    fddelims[1] = (WORD)carret;
    fddelims[2] = (WORD)eschar;

    utintmcb(&fdmcb, fdm0000, fdcdev, nullstr, nullstr, nullstr);

    fdsetmulti();

    fdmemalloc((LONG)1);
    fdfindsk();

}

/* fdsetmulti() : determines if multiple fixed disks exist		     */
/* Sets "globals" "fdmulti", "fddevopen", "fddsktbl", "fdfnum" and "fdmcb"   */

VOID fdsetmulti()
{

    BYTE	*ptr1, *ptr2, dskdev[DEVMAX];
    BOOLEAN	flag;
    LONG	lookey;
    DEVICE	devtbl;

    lookey = 0;						 /* clear search key */
    fdmulti = flag = FALSE;		/* no multis yet, and no fxdsk found */

    while((fdmcb.retcode = s_lookup(DEV_INFO, 0, (LONG)wilddev, (LONG)&devtbl,
      (LONG)sizeof(devtbl), (LONG)sizeof(devtbl),lookey)) > 0)
    {

	lookey = devtbl.dev_lookid;			/* update search key */

	if((devtbl.dev_type &0xf0) != (DISK_INFO & 0xf0))
	    continue;			   /* skip this device if not a DISK */

							 /* copy device name */
	ptr1 = devtbl.dev_name;
	ptr2 = dskdev;
	while(*ptr1)
	    *ptr2++ = *ptr1++;
	*ptr2++ = devdelim;				     /* add devdelim */
	*ptr2 = NULL;

	if(ut2upr(*dskdev) == fdm0099)	  /* TEMP !!! - skip probable floppy */
	    continue;

							 /* open disk device */
	if((fdfnum = s_open((OPF_DEL|OPF_WRT|OPF_FCAS),
	  (LONG)dskdev)) < SUCCESS)
		continue;				  /* skip if failure */

	fddevopen = TRUE;

						      /* get disk info table */
	if((fdmcb.retcode = s_get(DISK_INFO, fdfnum, (LONG)&fddsktbl,
	  (LONG)sizeof(fddsktbl))) < SUCCESS)
	{
		s_close(0 ,fdfnum);
		fddevopen = FALSE;
		continue;
	}
						    /* close the disk device */
	s_close(0, fdfnum);
	fddevopen = FALSE;

	if(fddsktbl.dsk_type & DTP_RMV)
	    continue;		       /* skip this disk device if not fixed */

	if(flag)			       /* fixed disk already found ? */
	{
	    fdmulti = TRUE;		   /* more than one fixed disk found */
	    fdmcb.retcode = 0;
	    break;
	}

	flag = TRUE;				   /* first fixed disk found */
    }

    if(fdmcb.retcode < SUCCESS)			 /* report any lookup errors */
    {
	fdmcb.pptr[PARM4] = cc0316;
	fderrhand(FDERR010, S_LOOKUP, fdmcb.retcode);
    }

    if(!flag)					  /* any fixed disks found ? */
	fderrhand(FDERR001, 0, (UR_SOURCE|UR_FORMAT));

}

/* fdfindsk() : find an available fixed disk				     */
/* Sets globals "fdfnum", "fddsktbl", "fddevopen", "fdtotcyl",		     */
/*              "fdfmtptr", "fdmcb", "fdnoinfo", "fdfulsrch", "fddevunav",   */
/*		"fdpartflg", "fdudev", "fdcdev", "fdlookey",		     */
/*		"fdbsiz", "fdmsiz", "fdmbprptr" and "fdbootptr".	     */

VOID fdfindsk()
{
						      /* temporary variables */
    BYTE	*ptr1, *ptr2;				  /* string pointers */
    BYTE	dskdev[DEVMAX];			/* name of disk device found */
    WORD	uc;				       /* temporary utilcode */
    WORD	i;
    BOOLEAN	loop;			      /* search "while" loop control */
    DEVICE	devtbl;		      /* for checking if device type is DISK */

						   /* free up current buffer */
    fdmemfree();

    loop = TRUE;
    fdudev[0] = NULL;

    while(loop)
    {

	if((fdmcb.retcode=s_lookup(DEV_INFO,0,(LONG)wilddev,(LONG)&devtbl,
	  (LONG)sizeof(devtbl),(LONG)sizeof(devtbl),fdlookey)) < SUCCESS)
	{
		fdmcb.pptr[PARM4] = cc0316;
		fderrhand(FDERR010, S_LOOKUP, fdmcb.retcode);
	}

	if(!fdmcb.retcode)		   /* if nothing found on lookup ... */
	{

	    if(fdfulsrch)	   /* full lookup loop without a usable find */
	    {

		if(fddevunav)		   /* device found but unavailable ? */
		{
		    uc = FDERR002;		   /* conflict error on open */

		    if(fdpartflg)
			uc = FDERR003;		     /* device unpartitioned */
		
		    if(fdnoinfo)
			uc = FDERR004;		    /* no FMTINFO for device */

		    fderrhand(uc, 0, (UR_SOURCE|UR_FORMAT));
		}
		else				     /* nothing found at all */
		    fderrhand(FDERR001, 0, (UR_SOURCE|UR_FORMAT));

	    }

	    fdlookey = 0;			      /* perform full search */
	    fdfulsrch = TRUE;		     /* mark as start of full search */
	    continue;

	}

	fdlookey = devtbl.dev_lookid;

	if((devtbl.dev_type & 0xf0) != (DISK_INFO & 0xf0))  /* disk device ? */
	    continue;					      /* skip if not */

	ptr1 = devtbl.dev_name;
	ptr2 = dskdev;
	while(*ptr1)
	    *ptr2++ = *ptr1++;
	*ptr2++ = devdelim;
	*ptr2 = NULL;


	if(ut2upr(*dskdev) == fdm0099)	  /* TEMP !!! - skip probable floppy */
	    continue;

							 /* open disk device */
	if((fdfnum = s_open((OPF_DEL|OPF_WRT|OPF_FCAS),
	  (LONG)dskdev)) < SUCCESS)
		continue;				  /* skip if failure */

	fddevopen = TRUE;

						      /* get disk info table */
	if((fdmcb.retcode = s_get(DISK_INFO, fdfnum, (LONG)&fddsktbl,
	  (LONG)sizeof(fddsktbl))) < SUCCESS)
	{
		s_close(0 ,fdfnum);
		fddevopen = FALSE;
		continue;
	}

	s_close(0, fdfnum);				 /* close the device */
	fddevopen = FALSE;

	if(fddsktbl.dsk_type & DTP_RMV)		       /* removable device ? */
	    continue;					    /* skip it if so */

	if(fddsktbl.dsk_ioptions & DIO_PDD)	       /* partitioned device */ 
	{
	    if(fdudev[0] == NULL)
	    {
		strcat(fdudev, dskdev);		      /* save unavail's name */
		fddevunav = fdpartflg = TRUE;
	    }
	    continue;				 	 /* skip this device */ 
	}


	if((fdfnum=s_open((OPF_DEL|OPF_WRT|OPF_RD|OPF_FCAS),
	  (LONG)dskdev)) < SUCCESS)			    /* S_OPEN failed */
	{
	    i = (WORD)(fdfnum & 0x0000ffffL);
	    if((i != E_CONFLICT) && (i != E_DEVCONFLICT) && (i != E_DEVLOCK))
	    {
		fdcdev[0] = NULL;
		strcat(fdcdev, dskdev);
		fderrhand(FDERR011, S_OPEN, fdfnum);
	    }

	    if(fdudev[0] == NULL)
	    {
		strcat(fdudev, dskdev);		 /* save name of 1st unavail */
		fddevunav = TRUE;	/* device won't open with privileges */
	    }

	    continue;					 /* skip this device */
	}
	fddevopen = TRUE;			  /* device found and opened */

	setfip(&fdfmtptr, fdfnum, &fddsktbl);	   /* get FMTINFO for device */

	if(fdfmtptr == 0)			    /* no FMTINFO for device */
	{
	    if(fdudev[0] == NULL)
	    {
		strcat(fdudev, dskdev);		      /* save unavail's name */
		fddevunav = fdnoinfo = TRUE;
	    }
	    s_close(0, fdfnum);
	    fddevopen = FALSE;
	    continue;					 /* skip this device */
	}

	fdudev[0] = fdcdev[0] = NULL;	      /* end of search, device found */
	loop = fdfulsrch = fddevunav = fdpartflg = fdnoinfo = FALSE;
	strcat(fdcdev, dskdev);

				    /* save one cylinder for IBM diagnostics */
	fdfmtptr->fi_nsecs -= (fdfmtptr->fi_nhds * fdfmtptr->fi_spt);
	fdtotcyl = ((fdfmtptr->fi_nsecs/fdfmtptr->fi_spt)/fdfmtptr->fi_nhds);

	fdbsiz = (LONG)(fdfmtptr->fi_bootsecs * fdfmtptr->fi_ssize);
	fdmsiz = (LONG)(fdfmtptr->fi_hidesecs * fdfmtptr->fi_ssize);
	fdmemalloc((LONG)(fdbsiz + fdmsiz));

	fdmbprptr = (MBPR *)fdbufptr;
	fdbootptr = (BOOTREC *)(fdbufptr + fdmsiz);

	fdrdmbpr();				    /* read in device's MBPR */
    }
}

/* fdrdmbpr() : read the master boot partition record */
/* Sets global "fdmcb" */
/* Accesses the globals "fdmbprptr", "fdmsiz", "fdfnum" and "fdfmtptr". */

VOID fdrdmbpr()
{

    REG BYTE	*sptr, *dptr;
    LONG	cnt;

    if((fdmcb.retcode = s_read(RDF_BEG, fdfnum, (LONG)fdmbprptr,
      fdmsiz, (LONG)0)) < SUCCESS)
	fderrhand(FDERR013, S_READ, fdmcb.retcode);
				  /* if image read is bad, use library image */
    if((fdmbprptr->mbpr_signature[0] != BSIG1) ||
      (fdmbprptr->mbpr_signature[1] != BSIG2))
    {
	sptr = (BYTE *)fdfmtptr->fi_mbprimg;
	dptr = (BYTE *)fdmbprptr;
	for(cnt = 0; cnt < fdmsiz; ++cnt)
	    *dptr++ = *sptr++;
    }
}

/* fdwtmbpr() : write the master boot partition record			     */
/* Sets globals "fdchange" & "fdmcb".					     */
/* Accesses globals "fdmsiz", "fdfnum" & "fdmbprptr".				     */

VOID fdwtmbpr()
{
    fdchange = TRUE;

    if((fdmcb.retcode = s_write(WRF_BEG, fdfnum, (LONG)fdmbprptr,
      fdmsiz, (LONG)0)) < SUCCESS)
	fderrhand(FDERR014, S_WRITE, fdmcb.retcode);
}

/* fdwtboot() : write out the boot sector of a partition */
/* Accesses globals "fdbootptr", "fdbsiz", "fdfnum", "fdfmtptr", */
/* "fddsktbl" and "fdmcb" */

VOID fdwtboot(ssec)

LONG	ssec;						  /* starting sector */

{

    REG	BYTE	*sptr, *dptr;
    LONG	cnt, offset;


    dptr = (BYTE *)fdbootptr;
    sptr = (BYTE *)fdfmtptr->fi_bimage;
    for(cnt = 0; cnt < fdbsiz; ++cnt)
	*dptr++ = *sptr++;

    fdbootptr->br_ssize = fdfmtptr->fi_ssize;
    fdbootptr->br_spb = (BYTE)fdfmtptr->fi_spb;
    fdbootptr->br_hidesecs = ssec;
    fdbootptr->br_rsvdsecs = (WORD)fdfmtptr->fi_bootsecs;
    fdbootptr->br_nfats = (BYTE)fdfmtptr->fi_nfats;
    fdbootptr->br_dirsize = fdfmtptr->fi_dirsize;
    fdbootptr->br_nsectors = 
      (fdfmtptr->fi_nsecs > 65535) ? 0 : (WORD)fdfmtptr->fi_nsecs;
    fdbootptr->br_drinsecs = fdfmtptr->fi_nsecs;
    fdbootptr->br_media = fdfmtptr->fi_media;
    fdbootptr->br_fsecs = fdfmtptr->fi_fsecs;
    fdbootptr->br_spt = fdfmtptr->fi_spt;
    fdbootptr->br_nheads = fdfmtptr->fi_nhds;
    fdbootptr->br_cbase = 0;
    fdbootptr->br_clen = 0;
    fdbootptr->br_dbase = 0;
    fdbootptr->br_dlen = 0;
    fdbootptr->br_filestart = (ssec + fdbootptr->br_rsvdsecs +
      (fdbootptr->br_nfats * fdbootptr->br_fsecs) +
      ((fdbootptr->br_dirsize * BPDE) / fdbootptr->br_ssize));

    offset = ssec * fdfmtptr->fi_ssize;

    if((fdmcb.retcode = s_write(WRF_BEG, fdfnum, (LONG)fdbootptr,
      fdbsiz, offset)) < SUCCESS)
	fderrhand(FDERR015, S_WRITE, fdmcb.retcode);
}

/* fdcntp() : count number of partitions in use.			     */
/* Sets globals fdpartcnt and fdexists[]. Accesses fdmbprptr.		     */

VOID fdcntp()
{

    WORD	i;

    fdpartcnt = 0;				      /* no partitions found */

    for(i = 0; i < MAXPARTS; ++i)			  /* check all pte's */
    {

	if(!fdmbprptr->mbpr_pte[i].pte_nsecs)		/* empty partition ? */
	{
	    fdpexist[i] = FALSE;		    /* mark as such and then */
	    continue;					     /* skip to next */
	}

	fdpexist[i] = TRUE;				 /* partition exists */
	++fdpartcnt;						 /* count it */
    }
}

/* fdwarnack() : print warning or acknowledge message */

VOID fdwarnack(msg, p5, p6)

BYTE	*msg, *p5, *p6;

{
    fdmcb.pptr[PARM5] = p5;
    fdmcb.pptr[PARM6] = p6;
    utprnmsg(msg, fdmcb.pptr, STDOUT);
}

/* fdmemalloc() : allocate a buffer for MBPR and BOOTREC */
/* Sets globals "fdmcb", "fdbufptr" and "fdbufsiz". */

VOID fdmemalloc(size)

LONG		size;

{

    MPB		mpb;

    mpb.mpb_start = 0;
    mpb.mpb_minact = mpb.mpb_max = size;
    if((fdmcb.retcode = s_malloc(SMO_NEW, &mpb)) < SUCCESS)
	fderrhand(FDERR016, S_MALLOC, fdmcb.retcode);
    fdbufptr = (BYTE *)mpb.mpb_start;
    fdbufsiz = mpb.mpb_minact;
}

/* VOID fdmemfree() : deallocate the MBPR/BOOTREC buffer */
/* Sets the global "fdmcb" and accesses the global "fdbufptr". */

VOID fdmemfree()
{
    if((fdmcb.retcode = s_mfree((LONG)fdbufptr)) < SUCCESS)
	fderrhand(FDERR017, S_MFREE, fdmcb.retcode);
}

/* fdterminate() : Handle termination exit */
VOID fdterminate(emask, ret)
LONG	emask, ret;
{

    s_swiret(SWO_MAIN);

    if((WORD)(ret & 0x0000ffffL) == E_CTLC)
	fderrhand(FDERR018, 0, (UR_SOURCE | UR_UTERM));
    else
	fderrhand(FDERR019, 0, (UR_SOURCE | UR_UTERM));
}


/* fderrhand() : error exit routine					     */
/* Sets globals "fddevopen" and "fdmcb"					     */

VOID fderrhand(uc, df, rc)

WORD	uc;
WORD	df;
LONG	rc;

{

    BYTE	*dev;

    utstmcb(&fdmcb, nullmsg, uc, df, rc);

    switch(df)
    {

	case 0:
	    switch(uc)
	    {

		case FDERR001:
		    utstmcb(&fdmcb, fdm0010, uc, df, rc);
		    break;

		case FDERR002:
		case FDERR003:
		case FDERR004:
		    fdmcb.pptr[PARM5] = fdudev;
		    fdmcb.pptr[PARM6] = fdm0011[HLVL3];
		    fdmcb.pptr[PARM7] = cc0465;

		    if(uc == FDERR003)
			fdmcb.pptr[PARM7] = fdm0012;

		    if(uc == FDERR004)
		    {
			fdmcb.pptr[PARM7] = fdm0013;
			rc = (UR_SOURCE | UR_INTERNAL);
		    }

		    utstmcb(&fdmcb, fdm0011, uc, df, rc);
		    break;

		case FDERR005:
		    fdmcb.pptr[PARM5] = cc0600[HLVL3];
		    utstmcb(&fdmcb, cc0600, uc, df, rc);
		    break;

		case FDERR006:
		case FDERR007:
		case FDERR008:
		default:
		    utstmcb(&fdmcb,nullmsg,uc,df,(UR_SOURCE|UR_INTERNAL));
		    break;

		case FDERR018:
		    utstmcb(&fdmcb, cc0415, uc, df, rc);
		    break;

		case FDERR019:
		    utstmcb(&fdmcb, cc0416, uc, df, rc);
		    break;

	    }
	    break;

	case S_GET:
	case S_LOOKUP:
	    utegtlk(&fdmcb, fdcdev, nullstr, UE_DEVONLY);
	    break;

	case S_MALLOC:
	    utemaloc(&fdmcb);
	    break;

	case S_MFREE:
	    utemfree(&fdmcb);
	    break;

	case S_OPEN:
	    utecrop(&fdmcb, fdcdev, nullstr, UE_DEVONLY);
	    break;

	case S_READ:
	case S_WRITE:
	    dev = (uc == FDERR012) ? stdiname : fdcdev;
	    uterw(&fdmcb, dev, nullstr, UE_DEVONLY);
	    if((uc==FDERR013)||(uc==FDERR014)||(uc==FDERR015))
	    {
		fdmcb.pptr[PARM7] = cc0561;
		fdmcb.pptr[PARM3] = (uc==FDERR015) ? cc0570 : cc0581;
	    }
	    break;

	default:
	    utstmcb(&fdmcb,nullmsg,FDERR008,0,(UR_SOURCE|UR_INTERNAL));
	    break;

    }

    utfarjmp(fdjmpbuf, fdmcb.retcode);
}

/* */
