
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/
/* ----------------------- openmsg.c --------------------------------- */
/* 4/16/85     							       */
/* ------------------------------------------------------------------- */
/*
 *  09/30/86 PKB
 *  references to CDOS, Concurrent or Concurrent DOS changed to FlexOS
 */

#include "portab.h"
#include "concur.h"
#include "ccutls.h"

EXTERN	BYTE	cc0520[],cc0540[],cc0470[],cc0414[];
EXTERN	BYTE	cc0464[],cc0465[],cc0468[];
EXTERN	BYTE	cc0450[],cc0454[],cc0491[];
EXTERN	BYTE	*cc0500[];

BYTE	emsg02[] = "\n\rAn error occurred in the File Allocation Table (FAT).";
BYTE	emsg04[] = "\n\rFlexOS does not support the media.";

VOID openmsg(mp,dc)
MCB	*mp;
LONG	dc;
{
	mp->pptr[PARM5] = cc0520;
	mp->pptr[PARM6] = cc0540;
	mp->pptr[PARM4] = cc0491;
	/* --- mp->pptr[PARM7] = file name --- */
	mp->pptr[PARM8] = cc0500[HLVL3];
	switch ((WORD)dc) {
		  case E_NO_FILE:
			/* PARM2 has to be set in main coding */
			mp->pptr[PARM2] = mp->pptr[PARM7]; /* temporary */
			mp->pptr[PARM9] = cc0470;
			break;
		  case E_PATH:
			mp->pptr[PARM9] = cc0464;
			break;
		  case E_CONFLICT:
		  case E_DEVLOCK: 
		  case E_PENDLK:
			mp->pptr[PARM9] = cc0465;			
			break;
		  case E_ACCESS:
			mp->pptr[PARM9] = cc0465;
			break;
		  case E_NAME:
			mp->pptr[PARM9] = cc0468;
			mp->pptr[PARM4] = cc0454;
			break;
		  case E_DEVICE:
			mp->pptr[PARM9] = cc0468;
			mp->pptr[PARM4] = cc0450;
			break;
		  case E_RAWMEDIA:
			mp->pptr[PARM9] = emsg04;
			break;
		  case E_POOL:
			mp->pptr[PARM9] = cc0414;
			break;
/* 		  case E_FATERROR:
			mp->pptr[PARM9] = emsg02;
			break;
*/
		  default:
			mp->pptr[PARM9] = "";
			break;
		}
}
	
