$title	('Load Relocatable File')
	name	ldrel
	cseg

	extrn	mon1

;
;	Procedure to Load and Relocate an SPR, RSP, or PRL file
;
LdRel:
	public	LdRel
	;    Entry:
	;	BC = Top address, relocate below this address
	;	DE = FCB of file to be relocated

	;    Exit:
	;	 A = 00 if OK, FF if error encountered
	;	HL = New Top address

	mov	h,b
	mov	l,c
	shld	top
	xchg
	shld	FCB
	mvi	c,26
	lxi	h,-0080h
	dad	d
	shld	buffer
	xchg
	call	mon1	;set DMA address to buffer
	lhld	FCB
	xchg
	mvi	c,15
	call	mon1	;open the file
	cpi	0ffh
	mov	h,a
	mov	l,a
	rz		;return with error if open failed
	call	read	;read header record
	;compute base = top - prgsiz - datsiz
	lhld	buffer
	inx	h
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	inx	h
	mov	c,m
	inx	h
	mov	b,m
	xchg
	shld	prgsiz
	dad	b
	xchg
	lhld	top
	xchg
	xra	a
	sub	l
	mov	l,a
	mvi	a,0
	sbb	h
	mov	h,a
	dad	d
	mvi	l,0	;HL = base address
	shld	base
	xchg
	lxi	h,-0080h
	dad	d
	shld	buffer
	call	read	;read second header record
	;compute number of sectors to be read
	lhld	prgsiz
	lxi	d,007fh
	dad	d
	mov	a,l
	ral		;carry = high order bit
	mov	a,h
	ral		;A = # sectors
	lhld	base
rdloop:
	sta	cnt
	shld	DMA
	xchg
	mvi	c,26
	call	mon1	;set DMA address for next sector
	call	read	;read next sector
	lhld	DMA
	lxi	d,0080h
	dad	d
	lda	cnt
	dcr	a
	jnz	rdloop

	lhld	buffer
	xchg
	mvi	c,26
	call	mon1	;set DMA address to buffer
;
	;file loaded, ready for relocation
	lhld	prgsiz
	mov	b,h
	mov	c,l	;BC = program size
	xchg
	lhld	base
	xchg		;DE = base of program
	dad	d	;HL = bit map base
	push	h	;save bit map base in stack
	mov	h,d	;D = relocation bias
pgrel0:
	mov	a,b	;bc=0?
	ora	c
	jnz	pgrel1	;not done
	pop	h
	lhld	base
	ret		;done
;
;	not end of the relocation, may be into next byte of bit map
pgrel1:
	dcx	b	;count length down
	mov	a,e
	ani	111b	;0 causes fetch of next byte
	jnz	pgrel3
;	fetch bit map from stacked address
	xthl
	mov	a,l
	ani	7fh
	jnz	pgrel2
	push	b
	push	d
	push	h
	lhld	FCB
	xchg
	mvi	c,20
	call	mon1
	pop	h
	pop	d
	pop	b
	lhld	buffer
	ora	a
	jnz	errtn	;return with error condition
pgrel2:
	mov	a,m	;next 8 bits of map
	inx	h
	xthl		;base address goes back to stack
	mov	l,a	;l holds the map as we process 8 locations
pgrel3:
	mov	a,l
	ral		;cy set to 1 if relocation necessary
	mov	l,a	;back to l for next time around
	jnc	pgrel4	;skip relocation if cy=0
;
;	current address requires relocation
	ldax	d
	add	h	;apply bias in h
	stax	d
pgrel4:
	inx	d	;to next address
	jmp	pgrel0	;for another byte to relocate
;
;	Local Procedures
;
read:
	lhld	FCB
	xchg
	mvi	c,20	;read sequential
	call	mon1
	ora	a
	rz
errtn:
	pop	h	;discard return address
	lxi	h,0ffffh
	ret		;return with error condition
;
;	Local Data Segment
;
buffer:	ds	2	;buffer address
prgsiz:	ds	2	;program size
FCB:	ds	2	;FCB address
top:	ds	2	;initial top for relocation
base:	ds	2	;base for relocation
cnt:	ds	1	;counter
DMA:	ds	2	;DMA address

	end
