.title	'Print the date and time.'
	.sbttl	'TIME'
version	==	1
revision==	2
        .pabs
	.phex
	.loc	100h
	sspd	savesp
	lxi	SP,stack
;
 Revisio 2:   add Login message to inform user
;		of program name, version number
;		and revision number. DB 03/02/82
;
;---------------
; Get the date from 44h,45h, & 46h
; and print out month, day, and year.
;
	lxi	H,logmsg
	call	prtmsg	;print program name
	lxi	H,crlf
	call	prtmsg	;space 1 line
	lxi	H,datmsg
	call	prtmsg	;print the date message
	lxi	H,month
	mov	A,M	;1-12 in A
	lxi	H,Janmsg
	cpi	1	;January?
	jz	prmnth
	lxi	H,Febmsg
	cpi	2	;February?
	jz	prmnth
	lxi	H,Marmsg
	cpi	3	;March?
	jz	prmnth
	lxi	H,Aprmsg
	cpi	4	;April?
	jz	prmnth
	lxi	H,Maymsg
	cpi	5	;May?
	jz	prmnth
	lxi	H,Junmsg
	cpi	6	;June?
	jz	prmnth
	lxi	H,Julmsg
	cpi	7	;July?
	jz	prmnth
	lxi	H,Augmsg
	cpi	8	;August?
	jz	prmnth
	lxi	H,Sepmsg
	cpi	9	;September?
	jz	prmnth
	lxi	H,Octmsg
.page
	cpi	10	;October?
	jz	prmnth
	lxi	H,Novmsg
	cpi	11	;November?
	jz	prmnth
	lxi	H,Decmsg
	cpi	12	;December?
	jz	prmnth
	lxi	H,XXXmsg ;no month in BIOS
prmnth:	call	prtmsg
;---------------
; Print the day
;
	lxi	H,day
	mov	A,M
	call	cvtbcd
	cpi	10	;is leading 0 necessary?
	jp	aa2
	push	PSW
	mvi	A,'0'	; out a leading 0
	call	CONOUT
	pop	PSW
aa2:	call	prtbyt	; out the day
	mvi	A,'-'
	call	CONOUT	
;---------------
; Print the year
;
	lxi	H,year
	mov	A,M
	cpi	10	; leading 0 necessary?
	jp	aa3
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW	; leading 0 printed
aa3:	call	cvtbcd
	call	prtbyt	; date is all out.
	lxi	H,crlf
	call	prtmsg	;space down
.page
;---------------
; Print the time
;
; Print the time on the DSC/3 or DSC/4.
; This program is used in conjunction with the TIMERopt
; option of the BIOS on the DSC/3 and DSC/4.
; The BIOS maintains the time in locations 40h-43h.
; 
	lxi	H,timmsg
	call	prtmsg	;Print the time message
	lxi	H,hours	; Print the hours
	mov	A,M	;get hours in A
	call	cvtbcd
	cpi	10	;is leading 0 necessary?
	jp	bb1
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
bb1:	call	prtbyt
	mvi	A,':'
	call	CONOUT	
;---------------
; Print the minutes
;
	lxi	H,minutes
	mov	A,M	;get minutes in A
	call	cvtbcd
	cpi	10	;is leading 0 necessary?
	jp	bb2
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
bb2:	call	prtbyt
	mvi	A,':'
	call	CONOUT
;---------------
; Print the seconds
;
	lxi	H,seconds
	mov	A,M
	call	cvtbcd
	cpi	10	;is leading 0 necessary?
	jp	bb3
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
bb3:	call	prtbyt
	jmp	retCPM
.page
.sbttl "SUBROUTINES"
;---------------
;    Subroutines
;
; Print a message on the console
;  Regs in:   HL = address of string (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
prtmsg:
	mov	A,M
	ora	A
	rz
	call	CONOUT
	inx	H
	jmpr	prtmsg
;----------
; Print a byte on the console
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtbyt:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	; don't print leading zeros
	jrz	..1
	call	prtnbl
..1:	pop	PSW
prtnbl:	ani	0Fh
	adi	'0'
	cpi	'9'+1
	jrc	CONOUT
	adi	'A'-('9'+1)
	jmpr	CONOUT
;----------
; Convert binary to BCD
;  Regs in:   A = byte to be converted
;  Regs out:  A = byte, in BCD format
;  Destroyed: B
cvtbcd:
	ora	A
	rz
	mov	B,A
	xra	A
..1:	inr	A
	daa
	djnz	..1
	ret
.page
;----------
; Print a character on the console
;  Regs in:   A = character to be printed
;  Regs out:  none
;  Destroyed: C
CONOUT:
	push	H
	push	D
	push	B
	mov	E,A
	mvi	C,2
	call	5
	pop	B
	pop	D
	pop	H
	ret
;---------------
; Subroutine retCPM:  Return to the operating system
;
retCPM:
	lspd	savesp
	ret
.page
.sbttl "CONSTANTS"
;---------------
; Constants

cr 	==	0Dh	;carriage return
lf	==	0Ah	;line feed
month	==      44h	;locations in BIOS where 
day	==	45h	;date is stored
year	==	46h
seconds	==      41h	;locations in BIOS where
minutes	==	42h	;time is stored
hours	==	43h
savesp: .word	0
;---------------
; Messages
logmsg: .ascii  [cr][lf]'TIME VER '
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.asciz	[cr][lf]'Get the time from the BIOS.'
datmsg:	.asciz	'Date  '
timmsg: .asciz	'Time  '
crlf:	.asciz	[cr][lf] [cr][lf]
janmsg:	.asciz	'Jan-'
febmsg:	.asciz	'Feb-'
marmsg:	.asciz	'Mar-'
aprmsg:	.asciz	'Apr-'
maymsg:	.asciz	'May-'
junmsg:	.asciz	'Jun-'
julmsg:	.asciz	'Jul-'
augmsg:	.asciz	'Aug-'
sepmsg:	.asciz	'Sep-'
octmsg:	.asciz	'Oct-'
novmsg:	.asciz	'Nov-'
decmsg:	.asciz	'Dec-'
XXXmsg:	.asciz	'000-'
;
	.blkb	30
stack:
	.end
