.title	'Spool control program'
	.sbttl	'SPOOL'
version	==	1
revision==	1
	.pabs
	.phex
	.loc	100h
;---------------
; Control spooling - accept following commands:
;
; WAKE  - wake all waiting spool jobs
; ABORT - abort current printing job
; RETRY - restart current printing job
; MODE  - select spooling mode
;
;     1.  AUTOMATIC on serial port 2, print when done.
;     2.  AUTOMATIC on serial port 2, wait when done.
;     3.  AUTOMATIC on parallel port 2, print when done.
;     4.  AUTOMATIC on parallel port 2, wait when done.
;     5.  MANUAL, print when done.
;     6.  MANUAL, wait when done.
;
; revision 1:  Clean up ascii messages.  Add login
;              message and version number.  DB 03/03/82
;---------------
	lxi	D,logmsg
	mvi	C,9
	call	BDOS	;print logon message
	lda	47h	; get user number
	ora	A	; OK if HiNet master
	jrz	findcmd
	lxi	D,errmsg ;if not master, send
	mvi	C,9	 ;him packing
	call	BDOS
	ret
.page
;---------------
; Look at command line
findcmd:
	lda	80h
	ora	A	; print help message
	jz	help	; if no command word entered
	lxi	D,commands
..next:	ldax	D
	ora	A
	jrz	synerr
	res	0,B	; assume match
	lxi	H,82h
..cmp:	
	ldax	D
	ora	A	; check for end of entry
	jrz	..chk
	cmp	M
	jrz	..yes
	set	0,B	; no match
..yes:	inx	H
	inx	D
	jmpr	..cmp
..chk:	
	inx	D
	bit	0,B
	jrz	..match
	inx	D
	inx	D
	jmpr	..next
..match:
	ldax	D
	mov	L,A
	inx	D
	ldax	D
	mov	H,A
	pchl		; jump to appropriate routine
;---------------
; Syntax error
synerr:
	lxi	D,synmsg
	mvi	C,9
	call	BDOS	;syntax error, print the 
;---------------	;help menu
; Help the user
help:
	lxi	D,helpmsg
	mvi	C,9
	call	BDOS
	ret
.page
;---------------
; Abort current print job
abort:
	lxi	H,SPLtable
	lxi	D,lenentry
	mvi	B,numentry
	di
..search:
	mov	A,M
	cpi	SPLprint
	jrz	..abort
	dad	D
	djnz	..search
	ei
	lxi	D,nonemsg
	mvi	C,9
	call	BDOS
	ret
..abort:mvi	M,SPLdone
	ei
	ret
;---------------
; Retry current print job
retry:
	lxi	H,SPLtable
	lxi	D,lenentry
	mvi	B,numentry
	di
..search:
	mov	A,M
	cpi	SPLprint
	jrz	..retry
	dad	D
	djnz	..search
	ei
	lxi	D,nonemsg
	mvi	C,9
	call	BDOS
	ret
..retry:mvi	M,SPLready
	ei
	ret
.page
;---------------
; Wake waiting spool jobs
wake:
	lxi	H,SPLtable
	lxi	D,lenentry
	mvi	B,numentry
	di
..search:
	mov	A,M
	cpi	SPLwait
	jrnz	..next
	mvi	M,SPLready
..next:
	dad	D
	djnz	..search
	ei
	ret
;---------------
; Set spool mode
;
setmode:
	lxi	D,oldmsg
	mvi	C,9
	call	BDOS
	call	prtmode	;Print current mode
	lxi	H,SPLtable
	lxi	D,lenentry ; Make sure that nobody 
	mvi	B,numentry ;is printing right now
..search:
	mov	A,M
	cpi	SPLprint
	jz	..noprint
	dad	D
	djnz	..search
.page
; If new mode on command line, use it
;
	lda	86h	; should be here
	cpi	'1'
	jrc	..chknext
	cpi	'7'
	jrnc	..chknext
	sui	'0'
	jmpr	..ok	; use mode on command line
..chknext:
	lda	87h	; must be here, if at all
	cpi	'1'
	jrc	..prnt
	cpi	'7'
	jrnc	..prnt
	sui	'0'
	jmpr	..ok	; use mode on command line
..prnt:
	lxi	D,askmsg
	mvi	C,9
	call	BDOS
..ask:
	lxi	D,askbuff
	mvi	C,10
	call	BDOS
	lda	askbuff+2
	sui	'0'
..ok:
	cpi	1
	jrz	..1
	cpi	2
	jrz	..2
	cpi	3
	jrz	..3
	cpi	4
	jrz	..4
	cpi	5
	jrz	..5
	cpi	6
	jrz	..6
	lxi	D,reaskmsg
	mvi	C,9
	call	BDOS
	jmpr	..ask
.page
; Select mode bits
..1:
	mvi	B,(0<modeWAIT)+(0<modePRT)+(0<modeSPL)
	jmpr	..change
..2:
	mvi	B,(1<modeWAIT)+(0<modePRT)+(0<modeSPL)
	jmpr	..change
..3:
	mvi	B,(0<modeWAIT)+(1<modePRT)+(0<modeSPL)
	jmpr	..change
..4:
	mvi	B,(1<modeWAIT)+(1<modePRT)+(0<modeSPL)
	jmpr	..change
..5:
	mvi	B,(0<modeWAIT)+(0<modePRT)+(1<modeSPL)
	jmpr	..change
..6:
	mvi	B,(1<modeWAIT)+(0<modePRT)+(1<modeSPL)
;
; Mask into mode byte in low core
..change:
	lxi	H,Mode
	mov	A,M
	ani	11100011b ; throw away old bits
	ora	B
	mov	M,A
	lxi	D,newmsg
	mvi	C,9
	call	BDOS
	jmpr	prtmode	; print new spool mode
.page
; Spool mode cannot be changed while printing a file
..noprint:
	lxi	D,prntmsg
	mvi	C,9
	jmp	BDOS
;----------
; Print current spool mode
prtmode:
	lda	Mode
	bit	modeSPL,A
	jrz	..auto
	lxi	D,manmsg
	mvi	C,9
	call	BDOS
	jmpr	..chkwait
..auto:	lxi	D,automsg
	mvi	C,9
	call	BDOS
	lda	Mode
	bit	modePRT,A
	jrz	..serial
	lxi	D,parmsg
	mvi	C,9
	call	BDOS
	jmpr	..chkwait
..serial:
	lxi	D,sermsg
	mvi	C,9
	call	BDOS
..chkwait:
	lda	Mode
	bit	modeWAIT,A
	jrz	..immed
	lxi	D,delaymsg
	mvi	C,9
	jmp	BDOS
..immed:
	lxi	D,immedmsg
	mvi	C,9
	jmp	BDOS
.page
.sbttl "CONSTANTS"
;---------------
SPLready==	2	; status of ready job
SPLprint==	3	; status of printing job
SPLdone	==	4	; status of completed job
SPLwait ==	5	; status of waiting job
Mode	==	4Eh	; spool mode byte
modeSPL	==	2	; 0 = automatic
			; 1 = manual
modePRT	==	3	; 0 = serial
			; 1 = parallel
modeWAIT==	4	; 0 = immediate printing
			; 1 = delayed printing
lenentry==	16	; length of spool table entry
numentry==	16	; number of spool table entries
SPLtable==	0F500h	; address of spool table
bell	==	07h	; BELL
cr	==	0Dh	; RETURN
lf	==	0Ah	; LINEFEED
BDOS	==	5	; BDOS entry point
;----------
; Console buffer
askbuff:.byte	10,0
	.blkb	10
;----------
; Spool options
commands:
	.asciz	"WAKE"
	.word	wake
	.asciz	"RETRY"
	.word	retry
	.asciz	"ABORT"
	.word	abort
	.asciz	"MODE"
	.word	setmode
	.byte	0	; end of command list
.page
.sbttl "CRT Messages"
;---------------
; CRT Messages
;
logmsg:	.ascii	[cr][lf]"SPOOL version "
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.ascii	[cr][lf]"$"
helpmsg:.ascii	[cr][lf]"Spooling options"
	.ascii	[cr][lf]"----------------"
	.ascii	[cr][lf]
	.ascii	[cr][lf]"ABORT - abort current "
	.ascii		"print job."
	.ascii	[cr][lf]"RETRY - retry current "
	.ascii		"print job."
	.ascii	[cr][lf]"WAKE  - activate all "
	.ascii		"waiting jobs."
	.ascii	[cr][lf]"MODE  - set spooling mode."
	.ascii	[cr][lf]
	.ascii	[cr][lf]" MODE1 - AUTOMATIC on serial "
	.ascii 		"port 2, print when done."
	.ascii	[cr][lf]" MODE2 - AUTOMATIC on serial "
	.ascii		"port 2, wait when done."
	.ascii	[cr][lf]" MODE3 - AUTOMATIC on paral"
	.ascii		"lel port 2, print when done."
	.ascii	[cr][lf]" MODE4 - AUTOMATIC on paral"
	.ascii		"lel port 2, wait when done."
	.ascii	[cr][lf]" MODE5 - MANUAL, print when "
	.ascii		"done."
	.ascii	[cr][lf]" MODE6 - MANUAL, wait when "
	.ascii		"done."
	.ascii	[cr][lf]
	.ascii	[cr][lf]"For example, the command "
	.ascii	        "'SPOOL ABORT' will stop the" 
	.ascii	[cr][lf]"printer and erase the file "
	.ascii	        "which is currently "
	.ascii		"being printed.$"
	.ascii	[cr][lf]
	.byte	'$'
;---------------
; Error messages
synmsg:	.ascii	[bell][cr][lf]"*** SPOOL command "
	.ascii		      "syntax error$"
nonemsg:.ascii		"Sorry, no spool job is "
	.ascii		"currently printing.$"
errmsg:	.ascii		"The SPOOL command can be used"
 	.ascii		" only at the master station.$"
reaskmsg:.ascii	[cr][lf]"Please enter a digit from "
	.ascii		"1 to 6 (or control-C): $"
.page
;---------------
; Spool messages
oldmsg: .ascii	[cr][lf]"The current spool mode is $"
newmsg:	.ascii	[cr][lf]"The new spool mode is $"
automsg:.ascii	"AUTOMATIC$"
parmsg:	.ascii	" on parallel port 2, $"
sermsg: .ascii	" on serial port 2, $"
manmsg: .ascii	"MANUAL, $"
delaymsg:.ascii "wait when done."[cr][lf]
	.byte	'$'
immedmsg:.ascii	"print when done."[cr][lf]
	.byte	'$'
prntmsg:.ascii	[cr][lf]"The spool mode cannot be "
	.ascii		"changed while a file is "
        .ascii		"being printed.$"
askmsg:	.ascii	[cr][lf]"Enter a digit from 1 to 6 to "
	.ascii		"select a new spooling mode:"
	.ascii	[cr][lf]
	.ascii	[cr][lf]"1. AUTOMATIC on serial port "
	.Ascii		"2, print when done."
	.ascii	[cr][lf]"2. AUTOMATIC on serial port "
	.ascii		"2, wait when done."
	.ascii	[cr][lf]"3. AUTOMATIC on parallel "
	.ascii		"port 2, print when done."
	.ascii	[cr][lf]"4. AUTOMATIC on parallel " 
	.ascii		"port 2, wait when done."
	.ascii	[cr][lf]"5. MANUAL, print when done."
	.ascii	[cr][lf]"6. MANUAL, wait when done."
	.ascii	[cr][lf]
	.ascii	[cr][lf]"Your selection, please "
	.ascii		"(control-C to abort): "
	.byte	'$'
.end
