	.title	'ADDS Regent 20/25 Emulation'
	.ident	regent
rgversion ==	2
rgrevision ==	0	;last modified 14-Apr-83

;
;		TABLE OF CONTENTS		PAGE
;
; 1. Equates
;	equates for crtfox rom			2
;	equates for emulation			6
; 2. General Purpose Macros			7
; 3. ROM entry points				8
; 4. Initialisation Code			10
; 5. Mainline emulation				
;	escape sequence processing		12
;	keyboard locking			13
;	vertical/horizontal cursor addressing	14
; 6. Emulation ram data				15
; 7. Ram for rom definitions			17
;

	.insert	romequs
	.page
	.sbttl	'equates for emulation'
forversion ==	2	;rom version this emulation is 
			;to be run with
forrevision ==	0	;revision emulation is for

	.insert genmacro
	.insert romentry.20
	.page
	.sbttl	'Initialisation Code'
	.pabs
	.phex
	.sall
;
;	the downloaded emulation can be located at
;	4000h if the rom is being used, or if the
;	rom is in ram at 7400h
;
	.ife	romeloc,[
	.loc	ramloc][
	.loc	7400h]

	lhld	disptab	;get address of first line
	res	7,h	;on screen
	shld	elloc
	lxi	h,hbf1	;emulation of viewpoint
	lded	elloc
	lxi	b,charsperline
	ldir		;copy buffer error line
	lda	verloc
	cpi	forversion
	jrnz	..badversion
	lda	revloc
	cpi	forrevision
	jrz	..versionok
..badversion:
	lxi	h,hbf2	;improper rom version exiting
	lded	elloc
	lxi	b,charsperline
	ldir
;
;	stall for a bit before reseting
;	controller
;
	mvi	h,5
			;note bc not inited first
			;time thru but who cares
..stallloop:
	dcx	b
	mov	a,b
	ora	c
	jrnz	..stallloop
	lxi	b,0ffffh
	dcr	h
	mov	a,h
	ora	a
	jrnz	..stallloop
	jmp	0	;software reset of
			;crt controller
	.page
..versionok:
;
;	set up table of actions to be taken for
;	non printable ascii chars
;
	lxi	h,rgcharact
	shld	acttabloc

;
;	set up to process escape sequences not present
;	in rom
;
	lxi	h,rgesc
	shld	altesc

;
;	set up for normal processing of 
;	ascii printable characters
;
	lxi	h,normasc
	shld	ascspecial

;
;	insure rom interupt processing, in case
;	taking over from other emulator
;
	lxi	h,normint
	shld	altint

	call	erase		;clear screen to make
		;all bits and screen chars right for
		;new emulation
	jmp	normret		;now ready for processing

	.page
	.sbttl	'escape sequence processing'
;
;	process escape sequences not present in rom
;
rgesc:
	cpi	'5'
	jz	rglockkybd
	cpi	'6'
	jz	rgunlockkybd
	jmp	normesc
	.page	
	.sbttl	'keyboard locking'
rglockkybd:
	lxi	h,flags2
	set	kybdlocked,m
	jmp	normret		;return from there

rgunlockkybd:
	lxi	h,flags2
	res	kybdlocked,m
	jmp	normret		;return from there
	.page
	.sbttl	'vertical/horizontal cursor addressing'
vertcursor:
	lxi	h,..vc2
	shld	actspecial
	ret
..vc2:
	ani	1fh	;get low five bits
	cpi	24
	jrc	..ok
	mvi	a,23	;go to last line
..ok:
	sta	lcury	;set y axis
	call	newcursor
	jmp	normret	;return from there

horzcursor:
	lxi	h,..hc2
	shld	actspecial
	ret
..hc2:
	push	psw
	ani	0fh	;get low four bits
	cpi	10
	jrc	..ok
	mvi	a,9
..ok:	
	mov	b,a	;save low four bits
	pop	psw
	ani	70h	;get bits which tell
			;group of 10
	srar	a	;*8
	mov	c,a
	srar	a
	srar	a	;*2
	add	c	;*10
	add	b	;now have row value
	sta	lcurx
	call	newcursor
	jmp	normret

	.page
	.sbttl	'Emulation ram data'
;
;	viewpoint message buffers
;
;		/1234567890123456789012345678901234567890/
hbf1:	
	.ascii	\                        Regent 20/25 E\
	.ascii	/mulation Ver /
	.byte	rgversion+'0','.',rgrevision+'0'
	.ascii	/                          $/

hbf2:	
	.ascii	/                  This emulation must ru/
	.ascii	/n with crt version /
	.byte	forversion + '0','.',forrevision + '0'
	.ascii	/                   /

;
;	key action table for non-printable characters
;	for Regent
;
rgcharact:
	.word	donull		;0
	.word	gothome		;1
	.word	gotasc		;2
	.word	gotasc		;3
	.word	gotasc		;4
	.word	gotasc		;5
	.word	gotforward	;6
	.word	gotbell		;7
	.word	gotback		;8
	.word	gottab		;9
	.word	dolf		;10 (ah)
	.word	vertcursor	;11 (bh)
	.word	erase		;12 (ch)
	.word	docr		;13 (dh)
	.word	gotasc		;14 (eh)
	.word	gotasc		;15 (fh)
	.word	horzcursor ;16 (10h) 10h-19h for dasoft
	.word	gotasc	;17 (11h) special characters
	.word	gotasc		;18 (12h)
	.word	gotasc		;19 (13h)
	.word	gotasc		;20 (14h)
	.word	gotback	;21 (15h) nak is backspace
	.word	gotasc		;22 (16h)
	.word	gotasc		;23 (17h)
	.word	gotasc		;24 (18h)
	.word	gotasc		;25 (19h)
	.word	gotup		;26 (1ah)
	.word	esckey		;27 (1bh)
	.word	gotasc		;28 (1ch)
	.word	gotasc		;29 (1dh)
	.word	gotasc		;30 (1eh)
	.word	gotasc		;31 (1fh)


elloc:	.blkw	1	;location of error line

	.ife	romeloc,[
	.ifg	. - (ramloc + lencode),[
	.prntx /Code too long/][
	.prntx /Code length ok/]
	][
	.ifg	. - (8000h),[
	.prntx /Code too long/][
	.prntx /Code length ok/]
	]
	.insert	ramfrrom
	.end
	
	