	.page
	.sbttl	'ram data for rom'
;	last updated 3-Jan-83
	.loc ramloc
;
code:	.blkb	lencode	;area reserved for down
			;loaded programs
;
;	the following are circular queue structures
;	used for buffering keyboart input and
;	host output and input
;
	.loc	(.+typeahead+2)&(#(typeahead+2))
houtqin:.blkb	1	;place to enter next char
houtqout:.blkb	1	;place to retreive next char
houtqbuf:.blkb	typeahead+1	;host output buffer

hinqin:.blkb	1	;place to enter next char
hinqout:.blkb	1	;place to retreive next char
hinqbuf:.blkb	typeahead+1	;host input buffer

keyqin:.blkb	1	;place to enter next char
keyqout:.blkb	1	;place to retreive next char
keyqbuf:.blkb	typeahead+1	;keyboard inputbuffer

;
;	the program keys have a table of one entry
;	per key.  this entry points to a string, the
;	first byte of which is the length , followed
;	by the characters
;
progtab:.blkb	lenprogtab	;allow 96 entries,
			;actually 90 are used

;
;	the programmable key buffer contains strings 
;	for each non default key string.  the strings 
;	are kept in key	order and all remaining space 
;	is kept at the end of the table.
;
progbuf:.blkb	lenpbuf
freeinprogbuf:.blkw	1	;set to lenpbuf in 
				;init code

	
;
; The display table is used by the interupt routine
; to find the current screen data to display.
; It has an entry for each half of each line on the
; screen.  Each entry of the table has an address of
; a line image with the high order bit set so pops
; get fed to character buffer.  Each also has a byte
; with -(length/2) to generate the number of pops to
; output the data.  The first 25 entries are the first
; half of each line, the next 25 entries are the second
; half of each line.
;
disptab:.blkb	linesonscreen*3
tabadr:	.blkw	1	;address in display table of 
			;next line to be displayed

;
;	the following are parameters describing
;	the active screen
;
scrno:	.blkb	1	;the screen number
chars:	.blkb	1	;chars per line
lines:	.blkb	1	;number of lines

orgxy:
orgx:	.blkb	1	;the org of the screen (column)
orgy:	.blkb	1	;the origin of the screen (row)

lcurxy:
lcurx:	.blkb	1	;the column on the local screen
lcury:	.blkb	1	;the row on the local screen

topscr:	.blkw	1	;use unknown
memstrt:.blkw	1	;the first address in screens 
			;data area
nextchar:.blkw	1	;the position of the nextchar's 
			;data
maxchar:.blkb	1	;remaining characters on line
memend:	.blkw	1	;the last address in screen's 
			;data area
scrparlen == .-scrno

;
;	the following are areas to save inactive
;	screen's parameters
;
savscrlen == 96	;length of area to save screen 
		;parameters and display table entries
scr0:	.blkb	savscrlen	;save area scr 0(host 
				;screen)
scr1:	.blkb	savscrlen	; scr 1 (crt screen)
scr2:	.blkb	savscrlen	;hinet(message) screen

nextmem:.blkw	1	;next availible unallocated
			;memory
acttabloc:.blkw	1	;location of table 
			;of key actions
actspecial:.blkw 1	;location of special actions to
			;be taken in dochar routine
			;usually for escape sequences
altesc:	.blkw	1	;location of special escape
			;sequences (down loaded)
altint:	.blkw	1	;location of alternate interupt 
			;processing
ascspecial:.blkw 1	;location of special actions
			;to be taken in gotasc
keycollect:.blkb 1	;place to collect input 
			;from keyboard bit by bit
keyflag:.blkb	1	;flag for reading from keyboard
;keyflag bit definitions
keyread	==	0	;set if a key has been read
keydata:.blkb	1	;char from keyboard
charsource:.blkb 1	;true if char from keyboard
			;false if char from host
nxtline:.blkb	1

nxtmessout:.blkb 1	;becomes messout when 
			;messbit set
messout:.blkb	1	;low three bits are sent to 
			;keyboard,bit 2,1,0 is order
savecontrol:.blkb 1	;place to save control 
			;character temporarily in
			;storecontrol routine

;
;	flagbytes are used for general purpose
;	bit flags
;
flags1:.blkb	1
;bit definitions for flags1
intactive ==	7	;set if interupt service routine
			;is active
pkerr	==	6	;set if error message on screen
			;in programming keys
readabit ==	5	;set if a bit should be read 
			;from the keyboard
			;at end of interupt processing
messbit	==	4	;set if nxtmessout contains 
			;bits to go out
traprequested == 3	;set if chars to be trapped and 
			;displayed before processing
zerodup	==	2	;set if in zero duplex mode, ie
			;accept no characters from host,
			;process chars from keyboard but
			;do not send to host
visible	==	1	;set if control chars to be 
			;visible
			;clear if in transparent mode
passprog ==	0	;set if programable keys are 
			;to be passed to host with out 
			;expansion
flags2:	.blkb	1
;bit definitions for bits in flags2
masstransfer == 7	;set if doing mass transfer from
			;host to allow direct transfer
			;after queue is empty
flushrequested == 6	;set in interupt code if
			;flush requested to cause
			;action on next character
			;rather than when char would
			;be processed
inblockmode ==	5	;set if in block mode where
			;chars from keyboard are
			;processed but not sent to
			;host, however characters
			;from host are processed
kybdlocked ==	4	;set if characters from 
			;keyboard are to be ignored
alterattribute == 3	;set if altering(removing or 
			;inserting) attribute chars
			;from anywhere on screen
			; to allow interupt routine
			;to output blank line, rather
			;than line with improper count
			;of attribute chars
linealterattribute == 2	;same use as alterattribute,
		;but only a single line on the screen
		;is being changed.  line number of
		;line being changed must be set
		;in linechanging variable

bitcount:.blkb	1	;count of bits to receive from 
			;keyboard
linedisplaying:.blkb	1	;line number of line
		;to be displayed by interupt routine
count1:	.blkb	1	;crt to keyboard bit count 
			;(first time)
count2:	.blkb	1	;crt to keyboard bit count 
			;(2nd time)
count3:	.blkb	1	;space
count4:	.blkb	1	;keyboard to crt bits 
			;(first time)
count5:	.blkb	1	;keyboard to crt bits 
			;(2nd time)

;
;	data to be sent to 8048 on int8048 port
;	also some bits controll other screen functions
;
data8048:.blkb	1
;bit definitions for dat8048
longchar==	1	;long characters desired if set
intkeyboard ==	3	;interupt keyboard
normalvideo ==	4	
disakeyout ==	5	;disable output to keyboard
datatokey ==	6	;output bit to keyboard
beepon	==	7	;send voltage to speaker if on

belllength:.blkw 1	;length of belltone in units
			;of frequency
bellfreq: .blkw	1	;bell frequency for delay
cgbellen: .blkw 1	;bell length for control g
cgbelfreq:.blkw 1	;bell length for control g
lencount: .blkb 1	;counter used in setting bell 
			;length and frequency
valuebrightness:.blkb 1	;value of screen brightness

;
;	the following variables are used in delete
;	and insert key routines
;
nsptr:	.blkw	1	;pointer to string to insert
dsptr:	.blkw	1	;pointer to string to delete
ptentry:.blkw	1	;pointer to entry in progtab
nslen:	.blkw	1	;length of new string 
nsloc:	.blkw	1	;place for new string in progbuf

;
;	the following variables are used in creating
;	a new programable function key string
;
newkey:	.blkb	1	;key to program
newstring:.blkb	1	;length of new string
	.blkb	255	;text of new string
charsremaining:.blkb	1 ;chars remaining to be filled 
			;in newstring
charplace:.blkw	1	;place in new string where next 
			;char is to go

examloc:.blkw	1	;memory location to be 
			;examined

savestackduringinterupt:
	.blkw	1	;space to save stack
			;in interupt
linechanging: .blkb	1	; line number of line
		;having its attribute chars changed
	.blkw	16	;interupt routine stack
intstack:
	.blkw	100	;normal stack
normstack:
;
;	insure transposition tables come on proper 
;	boundary.  each table entry is the value
;	to be subsituted for the entry number
;
	.loc	(.+lentranspose-1)&(#(lentranspose-1))
kybdtranspose:
	.blkb	lentranspose
disptranspose:
	.blkb	lentranspose

begdr:			;begining of display image 
			;region
errline:.blkb	lenstatusline	;status line at top 
			;of screen
nullline:.blkb	charsperline	;blank line to be 
			;displayed when updateing 
			;attribute character count
lendr	 ==	ramloc+ramavail - .	;the rest is 
				;availible for display
begfree:.blkb	lendr		;beggining of 
			;unallocated display region
topdr:			;end of display region
