.title	'Send lock string to master'
	.ident	netlok
;
version	==	1
revision==	2
patch	==	' '
;
	.pabs
	.phex
	.loc	100h
;
;	Table of contents
;
;  Update history			2
  Equate an BIOS jump		3
;  Test the lock string			4
;  Send the lock string			5
;  Subroutines				6
;  Define Storage			8
;  CRT messages				9
;
.page 
.sbttl	'Update history'
;
; Last changed Oct 29, 1982  DB

; Revision 1 10/27/82   Add code that prompts the user
;			for the lock string.  DB
;
; Revision 2 10/29/82	Convert all lock strings to
;			upper case so a lock string
;			can not be used twice.
; 			If user is not on the HiNet,
;			give a message and a boot. DB
.page
.sbttl	'Equates'
wboot	==	0
BDOS	==	5
cr	==	0Dh
lf	==	0Ah
ctrlc	==	3
usernum	==	47h
bufread ==	0Ah	;CPM 10, Read Console Buffer
cmdlin	==	80h
lockloc	==	4Ah	;loc of lock string in memory
locstat	==	49h	;BIOS returns lock conditions
			;as set below
locaccept==	0	;lock or unlock is accepted
locdeny	==	1	;if lock request, string exists
			;if unlock, string does not
locreject==	2	;string too long or table full
;
; Set up BIOS jumps
;
	sspd	saveSP	;save stack for return
	lxi	sp,stack
	lxi	H,login
	call	prtmsg
	lda	usernum
	cpi	0FFh
	jrnz	..net
	lxi	H,nonetmsg
	call	prtmsg	;If user not on net, give
	jmp	wboot	;a boot
;
..net:	lhld	wboot + 1
	mov	D,H
	mov	E,L	;DE = HL
	lxi	H,5Dh
	dad	D
	shld	netlock + 1 ;BIOS jump for netlock
	lxi	H,63h
	dad	D
	shld	netunlock + 1 ;BIOS jump for netunlock
.page
.sbttl	'Test the lock string'
;
	lda	cmdlin
	inr	A	;to LDIR all of comline
	mov	C,A
	mvi	B,0
	lxi	H,cmdlin
	lxi	D,comlinstor
	LDIR		     ;store comline in memry
	lxi	H,comlinstor ;addr of com line
	mov	A,M	;If accum = 0, no comline
	cpi	0	;so prompt user for it
	jrz	getlok	
;
..agn:	lxi	H,comlinstor+1
	mov	A,m	
	cpi	' '	;test for leading blanks
	dcx	H	;set HL to correct addr if
	jrnz	sendlok	;no more leading blanks
	lda	comlinstor
	mov	C,A
	mvi	B,0
	lxi	H,comlinstor+2
	lxi	D,comlinstor+1
	LDIR
	dcr	A
	sta	comlinstor
	jmpr	..agn
getlok:			;prompt user for lock string
	lxi	H,entmsg
	call	prtmsg
	call	putbuf	;put lock string in buffer
	sta	charcnt
	cpi	0
	jrnz  	sendlok
	lxi	H,nolokmsg
	call	prtmsg
	jmpr	getlok
.page
.sbttl	'Send the lock string'
sendlok:		;send lock string to master
	shld	lockloc
	lda	charcnt
	sta	UCcntr
..UC:	lda	UCcntr	;if upper case counter = 0,
	cpi	0	;send the lock string
	jrz	..cont
	inx	H	;else, see if next character is
	mov	A,m	;upper case
	cpi	'a'
	push	PSW
	lda	UCcntr
	dcr	A
	sta	UCcntr
	pop	PSW	;save the accum
	jrc	..UC
	ani	0DFh	;if it is not upper case, make
	mov	m,A	;it upper case and store it
	jmpr	..UC	;in memory and get next one
;
..cont:	call	netlock
	lda	locstat
	cpi	locaccept
	jrz	lockok
	cpi	locdeny
	jrz	exists
nostrg: lxi	H,badstrg
	call	prtmsg
	jmpr	retCCP
;
exists:			;lock string exists in master
	lxi	H,notokmsg
	call	prtmsg
	jmpr	retCCP
;
lockok:			;lock string stored on master
	lxi	H,okmsg
	call	prtmsg
;			;fall thru and return
retCCP:
	lxi	H,crlf
	call	prtmsg	;space down one line
	lspd	saveSP
	ret
.page
.sbttl	'Subroutines'
;---------------
; get character from console (using BDOS) then
; convert lower to upper case.
; Abort on CTRL-C, restart on ESC
CONIN:	mvi	C,1	; command 1
	call	BDOS	; read a char
	cpi	ctrlC
	jz	0	; abort if ctrlC
	cpi	1Bh
	jrz	..DDT	; jump into DDT if ESC
	call	CVTluc	; convert to upper case
	ret		; and return
..DDT:	rst	6	
;---------------
CVTluc:	cpi	'a'	; convert upper to lower case
	jm	..up
	cpi	'z'+1
	jp	..up	
	sui	'a'-'A'
..up:	ret
;---------------
; Print a message on the console
;  Regs in:   HL = address of string (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
prtmsg:
	mov	A,M
	ora	A
	rz
	call	CONOUT
	inx	H
	jmpr	prtmsg
;----------------
; Print a character on the console
;  Regs in:   A = character to be printed
CONOUT:
	push	H
	push	D
	push	B
	mvi	C,2
	mov	E,A
	call	5	; print using BDOS
	pop	B
	pop	D
	pop	H
	ret
.page
;---------------
; Subroutine putbuf:  Enter console input in a buffer
; Reg in:  None
; Reg out: A = number of characters in buffer
;	   HL= Addr of first buffer character -1
;
putbuf:
	call	clrBUF	 ; clear the console buffer
	mvi	C,bufread ; CP/M console buffer read
	lxi	D,conbuf ; address of console buffer
	call	BDOS	 ; put console input in buffer
	call	eatblnk	 ; eat leading blanks
	lxi	H,conbuf+1
	mov	A,M	 ; put num of buffer chrs in A
	ret
;---------------
; Subroutine clrBUF:  Clear console buffer at address
; Regs  in:  none
; Regs out:  None
; Destroyed: All
;
clrBUF:
	lxi	B,12
	lxi	H,clrBYTS
	lxi	D,conbuf+2
	ldir
	ret
;---------------
; Subroutine eatblnk:  Eat leading blanks
; Reg in:  none
; Reg out: none
; Destroyed:  All
;
eatblnk:
	lxi	H,conbuf+2
	mov	A,m	
	cpi	' '	;test for leading blanks
	rnz		;return when not blanks
	lda	conbuf+1
	mov	C,A
	mvi	B,0
	lxi	H,conbuf+3
	lxi	D,conbuf+2
	LDIR
	dcr	A
	sta	conbuf+1
	jmpr	eatblnk

.page
.sbttl	'Define storage'
;
UCcntr:	.byte	0	;counter for UC conversion
saveSP:	.word	0	;save CCP stack for return
netlock  :jmp	0
netunlock:jmp	0
	.blkb	14
comlinstor:		;comline copied here
charcnt:.byte	00h	;number of char in com line
conbuf:	.byte	15,0	;12-chr CP/M maintained buffer
	.byte	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
clrBYTS:.ascii	'                          '
.page
.sbttl	'CRT messages'
;
login:	.ascii	[cr][lf]'Send a lock string to the '
	.ascii		'lock table, version '
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.byte	patch
	.ascii	[cr][lf][lf]'Please use the following '
	.ascii		'convention when you enter '
	.ascii		'a lock string:'
	.ascii	[cr][lf][lf]'To lock a file, enter '
	.ascii		'the file name and file type.'
	.ascii	[cr][lf]'Separate the file name from '
	.ascii		'the file type with a period.'
	.ascii	[cr][lf][lf]'To lock a parititon, '
	.ascii		'enter the partition name.'
crlf:	.asciz	[cr][lf]
nonetmsg:.ascii [cr][lf]'You must be logged into Hi'
	.asciz		'net to send a lock string.'
entmsg:	.asciz	[cr][lf]'Enter your lock string:  '
nolokmsg:.ascii [cr][lf]'You did not enter a '
	.asciz		'lock string.'
badstrg:.ascii	[cr][lf]'Your lock string is incorrect'
	.asciz		' or the lock table is full.'
okmsg:	.ascii	[cr][lf]'Your lock string is stored '
	.asciz		'in the lock table.'
notokmsg:.ascii	[cr][lf][lf]'*** This file or '
	.ascii		'partition is locked.'
	.ascii	[cr][lf]    '-----------------'
	.asciz		'--------------------'
;
	.blkb	20
stack:
;
.end
