		.title	'hard disk controller rom code'
	.ident	hardrom
	.phex
	.pabs
romversion  ==	2
romrevision ==	2	;last modified 4-June-82

;
;		TABLE OF CONTENTS		PAGE
; 1. version descriptions			2
; 2. equates					3
; 3. initialisation				10
; 4. get command from host,load user,put command11
; 5. absolute read and write routines		13
; 6. read or write data to host			15
; 7. seek and head select routines		17
; 8. read or write sector routines		21
; 9. actual hardware read and write		23
;10. tables					26

	.page
	.sbttl	'version descriptions'
;
;	version 2.2 checks for timeout in finding
;	track 0 and seek completion
;

;
;	version 2.1 defaults to 23 meg memorex
;	type drive.  version,revision stored at
;	64hex just before the interupt reset at
;	66h.
;

;	version 2.0 started may-82
;	controls multiple hard disks

;	9-28-80
;
;	HD ROM FOR DSC3, MEMOREX 101
;
;
;ROM FOR THE HDC IMPLEMENTING ERROR CORRECTION, ERROR CODES AND 
;				SENDING BACK THE COMMANDS
;				AND IMPLEMENTING BAD SECTOR TABLE
;
;
	
	.insert	hardequ
	.page
	.sbttl	'initialisation'

	.LOC	00H
;
romstart:
	mvi	a,0		;zero is default drive
reboot:				;come here with drive 
			;in a reg to boot alternate disk
	sta	unitno
	LXI	SP,STACK
	IN	INPORT		;CLEAR HOST STATUS
	XRA	A
	lxi	h,BADTABLE	; NO MAP YET
	mov	m,a		;for any unit
	shld	badloc		;store pointer to badsec
				;table
	lxi	h,bad1table
	mov	m,a
	shld	badloc+2
	lxi	h,bad2table
	mov	m,a
	shld	badloc+4
	lxi	h,bad3table
	mov	m,a
	shld	badloc+6
	STA	PHYTRACK	;WILL READ ON TRK 0
	DCR	A
	STA	TRKD0		;FORCE HOME
;
	lxi	h,disktracks
	mvi	m,memtracks	;
	inx	h	;version
	inx	h	;revision
	inx	h	;disktype
	mvi	m,memsectors	;sectors/track (conservative)
	inx	h	;disksize
	MVI	M,mem23headmask	; SIZE - 23MB
	INX	H
	MVI	A,0C9H		;RET INSTR
	LXI	B,12		;ROOM FOR 4 ENTRIES
	CALL	FILL		;JMP TABLE NOW FULL OF RETS
;
;	leave reading of badsector table to firmware
;
;	LXI	H,601H		;=HD 1, SEC 6
;	SHLD	PHYHEAD
;	CALL	READSEC
;	LXI	D,BADTABLE
;	LXI	H,RDDATA
;	LXI	B,1024
;	LDIR

	LXI	H,100H		;= HD 0, SEC 1
	SHLD	PHYHEAD
;
INIT:
	CALL	READSEC
	LXI	H,RDDATA
	LXI	D,USRPROG
	LXI	B,1024
	LDIR
	.page
	.sbttl	'get command from host,load user, put command'
;
;	GET COMMAND FROM HOST PROCESSOR
;
GETCOMMAND:

	LXI	B,0D000H	;ASSUME IDLE IF DCR TO 0
GC1:	IN	PSTATUS
	RRC
	RRC
	JRC	GC2
	DCX	B
	JMPR	AROUND
	.ifg	.-64h,[.prntx	/64h overwrite/][
	.prntx	/64h ok/]
	.LOC	64H
	.byte	romversion,romrevision
	JMPR	romstart	;this must be at 66h
AROUND:
	MOV	A,B
	ORA	C
	JRNZ	GC1
	CALL	goidle		;WRITE ANY DIRTY SEC
	JMPR	GETCOMMAND
GC2:	IN	INPORT
	CPI	REQTOSEND
	JRZ	GETIT
ANSWAIT:
	IN	PSTATUS
	RRC
	JRC	ANSWAIT
	MVI	A,NOCLEAR
	OUT	OUTPORT
	JMPR	GETCOMMAND
GETIT:
	IN	PSTATUS
	RRC
	JRC	GETIT
	MVI	A,CLEAR
	OUT	OUTPORT
	LXI	H,COMMBUFF
	LXI	D,COMMSIZE
	CALL	PREAD
	LDA	COMMBUFF
	ORA	A
	JRZ	INIT
	cpi	bootunit
	jrz	doboot		;go boot alternate unit
	DCR	A
	JZ	ABSREAD
	DCR	A
	JRZ	ABSWRITE
	DCR	A
	JRZ	LUSER
	DCR	A
	JRZ	ABSWRITE
	DCR	A
	JNZ	USRPROG
;
	LHLD	TAG0		;GET HDC ADDR
	XCHG
	LHLD	PHYHEAD		;BYTE COUNT
	JMP	RDMEM
;
LUSER:	LXI	H,USRPROG	;GET PROG FOR HOST
	LXI	D,300H		;AND LOAD AT 4100H
	CALL	PREAD
	JMPR	GETCOMMAND
;
;
;
;	SEND THE COMMAND BACK TO THE HOST
;
PUTCOMD:
	LXI	H,COMMBUFF
	LXI	D,COMMSIZE
	CALL	PWRITE
	RET

;
;	do boot by loading a with unit passed
;	in command
;
doboot:
	lda	phytrack	;contains unit parameter
	jmp	reboot
	.page
	.sbttl	'absolute read and write routines'
;
;
;
;		ABSOLUTE READ AND WRITE ROUTINES
;
STRIPR:			;GET MSB OF RETRYS
	LDA	CON0
	MOV	B,A
	ANI	80H
	STA	RDAFTW		;SAVE AS RAW OR ECC
	MOV	A,B
	ANI	07FH
	STA	CON0
	RET
;
;
ABSWRITE:
	LXI	H,BUFDATA
	LXI	D,1024
	CALL	PREAD
	CALL	STRIPR
ABSW2:	CALL	WRITESEC
	MOV	B,A		;SAVE ERR RETURN
	JRZ	ABSW3		;IF NO ERR
ABSW2A:	LXI	H,CON0
	DCR	M		;DCR RETRYS
	JRNZ	ABSW2
	MOV	A,B		;GET ERR TYPE & RET
	JMPR	ABSW6
ABSW3:	LDA	RDAFTW		;CHECK FOR R AFTER W
	ORA	A
	JRZ	ABSW6		;RET IF NOT REQUIRED
ABSW4:	CALL	READSEC
	MOV	B,A
	JRNZ	ABSW2A
	LXI	H,BUFDATA	;COMPARE WRITE BUFFER
	LXI	D,RDDATA	;WITH READ BUFFER
	LXI	B,4		;FOR 1024 BYTES
ABSW5:	LDAX	D
	SUB	M		;LEAVE A=0 IF OK
	JRNZ	RWERR
	INX	H
	INX	D
	DJNZ	ABSW5		;LOOP
	DCR	C		;ABOVE LOOP 4 TIMES
	JRNZ	ABSW5
ABSW6:	STA	CON1		;RETURN STATUS
	CALL	PUTCOMD		;SEND BACK COMMAND BLOCK
	JMP	GETCOMMAND
RWERR:	LXI	H,CON0		;TEST FOR RETRY
	DCR	M
	JRNZ	ABSW2		;RETRY ENTIRE OPERATION
	MVI	A,hdereadafterwrite ;COMPARE ERROR CODE
	JMPR	ABSW6
;
ABSREAD:
	CALL	RDRTRY
	STA	CON1	;FOR NOW, JUST RETURN THE ERROR
			;STATUS INDICATION
	CALL	PUTCOMD
	LXI	H,RDDATA
	LXI	D,1024
RDMEM:	CALL	PWRITE
	JMP	GETCOMMAND
;
;
RDRTRY:				;READ AND RETRY TILL CON0=0
	CALL	STRIPR		;GET CORRECT WANTED BIT
	CALL	READSEC
	RZ
	MOV	B,A		;SAVE ERR TYPE
	LXI	H,CON0
	DCR	M
	JRNZ	RDRTRY
	MOV	A,B		;GET ERR TYPE
	ORA	A		;SET FLAG
	RET
	.page
	.sbttl	'read or write data to the host'
;
;
;
;	ROUTINES TO READ OR WRITE DATA TO THE HOST
;
;
; RTN TO READ IN A BLOCK OF DATA FROM THE COMM PORT
; ENTERS WITH REGS AS FOLLOWS
; DE  - BYTE COUNT
; HL - INPUT BUFFER ADRS
;
PREAD:
	MVI	C,INPORT
	MOV	B,E
	MOV	A,D
	ORA	B
	RZ
	XRA	A
	CMP	B
	JRZ	PRDLOOP
	INR	D
PRDLOOP:
	IN	PSTATUS
	RRC
	RRC
	JRNC	PRDLOOP
	INI
	JRNZ	PRDLOOP
	DCR	D
	JRNZ	PRDLOOP
	RET
;
;
; RTN TO WRITE A BLOCK OF DATA OUT TO THE COMM PORT
; ENTERS WITH REGS AS FOLLOWS
; DE  - BYTE COUNT
; HL - ADRS OF DATA BUFFER
;
PWRITE:
	MVI	C,OUTPORT
	MOV	B,E
	MOV	A,D
	ORA	B
	RZ
	XRA	A
	CMP	B
	JRZ	PWRTLOOP
	INR	D
PWRTLOOP:
	IN	PSTATUS
	RRC
	JRC	PWRTLOOP
	OUTI
	JRNZ	PWRTLOOP
	DCR	D
	JRNZ	PWRTLOOP
	RET
	.page
	.sbttl	'seek and head select routines'
;
;
;	SEEK AND HEAD SELECT ROUTINES
;
;SEEK TRACK 0
HSEEK:
	XRA	A		
	STA	TRKD0
	mvi	b,0ffh		;max tracsk to move
H2:
	IN	HSTATUS
	ANI	4		;TEST TRACK ZERO BIT
	JRNZ	SETUP		;AT ZERO IF SET
	MVI	C,1
	CALL	STEPOUT
	rnz	
	djnz	h2
	mvi	a,hdehometimeout
	ora	a
	ret

;
;
;
BADMAP:			;SEE IF SECTOR IS IN BAD SECTOR TABLE
			;IF SO, CHANGE PHYSICAL TRACK, HEAD,
			;SECTOR TO NEW VALUE
			;TABLE IS IN THE FORM SECTOR,HEAD,TRACK

	LHLD	PHYTRACK
	XCHG
	LDA	PHYSEC
	MOV	C,A
	push	psw
	push	d	;save registers while getting
			;indirect badtable in hl
	lda	unitno
	slar	a	;mult by 2
	mov	e,a
	mvi	d,0
	LXI	H,badloc
	dad	d	;now have pointer to table
			;entry
	mov	e,m
	inx	h
	mov	d,m
	xchg		;hl points to bad sector table
			;for selected unit
	pop	d
	pop	psw	
	MVI	B,0		;MAX 256 ENTRIES
BAD4:
	MOV	A,M
;
	ORA	A	;A ZERO IN THE SECTOR FIELD MEANS TABLE 
			;IS NOW EMPTY
	JRZ	SETUP
;
BAD6:
	CMP	C
	JRNZ	INCR3
	INX	H
	MOV	A,M
	CMP	D		;CMP HEAD
	JRNZ	INCR2
	INX	H
	MOV	A,M
	CMP	E		;CMP TRACK
	JRNZ	INCR1
	JMPR	GOTONE
INCR3:	INX	H
INCR2:	INX	H
INCR1:	INX	H
	INR	B
	JRNZ	BAD4
	JMPR	SETUP
;
GOTONE:
;IF WE GOT HERE, THE SECTOR,HEAD,TRACK WAS IN THE TABLE
;	NOTE:  FOLLOWING CODE applies to all drives
;	USE 8 SEC/TRACK FOR SPARES ... 2 TRACK*4 HEAD
;	*8 SEC = 64 ENTRIES
;	or
;	USE 8 SEC/TRACK FOR SPARES ... 2 TRACK*8 HEAD
;	*8 SEC = 128 ENTRIES
	MOV	A,B
	ANI	07H
	INR	A		;0-7 MAPS 1-8
	STA	PHYSEC
	MOV	A,B
	RRC
	RRC
	RRC
	MOV	B,A		;SAVE ROTATED
	ANI	1		;NEXT BIT IS TRK
	lxi	h,disktracks
	add	m
	sui	2		;last or next to last
	STA	PHYTRACK	;track
	MOV	A,B
	RRC			;GET HEAD
	lxi	h,disksize	;head mask
	ANa	m
	STA	PHYHEAD
SETUP:
;
; SEEK TRACK
;
	LDA	TRKD0		;GET CURRENT TRACK
	CPI	0FFH		;SEE IF NEEDS RESTORE
	JRZ	HSEEK
	MOV	B,A
	LDA	PHYTRACK
	MOV	C,A
	CPI	0FFH		;IF FIXED HEADS
	JRZ	SELHEAD
	lxi	h,disktracks
	cmp	m		;LARGEST LEGAL TRACK
	JRNC	badtrack
	STA	TRKD0		;SAVE NEW TRK
	SUB	B		;COMPUTE DIFFERENCE
	JZ	SELHEAD
	JRNC	SPOS
	MOV	A,B		;CUR TRK
	SUB	C		;DIFFERENCE AGAIN
	MOV	C,A		;PARAMETER=# TRKS TO STEP OUT
	CALL	STEPOUT
	rnz			;error detected
	JMPR	SELHEAD
;
SPOS:
	MOV	C,A
	MVI	A,10H		;SET DIRECTION IN
	CALL	stepin
	rnz
;
SELHEAD:
;
;VALID HEAD CHECK 
;
	lda	disksize	;effectively headmask
	cma
	lxi	h,phyhead
	ana	m
	jrz	..headok	;no bits outside of mask
	mvi	a,hdebdhead
	ret
..headok:
	mov	a,m
	OUT	HEADSPORT
	XRA	A		;ZERO FLAG
	RET

;
;	select the physical drive
;
selunit:
	lda	unitno		;get drive number in 
				;head select bits
	cma			;compliment bits
	ani	3h		;keep only 3 low bits
	ori	fltclrbit
	out	fccomd
	xri	fltclrbit
	out	fccomd		;toggle fault clear
	ret

	
;
badtrack:
	MVI	A,hdebdtrack
	ORA	A	;SET FLAG
	RET
;
STEPOUT:
;	tracks to step(seek) passed in c
;	to step in set a reg to 10h and enter at
;	stepin
;DESTROYS A AND C
	XRA	A
stepin:	OUT	HEADSPORT	;OUTPUT DIRECTION
ST1:	ORI	20H		;SET STEP BIT
	OUT	HEADSPORT
	ANI	01FH		;RESET STEP BIT
	OUT	HEADSPORT
	DCR	C		;STEP COUNT
	JRNZ	ST1		;LOOP
	push	d
	lxi	d,0ffffh	;wait a long time
WAIT:	IN	HSTATUS
	ANI	2		;TEST SEEK COMPLETE
	jrnz	..seekcomplete
	dcx	d
	mov	a,d
	ora	e
	jrnz	wait
	pop	d
	mvi	a,hdeseektimeout	;error type
	ora	a
	ret
..seekcomplete:
	pop	d
	MVI	A,40		;DELAY 40 MSEC
DLY:	PUSH	B		;SAVE REGS
DLY2:	MVI	C,0F8H		;ADJUST FOR 1 MSEC
DLY3:	DCR	C
	JRNZ	DLY3
	DCR	A
	JRNZ	DLY2
	POP	B
	RET
	.page
	.sbttl	'read or write sector routines'
;
;
;	READ OR WRITE SECTOR ROUTINES
;
;
READSEC:
	call	selunit		;talk to right unit
	CALL	BADMAP
	RNZ
	CALL	FINDS1
	RNZ
	CALL	READW	;ACTUALLY READ THE SECTOR
	RNZ		;RETURN IF ERROR
;THE READ ROUTINE DID NOT HAVE PROBLEMS
;WE WILL NOW VERIFY THE HEADER FIELD FOR THE
;SECTOR THAT WAS READ IN
	CALL	CHKHDR	;CALCULATE THE CHECKSUM
	JRZ	READS2
	MVI	A,hdechecksum	;HEADER CHECKSUM ERROR
	ORA	A	;ERROR FLAG
	RET
READS2:
	LDA	PHYSEC	;CHECK THE SECTOR THAT WAS DESIRED
	MOV	B,A
	LDA	RDSEC	;WITH THE ONE THAT WAS READ
	SUB	B
	JZ	CHKTRKHD	;IF THEY MATCH, GO VERIFY
				;THE TRACK AND HEAD
	JMP	X3		;ELSE SET ERROR CODE 22
;
;
WRITESEC:
	call	selunit		;talk to right unit
	CALL	BADMAP
	RNZ
	LXI	H,wrtbuff	;SET UP DISK BUFFER AREA
	LXI	B,14		;INITIAL ZEROES
	XRA	A
	CALL	FILL
	MVI	M,0FH		;SYNC CHAR
	INX	H
	LDA	PHYTRACK		;CYLINDER #
	MOV	M,A
	INX	H
	MOV	B,A
	LDA	PHYHEAD		;HEAD #
	MOV	M,A
	INX	H
	ADD	B
	MOV	B,A
	LDA	PHYSEC		;SECTOR #
	MOV	M,A
	INX	H
	ADD	B
	MOV	B,A
	LDA	TAG0
	MOV	M,A
	INX	H
	ADD	B
	MOV	B,A
	LDA	TAG1
	MOV	M,A
	INX	H
	ADD	B
	MOV	B,A
	XRA	A	;SET CON0 AND CON1 TO 0
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	SUB	B		;CHECKSUM TO 0
	MOV	M,A
	LXI	H,BUFECC
	XRA	A
	LXI	B,32
;
	CALL	FILL
	CALL	FINDS1
	RNZ
	CALL	WRITEW
	RET
;
;
;
;
FILL:	MOV	E,A
FILL2:	MOV	M,E
	INX	H
	DCX	B
	MOV	A,B
	ORA	C
	JRNZ	FILL2
	RET
	.page
	.sbttl	'actual hardware read and write'
;
;
;
;	THE ACTUAL HARDWARE READ AND WRITE ROUTINES
;
;
READW:	CALL	HRD
	JMPR	HRWWAIT		;READ AND WAIT FOR IOF
HRD:	MVI	A,0C5H		;READ COMMAND BITS
	OUT	COMMAND
	RET
;
HWRT:	MVI	A,96H		;WRITE AND RAMD BITS
	OUT	COMMAND
	RET
WRITEW:	CALL	HWRT		;WRITE AND WAIT FOR IOF
HRWWAIT: MVI	C,0FFH		;TIMEOUT CONSTANT
WL2:	IN	CSTATUS		;TEST FOR I/OF
	RAL
	RAL
	RAL			;TEST BIT 5 - DONE
	JRC	WL3
	RAR
	RAR			;DONE - TEST ERROR
	jrnc	..noerr
	mvi	a,hdeunprocessederr	;incase
	ora	a		;no firmware
	jmp	gorderr		;have firmware 
			;process err if present
..noerr:
	IN	HSTATUS
	ANI	8
	JRNZ	WFAULT
	mvi	b,0fh
..stall:djnz	..stall
	OUT	COMMAND		;TURN ON MEMORY AGAIN
	RET
WL3:	DCR	C		;TEST FOR TIMEOUT
	NOP
	NOP
	JRNZ	WL2
	XRA	A
	OUT	COMMAND		;GET RAM BACK
	ADI	hdetimeout	;SET TIMEOUT ERROR CODE
	RET
;
WFAULT:
	XRA	A
	OUT	COMMAND		;terminate command
	call	selunit		;strobe fault clear
	xra	a
	ADI	hdewritefault	;SET WRITE FAULT ERROR CODE
	RET
;
;
;
FINDS1:				;FIND SEC=AC-1
	LDA	PHYSEC
	DCR	A
	JRNZ	FScek		;JUMP IF NOT SECTOR ONE
	lxi	d,0fffh	;for time to wait count
	IN	clearindex
FSLP4:	IN	HSTATUS		;WAIT FOR INDEX MARKER
	ANI	10H
	jrnz	indexfound
	dcx	d
	mov	a,e
	ora	d
	jrnz	FSLP4		;keep trying
	mvi	a,hdenoindex	;time out error
	ora	a
	ret
indexfound:
	XRA	A
	RET
fscek:			;check that valid sector
	lxi	h,disktype	;effectively sec/track
	cmp	m
	jrc	fslp3		;ok
	mvi	a,hdebdsector
	ora	a
	ret
FSLP3:
	MOV	D,A		;SAVE FOR COMPARE
	MVI	E,0		;FOR ERROR COUNT
FSL1:	PUSH	D
	CALL	READA		;READ AND ABORT
	POP	D
	JRNZ	NOTIT		;IF CHECKSUM ERROR RETRY
	LDA	RDSEC
	SUB	D		;COMPARE
	JRZ	CHKTRKHD	;VERIFY TRACK AND HEAD
				;DO A JMP INSTEAD OF CALL
				;TO SAVE CODE ON RETURN
NOTIT:	MOV	A,E
	INR	A
	MOV	E,A		;NO OF SECTORS CHECKED
	SUI	60		;2+REVOLUTIONS
	JRNZ	FSL1
	ADI	hdepreviousgone		;CAN NOT FIND SECTOR ERROR CODE
	RET
;
CHKTRKHD:		;VERIFY THAT WE ARE ON CORRECT TRACK AND HEAD
	LXI	H,RDCYL
	LDA	PHYTRACK
	CMP	M
	JRZ	X2
X3:			;ERROR!
	MVI	A,hdeheaderbad
	ORA	A
	RET
X2:
	INX	H
	LDA	PHYHEAD
	SUB	M
	RZ
	JMPR	X3
;
;
READA:			;READ AND ABORT AFTER 32 BYTES
	CALL	HRD		;READ COMMAND TO DISK
	MVI	B,00	;SET READ AND ABORT COUNTER.
RA2:
	IN	CSTATUS
	ANI	10H		;PCB
	JRNZ	DLYAB		;WAIT FOR BYTE 32
	DJNZ	RA2
DLYAB:	MVI	A,128
RADL:	DCR	A
	JRNZ	RADL		;DELAY .5 MSEC FOR RFSH
	OUT	COMMAND		;GET RAM BACK
CHKHDR:			;CHECKSUM THE HEADER
	LXI	H,RDCK
RA3:	ADD	M
	DCR	L		;CHECKSUM ID FIELD
	JRNZ	RA3
	ORA	A		;SET FLAGS-SHOULD BE 0
	RET
	.page
	.sbttl	'tables'

	.ifg	.-romjump,[
	.prntx 'rom jump table overwritten'][
	.prntx 'rom jump table ok']
	.loc	romjump
	jmp	getcommand
	jmp	readsec
	jmp	writesec
	jmp	pread
	jmp	pwrite
	jmp	putcomd

	.ifg	.-400h,[.prntx /ROM Overflow/][
	.prntx /room left in ROM/]
	
	.end


