	.title	'hard disk controller ram firmware'
	.ident	hardfirm
	.pabs
	.phex
version	==	2
revision==	4	;changed 17-Feb-83

;
;		TABLE OF CONTENTS		PAGE
;
; 1. version change descriptions		2
; 2. equates					3
; 3. initalise firmware				11
; 4. idle code					16
;	clean least recently used buffer	17
;	write out dirty bad sector tables	18
; 5. cpm function decoding			19
;	flush and netwrite			20
;	select disk and partition		21
;	swap unit and set volume pointer	23
;	cpm read and write			24
;	assign command				26
;	return unit info			28
;	find a sector in the buffer		29
;	get a free buffer			30
;	set buffer most recently used		32
;	doread and dowrite			33
;	calculate track,head and sector		34
;	cpmove					35
;	hard disk boot				36
;	hard disk read routine			37
;	netread (1k)				38
;	shift and divide			39
;	oasis commands				41
; 6. error correction 				43
; 7. data area					48

	.page
	.sbttl	'version change descriptions'

;
;	ver 2.4 17-Feb-83	in errexit clean up
;	stack as errexit is jumped to from within
;	subroutines

;
;	ver 2.3 10-sept-82	change in hardcrc.asm
;	only.  does not do error correction if
;	old rom is present

;	ver 2.2 5-aug-82	select disk only returns
;	status if multidisk os indicated 

;	
;	ver 2.1 3-Aug-82	Select disk (CPM) always
;	returns status

;	ver 1.1 may-82	multiple hard disks supported

;
;	ADDED 1K BYTE READ 4/12/81
;	ADDED MULT BUFFERS 9/13/80
;	COMBINED OASIS CODE 2/16/81
;	CPMUSER PROGRAM 8/24/79 9AM
;
;
	
	.insert	hardequ


	.page
	.sbttl	'initialise firmware'
	
	.LOC	usrprog	;ENTER HERE

	LXI	D,usrprog+2		;OVERLAY STARTING THERE
	LXI	H,LASTJMP+2
	LXI	B,LASTJMP+4-SMOV
	LDDR
	JMP	firminit		;LEAVE FOLLOWING AS IS
;
;
;	note: disk tracks, sec/trk, disksize and
;	volumne level all get altered by hardhelp
;	before loading for the specific disk
;
SMOV:
	.BYTE	0,0,0,0,0,0,0		;SYS VARIABLES
	.ifn .-usrprog-offtracks,[.prntx 'bad offtracks']
	.byte	memtracks	;disk tracks for fujitsu
	.BYTE	VERSION,REVISION
	.ifn .-usrprog-offtype,[.prntx 'bad offtype']
	.BYTE	memsectors	;SEC/TRK MX=11, SA=17
	.ifn .-usrprog-offsize,[.prntx 'bad offsize']
	.BYTE	mem11headmask	;DISKSIZE=3,7,B,F
	JMP	DUMMY0
	JMP	DUMMY1
	JMP	IDLE
	JMP	rderr
LASTJMP: JMP	funcdecode	;THIS ENDS UP AT 4100H

;
;	the volumne label is altered in hardhelp
;	when placing firmware on disk
;
	.ifn .-usrprog-offvollabel,[.prntx 'bad offvollabel']
vollabel:.ascii	/          / 
	.ifn .-vollabel-vlabsize,[.prntx 'bad label size']
;
firminit:
	LXI	H,commbuff	;SAVE USER COMD
	LXI	D,tbuff1	;TEMP STORAGE
	LXI	B,commsize
	LDIR
	LXI	H,0
	SHLD	PHYTRACK	;WANT 0,0,2=BLOCK 1
	MVI	A,2
	STA	PHYSEC
	MVI	A,8AH		;ECC + 10 RETRYS
	STA	CON0
	CALL	goreadsec
	JRZ	frok
badinit:
	mvi	a,hdeinit
	jmp	errexit
frok:
	LXI	H,RDDATA
	LXI	D,4500H		;CONTINUE AFTER 1ST 1K
	LXI	B,400H
	LDIR

	LXI	H,0
	SHLD	PHYTRACK	;WANT 0,0,3=BLOCK 2
	MVI	A,3
	STA	PHYSEC
	MVI	A,8AH		;ECC + 10 RETRYS
	STA	CON0
	CALL	goreadsec
	JRnz	badinit
	LXI	H,RDDATA
	LXI	D,4900H		;CONTINUE AFTER 2nd 1K
	LXI	B,400H
	LDIR

;
;	fill in volumn information for each volumn
;
	xra	a	;start with unit 0
..volloop:
	call	swapunit
	call	initvolinfo
	lda	unitno
	inr	a
	cpi	maxvol+1
	jrnz	..volloop
	xra	a		;restore unit as 0
	call	swapunit
	LXI	H,tbuff1	;RESTORE USER COMD
	LXI	D,commbuff
	LXI	B,commsize
	LDIR
	JMP	funcdecode	;NOW RUN CONT PROG

;
;	init volumne information
;
initvolinfo:
	lda	unitno
	call	setvolptr	;x reg points to data
;
;	read firmware sector to get disk size stuff
;
	lxi	h,0
	shld	phytrack	;want 0,0,1=block 0
	mvi	a,1
	sta	physec
	mvi	a,8ah		;ecc + 10 retrys
	sta	con0
	call	goreadsec
	jrz	..firmok	;if bad read do not
				;init volumne info
	mov	vliopenerr(x),a	;save error
	ret
;
;	if firmware on disk not latest version
;	dont mark disk as present or read from
;	need firmware for disk size data for
;	later reads
;
..firmok:
	lda	rddata+offversion
	cpi	version
	jrz	..verok
..verbad:
	mvi	a,hdeversionbad
	mov	vliopenerr(x),a
	ret
..verok:
	lda	rddata+offrevision
	cpi	revision
	jrnz	..verbad

;
;	compare volume label with volume label for 
;	volume 0, if duplicate presume running with
;	single disk controller and mark volume as not
;	present
;
	lxi	h,rddata+offvollabel
	lxi	d,vli0+vlivollabel
	mvi	b,vlabsize
labloop:
	ldax	d
	cmp	m
	jrnz	..labok	;a character is different
	inx	d
	inx	h
	djnz	labloop
	mvi	a,hdeduplicatevollabel
	mov	vliopenerr(x),a
	ret
..labok:
	mvi	vlipresent(x),true ;mark volumne as present
	lda	rddata+offtracks
	mov	vlitracks(x),a
	lda	rddata+offtype
	mov	vlitype(x),a
	lda	rddata+offsize
	mov	vlisize(x),a
	lxi	h,vlivollabel
	push	x
	pop	d
	dad	d
	xchg			;de points to vol 
				;label area
	lxi	h,rddata+offvollabel
	lxi	b,vlabsize
	ldir			;copy volumne label
	lda	unitno
	call	swapunit	;get info avail to rom
;
;	read volumne bad sector table
;
	lxi	h,bstsec	;block number for bad
	shld	hardsec		;sector table
	call	doread
	jrz	..bsok
	mov	vliopenerr(x),a	;save error
	ret

..bsok:
	mov	e,vlibadtable(x)
	mov	d,vlibadtable+1(x) ; d points bad
				;table for volumne
	lxi	h,rddata
	lxi	b,1024
	ldir			;copy table to right area

	mov	l,vlidirty(x)
	mov	h,vlidirty+1(x)
	mov	m,false		;mark as not dirty
;
;	READ DISK ASSIGNMENT TABLE, BLOCK 15, AND
;	COMPUTE H0BIAS TABLE ENTRIES FROM SIZE BYTE
;
	LXI	H,dtable	;WANT DISK ASS TABLE
	SHLD	HARDSEC
	CALL	DOREAD
	JRZ	..dasok
	mov	vliopenerr(x),a	;save error
	ret
..dasok:
	mov	l,vlibiastable(x)
	mov	h,vlibiastable+1(x)
	call	bldtab		;build bias table
				;for partitions
	ret
	

;
;	build a partition bias table when
;	passed location of table in hl and
;	partitions sector is in rddata
;
BLDTAB:	MVI	B,63
	LXI	D,RDDATA+16
	XRA	A
	MOV	M,A		;FORCE UNIT 0 TO BLOCK0
	INX	H
	MOV	M,A
	INR	A
	STA	CUMBLK		;CUM BLOCK COUNT
..1:	LDAX	D
	ORA	A
	JRZ	..3		;IF NOT ASSIGNED
	MOV	C,A
	MVI	A,80H
..2:	RLC			;MAKE A=2**C-1
	DCR	C
	JRNZ	..2
	MOV	C,A
	LDA	CUMBLK
	ADD	C
	STA	CUMBLK
	SUB	C
	JMPR	..4
..3:	LDA	CUMBLK
..4:	INX	H
	MVI	M,0
	INX	H
	MOV	M,A		;1,2,4,8,10,20,40,FF
	CALL	BUMP16		;POINT NEXT ENTRY
	DJNZ	..1
	ret

;
BUMP16:	PUSH	H
	LXI	H,16
	DAD	D
	XCHG
	POP	H
	RET
;
	.page
	.sbttl	'idle code'
;
DUMMY0:	RET
;
DUMMY1:	RET
;
;	CALLED AFTER 1 SEC IDLE BY ROM. DIRTY
;	AND CLEAN ARE CALLED BY FLUSH COMMAND
;	
IDLE:	
	lda	unitno	;save unit active at start
	push	psw	;of idle
	CALL	DIRTY			
..2:	CALL	CLEAN		;CHECK OTHER DRTY BUFS
	jrz	..ret		;RET IF NO MORE DRTY
	IN	PSTATUS		;READ HOST STAT
	RRC
	RRC			;CHECK LSB=HOST DA
	jrnc    ..2	;keep on if no new command
..ret:
	pop	psw
	call	swapunit ;restore unit active at
	ret		;start of idle

	.page
	.sbttl	'clean least recently used buffer'
;
;	return zero flag set if dirty buffer cleaned
;	non zero if no dirty buffers
;
CLEAN:			;CLEAN LRU DIRTY BUFFER
	MVI	B,NUMBUF	;LOOP CONTROL
	LXI	H,MRUTAB+NUMBUF-1
..2:	MOV	A,M		;GET LRU BUF NUM
	PUSH	H
	PUSH	B
	CALL	LOCBUF		;MOVE INFO TO CUR
	POP	B
	POP	H
	LDA	CURD		;IS IT DIRTY
	ORA	A
	JRNZ	..3
	DCX	H
	DJNZ	..2
	RET			;ZERO MEANS NONE DIRTY
;
..3:	XRA	A
	STA	CURD		;MARK CLEAN
	CALL	DOWRITE		;WRITE IT BACK
	CALL	BUFBACK		;CLEAN TO BUFINFO
	XRA	A
	INR	A
	RET			;WITH NON ZERO
	.page
	.sbttl	'write out dirty bad sector tables'
;
;	WRITE OUT DIRTY BADSECTOR TABLES
;	FOR EACH VOLUME
;
dirty:
	xra	a
	sta	dirtyvolume	;start with vol 0
..volloop:
	lda	dirtyvolume
	call	swapunit
	lda	dirtyvolume
	call	setvolptr
	mov	a,vlipresent(x)
	cpi	true
	jrnz	..nextvol
	
	mov	l,vlidirty(x)		;IS BST DIRTY
	mov	h,vlidirty+1(x)
	mov	a,m
	ORA	A
	JRZ	..nextvol		;IF CLEAN=NO NEW CRC ERR
	XRA	A
	mov	m,a		;MARK CLEAN
	MVI	B,10		;10 RETRYS
..1:	PUSH	B
	LXI	H,BSTSEC
	CALL	RDHL		;SET UP TO WR BSTSEC
	mov	l,vlibadtable(x)
	mov	h,vlibadtable+1(x)
	LXI	D,BUFDATA	;WRITE OUT BST
	LXI	B,400H
	LDIR
	CALL	gowritesec
	POP	B		;RETRY COUNT
	ORA	A		;ERR ON WRITE
	JRZ	..nextvol
	DJNZ	..1		;TRY AGAIN
	MVI	A,0FFH
	STA	FATAL		;FATAL ERROR FLAG
..nextvol:
	lda	dirtyvolume
	inr	a
	cpi	maxvol+1
	rnc			;no more volumes
	sta	dirtyvolume
	jmpr	..volloop

	.page
	.sbttl	'cpm function decodeing'
funcdecode:
	LDA	COMMBUFF
	SUI	10H		;10H IS FIRST COMD
	JZ	BOOTCPM		;IF BOOT REQ
	DCR	A
	JZ	HARDRW
	DCR	A
	JZ	HARDW
	DCR	A
	JRZ	SELDSK
	DCR	A
	JRZ	DOFLUSH
	DCR	A
	JZ	DONETR
	DCR	A
	JRZ	DONETW
	DCR	A
	JZ	DOASGN
	dcr	a
	jz	dounitinfo
	JMP	TRYOASIS	;TRY OASIS COMMANDS
	.page
	.sbttl	'flush and netwrite'
;
DOFLUSH:
	call	dirty		;clean up bad sector 
				;tables
..cleanloop:
	call	clean		;clean lru buffer
	jrnz	..cleanloop	;found one,may be more
	JMP	SENDST
;
;
DONETW:
	JMP	cmderror	;invalid command

	.page
	.sbttl	'seleck disk and partition'

;
SELDSK:
	lda	unitno
	lxi	h,commbuff+2	;select physical drive
	cmp	m
	jrz	..sameunit
	lda	con0
	cpi	'M'		;check that multi disk
	jrnz	..sameunit	;select intended
	mov	a,m
	cpi	maxvol+1
	jrc	..doswap	;volume ok
	mvi	a,hdebdvolume
	jmpr	selexit
..doswap:
	call	swapunit	;go select new unit
..sameunit:
	lda	unitno
	call	setvolptr
	mov	a,vlipresent(x)
	cpi	true
	jrz	..ispresent
	lda	con0
	cpi	'M'
	jnz	..trytoset	;try to set to a valid unit
..notpresent:
	mvi	a,hdeunitnotpresent
	jmpr	selexit
..trytoset:			;try to set to unit 0 for
	xra	a		;old rom and hinet
	sta 	unitno
	call	setvolptr
	mov	a,vlipresent(x)
	cpi	true
	jrnz	..notpresent	;still bad
..ispresent:
	LDA	COMMBUFF+1
	STA	FIXFLAG		;HARD9=FIXED HEADS
	MOV	L,A
	MVI	H,0
	mov	e,vlibiastable(x)
	mov	d,vlibiastable+1(x)
	DAD	H
	DAD	D		;HL NOW POINTS TO BIAS FOR SELECTED DRIVE
	MOV	E,M
	INX	H
	MOV	D,M
	SDED	VBIAS
	INX	H
	MOV	E,M		;GET MAX BLOCK NO
	INX	H
	MOV	D,M
	SDED	MAXBIAS
	xra	a		;no error
selexit:
	sta	selerr
	lda	con0
	cpi	'M'		;if not multi disk
	jnz	gogetcommand	;do not return status block
	lda	selerr
	JMP	errexit		;return status

	.page
	.sbttl	'swap unit and set volumne pointer'
;
;	swap unit, new unit passed in a
;	all parameters for rom, saved for
;	old unit and changed for new
;
swapunit:
	push	psw	;save new unit
	lda	unitno	;old unit
	call	setvolptr
	lda	trkd0	;current track for old unit
	mov	vlicurtrack(x),a ;save old track

	pop	psw	;restore new unit
	sta	unitno	;store as unit number
	call	setvolptr
	lxi	h,trkd0
	mov	a,vlicurtrack(x) ;set current track
	mov	m,a
	lxi	h,disktracks
	mov	a,vlitracks(x)	;set tracks info
	mov	m,a
	lxi	h,disktype
	mov	a,vlitype(x)	;set type
	mov	m,a
	inx	h
	mov	a,vlisize(x)	;set size
	mov	m,a
	ret

;
;	set x to point to volumne info
;	for unit passed in a
;	regs a,d,h altered
;
setvolptr:
	slar	a	;* 2
	mov	e,a
	mvi	d,0
	lxi	h,vliindex
	dad	d	;hl points to vol info ptr
	mov	e,m
	inx	h
	mov	d,m	;de points to vol info
	push	d
	pop	x	;x points to vol info
	ret
	
	.page
	.sbttl	'cpm read and write'
hardw:
	lxi	h,cpmwbuf
	lxi	d,128
	call	gopread		;get info to write
				;buffer and fall thru
				;to common read/write
				;code
;
HARDRW:	
	call	cpmcheck	;is unit setup
	CALL	MAPC		;MAP TO BLOCK
	CALL	FINDSEC		;IS SEC IN BUFFER
	CZ	GETBUF		;NO, GET IT
	CALL	SETMRU		;MAKE IT MRU
	JMP	CPMOVE		;GET/SEND DATA

;
;	check that select disk was ok and current
;	volume is present
;
cpmcheck:
	lda	unitno
	call	setvolptr
	mov	a,vlipresent(x)
	ora	a	;false is zero
	jrnz	..present
	lda	unitno
	sta	con0		;return unit which isn't
				;present
	mvi	a,hdeunitnotpresent
..checkfailed:
	pop	h		;dont return,clean stack
	jmp	errexit
..present:
	lda	selerr
	ora	a
	rz
	jmpr	..checkfailed

;
; RTN TO MAP CP/M TRACK AND SECTORS TO THE HARDDISK
;
MAPC:	LHLD	COMMBUFF+1
	DCR	L		;CPM USES 1-128
	MOV	A,L
	ANI	7
	STA	SECSEG		;3BITS
	MOV	A,L
	RAL
	MOV	L,A
	MVI	C,4
	CALL	SHIFT		;12 BITS LEFT IN HL
	LDA	COMMBUFF+3	;GET MSBYTE TRACK
	RAL
	RAL
	RAL
	RAL
	ANI	0F0H		;JUST IN CASE
	ADD	H
	MOV	H,A
	XCHG
	LHLD	VBIAS
	DAD	D
	SHLD	HARDSEC
	XCHG
	LHLD	MAXBIAS
	DCX	H		;CHECK LESS THAN
	ORA	A
	DSBC	D
	RNC			;RET IF OK
;
;	return directly to error proceedure
;
	pop	h		;clean stack
	mvi	a,hdecpmmapping	;mapping error
	jmp	errexit

	.page
	.sbttl	'assign command'
;
DOASGN:		;DO ASSIGN COMMAND
	LXI	D,14		;GET NAME, PASSWORD
	LXI	H,NAMPAS	;SAVE HERE
	CALL	gopread
	lda	unitno
	sta	saveunit	;save the present unit
				;to restore when done
	xra	a		;start with unit 0
..unitloop:
	call	swapunit
	lda	unitno
	call	setvolptr	;x reg points to vol
				;data
	mov	a,vlipresent(x)
	cpi	true
	jrnz	..notfound
	LXI	H,dtable	;TABLE IS BLOCK 15
	SHLD	HARDSEC
	CALL	DOREAD
	STA	CON1		;0 IF NO DISK ERR
	jrnz	..notfound
	LXI	H,RDDATA+1
	LXI	B,1024-1-14	;NO BYTE WORTH SEARCH
..2:	LXI	D,NAMPAS
	LDAX	D		;GET 1ST BYTE TO COMP
	CCIR
	JRNZ	..notfound
	PUSH	B
	PUSH	H
	MVI	B,13		;CHECK OTHER 13 CHAR
..5:	INX	D
	LDAX	D
	CPI	00
	JRZ	..5A
	CMP	M
	JRNZ	..4		;NOT THIS ONE
..5A:	INX	H
	DJNZ	..5
	MOV	A,M
	STA	COMMBUFF+2	;FOUND, GET CTRL BYTE
	LXI	D,-15
	DAD	D		;GET TO SIZE BYTE
	MOV	A,M
	STA	COMMBUFF
	LXI	D,-(RDDATA)
	DAD	D	;RSLT SHOUULD = UNIT*16
	MVI	A,0FH
	ANA	L		;ARE WE OK
	JRNZ	..4
	POP	D		;PUSHED AS H,B
	POP	D
	MVI	C,4
	CALL	SHIFT
	MOV	A,L
..6:	STA	COMMBUFF+1	;partition
	lda	unitno		;drive unit found on
	sta	commbuff+3
	lda	saveunit
	call	swapunit	;restore active
				;unit called with
	JMP	SENDST		;SEND STATUS BACK
..4:	POP	H
	POP	B
	JMPR	..2
..notfound:
	lda	unitno
	inr	a
	cpi	maxvol+1
	jrnz	..unitloop
	MVI	A,0FFH		;SET DENIED FLAG
	STA	COMMBUFF
	JMPR	..6
	.page
	.sbttl	'return volumne info'
dounitinfo:
	lda	lcromversion	;return rom version 
	sta	commbuff+1	;and revision
	lda	lcromrevision
	sta	commbuff+2
	lda	usrprog+offversion	;return firmware 
	sta	commbuff+3		;version and
	lda	usrprog+offrevision	;revision
	sta	commbuff+4
	xra	a
	sta	con1	;no error
	call	goputcommand
	lxi	d,vlibufsize*4	;bytes to send
	lxi	h,vli0
	call	gopwrite
	jmp	gogetcommand

	.page
	.sbttl	'find a sector in the buffer'
;
;	now check that volume number in buffer info agrees
;	with current volume number
;
;	on return zero flag set if sector found
;
FINDSEC:		;COMP (HARDSEC) WITH SEC NO
			;FIELD FOR EACH BUFFER
	LHLD	HARDSEC
	MOV	A,H		;COMP FROM A,C
	MOV	C,L
	MVI	B,NUMBUF	;LOOP CONTROL
	LXI	H,BUFINFO+3	;SEC NO FIELD
	LXI	D,BLEN		;BUFINFO LENGTH
..4:	CMP	M		;COMP MS BYTE
	JRNZ	..2		;NOT EQUAL
	PUSH	PSW		;SAVE
	DCX	H		;CHECK LS BYTE
	MOV	A,M
	CMP	C
	JRZ	..3		;IF BOTH COMP
..notfound:
	POP	PSW
	INX	H		;RESTORE
..2:	DAD	D		;GET NEXT BUF
	DJNZ	..4
	XRA	A
	RET			;ZERO SET=NOT FOUND
;
..3:	
	push	h
	pop	y
	lda	unitno
	cmp	6(y)		;volume byte in info
	jrnz	..notfound
	POP	PSW		;CLEAN STACK
	MVI	A,NUMBUF+1	;COMPUTE NUM OF BUF
	SUB	B
	STA	CURBNO
	DCX	H
	DCX	H
MVBUFI:	LXI	D,CURADR	;MOVE BUF TO CURBUF
	LXI	B,BLEN
	SHLD	BIADR		;SAVE WHERE CAME FROM
	LDIR
	INR	B		;CLEAR ZERO
	RET			;NOT ZERO = FOUND
;
	.page
	.sbttl	'get a free buffer'
;
GETBUF:			;GET OR MAKE A FREE BUFFER
			;CLEAN IF LRU IS DIRTY
			;READ HARDSEC INTO BUFFER
	LXI	H,MRUTAB+NUMBUF-1
	MOV	A,M		;GET LRU BUF NUM
	CALL	LOCBUF		;GET INFO
	LDA	CURD		;CHECK IF DIRTY
	ORA	A
	JRZ	..2
	lda	unitno
	push	psw		;save current unit
	CALL	CLEANA		;MARK CLEAN
	lda	unitno
	sta	volclean	;save volume that
				;on track for
	pop	psw
	call	swapunit	;restore current unit
	LXI	H,MRUTAB+NUMBUF-2
	LDA	CURT		;LOOK FOR ANY OTHER
	MOV	C,A		;DIRTY BUF ON SAME TRK
	MVI	B,NUMBUF-2
..3:	PUSH	H
	PUSH	B
	MOV	A,M		;FROM MRU TABLE
	CALL	LOCBUF		;GET PARAMETERS
	LDA	CURD
	ORA	A
	JRZ	..4		;IF NOT DIRTY
	LDA	CURT
	POP	B
	PUSH	B		;GET TRK WE ARE ON
	CMP	C
	JRNZ	..4		;IF DIFF TRACK
	lda	curvol
	lxi	h,volclean	;check that on same
	cmp	m		;volume
	jrnz	..4
	lda	unitno
	push	psw		;save current vol
	CALL	CLEANA
	pop	psw
	call	swapunit	;restore current vol
..4:	POP	B
	POP	H
	DJNZ	..3
	JMPR	GETBUF		;LRU IS CLEAN
..2:	CALL	DOREAD
	LHLD	CURADR		;MOVE DATA TO BUF
	XCHG
	LXI	H,RDDATA
	LXI	B,1024
	LDIR
	LHLD	HARDSEC
	SHLD	CURSEC		;SAVE SEC NUM
	CALL	BUFBACK
	RET
;
;
;  FOLLOWING ROUTINE IS CALLED WITH BUFNO IN A, MOVES
;  CORRECT BUFINFO TO CURBUF
;
LOCBUF:	STA	CURBNO
	LXI	H,BUFINFO-BLEN	;WILL DAD>0
	LXI	D,BLEN
..2:	DAD	D
	DCR	A		;RANGE 1 TO NUMBUF
	JRNZ	..2
	JMP	MVBUFI		;DO MOVE
;
;  BUFBACK RESTORES BUFINFO FROM CURBUF
;
CLEANA:	CALL	DOWRITE
CLEANB:	XRA	A		;MARK CLEAN
	STA	CURD		;AND PUT BACK
BUFBACK:
	LHLD	BIADR
	XCHG
	LXI	H,CURADR
	LXI	B,BLEN
	LDIR
	RET
	.page
	.sbttl	'set buffer most recently used'
SETMRU:	LDA	CURBNO		;SET CUR TO MRU
	LXI	B,NUMBUF	;LOOP CONTROL
	MOV	E,C
	LXI	H,MRUTAB
	CCIR			;FIND POS IN TABLE
	MOV	D,A		;SAVE MRU
	MOV	A,E
	SUB	C		;NUMBUF-POSITION
	DCR	A		;ALREADY MRU
	RZ			;IF YES
	MOV	C,A		;NUM TO MOVE DOWN
	MOV	A,D
	DCX	H		;ADJUST FROM CCIR
	MOV	D,H
	MOV	E,L		;MAKE DEST
	DCX	H
	LDDR			;MOV DOWN ONE
	INX	H		;POINT TO MRU
	MOV	M,A
	RET
	
	.page
	.sbttl	'doread and dowrite'
DOREAD:			;READ HARDSEC INTO RDDATA
	lda	unitno
	sta	curvol		;set up current vol
				;to store with buffer 
				;info
	CALL	CALCTHS		;CONVERT SECNO TO THS
DORD2:	MVI	A,8AH		;ECC + 10 RTRYS
	CALL	DSETUP
	LDIR			;PUT THS TO CURINFO
..2:	CALL	goreadsec
	STA	CON1		;SAVE ERR RESULT
	RZ			;IF NO ERR
	LXI	H,CON0
	DCR	M
	JRNZ	..2		;IF RETRYS LEFT
	INR	A		;FORCE NON ZERO
	RET
;
DOWRITE:		;WRITE HARDSEC TO DISK
	LHLD	CURADR		;MOVE TO WRITE AREA
	LXI	D,BUFDATA
	LXI	B,1024
	LDIR
	MVI	A,10		;RETRYS
	CALL	DSETUP
	XCHG
	LDIR		;MOVE CUR TO THS
	MOV	M,B		;PUT 0 IN DIRTY
..2:	CALL	gowritesec
	RZ
	LXI	H,CON0
	DCR	M		;CHECK RETRYS
	JRNZ	..2
	INR	M
	STA	FATAL
	RET			;NON ZERO = ERROR
;
DSETUP:	LXI	H,CON0		;SETUP RETRY CNT
	MOV	M,A
	lda	curvol
	call	swapunit	;ready to act from
				;right vol
	LXI	D,CURT		;XCHG CURTHS,THS
	LXI	H,PHYTRACK	;SOURCE FOR READ
	LXI	B,3
	RET

	.page
	.sbttl	'calculate track head and sector'

CALCTHS:
	LHLD	HARDSEC
;
; HL NOW HAS A NUMBER THAT IS ONE OF THE 28,000 SECTORS
;ON THE HARD DISK. WE NOW NEED TO BREAK THIS DOWN INTO
;TRACK AND HEAD.
;
; FIRST DIVIDE BY NUM OF SEC PER TRK
;
RDHL:
	CALL	DIVSPT
	INR	A
	STA	PHYSEC
;
; HL NOW HAS REMAINING NUMBER TO CALC TRACK AND HEAD
;
	LDA	FIXFLAG		;CHECK FOR FIXED HEADS
	CPI	63
	JRNZ	CHT
	MVI	A,8
	ADD	L		;GET TO HEAD 8-F
	STA	PHYHEAD
	MVI	A,0FFH		;FIXED HDS ARE TRK FF
	STA	PHYTRACK
	RET
CHT:	LDA	DISKSIZE
	ANI	4		;THIS BIT=28MBYTE
	MOV	C,A		;SAVE IT
	ORI	3
	ANA	L
	STA	PHYHEAD		;PHY HEAD (0-7)
;
; SHIFT REMAINING BITS 2 OR 3 PLACES TO GET THE TRACK
;
	MOV	A,C		;GET 28MB BIT
	RAR
	RAR
	ADI	2		;NOW = 2 OR 3
	MOV	C,A
	CALL	SHIFT
	MOV	A,H
	ORA	A		;SHOULD BE 0
	JRZ	..2
	MVI	A,0FEH		;FORCE ILLEGAL TRK
	JMPR	..3
..2:	MOV	A,L
..3:	STA	PHYTRACK
	RET

	.page
	.sbttl	'cpmove'
CPMOVE:
	lhld	hardsec		;hard sector used 
	shld	tag0		;for read or write
	LDA	COMMBUFF	;is returned
	CPI	CPMREAD
	JRZ	HARDREAD
	CPI	CPMWRITE
	JRZ	CPMW
	JMP	cmderror
;
; HARD DISK WRITE RTN
;
CPMW:	CALL	SETPOINT	;returns address to 
			;place info in in h and length
			;in d
	xchg
	push	h
	pop	b
	lxi	h,cpmwbuf
	ldir
	MVI	A,0FFH
	STA	CURD
	CALL	BUFBACK
SENDST:	CALL	goputcomd
	JMP	gogetcommand
	.page
	.sbttl	'hard disk boot'
;	no longer supported
;
; HARD DISK BOOT FROM T0 H1
;
BOOTCPM:
;	XRA	A
;	STA	BOOTERR
;BRS:
;	CALL	goreadsec		;GET 1024 BYTES
;	LXI	H,BOOTERR
;	LDA	CON1		;GET STATUS FROM READ
;	ORA	M
;	MOV	M,A		;OR OF ANY ERRORS
;	LXI	H,PHYSEC
;	INR	M		;INCREMENT SECTOR
;	MVI	B,8		;8 CPMSEC/1024 BYTES
;	LXI	H,RDDATA	;START OF SEC
;firmbloop:	PUSH	B		;SAVE COUNT
;	LXI	D,128		;SEND 128 BYTE
;	CALL	gopwrite		;TO HOST
;	LDA	TAG0		;GET COUNT
;	DCR	A
;	STA	TAG0		;DECREMENT
;	POP	B
;	JRZ	BOOTDONE
;	DJNZ	firmbloop
;	JMPR	BRS		;READ ANOTHER SEC
;BOOTDONE:
;	LDA	BOOTERR
;	STA	CON1
;	CALL	goputcomd
;	JMP	gogetcommand

	jmp	cmderror	;invalid command

	.page
	.sbttl	'hard disk read routine'
;
;
; HARD DISK READ RTN
;
HARDREAD:
	LDA	FATAL		;ERROR ON CLEAN
	ORA	A
	JRZ	..2
	STA	CON1		;REPORT ERR
..2:	CALL	goputcomd
	CALL	SETPOINT
;****	LXI	D,128		;NOW DONE IN SETPOINT
	CALL	gopwrite
	JMP	gogetcommand
;
;
SETPOINT:
	LHLD	CURADR
	LDA	SECSEG
	INR	A
	MOV	C,A
	LXI	D,128	;**********USED ABOVE******
SETPTLP:
	DCR	C
	RZ
	DAD	D
	JMPR	SETPTLP
;
	.page
	.sbttl	'netread (1k)'
DONETR:
RD1K:	call	cpmcheck	;see that proper unit
				;selected
	CALL	MAPC		;MAP TO PHYSICAL
	CALL	FINDSEC		;IN BUFFER
	LHLD	CURADR		;IN CASE YES
	JRNZ	..2		;IF YES
	CALL	DOREAD
	LXI	H,RDDATA
..2:	PUSH	H
	CALL	goputcomd
	POP	H
	LXI	D,2
	PUSH	H
	CALL	gopwrite		;SEND BLOCK TO HOST
	POP	H
	INX	H
	INX	H
	LXI	B,254*256+0FBH
	OUTIR
	OUTIR
	OUTIR
	OUTIR
	JMP	gogetcommand
	.page
	.sbttl	'shift and divide'
;
;SHIFTS HL TO THE RIGHT BY THE AMOUNT IN C.
;
SHIFT:
	SRLR	H
	RARR	L
	DCR	C
	JRNZ	SHIFT
	RET
;
;
; DIVIDE BY NUMBER OF SECTORS PER TRACK
;
DIVSPT:	LDA	DISKTYPE	;DIV BY SEC/TRK
DIVIDE:			;DIVIDE (HL) BY (A)
	MVI	B,0FFH
DV1:	RLC
	INR	B		;NORMALIZE AND COUNT
	JNC	DV1
	RRC			;FIX ONE TOO MANY
	RRC
;
	PUSH	B
	MOV	C,A		;WILL SUB FROM C
	MVI	D,0FFH		;CATCH CASE HL>8800
	MOV	A,H
..2:	MOV	H,A
	SUB	C
	INR	D
	JNC	..2
	MOV	A,D
	CALL	DV3B
	MOV	D,A		;SAVE FIRST RESULT
	MVI	B,8		;DO 8 MORE
	CALL	DV3
	MOV	E,A
	MOV	A,H
	XCHG			;RESULT TO HL
	POP	B		;NORM COUNT
DV2:	RAR
	DJNZ	DV2
	RET
;
DV3:	XRA	A
DV3A:	RLC
DV3B:	MOV	E,A		;BUILD RESULT
	MOV	A,H
	SUB	C		;TEST THIS BIT
	JNC	DV4		;IF C TOO BIG
	XRA	A
	JMPR	DV5
DV4:	MOV	H,A		;RESTORE H
	MVI	A,1		;THIS RESULT
DV5:	ADD	E		;ADD PREV RSLT
	DAD	H		;SHIFT HL
	DJNZ	DV3A		;LOOP
	RET
;
	.page
	.sbttl	'oasis commands'
;
;	oasis no longer supported
;
TRYOASIS:			;CHECK FOR OASIS COMD
	LDA	COMMBUFF
	CPI	021H
	JRZ	OAREAD
	CPI	022H
	JRZ	OAWRITE

cmdERROR:
				;SET COMMAND ERROR BIT
	MVI	A,hdebadcommand
errexit:
	STA	CON1
	CALL	goputcomd
	lxi	sp,stack	;clean up the stack
	JMP	gogetcommand
;
;
;******************************************************
;OASIS READ
;OASIS RENDS TRACK, HEAD, SECTOR, AND WHICH 256 BYTE
;LOGICAL SECTOR (0-3) TO SEND
;SEE IF THE SECTOR IS ALREADY IN
OAREAD:
	CALL	goreadsec		;READ IT IN
				;ACC HAS STATUS
	STA	CON1
	CALL	goputcomd	;ECHO IT BACK
			;GET CORRECT 256 BYTE SECTOR
	CALL	OASTPT
			;H,L HAVE START OF BUFFFER
RD10:
				;D,E HAVE 256 * TAG1
	LDA	TAG1
	MOV	D,A
	XRA	A
	MOV	E,A
	CALL 	gopwrite		;SEND TO HOST
	JMP	gogetcommand

;
;******************************************************
;OASIS WRITE
;OASIS SENDS TRACK, HEAD, SECTOR, AND WHICH 256 BYTE
;LOGICAL SECTOR TO CHANGE
OAWRITE:
	LXI	H,TBUFF1	;GET THE DATA FROM THE
			;HOST AND PUT INTO TEMP BUFFER
	MVI	E,0
	LDA	TAG1
	MOV	D,A
	CALL 	gopread
;NOW SEE IF THE PHYSICAL SECTOR IS ALREADY IN MEMORY
	CALL	goreadsec
	;1K PHYSICAL SECTOR IS NOW IN THE READ BUFFER.  
			;FIND THE CORRECT 256 BYTE AREA
	CALL	OASTPT
			;H,L HAVE START OF 256 BYTE AREA
			;PUT INTO D,E AS DESTINATION
	XCHG
				;SOURCE
	LXI	H,TBUFF1
				;LENGTH=256*TAG1
	LDA	TAG1
	MOV	B,A
	MVI	C,0
	LDIR
				;WRITE THE BUFFER
	LXI	H,RDDATA
	LXI	D,BUFDATA
	LXI	B,1024
	LDIR
	CALL	gowritesec
				;ACC HAS STATUS
	STA	CON1
	CALL	goputcomd
	JMP	gogetcommand

;
;
OASTPT:
	LXI	H,RDDATA
	LDA	TAG0
	INR	A
	LXI	D,256
SET10:
	DCR	A
	RZ
	DAD	D
	JMPR	SET10

	.insert	hardcrc
	.page
	.sbttl	'data area'
;
TBUFF1	=	0D000H
;
;
HARDSEC:	.WORD	0
SECSEG:		.BYTE	0
VBIAS:		.WORD	0
MAXBIAS:	.WORD	0
BOOTERR:	.BYTE	0
FIXFLAG:	.BYTE	0
FATAL:		.BYTE	0		;FATAL ERR FLAG
;
BIADR:	.WORD	0		;ADR OF BUF FOR CURINFO
CURBNO:	.BYTE	0		;BUF NUM OF CUR
CURADR:	.WORD	0		;CURRENT BUF ADR
CURSEC:	.WORD	0		;CUR SECTOR NUMBER
CURT:	.BYTE	0		;CUR TRACK
CURH:	.BYTE	0		;CUR HEAD
CURS:	.BYTE	0		;CUR SECTOR
CURD:	.BYTE	0		;=FF IF CUR BUF DIRTY
curvol:	.byte	0		;current volume
BLEN	=	.-CURADR	;LENGTH OF INFO BLOCK
BUFINFO:		;ONE BLOCK FOR EACH 1K BUFFER
BUF1:	.WORD	5000H,0FFFFH
	.BYTE	0,0,0,0,0
BUF2:	.WORD	5400H,0FFFFH
	.BYTE	0,0,0,0,0
BUF3:	.WORD	5800H,0FFFFH
	.BYTE	0,0,0,0,0
BUF4:	.WORD	5C00H,0FFFFH
	.BYTE	0,0,0,0,0
BUF5:	.WORD	6000H,0FFFFH
	.BYTE	0,0,0,0,0
BUF6:	.WORD	6400H,0FFFFH
	.BYTE	0,0,0,0,0
BUF7:	.WORD	6800H,0FFFFH
	.BYTE	0,0,0,0,0
BUF8:	.WORD	6C00H,0FFFFH
	.BYTE	0,0,0,0,0
BUF9:	.WORD	7000H,0FFFFH
	.BYTE	0,0,0,0,0
BUFA:	.WORD	7400H,0FFFFH
	.BYTE	0,0,0,0,0
BUFB:	.WORD	7800H,0FFFFH
	.BYTE	0,0,0,0,0
BUFC:	.WORD	7C00H,0FFFFH
	.BYTE	0,0,0,0,0
BUFD:	.WORD	0C000H,0FFFFH
	.BYTE	0,0,0,0,0
BUFE:	.WORD	0C400H,0FFFFH
	.BYTE	0,0,0,0,0
BUFF:	.WORD	0C800H,0FFFFH
	.BYTE	0,0,0,0,0
BUF10:	.WORD	0CC00H,0FFFFH
	.BYTE	0,0,0,0,0
BUF11:	.WORD	0D000H,0FFFFH
	.BYTE	0,0,0,0,0
;
MRUTAB:	.BYTE	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
	.BYTE	16,17
NUMBUF	=	.-MRUTAB

CUMBLK:	.BYTE	0	;cumulative block count in init

vliindex:		;index by unit into volumne info
	.word	vli0
	.word	vli1
	.word	vli2
	.word   vli3
	.loc	(. + 1fh) & (#(1fh))	;locate on 32 
					;byte boundary
vli0:
	.byte	false	;volumne present
	.byte	0ffh	;current track
	.byte	shutracks	;tracks on disk
	.byte	memsectors	;sectors / track
	.byte	mem11headmask	;head mask
	.word	h0bias	;partition bias table
	.word	badtable ;bad table location
	.word	bstdrty ;location of bad sector dirty
			;flag
	.byte	0	;failure if any in init disk reads
	.ascii	/no volabel/ ;label
	.blkb	vlibufsize+vli0-.

vli1:
	.byte	false	;volumne present
	.byte	0ffh	;current track
	.byte	shutracks	;tracks on disk
	.byte	memsectors	;sectors / track
	.byte	mem11headmask	;head mask
	.word	h1bias	;partition bias table
	.word	bad1table ;bad table location
	.word	bad1dirty ;location of bad sector dirty
			;flag
	.byte	0	;failure if any in init disk reads
	.ascii	/no volabel/ ;label
	.blkb	vlibufsize+vli1-.

vli2:
	.byte	false	;volumne present
	.byte	0ffh	;current track
	.byte	shutracks	;tracks on disk
	.byte	memsectors	;sectors / track
	.byte	mem11headmask	;head mask
	.word	h2bias	;partition bias table
	.word	bad2table ;bad table location
	.word	bad2dirty ;location of bad sector dirty
			;flag
	.byte	0	;failure if any in init disk reads
	.ascii	/no volabel/ ;label
	.blkb	vlibufsize+vli2-.

vli3:
	.byte	false	;volumne present
	.byte	0ffh	;current track
	.byte	shutracks	;tracks on disk
	.byte	memsectors	;sectors / track
	.byte	mem11headmask	;head mask
	.word	h3bias	;partition bias table
	.word	bad3table ;bad table location
	.word	bad3dirty ;location of bad sector dirty
			;flag
	.byte	0	;failure if any in init disk reads
	.ascii	/no volabel/ ;label
	.blkb	vlibufsize+vli3-.
	
	.ifg	.-4c00h,[
	.prntx	'too much code'][
	.prntx	'code length ok']
;
;	after this point only uninited buffers
;	allowed
;
NAMPAS:	.BLKB	14

H0BIAS:	.BLKW	64	;partion offset table
H1BIAS:	.BLKW	64	;partion offset table
H2BIAS:	.BLKW	64	;partion offset table
H3BIAS:	.BLKW	64	;partion offset table

saveunit:.blkb	1	;save unit during assign
selerr:	.blkb	1	;error from seldsk,passed
			;back in subsequent read
			;or write
dirtyvolume:.blkb 1	;used to keep track of volume
			;whose dirty bad sector
			;tables are being written
			;to disk in routine dirty
volclean:.blkb	1	;used to keep volume that
			;lru buffer written to to
			;check if any other sector
			;on same track
cpmwbuf:.blkb 128	;read stuff from host to here

;
;
;**********************WARNING
;
;	LAST ADR MUST BE LESS THAN 5000 (BUF11)
;
	.ifg	5000h-.,[
	.prntx	'ram used ok'][
	.prntx	'too much ram used']

	.end
