	.page
	.sbttl	'error correction'
crcversion ==	0
crcrevision ==	1	;last changed 28-May-82

;
;	process read errors for rom
;
RDERR:
	IN	CSTATUS		;WAIT FOR ECC CIRCUIT
	RAL
	RAL
	JRNC	RDERR
	MVI	A,40H		;WAIT ADDITIONAL 100 USEC
RDWL:	DCR	A
	JRNZ	RDWL
	OUT	COMMAND		;TURN OFF CONTROLLER
	CALL	CRCERR		;LOG ERROR
	LDA	RDAFTW		;CORRECT OR NOT
	RLC
	JRC	CORCT		;TRY TO CORRECT
	MVI	A,hdedatacrc
	ORA	A
	RET
;
; LETS TRY AND CORRECT IT
;
CORCT:
	LXI	H,RDBUFF+1050
	LXI	B,1054
SLOOP:
	MVI	A,0FFH
	CMP	M
	INX	H
	JRZ	GOT1
NO2:
	DCX	B
	MOV	A,C
	ORA	B
	JRNZ	SLOOP
	JMPR	NOTCORRECTABLE
;
; GETS HERE IF IT FINDS A BYTE OF 0FFH
;
GOT1:
	CMP	M
	JRNZ	NO2		;DID NOT FIND ANOTHER 
	PUSH	H		;BYTE OF 0FFH
	DCX	H
	DCX	H
	MOV	A,M
	POP	H
	INX	H
	INX	H
	MVI	B,5
;
rombloop:
	RAR
	JRNC	GOTIT
	DCR	B
	JRNZ	rombloop
	DCX	H
	MVI	B,8
	JMPR	rombloop
;
; HL - NOW POINTS TO THE BYTE WHERE 
;	THE CORRECTION BITS START
; B  - POINTS TO THE BIT WHERE THE 
;	CORRECTION BITS START
;
GOTIT:
	PUSH	B
	MOV	A,M
	DCR	B
	JRZ	XX
XY:	RLC			;MAKE SURE LEFT OF 
	JRNC	NOGOOD		;BYTE IS ALL 1'S
	DJNZ	XY
XX:	DCX	H
	MVI	A,0FFH
	CMP	M
	JRZ	GOOD
NOGOOD:	DCX	H
	MVI	M,0
	DCX	H
	MVI	M,0
	POP	B
	JMPR	CORCT		;TRY AGAIN 
GOOD:	INX	H
	POP	B
	PUSH	H
	MOV	L,B
	DCR	L
	MVI	H,0
	DAD	H
	LXI	B,MASK
	DAD	B
	MOV	C,M
	INX	H
	MOV	B,M		;THE MASK IS NOW 
	POP	H		;IN BC
	MOV	A,M
	CMA
	ANA	B
	MOV	B,A
	INX	H
	MOV	A,M
	CMA
	ANA	C
	MOV	C,A	;CORRECTION MASK IS NOW IN BC
;
; WE NOW NEED TO SHIFT THIS CORRECTION MASK 3 BITS
;
	LXI	D,0
	MVI	A,3
RLOOP:
	RALR	C
	RALR	B
	RALR	D
	DCR	A
	JRNZ	RLOOP
	MOV	E,B
;
; DE IS NOW SET TO CORRECT THE ERROR
; BUT FIRST WE MUST FIND IT
;
	LXI	B,-1055
	DAD	B
	MOV	A,M
	XRA	E
	MOV	M,A
	DCX	H
	MOV	A,M
	XRA	D
	MOV	M,A
	MVI	A,hdefixedcrc	;CORRECTED CODE
	STA	CON0		;RET STATUS IN CON0
	XRA	A
	RET			;SUCESSFUL COR
;
NOTCORRECTABLE:
	MVI	A,hdenocrc
	ORA	A
	RET			;ERROR RET


	.page
;
;	log crc errors
;
CRCERR:	
	lda	unitno
	call	setvolptr	;x reg points to vol info
	mov	l,vlidirty(x)
	mov	h,vlidirty+1(x)
	MVI	m,true		;SET bad sec tab dirty FLAG
	lded	PHYTRACK
	LDA	PHYSEC
	MOV	C,A
	dcx	H		;h points below dirty flag
	MVI	B,60		;MAX ENTRIES ABOVE BST
..2:	MOV	A,M		;END OF ENTRIES
	ORA	A
	JRNZ	..3
..7:	MOV	M,C		;MT SLOT, PUT IN
	DCX	H
	MOV	M,D		;HEAD
	DCX	H
	MOV	M,E		;TRACK
	DCX	H
	JMPR	..8		;SET ERR COUNT
..3:	CMP	C		;COMP ENTRY WITH SEC
	DCX	H
	JRNZ	..4
	MOV	A,M
	CMP	D		;COMP HEAD
	DCX	H
	JRNZ	..5
	MOV	A,M
	CMP	E		;COMP TRACK
	DCX	H
	JRNZ	..6
..8:	INR	M		;S,H,T OK INR ERR CNT
	RNZ
	DCR	M		;BACK TO FF
	RET
..4:	DCX	H
..5:	DCX	H
..6:	DCX	H
	DJNZ	..2		;TRY NEXT
	JMPR	..7		;IF FULL INR LAST ENTRY
;
MASK:	.WORD	1111000000000000B
	.WORD	0111100000000000B
	.WORD	0011110000000000B
	.WORD	0001111000000000B
	.WORD	0000111100000000B
	.WORD	0000011110000000B
	.WORD	0000001111000000B
	.WORD	0000000111100000B
