/************************************************************************/
/*				cpr.y					*/
/*	Copyright (c) 1985  CurrenT Software.  All rights reserved.	*/
/* yacc test file.							*/
/************************************************************************/

/************************************************************************/
/*                              Contents                                */ 
/*                                                                      */ 
/*                                                                      */ 
/*	token declarations for grammar					*/
/*	rules for grammar						*/
/*	skeletal runtimes.						*/
/*									*/
/************************************************************************/ 
         
/************************************************************************/ 
/*                              History                                 */  
/*                                                                      */  
/*                                              Last mod: 85Nov19       */ 
/*                                                                      */ 
/* 85Nov19 CrT  Created.                                                */ 
/************************************************************************/ 

/************************************************************************/ 
/*				Comments				*/
/*                                                                      */   
/* This file implements a trivial maze game, providing a compact,	*/
/* tinkerable example of yacc as an interactive command parser.  One	*/
/* peculiar aspect of the program is that yacc wants to have both a	*/
/* "current" and "next" input token at all times, but we don't want	*/
/* to have the response messages always a move behind, so we pad an	*/
/* 'X' invisibly onto every character entered.				*/
/*									*/
/************************************************************************/

/************************************************************************/
/*				Map					*/
/*                                                                      */   
/*									*/
/*									*/
/*									*/
/*			stream	pond   woods				*/
/*									*/
/*			swamp	glade  hollow				*/
/*									*/
/*			thicket knoll  exit				*/
/*									*/
/*									*/
/*									*/
/************************************************************************/


%{ 
int     yylval; 
%} 

%start	exit
%token	FIRST

%%
exit	:	hollow	'S'	{printf("\nYou WIN!                      \n");}
	|	knoll	'E'	{printf("\nYou WIN!                      \n");}
	;
hollow	:	woods	'S'	{printf("\nSouth to a hollow.            \n");}
	|	glade	'E'	{printf("\nEast to a hollow.             \n");}
	|	hollow	'X'
	|	hollow error
		     { yyerrok; yyclearin; printf("\nYou are at hollow.  \n");}
	;
woods	:	hollow	'N'	{printf("\nNorth to a wood.              \n");}
	|	pond	'E'	{printf("\nEast to a wood.               \n");}
	|	woods	'X'
	|	woods error
		     { yyerrok; yyclearin; printf("\nYou are at wood.    \n");}
	;
knoll	:	glade	'S'	{printf("\nSouth to a knoll.             \n");}
	|	thicket 'E'	{printf("\nEast to a knoll.              \n");}
	|	knoll	'X'
	|	knoll error
		     { yyerrok; yyclearin; printf("\nYou are at knoll.   \n");}
	;
glade	:	FIRST		{printf("\nType N, S, E or W.            \n");}
	|	knoll	'N'	{printf("\nNorth to a glade.             \n");}
	|	hollow	'W'	{printf("\nWest to a glade.              \n");}
	|	pond	'S'	{printf("\nSouth to a glade.             \n");}
	|	swamp	'E'	{printf("\nEast to a glade.              \n");}
	|	glade	'X'
	|	glade error
		     { yyerrok; yyclearin; printf("\nYou are at glade.   \n");}
	;
pond	:	glade	'N'	{printf("\nNorth to a pond.              \n");}
	|	stream	'E'	{printf("\nEast to a pond.               \n");}
	|	woods	'W'	{printf("\nWest to a pond.               \n");}
	|	pond	'X'
	|	pond error
		     { yyerrok; yyclearin; printf("\nYou are at pond.    \n");}
	;
stream	:	pond	'W'	{printf("\nWest to a stream.             \n");}
	|	swamp	'N'	{printf("\nNorth to a stream.            \n");}
	|	stream	'X'
	|	stream error
		     { yyerrok; yyclearin; printf("\nYou are at stream.  \n");}
	;
swamp	:	stream	'S'	{printf("\nSouth to a swamp.             \n");}
	|	glade	'W'	{printf("\nWest to a swamp.              \n");}
	|	thicket 'N'	{printf("\nNorth to a swamp.             \n");}
	|	swamp	'X'
	|	swamp error
		     { yyerrok; yyclearin; printf("\nYou are at swamp.   \n");}
	;
thicket :	swamp	'S'	{printf("\nSouth to a thicket.           \n");}
	|	knoll	'W'	{printf("\nWest to a thicket.            \n");}
	|	thicket 'X'
	|	thicket error
		     { yyerrok; yyclearin; printf("\nYou are at thicket. \n");}
	;
%%
yylex() {
    static firstTime = 1;
    static echo = 0;
    if (!firstTime)  {
	if (echo) {
	    echo = 0;
            return 'X';
	} else {
	    echo = 1;
	    return toupper( getChar() );
	}
    } else {
	firstTime = 0;
        return FIRST;
    }
}

yyerror(s)
char *s;
{
/* For this program we ignore yyerror() calls: */
/*  printf("\n%s",s);   */
}

main() {
    return yyparse();
}

