se, XtNfile, XtNfont, XtNfontinfo, XtNgeometry,
                XtNgfunc, XtNheight, XtNinaddr, XtNint, XtNjustify, XtNkey,
                XtNno, XtNoff, XtNon, XtNpixel, XtNpixmap,
                XtNpointer, XtNpos, XtNstring,
                XtNtile, XtNtrue, XtNwidgetclass, XtNwidgetname, XtNwidth,
                XtNwindow, XtNwindowinfo, XtNxpos, XtNyes, XtNypos;

#define XtAatom &XtNatom
#define XtAbitmap       &XtNbitmap
#define XtAboolean      &XtNboolean
#define XtAbrush        &XtNbrush
#define XtAchar &XtNchar
#define XtAcolor        &XtNcolor
#define XtAcursor       &XtNcursor
#define XtAdims &XtNdims
#define XtAdisplay      &XtNdisplay
#define XtAdnaddr       &XtNdnaddr
#define XtAenum &XtNenum
#define XtAeventbindings        &XtNeventbindings
#define XtAeventtype    &XtNeventtype
#define XtAfalse        &XtNfalse
#define XtAfile &XtNfile
#define XtAfont &XtNfont
#define XtAfontinfo     &XtNfontinfo
#define XtAgeometry     &XtNgeometry
#define XtAgfunc        &XtNgfunc
#define XtAheight       &XtNheight
#define XtAinaddr       &XtNinaddr
#define XtAint  &XtNint
#define XtAjustify      &XtNjustify



                       March 16, 1987





                           - 80 -


#define XtAkey  &XtNkey
#define XtAno   &XtNno
#define XtAoff  &XtNoff
#define XtAon   &XtNon
#define XtApixel        &XtNpixel
#define XtApixmap       &XtNpixmap
#define XtApointer      &XtNpointer
#define XtApos  &XtNpos
#define XtAstring       &XtNstring
#define XtAtile &XtNtile
#define XtAtrue &XtNtrue
#define XtAwidgetclass  &XtNwidgetclass
#define XtAwidgetname   &XtNwidgetname
#define XtAwidth        &XtNwidth
#define XtAwindow       &XtNwindow
#define XtAwindowinfo   &XtNwindowinfo
#define XtAxpos &XtNxpos
#define XtAyes  &XtNyes
#define XtAypos &XtNypos

extern void XtRegisterTypeConverter(/*fromType, toType, convertProc*/);
    /* Atom fromType, toType; */
    /* ConvertTypeProc convertProc; */

extern void XtConvert(/* from, toType, to*/);
    /* XrmTypedValue from; */
    /* Atom toType; */
    /* XrmValue *to; */

/****************************************************************
 *
 * Resource Database Management
 *
 ****************************************************************/

typedef struct          ResourceDataBaseStruct *ResourceDataBase;
typedef int             unspecified;

extern void XtSetCurrentDataBase(/*db*/);
    /* ResourceDataBase db; */

extern void XtGetCurrentDataBase(/*db*/);
    /* ResourceDataBase *db; */

extern void XtGetDataBase(/*magicCookie, db*/);
    /* unspecified magicCookie; /* file */
    /* ResourceDataBase *db; */

extern void XtPutDataBase(/*magicCookie, db*/);
    /* unspecified magicCookie; /* file */
    /* ResourceDataBase db; */

extern void XtMerge(/*new, into*/);
    /* ResourceDataBase new, *into; */



                       March 16, 1987





                           - 81 -


/****************************************************************
 *
 * Command line option mapping to resource entries
 *
 ****************************************************************/

typedef enum _OptionKind {
    noarg,      /* Value is specified in OptionDescRec.value                */
    isarg,      /* Value is the option string itself                        */
    stickyarg,  /* Value is characters immediately following option         */
    separg,     /* Value is next argument in argv                           */
    skiparg,    /* Ignore this option and the next argument in argv         */
    skipline    /* Ignore this option and the rest of argv                  */
} OptionKind;

typedef struct _OptionDescRec {
    char        *option;        /* Option abbreviation in argv              */
    char        *resource_name; /* Resource name (sans application name)    */
    OptionKind  argkind;        /* Which style of option it is              */
    caddr_t     value;          /* Value to provide if stickyarg            */
} OptionDescRec, *OptionDescPtr;

typedef struct _CompiledOptionRec {
    char        *option;
    AtomList    resource_name;
    OptionKind  argkind;
    caddr_t     value;
} CompiledOptionRec, *CompiledOptionPtr;


extern CompiledOptionPtr XtCompileOptions(); /* table, prependName      */
    /* OptionDescPtr    table;                                          */
    /* Atom             prependName; (NULLATOM means don't prepend)     */

extern void XtParseCommand(); /* table, argc, argv */
    /* CompiledOptionPtr table;  */
    /* int               *argc;  */
    /* char              **argv; */



/****************************************************************
 *
 * Translation Management
 *
 ****************************************************************/

typedef caddr_t XtEventsPtr;

typedef struct _XtActionsRec {
    char *string;
    caddr_t value;
} XtActionsRec, *XtActionsPtr;




                       March 16, 1987





                           - 82 -


/* Different classes of action tokens */

typedef enum _TokenType {TTchar, TTstring, TTatom} TokenType;

/* List of tokens. */

typedef struct _XtActionTokenRec {
    TokenType type;
    union {
        char c;
        char *str;
        Atom atom;
    } value;
    struct _XtActionTokenRec *next;
} XtActionTokenRec, *XtActionTokenPtr;

extern XtEventsPtr XtSetActionBindings(); /* eventTable, actionTable, default */
  /*  XtEventsPtr eventTable; */
  /*  XtActionsPtr actionTable; */
  /*  caddr_t default; */

extern XtEventsPtr XtParseEventBindings(); /* stringTable */
  /* char **stringTable */

extern caddr_t XtInterpretAction();


/****************************************************************
 ****************************************************************
 ***                                                          ***
 ***                                                          ***
 ***                   X Toolkit Widgets                      ***
 ***                                                          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************/




/***********************************************************************
 *
 * Command Button Widget
 *
 ***********************************************************************/

extern AtomName XtNfunction, XtNparameter;

#define XtAfunction     &XtNfunction
#define XtAparameter    &XtNparameter

typedef enum _XtEjustify {
    leftjustify,       /* justify text to left side of button */
    centerjustify,     /* justify text in center of button */



                       March 16, 1987





                           - 83 -


    rightjustify       /* justify text to right side of button */
} XtEjustify;


/*

 New parameter types
 ==================

 Name           Type            Comment
 ----           ----            -------
 function       void (*)()      procedure returning status, takes caddr_t

 Parameters
 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          create window
 BorderWidth    int             int             1
 Width          int             int             text width + 2*InternalWidth
 Height         int             int             font height + 2*InternalHeight
 InternalWidth  int             int             4
 InternalHeight int             int             2
 Label          string          string          Dummy
 Foreground     color           pixel           BlackPixel
 Background     color           pixel           WhitePixel
 Border         color           pixmap          BlackPixmap
 Font           font            fontinfo        helv10b
 Justify        XtEjustify      XtEjustify      centerjustify
 Function       function        function        do nothing
 Parameter      pointer         pointer         NULL
 Highlight      int             int             EnterWindow
 Unhighlight    int             int             LeaveWindow
 Notify         int             int             ButtonReleased

*/

extern Window XtCreateCommand (); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* Arg * arglist; */




/***********************************************************************
 *
 * Label Widget
 *
 ***********************************************************************/

/*
typedef enum _XtEjustify {
    leftjustify,



                       March 16, 1987





                           - 84 -


    centerjustify,
    rightjustify
} XtEjustify;
note: already defined in Command Button section
*/


/*

 Parameters
 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          create window
 BorderWidth    int             int             1
 Width          int             int             text width + 2*InternalWidth
 Height         int             int             font height + 2*InternalHeight
 InternalWidth  int             int             4
 InternalHeight int             int             2
 Label          string          string          Dummy
 Foreground     color           pixel           BlackPixel
 Background     color           pixel           WhitePixel
 Border         color           pixmap          BlackPixmap
 Font           font            fontinfo        helv10b
 Justify        justify         atom            centerJustify

*/

extern AtomName XtNleftJustify, XtNcenterJustify, XtNrightJustify;

#define XtAleftJustify  &XtNleftJustify
#define XtAcenterJustify        &XtNcenterJustify
#define XtArightJustify &XtNrightJustify

extern Window XtCreateLabel(); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* Arg * arglist; */




/***********************************************************************
 *
 * Boolean Button Widget
 *
 ***********************************************************************/

extern AtomName XtNHighlight, XtNUnhighlight, XtNOn, XtNOff, XtNToggle;

#define XtAHighlight &XtNHighlight
#define XtAUnhighlight &XtNUnhighlight
#define XtAOn &XtNOn
#define XtAOff &XtNOff



                       March 16, 1987





                           - 85 -


#define XtAToggle &XtNToggle

/*

 Parameters
 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Value          pointer         pointer         NONE, required parameter
 Window         window          window          create window
 BorderWidth    int             int             1
 Width          int             int             text width + 2*InternalWidth
 Height         int             int             font height + 2*InternalHeight
 InternalWidth  int             int             4
 InternalHeight int             int             2
 Label          string          string          Dummy
 Foreground     color           pixel           BlackPixel
 Background     color           pixel           WhitePixel
 Border         color           pixmap          BlackPixmap
 Font           font            fontinfo        helv10b
 Highlight      int             int             EnterWindow
 Unhighlight    int             int             LeaveWindow
 On             int             int             NoEvent
 Off            int             int             NoEvent
 Toggle         int             int             ButtonPressed

*/

extern Window XtCreateBoolean(); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* Arg * arglist; */




/***********************************************************************
 *
 * Button Box Widget
 *
 ***********************************************************************/

extern AtomName XtNHSpace, XtNVSpace, XtNButton;

#define XtAHSpace &XtNHSpace
#define XtAVSpace &XtNVSpace
#define XtAButton &XtNButton

/*

extern AtomName XtNButton;
#define XtAButton       &XtNButton;

 Parameters



                       March 16, 1987





                           - 86 -


 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          create window
 Width          int             int             chosen arbitrarily
 Height         int             int             chosen arbitrarily
 BorderWidth    int             int             1
 Border         color           pixmap          BlackPixmap
 Background     color           pixmap          WhitePixmap
 HSpace         int             int             4
 VSpace         int             int             4
 Button         window          window          <none, optional, repeated>

*/

extern Window XtCreateButtonBox(); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* ArgList arglist; */

/*

 Parameters
 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          NONE, required parameter
 Index          int             int             0

*/

extern XtStatus XtButtonBoxAddButton(); /* w, arglist */
    /* Window   w; */
    /* ArgList  arglist; */

/*

 Parameters
 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          computed from index (*)
 Index          int             int             computed from window (*)

* - one of Window or Index is required.

*/

extern XtStatus XtButtonBoxDeleteButton(); /* w, arglist */
    /* Window   w; */
    /* ArgList  arglist; */




                       March 16, 1987





                           - 87 -


/****************************************************************
 *
 * Scrollbar Widget
 *
 ****************************************************************/
typedef enum _Orient {Horizontal, Vertical} Orient;
/*** The above is obsolete ***/

extern AtomName XtNhorizontal, XtNvertical, XtNClientWindow, XtNThumb,
                XtNTopPercent, XtNpercent, XtNfloat, XtNShownPercent;

#define XtAhorizontal &XtNhorizontal
#define XtAvertical &XtNvertical
#define XtAClientWindow &XtNClientWindow
#define XtAThumb &XtNThumb
#define XtATopPercent &XtNTopPercent
#define XtApercent &XtNpercent
#define XtAfloat &XtNfloat
#define XtAShownPercent &XtNShownPercent

/* Parameters:

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          create window
 Orientation    orientation     atom            horizontal
 ClientWindow   window          window          parent window
 Width          width           int             1
 Height         height          int             1
 BorderWidth    borderwidth     int             1
 Border         color           pixel           Default foreground
 ScrollUpDownProc function      function        No-op
 ThumbProc      function        function        No-op
 Foreground     color           pixel           Default foreground
 Background     color           pixel           Default background
 Thumb          pixmap          pixmap          Grey
 TopPercent     percent         float           0.0
 ShownPercent   percent         float           0.0

*/

extern Window XtCreateScrollBar(); /*parent, arglist*/
/* Window parent; */
/* ArgList arglist; */

extern void XtDestroyScrollBar(); /* scrollbarWindow */
/* Window scrollbarWindow; */

extern void XtSetScrollBarPercentages(); /* scrollbarWindow, topPercent,
                                            shownPercent*/
/* Window scrollbarWindow; */
/* float topPercent, shownPercent; */





                       March 16, 1987





                           - 88 -


/****************************************************************
 *
 * Scrollbar Manager Widget
 *
 ****************************************************************/

extern AtomName XtNChildWindow, XtNThickness, XtNthickness;

#define XtAChildWindow &XtNChildWindow
#define XtAThickness &XtNThickness
#define XtAthickness &XtNthickness

/* Parameters:

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          <Created>
 ChildWindow    window          window          <Created>
 BorderWidth    borderwidth     int             1
 Border         pixmap          pixmap          Default Foreground
 Thickness      thickness       int             15
 Width          width           int             1
 Height         height          int             1
 X              x               int             0
 Y              y               int             0


Parameters for XtAddScrollBar():

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Lowerright     boolean         boolean         false
 Orientation    orientation     atom            vertical
*/


extern Window XtCreateWithScrollBars(); /* pw, arglist */
/* Window pw; */
/* ArgList arglist; */

extern Window XtScrollBarsGetChild(); /* pw */
/* Window pw; */

extern Window XtScrollBarsSetChild(); /* pw, child */
/* Window pw, child; */

extern XtUnarrangeWithScrollBars(); /* w */
/* Window w; */

extern XtSetScrollBarThickness(); /* w, thickness */
/* Window w; */
/* int thickness; */

extern int XtGetScrollBarThickness(); /* w */



                       March 16, 1987





                           - 89 -


/* Window w; */

extern Window XtAddScrollBar(); /* w, arglist */
/* Window w; */
/* ArgList arglist; */

extern XtRemoveScrollBar(); /* w, sbar */
/* Window w, sbar; */


/****************************************************************
 *
 * Scrolled Window Widget
 *
 ****************************************************************/

#define SWUseBottom     0x01    /* Use the bottom for horiz bars, not top */
#define SWUseRight      0x02    /* Use the right for vert bars, not left */
#define SWAllowHorizBar 0x04    /* Allow the window to become too wide */
#define SWAllowVertBar  0x08    /* Allow the window to become too high */
#define SWForceBars     0x10    /* Force the above bars to appear even if
                                   the window is currently narrow enough. */
/**** The above is obsolete ****/
extern AtomName XtNLowerright, XtNScrollUpDownProc, XtNThumbProc,
                XtNInnerwidth, XtNInnerheight, XtNInnerheight,
                XtNForcebars, XtNAllowhoriz, XtNAllowvert,
                XtNUsebottom, XtNUseright, XtNInnerwindow;

#define XtALowerright   &XtNLowerright
#define XtAScrollUpDownProc     &XtNScrollUpDownProc
#define XtAThumbProc    &XtNThumbProc
#define XtAInnerwidth   &XtNInnerwidth
#define XtAInnerheight  &XtNInnerheight
#define XtAInnerheight  &XtNInnerheight
#define XtAForcebars    &XtNForcebars
#define XtAAllowhoriz   &XtNAllowhoriz
#define XtAAllowvert    &XtNAllowvert
#define XtAUsebottom    &XtNUsebottom
#define XtAUseright     &XtNUseright
#define XtAInnerwindow  &XtNInnerwindow

/* Parameters:

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Innerwidth     width           int             1
 Innerheight    height          int             1
 Innerwindow    window          window          <Created>
 Forcebars      boolean         boolean         false
 Allowhoriz     boolean         boolean         false
 Allowvert      boolean         boolean         false
 Usebottom      boolean         boolean         false
 Useright       boolean         boolean         false
*/



                       March 16, 1987





                           - 90 -


extern Window XtCreateScrolledWindow(); /* parent, arglist */
/* Window parent; */
/* ArgList arglist; */

extern Window XtScrolledWindowGetChild(); /* outer */
/* Window outer; */

extern Window XtScrolledWindowSetChild(); /* pw, child */
/* Window pw, child; */

extern Window XtScrolledWindowGetFrame(); /* outer */
/* Window outer; */

extern Window XtUnmakeScrolledWindow(); /* outer */
/* Window outer; */


/****************************************************************
 *
 * Text widget
 *
 ****************************************************************/

extern AtomName XtNEditType, XtNedittype, XtNDisplayPosition,
                XtNtextposition, XtNTextPosition,
                XtNSelection, XtNtextselection, XtNTextSelection,
                XtNSelectionArray, XtNselectionarray,
                XtNTextSink, XtNtextsink, XtNTextSource, XtNtextsource,
                XtNEventBindings, XtNeventBindings,
                XtNsource, XtNsink, XtNTextOptions, XtNtextoptions,
                XtNLeftMargin, XtNInsertPosition;

#define XtAEditType &XtNEditType
#define XtAedittype &XtNedittype
#define XtADisplayPosition      &XtNDisplayPosition
#define XtAtextposition &XtNtextposition
#define XtATextPosition &XtNTextPosition
#define XtASelection    &XtNSelection
#define XtAtextselection        &XtNtextselection
#define XtATextSelection        &XtNTextSelection
#define XtASelectionArray       &XtNSelectionArray
#define XtAselectionarray       &XtNselectionarray
#define XtATextSink     &XtNTextSink
#define XtAtextsink     &XtNtextsink
#define XtATextSource   &XtNTextSource
#define XtAtextsource   &XtNtextsource
#define XtAEventBindings        &XtNEventBindings
#define XtAeventBindings        &XtNeventBindings
#define XtAsource       &XtNsource
#define XtAsink         &XtNsink
#define XtATextOptions          &XtNTextOptions
#define XtAtextoptions          &XtNtextoptions
#define XtALeftMargin           &XtNLeftMargin
#define XtAInsertPosition       &XtNInsertPosition



                       March 16, 1987





                           - 91 -


/*

 Parameters
 ==========

 Name            Class           RepType         Default Value
 ----            -----           -------         -------------
 Window          window          Window          create window
 Foreground      color           Pixmap          BlackPixmap
 Background      color           Pixmap          WhitePixmap
 Border          pixmap          Pixmap          BlackPixmap
 BorderWidth     int             int             4
 DisplayPosition textposition    XtTextPosition  0
 Selection       textselection   pointer         {0,0,posSelection}
 SelectionArray  selectionarray  pointer         {posSelection, wordSelection,
                                                 lineSelection, paraSelection,
                                                 allSelection, nullSelection}
 TextOptions     textoptions     int             0
 LeftMargin      int             int             2
 InsertPosition  textpositon     XtTextPosition  0
 Font            font            FontInfo        helv10b
 String          string          string          NULL
 Length          int             int             100
 File            file            string          tmname()
 EditType        edittype        XtEditType      textRead

*/

extern Window XtCreateDiskText(); /* pw, arglist */
    /* Window pw;                 /* parent window */
    /* Arg * arglist; */

extern Window XtCreateStringText(); /* pw, arglist */
    /* Window pw;                 /* parent window */
    /* Arg * arglist; */

extern XtDestroyDiskText(); /* w */
    /* Window w; */

extern XtDestroyStringText(); /* w */
    /* Window w; */


typedef enum _XtEditType {textRead, textAppend, textEdit} XtEditType;
#define wordBreak               0x01
#define scrollVertical          0x02
#define resizeWidth             0x10
#define resizeHeight            0x20


/****************************************************************
 *
 * VPane
 *



                       March 16, 1987





                           - 92 -


 ****************************************************************/

extern AtomName XtNX, XtNx, XtNY, XtNy, XtNborderwidth, XtNKnobwidth,
                XtNknobwidth, XtNKnobheight, XtNknobheight, XtNKnobindent,
                XtNknobindent, XtNKnobpixmap, XtNknobpixmap;

#define XtAX &XtNX
#define XtAx &XtNx
#define XtAY &XtNY
#define XtAy &XtNy
#define XtAborderwidth &XtNborderwidth
#define XtAKnobwidth &XtNKnobwidth
#define XtAknobwidth &XtNknobwidth
#define XtAKnobheight &XtNKnobheight
#define XtAknobheight &XtNknobheight
#define XtAKnobindent &XtNKnobindent
#define XtAknobindent &XtNknobindent
#define XtAKnobpixmap &XtNKnobpixmap
#define XtAknobpixmap &XtNknobpixmap

extern Window XtCreateVPanedWindow(); /* ourparent, arglist */
    /* Window ourparent; */
    /* ArgList arglist; */

extern void XtUnmakeVPanedWindow(); /* w */
    /* Window w; */

extern void XtAddToVPanedWindow();
                /* w, subwindow, position, min, max, autochange */
    /* Window w, subwindow; */
    /* int position, min, max, autochange; */

extern void XtVPanedSetMinMax(); /* w, subwindow, min, max */
    /* Window w, subwindow; */
    /* int min, max; */

extern void XtDeleteFromVPanedWindow(); /* w, subwindow */
    /* Window w, subwindow; */

extern void XtVPanedRefigureMode(); /* window, mode */
    /* Window window; */
    /* short mode; */


/****************************************************************
 *
 * Basic Menu Widget
 *
 ****************************************************************/

extern AtomName XtNorientation, XtNinternalwidth, XtNinternalheight, XtNSpace,
                XtNspace, XtNMenuEntry, XtNmenuentry;

#define XtAorientation &XtNorientation



                       March 16, 1987





                           - 93 -


#define XtAinternalwidth &XtNinternalwidth
#define XtAinternalheight &XtNinternalheight
#define XtASpace &XtNSpace
#define XtAspace &XtNspace
#define XtAMenuEntry &XtNMenuEntry
#define XtAmenuentry &XtNmenuentry

/*
 Parameters
 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          Window          <Created>
 Width          int             int             1
 Height         int             int             1
 Orientation    orientation     Atom            vertical
 BorderWidth    int             int             1
 Border         color           Pixmap          BlackPixmap
 Background     color           Pixmap          WhitePixmap
 InternalWidth  int             int             2
 InternalHeight int             int             2
 Space          space           int             1
 Function       function        function        <built-in debug function>
 Parameter      pointer         caddr_t         0
 Notify         int             int             0

 Parameters for XtAddMenuEntry():
 ================================

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 MenuEntry      menuentry       XtMenuEntry     <none>



The callback function should look like:

void function(tag)
caddr_t tag;
{
}

*/

typedef struct _XtMenuEntry {
    Window index;       /* insert w in front of this window; NULL=append*/
    Window w;           /* window id of entry to be added */
} XtMenuEntry, *XtMenuEntryPtr;

extern Window XtCreateMenu(); /* pw, arglist */
    /* Window pw; */    /* parent window */
    /* Arg *arglist; */ /* argument list */




                       March 16, 1987





                           - 94 -


extern XtStatus XtAddMenuEntry(); /* w, arglist */
    /* Window w; */     /* Menu window */
    /* Arg *arglist; */ /* argument list */

extern Window XtDeleteMenuEntry(); /* pw, arglist */
    /* Window pw; */    /* parent window */
    /* Arg *arglist; */ /* argument list */

/*
 * Note: The following default menu geometry manager is provided as an
 * aid to prototyping pop-up menus.  It says "requestYes" to everything.
 * Clients should replace this with their own geometry manager as
 * necessary.
 */
extern XtGeometryReturnCode XtMenuGeometryManager(); /* w,req,reqBox,repBox */
    /* Window w; */     /* window requesting geometry change */
    /* Atom req; */     /* ignored, but must be present */
    /* WindowBox *reqBox, *RepBox; */ /* size boxes for request */





/****************************************************************
 *
 * *Temporary* *implementation* of Dialog box widget
 *
 ****************************************************************/


extern AtomName XtNDialogButtons, XtNdialogbuttons, XtNDialogValue,
                XtNdialogvalue;

#define XtADialogButtons &XtNDialogButtons
#define XtAdialogbuttons &XtNdialogbuttons
#define XtADialogValue &XtNDialogValue
#define XtAdialogvalue &XtNdialogvalue

extern Window XtCreateDialog(); /* pw, arglist */
  /* Window pw; */
  /* ArgList arglist; */

extern void XtDestroyDialog(); /* w */
  /* Window w; */

extern char *XtDialogValue(); /* w */
  /* Window w; */

extern XtAlignWindow(); /* window, align, xres, yres */
  /* Window window, align; */
  /* int *xres, *yres; */


/****************************************************************



                       March 16, 1987





                           - 95 -


 *
 * Dialog Widget (a special kind of Form widget)
 *
 ****************************************************************/

/*
 Parameters
 ==========

 Name           Class           RepType         Default Value
 ----           -----           -------         -------------
 Window         window          window          create window
 BorderWidth    int             int             1
 Width          int             int             text width + 2*InternalWidth
 Height         int             int             font height + 2*InternalHeight
 InternalWidth  int             int             4
 InternalHeight int             int             2
 Label          string          string          Dummy
 Foreground     color           pixel           BlackPixel
 Background     color           pixel           WhitePixel
 DialogButtons  dialogbuttons   caddr_t         NULL
 DialogValues   dialogvalues    caddr_t         NULL

*/

typedef struct _DialogButton {
    char        *name;
    int         (*funct)();
    caddr_t     param;
} DialogButton, *DialogButtons;

typedef struct _DialogValue {
    char        *tag;
    char        *string;
    int         length
} DialogValue, *DialogValues;

#endif
/* DON'T ADD STUFF AFTER THIS #endif */


















                       March 16, 1987





                           - 96 -


_9.  _S_a_m_p_l_e _P_r_o_g_r_a_m

The  following  is  a  sample  program  that  creates,  then
displays, a command button.

/*
 * demo1.c - introductory example of X Toolkit Usage
 *
 * Make executable with:
 *      cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include <X/Toolkit.h>
#include <stdio.h>

static void ButtonAction(tag)
caddr_t tag;
{
    printf("Button Pressed0);
}

static char ButtonLabel[] = "Press Me";
static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) ButtonLabel},
    {XtAFunction, (caddr_t) ButtonAction},
    {NULL, NULL}        /* needed to terminate argument list */
};

void main()
{
    Display  *d;
    Window   bw;        /* button window */

    d = XOpenDisplay(NULL);

    XtInitToolkit();

    bw = XtCreateCommand(RootWindow, buttonArgs);

    /* widget clients normally position, size and map widget windows */
    XMoveWindow(bw, 100, 100);
    XMapWindow(bw);

    for(;;) {
        XEvent ev;

        XNextEvent(&ev);                /* Get next event */
        (void) XtDispatchXEvent(&ev);   /* Hand it to Toolkit Dispatcher */
    }
}






                       March 16, 1987





                           - 97 -


_1_0.  _S_a_m_p_l_e _P_r_o_g_r_a_m

The following is a sample program that:

o+    Uses the external resource file

o+    Obtains resources from the resource manager

o+    Creates a button box

o+    Adds command buttons to a button box

o+    Provides a simple geometry manager for the button box

/*
 * demo2.c - example of X Toolkit usage
 *
 * Make executable with:
 * cc -o demo2 demo2.c -lXt -lX
 *
 */

#include        <X/Xlib.h>
#include        "Toolkit.h"
#include        <stdio.h>


#define max(x,y) ((x) > (y) ? (x) : (y))

static Window pw1, bbw1;
static int value[10];
static Pixmap   border;
static Pixmap   bg;
static int      borderwidth = 1;

/* Call back procedure for the command buttons */
static void MyFunc(p)
    caddr_t p;
{ printf("MyFunc called with %d0, p); sleep(1); }

/* This handler will perform geometry management on the button box */
static XtEventReturnCode EventHandler(event, eventdata)
XEvent *event;
caddr_t eventdata;
{
    WindowInfo          wi;
    XtEventReturnCode code;

    switch (event->type) {
        case ResizeWindow:
            if (XQueryWindow(bbw1, &wi)) {
                XChangeWindow(bbw1,
                   max(1, ((XExposeEvent *)event)->width-20-2*wi.bdrwidth),
                   max(1, ((XExposeEvent *)event)->height-20-2*wi.bdrwidth));



                       March 16, 1987





                           - 98 -


            }
        case MessageEvent: break;
        case DestroyWindow: exit(0); break;
    }
    return (processed);
}


void main(argc, argv)
int argc;
char **argv;
{
    Display     *d;
    Window      ww;
    Arg         buttons[10];
    int         buttoncount, x, y, width;
    AtomList    name, class;
    WindowInfo  wi;

/* Arglists for creating the widgets */

    static Arg commandarglist[] = {
        {XtALabel,      (caddr_t) "TestCommand"},
        {XtAFunction,   (caddr_t) MyFunc},
        {XtAParameter,  (caddr_t) NULL},
        {NULL,          NULL}
    };


    static Arg bbarglist[] = {
        {NULL, NULL}
    };


/* Resource List for obtaining width and colors */
static Resource resourcelist[] = {
    {XtABorderWidth, XtAint, XtAint,
        sizeof(int), (caddr_t)&borderwidth, (caddr_t)NULL},
    {XtABorder, XtAcolor, XtApixmap,
        sizeof(Pixmap), (caddr_t)&border, (caddr_t)NULL},
    {XtABackground, XtAcolor, XtApixmap,
        sizeof(Pixmap), (caddr_t)&bg, (caddr_t)NULL},
    {NULL, NULL, NULL, 0, NULL, NULL}
};


    ResourceDataBase    db;
    FILE                *rdbFile;
    XrmValue            val;
    int i;

/* Macro to add button to button array and increment button count */
#define addbutton(w) \
    buttons[buttoncount].name = XtAWindow; \



                       March 16, 1987





                           - 99 -


    buttons[buttoncount].value = (caddr_t) w; \
    buttoncount++;


/* Initiialize the display and the toolkit */
    d = XOpenDisplay(NULL);
    XtInitToolkit();

/* Read resource file and get resources */
    rdbFile = fopen(".Xresources", "r");
    XtGetDataBase(rdbFile, &db);
    XtSetCurrentDataBase(db);
    fclose(rdbFile);
    border = BlackPixmap;
    bg = WhitePixmap;
    XtGetResources(
        resourcelist, NULL, RootWindow,
        XtMakeAtom("ButtonTest"), XtMakeAtom("app"),
        &name, &class);

/* Parent window for the button box */
    pw1 = XCreateWindow(
        RootWindow,
        100, 100,
        400, 200,
        borderwidth, border, bg);


/* Create the button box */
    bbw1 = XtCreateButtonBox(pw1, bbarglist);


/*  Create 10 command buttons with unique tags and add to button box*/
    buttoncount = 0;
    for (i=0; i<10; i++) {
        value[i] = i;
        commandarglist[2].value = (caddr_t) value[i];
        ww = XtCreateCommand(bbw1, commandarglist);
        XMapWindow(ww);
        addbutton(ww);
    }
    (void) XtButtonBoxAddButton(bbw1, buttons);


/* Map the button box window, set event handler for the parent window,
   and map the parent window */
    XMapWindow(bbw1);
    XtSetXEventDispatch(
        pw1, (XtEventProc)EventHandler, ExposeWindow, (caddr_t) NULL);
    XMapWindow(pw1);

/* Get and dispatch events */
    for(;;) {
        XEvent ev;



                       March 16, 1987





                          - 100 -


        XNextEvent(&ev);
        (void) XtDispatchXEvent(&ev);
    }

}
#
# Set border of button box to 0
# Set button background to blue-green, and border
# to black
#
buttonbox.BorderWidth:          0
buttonbox.command.BorderWidth:           5
buttonbox.command.Background:            #00fdfd
buttonbox.command.Border:                #000000
buttonbox.command.Font:                  helv10b










































                       March 16, 1987


     borderwidth = 1;

/* Call back procedure for the command buttons */
static void MyFunc(p)
    caddr_t p;
{ printf("MyFunc called with %d0, p); sleep(1); }

/* This handler will perform geometry mana./X.V10R4/Xtool/                                                                                     40755     545      12            0  4030003762  10110  5                                                                                                    ustar                                                                                     1  0                                                                                                                                                                 ./X.V10R4/Xtool/.XtActions                                                                          100444     545      12         2524  4026032034  12122  0                                                                                                    ustar                                                                                     1  0                                                                                                                                                                 <Ctrl>A:	beginning-of-line
<Ctrl>B:	backward-character
<Ctrl>D:	delete-next-character
<Ctrl>E:	end-of-line
<Ctrl>F:	forward-character
<Ctrl>G:	illegal-operation
<Ctrl>H:	backward-character
<Ctrl>J:	newline-and-indent
<Key>115:	newline-and-indent
<Ctrl>K:	kill-to-end-of-line
<Ctrl>L:	redraw-display
<Ctrl>M:	newline
<Ctrl>N:	next-line
<Ctrl>O:	newline-and-backup
<Ctrl>P:	previous-line
<Ctrl>V:	next-page
<Ctrl>W:	backward-kill-word
<Ctrl>Y:	unkill
<Ctrl>Z:	scroll-one-line-up
cs<Key>!:	kill-selection
<Meta>,:	beginning-of-file
<Meta>.:	end-of-file
<Meta>\<:	beginning-of-file
<Meta>\>:	end-of-file
<Meta>[:	backward-paragraph
<Meta>]:	forward-paragraph
<Meta>b:	backward-word
<Meta>d:	kill-word
<Meta>f:	forward-word
<Meta>h:     	backward-kill-word
<Meta>i:	insert-file
<Meta>v:	previous-page
<Meta>y:	stuff
<Meta>z:	scroll-one-line-down
<Meta>188:	backward-kill-word
~m<Key>188:	delete-previous-character
<Key>189:	newline
<Key>114:	backward-character
m~s<Key>201:	beginning-of-file
ms<Key>201:	end-of-file
<Key>167:	backward-character
<Key>168:	forward-character
<Key>169:	next-line
<Key>170:	previous-line
<Key>139:	stuff
<Key>140:	kill-selection
<Key>142:	previous-page
<Key>143:	next-page
<BtnDown>left:	select-start
<PtrMoved>left:	select-adjust
<BtnUp>left:	select-end
<BtnDown>right:	extend-start
<PtrMoved>right: extend-adjust
<BtnUp>right:	extend-end
("ButtonTest"), XtMakeAtom("app"),
        &name, &class);

/* Parent window for the button box */
    pw1 = XCreateWindow(
        RootWindow,
        100, 100,
        40./X.V10R4/Xtool/Actions.c                                                                           100644     545      12        35147  4026032034  12002  0                                                                                                    ustar                                                                                     1  0                                                                                                                                                                 #if