/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vfs_conf.c,v $
 * Revision 4.2.4.4  92/03/10  13:42:18  Peter_Stoppani
 * 	Pool merge.
 * 	[92/03/03  16:46:09  Peter_Stoppani]
 * 
 * 	Added MegaSafe to vops array.
 * 	[92/03/02  19:39:52  Peter_Stoppani]
 * 
 * 	add /proc support
 * 	[92/02/27  14:49:54  David_Scoda]
 * 
 * Revision 4.2.4.3  92/02/27  15:28:52  David_Scoda
 * 	"add /proc support"
 * 
 * Revision 4.2.4.2  92/02/26  15:51:27  Charles_Briggs
 * 	Pool merge
 * 	[92/02/23  13:01:02  Charles_Briggs]
 * 
 * 	DCE merge.
 * 	[92/02/22  14:01:44  Charles_Briggs]
 * 
 * 	UBC merge
 * 	[92/02/21  09:51:07  Charles_Briggs]
 * 
 * Revision 4.2  91/09/19  23:06:44  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
#ifndef lint
static char	*sccsid = "@(#)$RCSfile: vfs_conf.c,v $ $Revision: 4.2.4.4 $ (DEC) $Date: 92/03/10 13:42:18 $";
#endif 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)vfs_conf.c	3.2 (Berkeley) 5/30/91
 */

#include <sys/param.h>
#include <sys/mount.h>
#include <sys/user.h>
#include <sys/vnode.h>
#include <sys/errno.h>
#include <sys/lock_types.h>


/*
 * These define the root filesystem and device.
 */
struct vnode *rootvp = (struct vnode *)0;
struct mount *rootfs = (struct mount *)0;
struct vnode *rootdir = (struct vnode *)0;

/*
 * Set up the filesystem operations for vnodes.
 * The types are defined in mount.h.
 */
extern	struct vfsops ufs_vfsops;

#include <nfs.h>
#if	NFS && !NFS_DYNAMIC
extern	struct vfsops nfs_vfsops;
#endif

#include <sysv_fs.h>
#if	SYSV_FS && !SYSV_FS_DYNAMIC
extern  struct vfsops s5fs_vfsops;
#endif

#include <cdfs.h>
#if	CDFS && !CDFS_DYNAMIC
extern  struct vfsops cdfs_vfsops;
#endif

#include <msfs.h>
#if     MSFS && !MSFS_DYNAMIC
extern  struct vfsops msfs_vfsops;
#endif

#ifdef  DCEDFS
extern  struct vfsops dfs_vfsops;
extern  struct vfsops efs_vfsops;
#endif
extern  struct vfsops procfs_vfsops;

struct vfsops *vfssw[] = {
	(struct vfsops *)0,	/* 0 = MOUNT_NONE */
	&ufs_vfsops,		/* 1 = MOUNT_UFS */
#if	NFS && !NFS_DYNAMIC
	&nfs_vfsops,		/* 2 = MOUNT_NFS */
#else
	(struct vfsops *)0,	/* 2 = MOUNT_NFS */
#endif
	(struct vfsops *)0,	/* 3 = MOUNT_MFS */
	(struct vfsops *)0,	/* 4 = MOUNT_PC */
#if	SYSV_FS && !SYSV_FS_DYNAMIC
        &s5fs_vfsops,           /* 5 = MOUNT_S5FS */
#else
	(struct vfsops *)0,    	/* 5 = MOUNT_S5FS */
#endif
#if	CDFS && !CDFS_DYNAMIC
        &cdfs_vfsops,           /* 6 = MOUNT_CDFS */
#else
	(struct vfsops *)0,    	/* 6 = MOUNT_CDFS */
#endif
#ifdef  DCEDFS
	&dfs_vfsops,            /* 7 = MOUNT_DFS */
#else
	(struct vfsops *)0,     /* 7 = MOUNT_DFS */
#endif
#ifdef  DCEDFS
	&efs_vfsops,            /* 8 = MOUNT_EPI */
#else
	(struct vfsops *)0,     /* 8 = MOUNT_EPI */	
#endif  
	&procfs_vfsops,		/* 9 = MOUNT_PROCFS */
#if     MSFS && !MSFS_DYNAMIC
        &msfs_vfsops,           /* 10 = MOUNT_MSFS */
#else
        (struct vfsops *)0,     /* 10 = MOUNT_MSFS */
#endif
};


void
vfs_mountroot()
{
	register int error;
	extern int networkboot;

	/*
	 * Allocate a mount structure for root (rootfs).
	 * Initialize locks and common fields
	 */
        ZALLOC(mount_zone, rootfs, struct mount *);
        bzero(rootfs, sizeof(*rootfs));
        MOUNT_LOOKUP_LOCK_INIT(rootfs);
        MOUNT_VLIST_LOCK_INIT(rootfs);
        MOUNT_LOCK_INIT(rootfs);
        rootfs->m_op = vfssw[networkboot ? MOUNT_NFS : MOUNT_UFS];
        rootfs->m_next = rootfs;
        rootfs->m_prev = rootfs;
        /*
         * Call the filesystem specific mountroot routine.
         */
        VFS_MOUNTROOT(rootfs, &rootvp, error);
        if (error)
                panic("vfs_mountroot: cannot mount root");
	/*
         * Get vnode for '/'.
         * Setup rootdir and u.u_cdir to point to it.
         */
        rootvp->v_mount = rootfs;       /* set up root device's mount ptr */
        VFS_ROOT(rootfs, &rootdir, error);
        if (error)
                panic("vfs_mountroot: cannot get root filesystem");
        u.u_cdir = rootdir;
        VREF(u.u_cdir);
        u.u_rdir = NULL;
}

