/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	str_config.c,v $
 * Revision 4.2.6.4  92/03/25  13:18:44  Mary_Walker
 * 	took out extra extern
 * 	[92/03/25  13:13:14  Mary_Walker]
 * 
 * 	Devices now get the first available major number instead of reserving the
 * 	numbers after "clone"
 * 	[92/03/25  13:09:25  Mary_Walker]
 * 
 * Revision 4.2.6.3  92/03/01  16:18:49  William_Burns
 * 	Moved extern
 * 	[92/03/01  15:58:02  William_Burns]
 * 
 * Revision 4.2.6.2  92/02/14  18:28:01  Ajay_Kachrani
 * 	Configure "dlb" device for DLPI-ifnet pesudo driver
 * 	[92/02/14  16:11:25  Ajay_Kachrani]
 * 
 * Revision 4.2  91/09/19  22:54:05  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
#ifndef lint
static char	*sccsid = "@(#)$RCSfile: str_config.c,v $ $Revision: 4.2.6.4 $ (DEC) $Date: 92/03/25 13:18:44 $";
#endif 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#include <streams/str_stream.h>
#include <streams/str_debug.h>
#include <sys/stropts.h>
#include <sys/sysconfig.h>

/*
 *	Configuration of statically bound modules.
 *	If sources for the module/driver are available, then the
 *	configuration call should probably go there. If not, then
 *	those few lines of code can be coded here.
 *
 *	In any case, insert the configure call in str_config().
 *
 *	Note: under the current scheme of installing the /dev entries
 *	for these STREAMS devices, it is advised not to change the
 *	sequence of configuration calls to devices.
 */

extern int	bufcall_configure();
extern int	log_configure();
extern int	strnull_configure();
extern int	strecho_configure();
extern int	strpass_configure();
extern int	strtmux_configure();
extern int	strsc_configure();
extern int	timod_configure();
extern int	tirdwr_configure();
extern int	xtiso_configure();
extern int	kinfo_configure();
extern int	svtt_configure();
extern int	strdlb_configure();
extern int      ifnet_configure();

#include <strnull.h>
#include <strecho.h>
#include <strpass.h>
#include <strtmux.h>
#include <strsc.h>
#include <timod.h>
#include <tirdwr.h>
#include <xtiso.h>
#include <dlpi.h>
#include <strkinfo.h>
#include <svtt.h>
#include <strifnet.h>

static void
strdev_print(sc, name, retval)
	str_config_t *sc;
	char *name;
	int retval;
{
	if (retval)
		printf("STREAMS: '%s' configure failed (%d)\n", name, retval);
#ifdef	STREAMS_DEBUG
	else
		printf("STREAMS: '%s' configured (device %d/%d)\n",
		    sc->sc_sa_name, major(sc->sc_devnum), minor(sc->sc_devnum));
#endif
}

static void
strmod_print(sc, name, retval)
	str_config_t *sc;
	char *name;
	int retval;
{
	if (retval)
		printf("STREAMS: module '%s' configure failed (%d)\n",
			name, retval);
}

void
str_config()
{
	str_config_t	sb, sc;
#define sc_size		sizeof(sc)
	int		retval;

	/*
	 * STREAMS modules
	 */
	retval = bufcall_configure(SYSCONFIG_CONFIGURE,
				NULL, 0, &sc, sc_size);
	strmod_print(&sc, "bufcall", retval);

#if	STRPASS && !STRPASS_DYNAMIC
	retval = strpass_configure(SYSCONFIG_CONFIGURE,
				NULL, 0, &sc, sc_size);
	strmod_print(&sc, "pass", retval);
#endif

#if	STRSC && !STRSC_DYNAMIC
	retval = strsc_configure(SYSCONFIG_CONFIGURE,
				NULL, 0, &sc, sc_size);
	strmod_print(&sc, "sc", retval);
#endif

#if	TIMOD && !TIMOD_DYNAMIC
	retval = timod_configure(SYSCONFIG_CONFIGURE,
				NULL, 0, &sc, sc_size);
	strmod_print(&sc, "timod", retval);
#endif

#if	TIRDWR && !TIRDWR_DYNAMIC
	retval = tirdwr_configure(SYSCONFIG_CONFIGURE,
				NULL, 0, &sc, sc_size);
	strmod_print(&sc, "tirdwr", retval);
#endif

#if	SVTT && !SVTT_DYNAMIC
	retval = svtt_configure(SYSCONFIG_CONFIGURE,
				NULL, 0, &sc, sc_size);
	strmod_print(&sc, "s5tt", retval);
#endif

#if	STRIFNET && !STRIFNET_DYNAMIC
	retval = ifnet_configure(SYSCONFIG_CONFIGURE,
				&sb, sc_size, &sc, sc_size);
	strdev_print(&sc, "ifnet", retval);
#endif

	/*
	 * STREAMS drivers
	 */

	if (clonedev == NODEV)
		return;

	bzero((caddr_t)&sb, sc_size);
	sb.sc_version = OSF_STREAMS_CONFIG_10;
	sb.sc_devnum = NODEV;   /* will find available slot */

	retval = log_configure(SYSCONFIG_CONFIGURE,
				&sb, sc_size, &sc, sc_size);
	strdev_print(&sc, "log", retval);

#if     STRNULL && !STRNULL_DYNAMIC
	retval = strnull_configure(SYSCONFIG_CONFIGURE,
				&sb, sc_size, &sc, sc_size);
	strdev_print(&sc, "null", retval);
#endif

#if	STRECHO && !STRECHO_DYNAMIC
	retval = strecho_configure(SYSCONFIG_CONFIGURE,
				&sb, sc_size, &sc, sc_size);
	strdev_print(&sc, "echo", retval);
#endif

#if	STRTMUX && !STRTMUX_DYNAMIC
	retval = strtmux_configure(SYSCONFIG_CONFIGURE,
				&sb, sc_size, &sc, sc_size);
	strdev_print(&sc, "tmux", retval);
#endif

#ifdef  STRKINFO && !STRKINFO_DYNAMIC
	retval = kinfo_configure(SYSCONFIG_CONFIGURE,
				&sb, sc_size, &sc, sc_size);
	strdev_print(&sc, "kinfo", retval);
#endif

#if	XTISO && !XTISO_DYNAMIC
	/*
	 * Xtiso is multiply configurable...
	 * Put it last so the variable config count
	 * doesn't skew the table.
	 */
	for (;;) {
		retval = xtiso_configure(SYSCONFIG_CONFIGURE,
					&sb, sc_size, &sc, sc_size);
		if (retval != EADDRINUSE)
			strdev_print(&sc, "xtiso???", retval);
		if (retval)
			break;
	}
#endif

#if	DLPI && !DLPI_DYNAMIC
	retval = strdlb_configure(SYSCONFIG_CONFIGURE,
				&sb, sc_size, &sc, sc_size);
	strdev_print(&sc, "dlpi", retval);
#endif

/*
 * add new configurations above this comment
 */

}
