/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vm_kern.h,v $
 * Revision 4.2.2.2  92/02/26  15:54:18  Charles_Briggs
 * 	UBC merge
 * 	[92/02/23  14:18:21  Charles_Briggs]
 * 
 * 	UBC merge.
 * 	[92/02/22  14:36:03  Charles_Briggs]
 * 
 * Revision 4.2  91/09/19  23:07:44  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: vm_kern.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/02/26 15:54:18 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 *	File:	vm/vm_kern.h
 *	Author:	Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Copyright (C) 1985, Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Kernel memory management definitions.
 *
 *	Revision History:
 *
 * 8-Apr-91	Ron Widyono
 *	Delay inclusion of sys/preempt.h (for RT_PREEMPT) to avoid circular
 *	include file problem.
 *
 */

#ifndef	_VM_VM_KERN_H_
#define _VM_VM_KERN_H_

#include <rt_preempt.h>

#if	RT_PREEMPT
#ifndef	_SKIP_PREEMPT_H_
#define _SKIP_PREEMPT_H_
#define	_VM_VM_KERN_H_PREEMPT_
#endif
#endif

#include <mach/kern_return.h>
#include <sys/types.h>
#include <vm/vm_map.h>

extern void		kmem_init();
extern vm_offset_t	kmem_alloc();
extern vm_offset_t	kmem_alloc_pageable();
extern void		kmem_free();
extern vm_map_t		kmem_suballoc();
extern vm_map_t		kmem_csuballoc();

extern vm_map_t		kernel_map;
extern vm_map_t		kernel_pageable_map;
extern vm_map_t		kernel_copy_map;
extern vm_map_t		user_pt_map;

extern vm_offset_t	vm_kern_zero_page;	/* A page full of nothing */

/* See vm/vm_kern.c and bsd/uipc_mbuf.c */
extern void		kmem_mb_init();
extern vm_offset_t	kmem_mb_alloc();
extern vm_map_t		mb_map;
/* See vm/vm_kern.c and streams/str_memory.c */
extern void		kmem_streams_init();
extern vm_map_t		streams_mb_map;

/* The following two routines may be defined as macros */
#ifndef	map_physical_page
extern vm_offset_t	map_physical_page();
extern void		unmap_physical_page();
#endif

#if	RT_PREEMPT
#ifdef	_VM_VM_KERN_H_PREEMPT_
#include <sys/preempt.h>
#endif
#endif

#endif	/* _VM_VM_KERN_H_ */
