/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	uio.h,v $
 * Revision 4.2.3.2  92/05/20  09:17:43  Jeffrey_Denham
 * 	"Submit AIO to AG"
 * 
 * Revision 4.2.2.3  92/05/19  21:01:26  Jeffrey_Denham
 * 	Merged with AG.
 * 
 * Revision 4.2.2.2  92/05/19  19:03:25  Jeffrey_Denham
 * 	Added UIO_AIORW to enum uio_rw.
 * 
 * Revision 4.2  91/09/19  23:02:28  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: uio.h,v $ $Revision: 4.2.3.2 $ (DEC) $Date: 92/05/20 09:17:43 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1982, 1986 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *

 */

#ifndef	_SYS_UIO_H_
#define _SYS_UIO_H_

#include <sys/types.h>

struct iovec {
	caddr_t	iov_base;
	int	iov_len;
};

enum	uio_rw { UIO_READ, UIO_WRITE, UIO_AIORW };

/*
 * Segment flag values.
 */
enum	uio_seg {
	UIO_USERSPACE,		/* from user data space */
	UIO_SYSSPACE,		/* from system space */
	UIO_USERISPACE,		/* from user I space */
	UIO_PHYSSPACE		/* from physical address space */
};

struct uio {
	struct	iovec *uio_iov;
	int	uio_iovcnt;
	off_t	uio_offset;
	int	uio_resid;
	enum	uio_seg uio_segflg;
	enum	uio_rw uio_rw;
};

 /*
  * Limits
  */
#define UIO_MAXIOV	1024		/* max 1K of iov's */
#define UIO_SMALLIOV	8		/* 8 on stack, else malloc */

#ifndef _KERNEL
#ifdef _NO_PROTO 
extern int readv();
extern int writev();
#else 	/*_NO_PROTO */
extern int readv(int, struct iovec *, int);
extern int writev(int, struct iovec *, int);
#endif	/* _NO_PROTO */
#endif	/* _KERNEL */

#endif	/* _SYS_UIO_H_ */
