/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	syslimits.h,v $
 * Revision 4.3.3.2  92/04/08  12:14:08  David_Metsky
 * 	Remove definition of STREAM_MAX as specified by section 2.8.4 of the
 * 	POSIX standard.
 * 	[92/04/01  11:04:56  David_Metsky]
 * 
 * 	Change definition of TZNAME_MAX from _POSIX_TZNAME_MAX to 255
 * 	[92/04/01  10:43:05  David_Metsky]
 * 
 * 	Added SSIZE_MAX and TZNAME_MAX for POSIXZ standards work
 * 	[92/03/31  18:19:04  David_Metsky]
 * 
 * Revision 4.3  91/11/26  11:13:24  devbld_zk3
 * 	Baselevel AG_BL0
 * 
 * Revision 4.2.2.2  91/10/23  15:09:20  William_Burns
 * 	Merge from ODE/TIN: revision 3.5.9.2
 * 	date: 91/10/17 21:12:36;  author: devrcs;  state: Exp;  lines added/del: 3/4
 * 	sccs rev: 3.6;  orig date: 91/10/02 08:23:34;  orig author: fred
 * 	Fred Canter - headers, remove posix OPEN_MAX hackaround.
 * 	[91/10/23  09:46:51  William_Burns]
 * 
 * Revision 4.2  91/09/19  23:01:07  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: syslimits.h,v $ $Revision: 4.3.3.2 $ (DEC) $Date: 92/04/08 12:14:08 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *

 */

#ifndef	_SYS_SYSLIMITS_H_
#define _SYS_SYSLIMITS_H_

#define	ARG_MAX		20480	/* max bytes for an exec function */
#if	defined(multimax) || defined(balance)
#define CHILD_MAX	100     /* max processes per user */
#else	/* defined(multimax) || defined(balance) */
#define CHILD_MAX	64	/* max processes per user */
#endif	/* defined(multimax) || defined(balance) */
#define	LINK_MAX	32767	/* max file link count */
#define	MAX_CANON	255	/* max bytes in terminal canonical input line */
#define	MAX_INPUT	255	/* max bytes in terminal input */
#define	NAME_MAX	255	/* max number of bytes in a file name */
#define	NGROUPS_MAX	32	/* max number of supplemental group id's */
#define SSIZE_MAX       LONG_MAX /* Max value fitting ssize_t (a long) */
#define TZNAME_MAX	255

#if !defined(_POSIX_SOURCE) && !defined(_XOPEN_SOURCE)
#define	OPEN_MAX	64	/* max open files per process - OBSOLETE, sysconf() interface should be used */
#endif

#define	PATH_MAX	1024	/* max number of bytes in pathname */
#define	PIPE_BUF	4096	/* max number of bytes for atomic pipe writes */

#endif	/* _SYS_SYSLIMITS_H_ */
