/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	secdefines.h,v $
 * Revision 4.2  91/09/19  22:59:45  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: secdefines.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:59:45 $
 */ 
/*
 */
#ifndef __SECDEFINES__
#define __SECDEFINES__

/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Copyright (c) 1990 SecureWare, Inc.  All Rights Reserved.
 *

 *
 * This header file configures the conditional compilation symbols
 * used to control the inclusion of security features.
 */
/*
 * OSF/1 Release 1.0
 */

#include <standards.h>

#if defined(KERNEL) && defined(_OSF_SOURCE)
#include <sec_base.h>
#include <sec_priv.h>
#include <sec_mac_ob.h>
#include <sec_cmw.h>
#include <sec_shw.h>
#include <sec_acl_posix.h>
#include <sec_acl_sware.h>
#include <sec_ncav.h>
#endif /* KERNEL && _OSF_SOURCE */

#if SEC_BASE

/*
 * Resolve mutually exclusive base conditionals
 */

#if SEC_CMW
#undef SEC_MAC_OB
#undef SEC_SHW
#endif

#if SEC_SHW
#undef SEC_MAC_OB
#endif

#if SEC_ACL_POSIX
#undef SEC_ACL_SWARE
#endif

#if defined(_OSF_SOURCE) || defined(AUX)

#define	SEC_AUDIT_SYMLINKS	1	/* system supports symbolic links */
#define	SEC_PTY			1
#define	SEC_SOCKET		1

#include <sys/param.h>
#if NGROUPS
#define	SEC_GROUPS	NGROUPS
#else
#undef	SEC_GROUPS
#endif

#endif /* _OSF_SOURCE || AUX */

#ifdef SYSV_3

#undef	SEC_AUDIT_SYMLINKS
#undef	SEC_PTY
#undef	SEC_SOCKET
#undef	SEC_GROUPS

#endif /* SYSV_3 */


/*
 * The following definitions derive various conditional compilation
 * symbols from the base conditionals that are specified on the
 * compiler command line.
 */

#if SEC_MAC_OB || SEC_SHW || SEC_CMW
#define	SEC_MAC	1
#else
#undef	SEC_MAC
#endif

#if SEC_ACL_SWARE || SEC_ACL_POSIX
#define	SEC_ACL	1
#else
#undef	SEC_ACL
#endif

#if SEC_SHW || SEC_CMW
#define	SEC_ILB	1
#define	SEC_ENCODINGS	1
#else
#undef	SEC_ILB
#undef	SEC_ENCODINGS
#endif

#if SEC_ACL || SEC_MAC || SEC_NCAV
#define	SEC_ARCH	1
#else
#undef	SEC_ARCH
#endif

#if SEC_ARCH || SEC_PRIV
#define	SEC_FSCHANGE	1
#else
#undef	SEC_FSCHANGE
#endif

#else /* !SEC_BASE */

#undef	SEC_BASE
#undef	SEC_PRIV
#undef	SEC_MAC_OB
#undef	SEC_SHW
#undef	SEC_CMW
#undef	SEC_ACL_SWARE
#undef	SEC_ACL_POSIX
#undef	SEC_NCAV
#undef	SEC_ACL
#undef	SEC_MAC
#undef	SEC_ILB
#undef	SEC_ENCODINGS
#undef	SEC_ARCH
#undef	SEC_FSCHANGE
#undef	SEC_PTY
#undef	SEC_SOCKET
#undef	SEC_GROUPS
#undef	SEC_AUDIT_SYMLINKS

#endif /* !SEC_BASE */
#endif /* __SECDEFINES__ */
