/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ipc.h,v $
 * Revision 4.2  91/09/19  22:58:01  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: ipc.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:58:01 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 

#ifndef _SYS_IPC_H_
#define _SYS_IPC_H_

#include	<standards.h>

#ifdef _XOPEN_SOURCE

#include <sys/types.h>

typedef long    mtyp_t;		/* ipc message type */

/* Common IPC Structures */
struct ipc_perm {
	ushort		uid;		/* owner's user id	*/
	ushort		gid;		/* owner's group id	*/
	ushort		cuid;		/* creator's user id	*/
	ushort		cgid;		/* creator's group id	*/
	ushort		mode;		/* access modes		*/
	u_short		seq;		/* slot usage sequence number */
	key_t		key;		/* key			*/
};

/* common IPC operation flag definitions */
#define	IPC_CREAT	0001000		/* create entry if key doesn't exist */
#define	IPC_EXCL	0002000		/* fail if key exists */
#define	IPC_NOWAIT	0004000		/* error if request must wait */

/* Keys. */
#define	IPC_PRIVATE	(key_t)0	/* private key */

/* Control Commands. */
#define	IPC_RMID	0	/* remove identifier */
#define	IPC_SET		1	/* set options */
#define	IPC_STAT	2	/* get options */

#endif /* _XOPEN_SOURCE */

#ifdef _OSF_SOURCE

/* Common ipc_perm mode Definitions. */
#define	IPC_ALLOC	0100000		/* entry currently allocated        */
#define	IPC_R		0000400		/* read or receive permission       */
#define	IPC_W		0000200		/* write or send permission	    */

#endif /* _OSF_SOURCE */

#endif /* _SYS_IPC_H_ */
