/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	conf.h,v $
 * Revision 4.3.5.7  92/05/19  09:30:18  Robin_Lewis
 * 	added at_ prefix to major/minor elements of Assign table.
 * 	[92/05/19  08:33:26  Robin_Lewis]
 * 
 * 	Made change from the alpha pool as requested by Al Delory to change the major and minor vars to at_major ... etc
 * 	[92/05/01  08:37:19  Robin_Lewis]
 * 
 * Revision 4.3.5.6  92/04/10  12:35:46  Debra_Haeck
 * 	bmerge, ready for bsubmit
 * 	[92/04/10  12:35:03  Debra_Haeck]
 * 
 * 	add mode, uid and gid fields to Assign_table and Assign_entry
 * 	[92/03/26  11:14:41  Debra_Haeck]
 * 
 * Revision 4.3.5.5  92/03/25  12:53:31  Debra_Haeck
 * 	bmerge -r$NEW
 * 	[92/03/25  10:40:21  Debra_Haeck]
 * 
 * 	correct ifdef of Assign_table and Assign_entry
 * 	[92/03/25  10:10:30  Debra_Haeck]
 * 
 * Revision 4.3.5.4  92/03/13  13:43:44  Debra_Haeck
 * 	add define and typedef's needed by assign_table in conf.c and by the new
 * 	getsysinfo calls to retrieve info from this table
 * 	[92/03/13  13:42:02  Debra_Haeck]
 * 
 * Revision 4.3.5.3  92/03/12  14:24:17  Timothy_Burke
 * 	Merged to ag.latest.
 * 	[92/03/11  13:28:19  Timothy_Burke]
 * 
 * 	Removed conditional compilation of d_funnel in bdevsw and
 * 	cdevsw struct. Always include the field.
 * 	[92/03/04  10:39:45  Timothy_Burke]
 * 
 * Revision 4.3.5.2  92/03/10  09:51:29  Ronald_Widyono
 * 	"Fix broken RT Kernel build"
 * 	     Include kern/parallel.h because unix_master/release is being used.
 * 
 * Revision 4.3.5.3  92/03/12  14:24:17  Timothy_Burke
 * 	Merged to ag.latest.
 * 	[92/03/11  13:28:19  Timothy_Burke]
 * 
 * 	Removed conditional compilation of d_funnel in bdevsw and
 * 	cdevsw struct. Always include the field.
 * 	[92/03/04  10:39:45  Timothy_Burke]
 * 
 * Revision 4.3.5.2  92/03/10  09:51:29  Ronald_Widyono
 * 	"Fix broken RT Kernel build"
 * 	     Include kern/parallel.h because unix_master/release is being used.
 * 
 * Revision 4.3.5.4  92/03/13  13:43:44  Debra_Haeck
 * 	add define and typedef's needed by assign_table in conf.c and by the new
 * 	getsysinfo calls to retrieve info from this table
 * 	[92/03/13  13:42:02  Debra_Haeck]
 * 
 * Revision 4.3.5.3  92/03/12  14:24:17  Timothy_Burke
 * 	Merged to ag.latest.
 * 	[92/03/11  13:28:19  Timothy_Burke]
 * 
 * 	Removed conditional compilation of d_funnel in bdevsw and
 * 	cdevsw struct. Always include the field.
 * 	[92/03/04  10:39:45  Timothy_Burke]
 * 
 * Revision 4.3.5.2  92/03/10  09:51:29  Ronald_Widyono
 * 	"Fix broken RT Kernel build"
 * 	     Include kern/parallel.h because unix_master/release is being used.
 * 
 * Revision 4.3.5.3  92/03/12  14:24:17  Timothy_Burke
 * 	Merged to ag.latest.
 * 	[92/03/11  13:28:19  Timothy_Burke]
 * 
 * 	Removed conditional compilation of d_funnel in bdevsw and
 * 	cdevsw struct. Always include the field.
 * 	[92/03/04  10:39:45  Timothy_Burke]
 * 
 * Revision 4.3.5.2  92/03/10  09:51:29  Ronald_Widyono
 * 	"Fix broken RT Kernel build"
 * 	     Include kern/parallel.h because unix_master/release is being used.
 * 
 * Revision 4.3.5.4  92/03/13  13:43:44  Debra_Haeck
 * 	add define and typedef's needed by assign_table in conf.c and by the new
 * 	getsysinfo calls to retrieve info from this table
 * 	[92/03/13  13:42:02  Debra_Haeck]
 * 
 * Revision 4.3.5.3  92/03/12  14:24:17  Timothy_Burke
 * 	Merged to ag.latest.
 * 	[92/03/11  13:28:19  Timothy_Burke]
 * 
 * 	Removed conditional compilation of d_funnel in bdevsw and
 * 	cdevsw struct. Always include the field.
 * 	[92/03/04  10:39:45  Timothy_Burke]
 * 
 * Revision 4.3.5.2  92/03/10  09:51:29  Ronald_Widyono
 * 	"Fix broken RT Kernel build"
 * 	     Include kern/parallel.h because unix_master/release is being used.
 * 
 * Revision 4.3.5.3  92/03/12  14:24:17  Timothy_Burke
 * 	Merged to ag.latest.
 * 	[92/03/11  13:28:19  Timothy_Burke]
 * 
 * 	Removed conditional compilation of d_funnel in bdevsw and
 * 	cdevsw struct. Always include the field.
 * 	[92/03/04  10:39:45  Timothy_Burke]
 * 
 * Revision 4.3.5.2  92/03/10  09:51:29  Ronald_Widyono
 * 	"Fix broken RT Kernel build"
 * 	     Include kern/parallel.h because unix_master/release is being used.
 * 
 * Revision 4.3  91/11/26  11:12:49  devbld_zk3
 * 	Baselevel AG_BL0
 * 
 * Revision 4.2.2.2  91/10/25  14:49:35  William_Burns
 * 	Merge from ODE/TIN: revision 3.2.9.2
 * 	date: 91/10/22 20:06:24;  author: devrcs;  state: Exp;  lines added/del: 24/4
 * 	sccs rev: 3.4;  orig date: 91/10/08 14:58:40;  orig author: plong
 * 	  Realtime extension
 * 	[91/10/25  12:47:52  William_Burns]
 * 
 * Revision 4.2  91/09/19  22:57:05  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: conf.h,v $ $Revision: 4.3.5.7 $ (DEC) $Date: 92/05/19 09:30:18 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * conf.h
 *
 * Modification History:
 *
 * 7-SEP-91	B Harrigan
 *	
 *      Changed  DEVSW_FUNNEL and UNFUNNEL to funnel if RT_PREEMPT is turned
 *       on. This will cause all devices to funnel if RT_PREEMPTION is turned
 *       on, unless SER_COMPAT was on in which case I assume SER_COMPAT works
 *       and we do nothing.
 *      
 */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 */

#ifndef	_SYS_CONF_H_
#define _SYS_CONF_H_

#ifdef	_KERNEL
#include <sys/unix_defs.h>
#endif
/*
 * Declaration of block device
 * switch. Each entry (row) is
 * the only link between the
 * main unix code and the driver.
 * The initialization of the

 * device switches is in the
 * file conf.c.
 */

struct bdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	int	(*d_dump)();
	int	(*d_psize)();
	int	d_flags;
	int	(*d_ioctl)();
	int 	d_funnel;	/* serial code compatibility */
};

#ifdef	_KERNEL
extern struct	bdevsw bdevsw[];
extern int	nblkdev;			/* bdevsw size */
#endif

struct cdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	int	(*d_stop)();
	int	(*d_reset)();
	struct tty *d_ttys;
	int	(*d_select)();
	int	(*d_mmap)();
	int 	d_funnel;	/* serial code compatibility */
};

#ifdef	_KERNEL
extern struct	cdevsw cdevsw[];
extern int	nchrdev;			/* cdevsw size */
#endif

/*
 * tty line control switch.
 */

struct linesw
{
	int	(*l_open)();
	int	(*l_close)();
	int	(*l_read)();
	int	(*l_write)();
	int	(*l_ioctl)();
	int	(*l_rint)();
	int	(*l_rend)();
	int	(*l_meta)();
	int	(*l_start)();
	int	(*l_modem)();
#ifdef	IBM_CONSOLE
	int	(*l_select)();
#endif
};

#ifdef	_KERNEL
extern struct	linesw linesw[];
#endif

#ifdef	_KERNEL
#include <ser_compat.h>
#include <kern/lock.h>
#include <kern/parallel.h>

/*
 * Character and Block Device Switch Locking definition.
 *
 * A device switch lock guards a particular entry in a
 * device switch table; these locks are used by the
 * driver open routines.  Note that these locks have
 * nothing to do with synchronizing the drivers themselves;
 * they guard the use of entries in the devsw arrays.
 */
typedef struct dswlock {
        lock_data_t     dsw_lock;               /* devsw entry r/w lock */
        int             dsw_flags;              /* devsw entry status flags */
} dswlock_t;

/*
 * Parallel device switch lock arrays, one entry
 * for each entry in cdevsw and bdevsw.
 */
extern dswlock_t cdevlock[];                    /* cdevsw lock structure */
extern dswlock_t bdevlock[];                    /* bdevsw lock structure */

						/* dsw flag defines */
#define DSW_INUSE	0x0001
						/* Lock macros for open() */
#define CDEVSW_READ_LOCK(maj)		lock_read(&(cdevlock[maj].dsw_lock))
#define CDEVSW_WRITE_LOCK(maj)		lock_write(&(cdevlock[maj].dsw_lock))
#define CDEVSW_READ_UNLOCK(maj)		lock_done(&(cdevlock[maj].dsw_lock))
#define CDEVSW_WRITE_UNLOCK(maj)	lock_done(&(cdevlock[maj].dsw_lock))
#define BDEVSW_READ_LOCK(maj)		lock_read(&(bdevlock[maj].dsw_lock))
#define BDEVSW_WRITE_LOCK(maj)		lock_write(&(bdevlock[maj].dsw_lock))
#define BDEVSW_WRITE_UNLOCK(maj)	lock_done(&(bdevlock[maj].dsw_lock))
#define BDEVSW_READ_UNLOCK(maj)		lock_done(&(bdevlock[maj].dsw_lock))
#define CDEVSW_LOCK_INIT(maj)		\
		lock_init2(&(cdevlock[maj].dsw_lock), TRUE, LTYPE_CDEVSW)
#define BDEVSW_LOCK_INIT(maj)		\
		lock_init2(&(bdevlock[maj].dsw_lock), TRUE, LTYPE_BDEVSW)

#ifdef __STDC__
#define PASTE(a,b) a##b
#else
#define PASTE(a,b) a/**/b
#endif

/*
 * Backwards compatibility for unparallelized device drivers.
 * Unparallelized device drivers can be funnelled.	XXX
 */
#if (RT_PREEMPT   && !SER_COMPAT) 
/*
* This code causes all devices to funnel if realtime preemption is
*  turned on and serial Compatiblity is not.
*/
#define DEVSW_FUNNEL(sw,maj)		unix_master()
#define  DEVSW_UNFUNNEL(sw,maj)		unix_release()
#else
#define	DEVSW_FUNNEL(sw,maj)		FUNNEL(PASTE(sw,devsw)[(maj)].d_funnel)
#define	DEVSW_UNFUNNEL(sw,maj)		UNFUNNEL(PASTE(sw,devsw)[(maj)].d_funnel)
#endif
/*
 * The following macros hide the use of funnelling from most
 * kernel code.  Most of the macros use _DVC_ but there are
 * three special cases for fetching an associated tty array,
 * flags, or the partition size (optional entry).
 */
#define	_DVC_(sw,f,maj,args,ret)					\
MACRO_BEGIN								\
	DEVSW_FUNNEL(sw,(maj));						\
	(ret) = (*PASTE(sw,devsw)[(maj)].PASTE(d_,f))args;		\
	DEVSW_UNFUNNEL(sw,(maj));					\
MACRO_END

#define	_TTYS_(sw,maj,min,ret)						\
MACRO_BEGIN								\
	DEVSW_FUNNEL(sw,(maj));						\
	(ret) = &PASTE(sw,devsw)[(maj)].d_ttys[(min)];			\
	DEVSW_UNFUNNEL(sw,(maj));					\
MACRO_END

#define	_FLAGS_(sw,maj,ret)						\
MACRO_BEGIN								\
	DEVSW_FUNNEL(sw,(maj));						\
	(ret) = PASTE(sw,devsw)[(maj)].d_flags;				\
	DEVSW_UNFUNNEL(sw,(maj));					\
MACRO_END

#define	_DVC_OPT_(sw,f,maj,args,ret)					\
MACRO_BEGIN								\
	DEVSW_FUNNEL(sw,(maj));						\
	if (PASTE(sw,devsw)[(maj)].PASTE(d_,f))				\
		(ret) = (*PASTE(sw,devsw)[(maj)].PASTE(d_,f))args;	\
	else								\
  		(ret) = -1;						\
	DEVSW_UNFUNNEL(sw,(maj));					\
MACRO_END

/*
 * These macros were developed to have a single interface for the cdevsw
 * and the bdevsw in code, but easily adding funneling.
 *
 * They are all called with 'similar' arguments:
 *	(major device #, arg1, arg2, ..., result)
 * where:
 *	result will be set to the return value of the b/cdevsw call.
 *	arg[12...] is the list of arguments to be passed into the call.
 */
/*
 * Special-case open macros to use devsw locking to synchronize with 
 * dynamic installation of drivers.
 */
#define	BDEVSW_OPEN(maj,dev,mode,flag,ret)				\
MACRO_BEGIN								\
	BDEVSW_READ_LOCK(maj);						\
	DEVSW_FUNNEL(b,(maj));						\
	(ret) = (*bdevsw[(maj)].d_open)(dev,mode,flag);			\
	DEVSW_UNFUNNEL(b,(maj));					\
	BDEVSW_READ_UNLOCK(maj);					\
MACRO_END

#define	CDEVSW_OPEN(maj,dev,mode,flag,newdev,ret)			\
MACRO_BEGIN								\
	CDEVSW_READ_LOCK(maj);						\
	DEVSW_FUNNEL(c,(maj));						\
	(ret) = (*cdevsw[(maj)].d_open)(dev,mode,flag,newdev);		\
	DEVSW_UNFUNNEL(c,(maj));					\
	CDEVSW_READ_UNLOCK(maj);					\
MACRO_END

#define	BDEVSW_CLOSE(m,d,f,f2,r)	_DVC_(b,close,m,(d,f,f2),r)
#define	BDEVSW_STRATEGY(m,bp,r)		_DVC_(b,strategy,m,(bp),r)
#define	BDEVSW_DUMP(m,d,lo,s,bl,f,r)	_DVC_(b,dump,m,(d,lo,s,bl,f),r)
#define	BDEVSW_PSIZE(m,d,r)		_DVC_OPT_(b,psize,m,(d),r)
#define	BDEVSW_FLAGS(m,r)		_FLAGS_(b,m,r)
#define	BDEVSW_IOCTL(m,d,c,d1,f,r)	_DVC_(b,ioctl,m,(d,c,d1,f),r)

#define	CDEVSW_CLOSE(m,d,f,mo,r)	_DVC_(c,close,m,(d,f,mo),r)
#define	CDEVSW_READ(m,d,u,f,r)		_DVC_(c,read,m,(d,u,f),r)
#define	CDEVSW_WRITE(m,d,u,f,r)		_DVC_(c,write,m,(d,u,f),r)
#define	CDEVSW_IOCTL(m,d,com,t,f,r)	_DVC_(c,ioctl,m,(d,com,t,f),r)
#define	CDEVSW_STOP(m,t,w,r)		_DVC_(c,stop,m,(t,w),r)
#define	CDEVSW_RESET(m,i,r)		_DVC_(c,reset,m,(i),r)
#define	CDEVSW_TTYS(maj,min,r)		_TTYS_(c,maj,min,r)
#define	CDEVSW_SELECT(m,d,e,re,s,r)	_DVC_(c,select,m,(d,e,re,s),r)
#define	CDEVSW_MMAP(m,d,o,p,r)		_DVC_(c,mmap,m,(d,o,p),r)

#endif	/* _KERNEL */
#include	<sys/types.h>

/* size of ascii strings within the assign_table
 */
#define	ANAMELEN	80

/* struct that is returned to caller as a result of a getsyscall with op =
 * GSI_STATIC_NXT or GSI_STATIC_DEF
 */
typedef	struct	aentry {
	char	config_name[ANAMELEN];
	char	bc[2];
	int	mode;
	char	username[ANAMELEN];
	uid_t	user;
	char	groupname[ANAMELEN];
	gid_t	group;
	char	dirname[ANAMELEN];
	int	ae_major;
	int	ae_minor;
	char	dev_name[ANAMELEN];
	} Assign_entry;

/* struct of assign table as it is really stored in conf.c
 */
typedef struct atable {
	char	config_name[ANAMELEN];
	char	bc[2];
	int	mode;
	char	username[ANAMELEN];
	uid_t	user;
	char	groupname[ANAMELEN];
	gid_t	group;
	char	dirname[ANAMELEN];
	int	at_major;
	int	*at_minor;
	char	*dev_name;
	} Assign_table;
#endif	/* _SYS_CONF_H_ */
