/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	procfs_l.h,v $
 * Revision 1.1.2.5  92/06/02  12:55:52  David_Scoda
 * 	"/proc update, speedup, 64 bit, memory usage"
 * 
 * Revision 1.1.3.3  92/06/02  09:37:10  David_Scoda
 * 	<<<bci after bmerge>>>
 * 
 * Revision 1.1.3.2  92/06/02  09:31:49  David_Scoda
 * 	<<<update, speedup, 64 bit safe, reduce kernel memory requirements>>>
 * 
 * Revision 1.1.2.4  92/04/23  14:30:38  David_Scoda
 * 	"/proc fixes"
 * 
 * Revision 1.1.3.3  92/04/23  10:46:11  David_Scoda
 * 	/proc fixes
 * 
 * Revision 1.1.3.2  92/04/23  09:54:29  David_Scoda
 * 	<<</proc fixes>>>
 * 
 * Revision 1.1.2.3  92/03/25  13:47:24  David_Scoda
 * 	"BL6 /proc fixes"
 * 
 * Revision 1.1.3.3  92/03/25  12:55:36  David_Scoda
 * 	bci after bmerge for /proc changes
 * 
 * Revision 1.1.3.2  92/03/24  12:53:23  David_Scoda
 * 	<<</proc bug fixes>>>
 * 
 * Revision 1.1.2.2  92/02/27  15:26:26  David_Scoda
 * 	"add /proc support"
 * 
 * Revision 1.1.1.2  92/02/27  14:47:42  David_Scoda
 * 	add /proc support
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: procfs_l.h,v $ $Revision: 1.1.2.5 $ (DEC) $Date: 92/06/02 12:55:52 $
 */

#ifndef _SYS_PROCFS_L_H_
#define _SYS_PROCFS_L_H_

#include <procfs/procfs.h>
#include <s5fs/s5dir.h>
#include <dirent.h>

extern int nproc;

/*
 * Use the index in the procnode to verify that the proc table
 * p_pid is the same as the one in the procnode.  Compare the
 * procnode creation time, prc_time, with the start time in the
 * proc table entry, proc[index]->utask.uu_start.  If either
 * check fails, the macro evaluates to TRUE.
 */
#define PROCFS_VNINVALID(pn) ( ((pn)->prc_index == NULL) ? NULL : \
 (proc[(pn)->prc_index].p_pid != (pn)->prc_pid) || \
 (proc[(pn)->prc_index].utask->uu_start.tv_sec != (pn)->prc_time.tv_sec) || \
 (proc[(pn)->prc_index].p_stat == SZOMB) )


/*
 * Local definitions and structure needed by the procfs filesystem.
 * Definitions that are interfaces to other parts of the kenel are in a
 * different file.
 */
#define	PR_MAX_NAME_SZ	23 /* Max size of a /proc filename */
#define PR_MIN_NAME_SZ	5  /* Report /proc filenames as 5 decimal digits MIN */
#define	PR_LAG_SEC	2 /* Number of seconds allowed between dirbuf updates */

struct pr_sys5_dir {
	struct s5direct s5_dir;
};

typedef	struct s5direct	pr_s5_dirent_t;

extern	lock_t	pr_s5_dirlock;

struct pr_generic_dir {
	ino_t	d_ino;
	ushort_t	d_reclen;
	ushort_t	d_namlen;
	char	d_name[PR_MAX_NAME_SZ+1];
};

typedef	struct pr_generic_dir	pr_g_dirent_t;

extern	lock_t	pr_g_dirlock;

/* The following macros use a feature of the preprocessor, that comments use
 * no space, to get around the automatic insertion of whitespace around the
 * argument passed into a macro (another preprocessor feature).  This can be
 * replaced by the ## operator in ANSI C when ANSI C is available.
 */

#define PROCFS_GETDIR(xxx) \
		if(time.tv_sec >= (pr_/**/xxx/**/_timestamp.tv_sec+PR_LAG_SEC))\
			procfs_get_/**/xxx/**/_dir();

#define PR_DLOCK(xxx)	simple_lock(pr_/**/xxx/**/_dirlock)
#define PR_DUNLOCK(xxx)	simple_unlock(pr_/**/xxx/**/_dirlock)

#endif
