/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	if_ether.h,v $
 * Revision 4.2  91/09/19  22:46:34  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: if_ether.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:46:34 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	Base:	if_ether.h	7.4 (Berkeley) 2/17/89
 *	Merged:	if_ether.h	7.5 (Berkeley) 6/28/90
 */

/*
 * Modification History:
 *
 *	Matt Thomas	 2/15/90
 *	Add ETHERTYPE_LAT and ETHERTYPE_DECnet for LAT and DLI.
 */

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct	ether_header {
	u_char	ether_dhost[6];
	u_char	ether_shost[6];
	u_short	ether_type;
};

/*
 * Note that PUP is <= 1500 and since falls in the range of valid 802.3
 * frames.  Hence, PUP is not actually usuable.
 */
#define	ETHERTYPE_PUP		0x0200	/* PUP protocol */
#define	ETHERTYPE_IP		0x0800	/* IP protocol */
#define ETHERTYPE_ARP		0x0806	/* Addr. resolution protocol */
#define ETHERTYPE_LAT		0x6004	/* Local Area Transport (LAT) */
#define ETHERTYPE_DECnet	0x6003	/* Phase IV DECnet */
#define ETHERTYPE_MOPRC		0x6002	/* MOP CCR protocol type */
#define ETHERTYPE_MOPDL		0x6001	/* MOP Downline Load protocol type */
#define ETHERTYPE_LBACK		0x9000	/* MOP loopback protocol type */


/*
 * The ETHERTYPE_NTRAILER packet types starting at ETHERTYPE_TRAIL have
 * (type-ETHERTYPE_TRAIL)*512 bytes of data followed
 * by an ETHER type (as given above) and then the (variable-length) header.
 */
#define	ETHERTYPE_TRAIL		0x1000		/* Trailer packet */
#define	ETHERTYPE_NTRAILER	16

#define	ETHERMTU	1500
#define	ETHERMIN	(60-14)

/*
 * Ethernet Address Resolution Protocol.
 *
 * See RFC 826 for protocol description.  Structure below is adapted
 * to resolving internet addresses.  Field names used correspond to 
 * RFC 826.
 */
struct	ether_arp {
	struct	arphdr ea_hdr;	/* fixed-size header */
	u_char	arp_sha[6];	/* sender hardware address */
	u_char	arp_spa[4];	/* sender protocol address */
	u_char	arp_tha[6];	/* target hardware address */
	u_char	arp_tpa[4];	/* target protocol address */
};
#define	arp_hrd	ea_hdr.ar_hrd
#define	arp_pro	ea_hdr.ar_pro
#define	arp_hln	ea_hdr.ar_hln
#define	arp_pln	ea_hdr.ar_pln
#define	arp_op	ea_hdr.ar_op

/*
 * Structure shared between the ethernet driver modules and
 * the address resolution code.  For example, each ec_softc or il_softc
 * begins with this structure.
 */
#define NISAPS	128
struct	arpcom {
	struct 	ifnet ac_if;		/* network-visible interface */
	u_char	ac_hwaddr[14];		/* hardware address (sizeof sa_data) */
	u_short	ac_arphrd;		/* arp hardware type (net/if_arp.h) */
	u_char	*ac_bcastaddr;		/* pointer to link broadcast or 0 */
	struct in_addr ac_ipaddr;	/* copy of ip address- XXX */
	struct socket *ac_so[NISAPS];	/* socket ptr to isap */
	u_char ac_svc[NISAPS/8];	/* svc bit mask, 0=user, 1=class 1 */
	u_char ac_gsap[NISAPS][NISAPS/8]; /* gsap is index, bit set is isap */
	u_short ac_to;			/* remaining sysid time in PR_SLOWHZ units */
	u_short ac_tr;			/* sysid time in PR_SLOWHZ units */
};
#define ac_enaddr	ac_hwaddr	/* one size fits many */

/*
 * Internet to ethernet address resolution table.
 */
struct	arptab {
	struct	in_addr at_iaddr;	/* internet address */
	struct	ifnet *at_if;		/* interface pointer */
	u_char	at_hwaddr[14];		/* hardware address (len in at_if) */
	u_short	at_flags;		/* flags (net/if_arp.h) */
	short	at_timer;		/* ticks since last referenced */
	short	at_valid;		/* ticks since last valid */
	short	at_retry;		/* request send count */
	short	at_sent;		/* at_valid at last send */
	struct	mbuf *at_hold;		/* last packet until resolved/timeout */
};
#define at_enaddr	at_hwaddr	/* as for arpcom */

#ifdef	_KERNEL
extern CONST u_char etherbroadcastaddr[6];
#endif
